/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.I_GL_Journal;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPeriod;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Asset_Dep;
import org.compiere.model.X_A_Asset_Forecast;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DepreAssetsDefensoria
extends SvrProcess {
    private Properties m_ctx;
    private int Record_ID;
    X_A_Asset_Dep DepDoc = null;

    protected void prepare() {
        this.m_ctx = Env.getCtx();
        this.Record_ID = this.getRecord_ID();
        this.DepDoc = new X_A_Asset_Dep(this.m_ctx, this.Record_ID, this.get_TrxName());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        MOrg orgP;
        Calendar cal;
        String sql = "select a.a_asset_id,a.name,a.value,acct.c_acctschema_id, acct.a_asset_acct,  acct.a_depreciation_acct, fore.amount,fore.a_asset_forecast_id,p.c_period_id,p.name, acct.a_accumdepreciation_acct,acct.A_Disposal_Gain_Acct,wk.a_asset_cost,acct.A_Disposal_RevenueC_Acct, acct.A_Disposal_RevenueD_Acct,acct.A_Disposal_Loss_Acct, wk.a_accumulated_depr, acct.A_AssetComplement_Acct from a_asset a inner join a_asset_acct acct on (a.a_asset_id=acct.a_asset_id) inner join A_Depreciation_Workfile wk on (a.a_asset_id=wk.a_asset_id) inner join a_asset_forecast fore on (a.a_asset_id=fore.a_asset_id) inner join c_period p on (fore.datedoc between p.startdate and p.enddate) where a.ad_client_id=? ";
        if (this.DepDoc.isSameYear()) {
            cal = Calendar.getInstance();
            cal.set(6, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else {
            cal = Calendar.getInstance();
            cal.set(6, 1);
            cal.set(1, cal.get(1) - 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
        String ID_grupo = "";
        try {
            int id_GrupoPadre = this.DepDoc.get_ValueAsInt("A_Asset_Group_Ref_ID");
            ID_grupo = id_GrupoPadre > 0 ? " a.A_Asset_Group_Ref_ID = " + this.DepDoc.get_ValueAsInt("A_Asset_Group_Ref_ID") : " a.a_asset_group_id = " + this.DepDoc.getA_Asset_Group_ID();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            ID_grupo = " a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID();
        }
        if (ID_grupo == null || ID_grupo == "") {
            ID_grupo = " a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID();
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
            sql = String.valueOf(sql) + " And p.c_period_id=" + this.DepDoc.getC_Period_ID() + " And fore.processed='N' and a.isinposession='Y' And " + ID_grupo;
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
            sql = String.valueOf(sql) + " And p.c_period_id=" + this.DepDoc.getC_Period_ID() + " And fore.Corrected='N' And a.isinposession='Y' And " + ID_grupo;
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("REV") || this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
            sql = String.valueOf(sql) + " And p.c_period_id=" + this.DepDoc.getC_Period_ID() + " And wk.a_asset_cost>wk.a_accumulated_depr+2 And " + ID_grupo + " and a.isinposession=" + (this.DepDoc.isInPosession() ? "'Y'" : "'N'");
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
            sql = String.valueOf(sql) + " And p.c_period_id=" + this.DepDoc.getC_Period_ID();
            int id_invoice = 0;
            try {
                id_invoice = this.DepDoc.get_ValueAsInt("C_Invoice_ID");
            }
            catch (Exception e) {
                id_invoice = 0;
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            sql = id_invoice > 0 ? String.valueOf(sql) + " And a.A_Asset_ID IN (SELECT DISTINCT(A_Asset_ID) FROM C_InvoiceLine WHERE C_Invoice_ID = " + this.DepDoc.get_ValueAsInt("C_Invoice_ID") + ")" : String.valueOf(sql) + " And a.A_Asset_ID=" + this.DepDoc.getA_Asset_ID();
        }
        if ((orgP = new MOrg(this.getCtx(), this.DepDoc.getAD_Org_ID(), this.get_TrxName())).getValue() != null && !orgP.getValue().contains("*")) {
            sql = String.valueOf(sql) + " and a.AD_OrgRef_ID=" + this.DepDoc.getAD_Org_ID();
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("VCO")) {
            int id_invoice = 0;
            try {
                id_invoice = this.DepDoc.get_ValueAsInt("C_Invoice_ID");
            }
            catch (Exception e) {
                id_invoice = 0;
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            sql = id_invoice > 0 ? String.valueOf(sql) + " And a.A_Asset_ID IN (SELECT DISTINCT(A_Asset_ID) FROM C_InvoiceLine WHERE C_Invoice_ID = " + this.DepDoc.get_ValueAsInt("C_Invoice_ID") + ")" : String.valueOf(sql) + " And a.A_Asset_ID = 0";
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("VCP")) {
            int id_invoice = 0;
            sql = "select a.a_asset_id,a.name,a.value,acct.c_acctschema_id, acct.a_asset_acct,  acct.a_depreciation_acct, acct.a_accumdepreciation_acct,acct.A_Disposal_Gain_Acct,wk.a_asset_cost,acct.A_Disposal_RevenueC_Acct, acct.A_Disposal_RevenueD_Acct,acct.A_Disposal_Loss_Acct, wk.a_accumulated_depr, acct.A_AssetComplement_Acct from a_asset a inner join a_asset_acct acct on (a.a_asset_id=acct.a_asset_id) inner join A_Depreciation_Workfile wk on (a.a_asset_id=wk.a_asset_id) where a.ad_client_id=? ";
            try {
                id_invoice = this.DepDoc.get_ValueAsInt("C_Invoice_ID");
            }
            catch (Exception e) {
                id_invoice = 0;
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            sql = id_invoice > 0 ? String.valueOf(sql) + " And a.A_Asset_ID IN (SELECT DISTINCT(A_Asset_ID) FROM C_InvoiceLine WHERE C_Invoice_ID = " + this.DepDoc.get_ValueAsInt("C_Invoice_ID") + ")" : String.valueOf(sql) + " And a.A_Asset_ID = 0";
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("RRV")) {
            int id_activo = 0;
            sql = "select a.a_asset_id,a.name,a.value,acct.c_acctschema_id, acct.a_asset_acct,  acct.a_depreciation_acct, acct.a_accumdepreciation_acct,acct.A_Disposal_Gain_Acct,wk.a_asset_cost,acct.A_Disposal_RevenueC_Acct, acct.A_Disposal_RevenueD_Acct,acct.A_Disposal_Loss_Acct, wk.a_accumulated_depr, acct.A_AssetComplement_Acct from a_asset a inner join a_asset_acct acct on (a.a_asset_id=acct.a_asset_id) inner join A_Depreciation_Workfile wk on (a.a_asset_id=wk.a_asset_id) where a.ad_client_id=? ";
            try {
                id_activo = this.DepDoc.get_ValueAsInt("A_Asset_ID");
            }
            catch (Exception e) {
                id_activo = 0;
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            sql = id_activo > 0 ? String.valueOf(sql) + " And a.A_Asset_ID IN (" + this.DepDoc.get_ValueAsInt("A_Asset_ID") + ")" : String.valueOf(sql) + " And a.A_Asset_ID = 0";
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("DDT")) {
            int id_activo = 0;
            sql = "select a.a_asset_id,a.name,a.value,acct.c_acctschema_id, acct.a_asset_acct,  acct.a_depreciation_acct, acct.a_accumdepreciation_acct,acct.A_Disposal_Gain_Acct,wk.a_asset_cost,acct.A_Disposal_RevenueC_Acct, acct.A_Disposal_RevenueD_Acct,acct.A_Disposal_Loss_Acct, wk.a_accumulated_depr, acct.A_AssetComplement_Acct from a_asset a inner join a_asset_acct acct on (a.a_asset_id=acct.a_asset_id) inner join A_Depreciation_Workfile wk on (a.a_asset_id=wk.a_asset_id) where a.ad_client_id=? ";
            try {
                id_activo = this.DepDoc.get_ValueAsInt("A_Asset_ID");
            }
            catch (Exception e) {
                id_activo = 0;
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            sql = id_activo > 0 ? String.valueOf(sql) + " And a.A_Asset_ID IN (" + this.DepDoc.get_ValueAsInt("A_Asset_ID") + ")" : String.valueOf(sql) + " And a.A_Asset_ID = 0";
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("DDP")) {
            sql = "select a.a_asset_id,a.name,a.value,acct.c_acctschema_id, acct.a_asset_acct,  acct.a_depreciation_acct, fore.amount,fore.a_asset_forecast_id, acct.a_accumdepreciation_acct,acct.A_Disposal_Gain_Acct,wk.a_asset_cost,acct.A_Disposal_RevenueC_Acct, acct.A_Disposal_RevenueD_Acct,acct.A_Disposal_Loss_Acct, wk.a_accumulated_depr, acct.A_AssetComplement_Acct from a_asset a inner join a_asset_acct acct on (a.a_asset_id=acct.a_asset_id) inner join A_Depreciation_Workfile wk on (a.a_asset_id=wk.a_asset_id) inner join a_asset_forecast fore on (a.a_asset_id=fore.a_asset_id) where a.ad_client_id=? ";
            sql = String.valueOf(sql) + " AND extract(year from fore.datedoc) = (select to_number(fiscalyear,'9999')  from c_year where c_year_id in (select c_year_id from c_period where c_period_id = " + this.DepDoc.getC_Period_ID() + ")) AND fore.processed='N' ";
            sql = String.valueOf(sql) + " and a.isinposession='Y' And " + ID_grupo;
            sql = String.valueOf(sql) + " and a.isactive='Y'";
            if (orgP.getValue() != null && !orgP.getValue().contains("*")) {
                sql = String.valueOf(sql) + " and a.AD_OrgRef_ID=" + this.DepDoc.getAD_Org_ID();
            }
        }
        this.log.config("SQL Activos: " + sql);
        CPreparedStatement pstmt = null;
        MJournalBatch batch = null;
        MJournal journal = null;
        MClient client = MClient.get((Properties)this.m_ctx, (int)Env.getAD_Client_ID((Properties)this.m_ctx));
        int count = 0;
        if (this.DepDoc.getDocStatus().equals("DR") && !this.DepDoc.getDepType().equalsIgnoreCase("ANC")) {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.DepDoc.getAD_Client_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    MJournalLine line2;
                    MJournalLine line1;
                    BigDecimal newAmount;
                    MJournalLine line22;
                    MJournalLine line12;
                    int ID_Org = 0;
                    if (this.DepDoc.getDepType().equalsIgnoreCase("VCO") || this.DepDoc.getDepType().equalsIgnoreCase("VCP") && this.DepDoc.getAD_Org_ID() < 1) {
                        MInvoice inv = new MInvoice(this.getCtx(), this.DepDoc.get_ValueAsInt("C_Invoice_ID"), this.get_TrxName());
                        ID_Org = inv.getAD_Org_ID();
                    } else {
                        ID_Org = this.DepDoc.getAD_Org_ID();
                    }
                    if (batch == null) {
                        batch = new MJournalBatch(this.m_ctx, 0, this.get_TrxName());
                        batch.setAD_Org_ID(ID_Org);
                        batch.setDescription("Assets Deprecation Process");
                        batch.setPostingType("A");
                        batch.setC_DocType_ID(MDocType.getOfDocBaseType((Properties)this.m_ctx, (String)"GLJ")[0].getC_DocType_ID());
                        batch.setGL_Category_ID(MGLCategory.getDefault((Properties)this.m_ctx, (String)"M").getGL_Category_ID());
                        batch.setDateAcct(this.DepDoc.getDateDoc());
                        batch.setDateDoc(this.DepDoc.getDateDoc());
                        batch.setC_Period_ID(MPeriod.getC_Period_ID((Properties)this.m_ctx, (Timestamp)this.DepDoc.getDateAcct()));
                        batch.setC_Currency_ID(client.getC_Currency_ID());
                        if (!batch.save()) {
                            return "la transaccion no puede ser generara para *";
                        }
                    }
                    ++count;
                    MAsset assetTemp = new MAsset(this.getCtx(), rs.getInt("a_asset_id"), this.get_TrxName());
                    journal = new MJournal(batch);
                    journal.setDescription(String.valueOf(rs.getString("value")) + "-" + rs.getString("name"));
                    journal.setC_AcctSchema_ID(MAcctSchema.getClientAcctSchema((Properties)this.m_ctx, (int)Env.getAD_Client_ID((Properties)this.m_ctx))[0].getC_AcctSchema_ID());
                    journal.setGL_Category_ID(MGLCategory.getDefault((Properties)this.m_ctx, (String)"D").getGL_Category_ID());
                    journal.setC_ConversionType_ID(114);
                    journal.set_ValueOfColumn("A_Asset_ID", rs.getInt("a_asset_id"));
                    if (!this.DepDoc.getDepType().equalsIgnoreCase("VCP")) {
                        journal.set_ValueOfColumn("A_Asset_Forecast_ID", rs.getInt("a_asset_forecast_id"));
                    }
                    journal.save();
                    journal.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                    journal.save();
                    if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                        line12 = new MJournalLine(journal);
                        line12.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line12.setAmtSourceDr(rs.getBigDecimal("amount"));
                        line12.setAmtSourceCr(Env.ZERO);
                        line12.setAmtAcct(rs.getBigDecimal("amount"), Env.ZERO);
                        line12.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                        line12.save();
                        line12.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line12.save();
                        line22 = new MJournalLine(journal);
                        line22.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line22.setAmtSourceDr(Env.ZERO);
                        line22.setAmtSourceCr(rs.getBigDecimal("amount"));
                        line22.setAmtAcct(Env.ZERO, rs.getBigDecimal("amount"));
                        line22.setC_ValidCombination_ID(rs.getInt("A_AssetComplement_Acct"));
                        line22.save();
                        line22.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line22.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
                        batch.setDescription("Correcion Monetaria");
                        line12 = new MJournalLine(journal);
                        line12.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line12.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line12.setAmtSourceCr(Env.ZERO);
                            line12.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)), Env.ZERO);
                        } else if (this.DepDoc.getRate().signum() < 0) {
                            line12.setAmtSourceDr(Env.ZERO);
                            line12.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line12.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                        }
                        line12.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                        line12.save();
                        line12.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line12.save();
                        line22 = new MJournalLine(journal);
                        line22.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line22.setAmtSourceDr(Env.ZERO);
                            line22.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line22.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                        }
                        if (this.DepDoc.getRate().signum() < 0) {
                            line22.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line22.setAmtSourceCr(Env.ZERO);
                            line22.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)), Env.ZERO);
                        }
                        line22.setC_ValidCombination_ID(rs.getInt("a_accumdepreciation_acct"));
                        line22.save();
                        line22.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line22.save();
                        MJournalLine line3 = new MJournalLine(journal);
                        line3.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line3.setAmtSourceDr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line3.setAmtSourceCr(Env.ZERO);
                            line3.setAmtAcct(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)), Env.ZERO);
                        }
                        if (this.DepDoc.getRate().signum() < 0) {
                            line3.setAmtSourceDr(Env.ZERO);
                            line3.setAmtSourceCr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line3.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                        }
                        line3.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line3.save();
                        line3.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line3.save();
                        MJournalLine line4 = new MJournalLine(journal);
                        line4.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line4.setAmtSourceDr(Env.ZERO);
                            line4.setAmtSourceCr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line4.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                        }
                        if (this.DepDoc.getRate().signum() < 0) {
                            line4.setAmtSourceDr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line4.setAmtSourceCr(Env.ZERO);
                            line4.setAmtAcct(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)), Env.ZERO);
                        }
                        line4.setC_ValidCombination_ID(rs.getInt("a_accumdepreciation_acct"));
                        line4.save();
                        line4.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line4.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                        batch.setDescription("Reevaluacion Activos");
                        newAmount = new BigDecimal(0.0);
                        newAmount = rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED));
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line1.save();
                        line1.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("A_Disposal_Gain_Acct"));
                        line2.save();
                        line2.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line2.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
                        batch.setDescription("Deteriodo Activos");
                        newAmount = new BigDecimal(0.0);
                        newAmount = rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED));
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("A_Disposal_Loss_Acct"));
                        line1.save();
                        line1.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line2.save();
                        line2.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line2.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                        newAmount = new BigDecimal(0.0);
                        newAmount = rs.getBigDecimal("a_asset_cost").subtract(rs.getBigDecimal("a_accumulated_depr"));
                        newAmount = newAmount.add(Env.ONE);
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                        line1.save();
                        line1.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line2.save();
                        line2.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line2.save();
                        MJournalLine line3 = new MJournalLine(journal);
                        line3.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line3.setAmtSourceDr(this.DepDoc.getRate());
                        line3.setAmtSourceCr(Env.ZERO);
                        line3.setAmtAcct(this.DepDoc.getRate(), Env.ZERO);
                        line3.setC_ValidCombination_ID(rs.getInt("A_Disposal_RevenueD_Acct"));
                        line3.save();
                        line3.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line3.save();
                        MJournalLine line4 = new MJournalLine(journal);
                        line4.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line4.setAmtSourceDr(Env.ZERO);
                        line4.setAmtSourceCr(this.DepDoc.getRate());
                        line4.setAmtAcct(Env.ZERO, this.DepDoc.getRate());
                        line4.setC_ValidCombination_ID(rs.getInt("A_Disposal_RevenueC_Acct"));
                        line4.save();
                        line4.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line4.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("VCO") || this.DepDoc.getDepType().equalsIgnoreCase("VCP")) {
                        BigDecimal newAmountCost = new BigDecimal(0.0);
                        BigDecimal newAmountDep = new BigDecimal(0.0);
                        newAmountCost = rs.getBigDecimal("a_asset_cost");
                        newAmountDep = rs.getBigDecimal("a_accumulated_depr");
                        MJournalLine line13 = new MJournalLine(journal);
                        line13.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line13.setAmtSourceDr(newAmountDep);
                        line13.setAmtSourceCr(Env.ZERO);
                        line13.setAmtAcct(newAmountDep, Env.ZERO);
                        line13.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                        line13.save();
                        line13.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line13.save();
                        MJournalLine line23 = new MJournalLine(journal);
                        line23.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line23.setAmtSourceDr(newAmountCost.subtract(newAmountDep));
                        line23.setAmtSourceCr(Env.ZERO);
                        line23.setAmtAcct(newAmountCost.subtract(newAmountDep), Env.ZERO);
                        line23.setC_ValidCombination_ID(rs.getInt("A_Disposal_RevenueD_Acct"));
                        line23.save();
                        line23.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line23.save();
                        MJournalLine line3 = new MJournalLine(journal);
                        line3.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line3.setAmtSourceDr(Env.ZERO);
                        line3.setAmtSourceCr(newAmountCost);
                        line3.setAmtAcct(Env.ZERO, newAmountCost);
                        line3.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line3.save();
                        line3.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line3.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("RRV")) {
                        batch.setDescription("Reevaluacion Activos");
                        newAmount = new BigDecimal(0.0);
                        newAmount = rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED));
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line1.save();
                        line1.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("A_Disposal_Gain_Acct"));
                        line2.save();
                        line2.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line2.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("DDT")) {
                        batch.setDescription("Deterioro Activos");
                        newAmount = new BigDecimal(0.0);
                        newAmount = rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED));
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("A_Disposal_Loss_Acct"));
                        line1.save();
                        line1.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line2.save();
                        line2.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                        line2.save();
                        continue;
                    }
                    if (!this.DepDoc.getDepType().equalsIgnoreCase("DDP")) continue;
                    line12 = new MJournalLine(journal);
                    line12.setA_Asset_ID(rs.getInt("a_asset_id"));
                    line12.setAmtSourceDr(rs.getBigDecimal("amount"));
                    line12.setAmtSourceCr(Env.ZERO);
                    line12.setAmtAcct(rs.getBigDecimal("amount"), Env.ZERO);
                    line12.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                    line12.save();
                    line12.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                    line12.save();
                    line22 = new MJournalLine(journal);
                    line22.setA_Asset_ID(rs.getInt("a_asset_id"));
                    line22.setAmtSourceDr(Env.ZERO);
                    line22.setAmtSourceCr(rs.getBigDecimal("amount"));
                    line22.setAmtAcct(Env.ZERO, rs.getBigDecimal("amount"));
                    line22.setC_ValidCombination_ID(rs.getInt("A_AssetComplement_Acct"));
                    line22.save();
                    line22.setAD_Org_ID(assetTemp.get_ValueAsInt("AD_OrgRef_ID"));
                    line22.save();
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            if (count > 0) {
                this.DepDoc.setGL_JournalBatch_ID(batch.getGL_JournalBatch_ID());
                DB.executeUpdate((String)("Update GL_JournalLine set A_Asset_Dep_ID=" + this.DepDoc.getA_Asset_Dep_ID() + " Where GL_Journal_ID IN (select GL_Journal_ID from GL_Journal where GL_JournalBatch_ID=" + batch.getGL_JournalBatch_ID() + " )"), (String)this.get_TrxName());
            } else if (batch != null) {
                batch.delete(true, this.get_TrxName());
            }
            this.DepDoc.setDocStatus("IP");
            this.DepDoc.save();
        } else if (this.DepDoc.getDocStatus().equals("DR") && this.DepDoc.getDepType().equalsIgnoreCase("ANC")) {
            this.DepDoc.setDocStatus("IP");
            this.DepDoc.save();
        } else if (!(!this.DepDoc.getDocStatus().equals("IP") || this.DepDoc.isVoid() || this.DepDoc.getDepType().equalsIgnoreCase("ANC") || this.DepDoc.getDepType().equalsIgnoreCase("VCO") || this.DepDoc.getDepType().equalsIgnoreCase("VCP"))) {
            this.log.info("IP");
            batch = new MJournalBatch(this.m_ctx, this.DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
            batch.processIt("CO");
            batch.save();
            batch.setProcessed(true);
            batch.save();
            MJournal[] journals = batch.getJournals(true);
            int i = 0;
            while (i < journals.length) {
                X_A_Asset_Forecast fore;
                MDepreciationWorkfile workfile;
                MJournal jour = journals[i];
                X_A_Asset asset = new X_A_Asset(this.getCtx(), jour.get_ValueAsInt("A_Asset_ID"), null);
                if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(jour.getTotalCr()));
                    workfile.setA_Period_Posted(workfile.getA_Period_Posted() + 1);
                    workfile.setAssetDepreciationDate(this.DepDoc.getDateDoc());
                    workfile.save();
                    fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setProcessed(true);
                    fore.setGL_Journal_ID(jour.getGL_Journal_ID());
                    fore.save();
                    asset.setLastMaintenanceNote("Depreciacion Periodo :" + (workfile.getA_Period_Posted() + 1) + " por " + jour.getTotalCr());
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    MAssetAcct group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    BigDecimal acum = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct()), (Object[])new Object[0]);
                    acum = acum.subtract(DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct()), (Object[])new Object[0]));
                    BigDecimal neto = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Asset_Acct()), (Object[])new Object[0]);
                    neto = neto.subtract(DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Asset_Acct()), (Object[])new Object[0]));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(acum));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(neto));
                    workfile.save();
                    X_A_Asset_Forecast fore2 = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore2.setCorrected(true);
                    fore2.save();
                    asset.setLastMaintenanceNote("CM Periodo " + this.DepDoc.getRate() + " % Valor:" + neto);
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("RRV")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(jour.getTotalCr()));
                    workfile.save();
                    if (this.DepDoc.get_ValueAsInt("A_Asset_Life_Years") > 0) {
                        DB.executeUpdate((String)("Update a_asset_acct set a_period_end = " + this.DepDoc.get_ValueAsInt("A_Asset_Life_Years") + " WHERE a_Asset_id = " + jour.get_ValueAsInt("A_Asset_ID")), (String)this.get_TrxName());
                    }
                    try {
                        asset.set_CustomColumn("GrandTotal", (Object)workfile.getA_Asset_Cost());
                        asset.save();
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    }
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DDT")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(jour.getTotalCr()));
                    workfile.save();
                    if (this.DepDoc.get_ValueAsInt("A_Asset_Life_Years") > 0) {
                        DB.executeUpdate((String)("Update a_asset_acct set a_period_end = " + this.DepDoc.get_ValueAsInt("A_Asset_Life_Years") + " WHERE a_Asset_id = " + jour.get_ValueAsInt("A_Asset_ID")), (String)this.get_TrxName());
                    }
                    try {
                        asset.set_CustomColumn("GrandTotal", (Object)workfile.getA_Asset_Cost());
                        asset.save();
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    }
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Calc_Accumulated_Depr(workfile.getA_Accumulated_Depr());
                    workfile.setA_Accumulated_Depr(workfile.getA_Asset_Cost());
                    workfile.save();
                    asset.setLastMaintenanceNote("Venta Activo");
                    DB.executeUpdate((String)("Update A_Asset_Forecast set processed='Y', corrected='Y' where A_Asset_ID=" + jour.get_ValueAsInt("A_Asset_ID")), (String)this.get_TrxName());
                    asset.setIsFullyDepreciated(true);
                    asset.set_CustomColumn("AssetStatus", (Object)"BAJ");
                    asset.set_CustomColumn("A_Asset_RevalDate", (Object)this.DepDoc.getDateDoc());
                    asset.save();
                    asset.setIsActive(false);
                    asset.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DDP")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(jour.getTotalCr()));
                    workfile.setA_Period_Posted(workfile.getA_Period_Posted() + 1);
                    workfile.setAssetDepreciationDate(this.DepDoc.getDateDoc());
                    workfile.save();
                    fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setProcessed(true);
                    fore.setGL_Journal_ID(jour.getGL_Journal_ID());
                    fore.save();
                    asset.setLastMaintenanceNote("Depreciacion Periodo :" + (workfile.getA_Period_Posted() + 1) + " por " + jour.getTotalCr());
                }
                this.log.config("deptype " + this.DepDoc.getDepType());
                ++i;
            }
            this.DepDoc.setDocStatus("CO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
        } else if (this.DepDoc.getDocStatus().equals("IP") && !this.DepDoc.isVoid() && this.DepDoc.getDepType().equalsIgnoreCase("ANC")) {
            if (this.DepDoc.getDepType().equalsIgnoreCase("ANC")) {
                String sqlANC = " ";
                int id_invoice = 0;
                try {
                    id_invoice = this.DepDoc.get_ValueAsInt("C_Invoice_ID");
                }
                catch (Exception e) {
                    id_invoice = 0;
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                }
                sqlANC = id_invoice > 0 ? " SELECT DISTINCT(A_Asset_ID) as A_Asset_ID FROM C_InvoiceLine WHERE C_Invoice_ID = " + this.DepDoc.get_ValueAsInt("C_Invoice_ID") : " SELECT A_Asset_ID FROM A_Asset WHERE A_Asset_ID=" + this.DepDoc.getA_Asset_ID();
                CPreparedStatement pstmtANC = DB.prepareStatement((String)sqlANC, (String)this.get_TrxName());
                ResultSet rsANC = pstmtANC.executeQuery();
                while (rsANC.next()) {
                    if (rsANC.getInt("A_Asset_ID") <= 0) continue;
                    X_A_Asset assetANC = new X_A_Asset(this.getCtx(), rsANC.getInt("A_Asset_ID"), null);
                    assetANC.setIsFullyDepreciated(true);
                    assetANC.setLastMaintenanceNote("Venta Activo");
                    assetANC.set_CustomColumn("AssetStatus", (Object)"BAJ");
                    assetANC.save();
                    assetANC.setIsActive(false);
                    assetANC.set_CustomColumn("A_Asset_RevalDate", (Object)this.DepDoc.getDateDoc());
                    assetANC.save();
                    int cantWK = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM A_Depreciation_Workfile WHERE IsActive = 'Y' AND A_Asset_ID  = " + assetANC.get_ID()));
                    if (cantWK > 0) {
                        MDepreciationWorkfile workfile = MAsset.getWorkFile(assetANC.get_ID());
                        workfile.setA_Calc_Accumulated_Depr(workfile.getA_Accumulated_Depr());
                        workfile.setA_Accumulated_Depr(workfile.getA_Asset_Cost());
                        workfile.save();
                    }
                    DB.executeUpdate((String)("Update A_Asset_Forecast set processed='Y', corrected='Y' where A_Asset_ID=" + assetANC.get_ID()), (String)this.get_TrxName());
                }
            }
            this.DepDoc.setDocStatus("CO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
        } else if (this.DepDoc.getDocStatus().equals("IP") && !this.DepDoc.isVoid() && (this.DepDoc.getDepType().equalsIgnoreCase("VCO") || this.DepDoc.getDepType().equalsIgnoreCase("VCP"))) {
            this.log.info("IP, Baja consolidad activos contables");
            if (this.DepDoc.getGL_JournalBatch_ID() > 0) {
                batch = new MJournalBatch(this.m_ctx, this.DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
                batch.processIt("CO");
                batch.save();
                batch.setProcessed(true);
                batch.save();
                MJournal[] journals = batch.getJournals(true);
                int i = 0;
                while (i < journals.length) {
                    MJournal jour = journals[i];
                    X_A_Asset asset = new X_A_Asset(this.getCtx(), jour.get_ValueAsInt("A_Asset_ID"), null);
                    MDepreciationWorkfile workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Calc_Accumulated_Depr(workfile.getA_Accumulated_Depr());
                    workfile.setA_Accumulated_Depr(workfile.getA_Asset_Cost());
                    workfile.save();
                    asset.setLastMaintenanceNote("Venta Activo");
                    DB.executeUpdate((String)("Update A_Asset_Forecast set processed='Y', corrected='Y' where A_Asset_ID=" + jour.get_ValueAsInt("A_Asset_ID")), (String)this.get_TrxName());
                    asset.setIsFullyDepreciated(true);
                    asset.set_CustomColumn("AssetStatus", (Object)"BAJ");
                    asset.set_CustomColumn("A_Asset_RevalDate", (Object)this.DepDoc.getDateDoc());
                    asset.save();
                    asset.setIsActive(false);
                    asset.save();
                    ++i;
                }
            }
            this.log.info("IP, Baja consolidad activos NO contables");
            String sqlANC = " ";
            int id_invoice = 0;
            try {
                id_invoice = this.DepDoc.get_ValueAsInt("C_Invoice_ID");
            }
            catch (Exception e) {
                id_invoice = 0;
                this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            }
            if (id_invoice > 0) {
                sqlANC = " SELECT DISTINCT(A_Asset_ID) as A_Asset_ID FROM C_InvoiceLine WHERE C_Invoice_ID = " + this.DepDoc.get_ValueAsInt("C_Invoice_ID");
                CPreparedStatement pstmtANC = DB.prepareStatement((String)sqlANC, (String)this.get_TrxName());
                ResultSet rsANC = pstmtANC.executeQuery();
                while (rsANC.next()) {
                    if (rsANC.getInt("A_Asset_ID") <= 0) continue;
                    X_A_Asset assetANC = new X_A_Asset(this.getCtx(), rsANC.getInt("A_Asset_ID"), null);
                    assetANC.setIsFullyDepreciated(true);
                    assetANC.setLastMaintenanceNote("Venta Activo");
                    assetANC.set_CustomColumn("AssetStatus", (Object)"BAJ");
                    assetANC.save();
                    assetANC.setIsActive(false);
                    assetANC.set_CustomColumn("A_Asset_RevalDate", (Object)this.DepDoc.getDateDoc());
                    assetANC.save();
                    int cantWK = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM A_Depreciation_Workfile WHERE IsActive = 'Y' AND A_Asset_ID  = " + assetANC.get_ID()));
                    if (cantWK > 0) {
                        MDepreciationWorkfile workfile = MAsset.getWorkFile(assetANC.get_ID());
                        workfile.setA_Calc_Accumulated_Depr(workfile.getA_Accumulated_Depr());
                        workfile.setA_Accumulated_Depr(workfile.getA_Asset_Cost());
                        workfile.save();
                    }
                    DB.executeUpdate((String)("Update A_Asset_Forecast set processed='Y', corrected='Y' where A_Asset_ID=" + assetANC.get_ID()), (String)this.get_TrxName());
                }
            }
            this.DepDoc.setDocStatus("CO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
        } else if (this.DepDoc.getDocStatus().equals("CO") && this.DepDoc.isVoid()) {
            batch = new MJournalBatch(this.m_ctx, this.DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
            MJournal[] journals = batch.getJournals(true);
            int i = 0;
            while (i < journals.length) {
                MDepreciationWorkfile workfile;
                MJournal jour = journals[i];
                if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(jour.getTotalCr()));
                    workfile.setA_Period_Posted(workfile.getA_Period_Posted() - 1);
                    workfile.setAssetDepreciationDate(this.DepDoc.getDateDoc());
                    workfile.save();
                    X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), this.get_TrxName());
                    fore.setProcessed(false);
                    fore.setGL_Journal_ID(0);
                    fore.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    MAssetAcct group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    BigDecimal acum = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct()), (Object[])new Object[0]);
                    BigDecimal neto = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct()), (Object[])new Object[0]);
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(neto));
                    workfile.save();
                    X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setCorrected(false);
                    fore.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Calc_Accumulated_Depr());
                    workfile.save();
                    DB.executeUpdate((String)("Update A_Asset_Forecast set processed='N', corrected='N' where gl_journal_id is null and A_Asset_ID=" + jour.get_ValueAsInt("A_Asset_ID")), (String)this.get_TrxName());
                }
                ++i;
            }
            MJournal[] mJournalArray = journals;
            int n = journals.length;
            int n2 = 0;
            while (n2 < n) {
                MJournal j = mJournalArray[n2];
                DB.executeUpdate((String)("delete from fact_acct where record_id=" + j.getGL_Journal_ID() + " and ad_table_id=" + I_GL_Journal.Table_ID), (String)this.get_TrxName());
                DB.executeUpdate((String)("delete from gl_journalline where gl_journal_id=" + j.getGL_Journal_ID()), (String)this.get_TrxName());
                ++n2;
            }
            DB.executeUpdate((String)("delete from gl_journal where gl_journalbatch_id=" + batch.getGL_JournalBatch_ID()), (String)this.get_TrxName());
            this.DepDoc.setDocStatus("VO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
        }
        this.commitEx();
        return "";
    }
}

