/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class UpdatePriceOLine
extends SvrProcess {
    private int id_OrderLine;
    private BigDecimal priceNew;
    private String p_Password;

    protected void prepare() {
        this.id_OrderLine = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (para[i].getParameterName().equals("Price")) {
                    this.priceNew = para[i].getParameterAsBigDecimal();
                } else if (para[i].getParameterName().equals("Password")) {
                    this.p_Password = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MOrderLine oLine = new MOrderLine(this.getCtx(), this.id_OrderLine, this.get_TrxName());
        MOrder order = new MOrder(this.getCtx(), oLine.getC_Order_ID(), this.get_TrxName());
        MClient client = new MClient(this.getCtx(), oLine.getAD_Client_ID(), this.get_TrxName());
        String msg = "";
        if ((order.getDocStatus().compareTo("DR") == 0 || order.getDocStatus().compareTo("IP") == 0 || order.getDocStatus().compareTo("IN") == 0) && client.get_ValueAsString("PricePassword").compareTo(this.p_Password) == 0) {
            oLine.setPrice(this.priceNew);
            oLine.setLineNetAmt();
            oLine.set_CustomColumn("MonthlyAmount", this.priceNew.divide(new BigDecimal(12)));
            oLine.setTax();
            oLine.save();
            msg = "Precio Actualizado";
        } else {
            msg = "Error: Password Incorrecta";
        }
        return msg;
    }
}

