/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class UpdateDateEndOLine
extends SvrProcess {
    private int id_OrderLine;
    private Timestamp p_DatePromised;

    protected void prepare() {
        this.id_OrderLine = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (para[i].getParameterName().equals("DatePromised")) {
                    this.p_DatePromised = para[i].getParameterAsTimestamp();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        Timestamp dateStart;
        MOrderLine oLine = new MOrderLine(this.getCtx(), this.id_OrderLine, this.get_TrxName());
        MOrder order = new MOrder(this.getCtx(), oLine.getC_Order_ID(), this.get_TrxName());
        String msg = "";
        if (!(order.getDocStatus().compareTo("DR") != 0 && order.getDocStatus().compareTo("IP") != 0 && order.getDocStatus().compareTo("IN") != 0 || oLine.get_ValueAsBoolean("IsFree") || (dateStart = (Timestamp)oLine.get_Value("DatePromised2")) == null || this.p_DatePromised.compareTo(dateStart) <= 0)) {
            int dayInicial = dateStart.getDate();
            int dayNew = this.p_DatePromised.getDate();
            int CorrectDay = dayInicial - 1;
            if (CorrectDay <= 0) {
                if (dayNew < 28) {
                    throw new AdempiereException("Error: Dia de termino incorrecto.");
                }
            } else if (dayNew != dayInicial - 1) {
                throw new AdempiereException("Error: Dia debe ser " + CorrectDay);
            }
            BigDecimal newAmt = null;
            Timestamp dateEnd = (Timestamp)oLine.get_Value("DatePromised3");
            long dif1 = dateEnd.getTime() - dateStart.getTime();
            long dif2 = this.p_DatePromised.getTime() - dateStart.getTime();
            newAmt = oLine.getPriceEntered().multiply(new BigDecimal(dif2 *= 86400000L));
            newAmt = newAmt.divide(new BigDecimal(dif1 *= 86400000L), 0, RoundingMode.HALF_EVEN);
            oLine.setPrice(newAmt);
            oLine.setLineNetAmt();
            oLine.setTax();
            oLine.set_CustomColumn("DatePromised3", this.p_DatePromised);
            oLine.save();
            msg = "Precio Actualizado";
        }
        return msg;
    }
}

