/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequest;
import org.compiere.model.MResolution;
import org.compiere.model.X_C_OrderShipCalendar;
import org.compiere.model.X_R_RequestLine;
import org.compiere.model.X_R_RequestLineAction;
import org.compiere.model.X_R_ServiceRequest;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ProcessRequest
extends SvrProcess {
    private int ID_Request;

    protected void prepare() {
        this.ID_Request = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRequest req = new MRequest(this.getCtx(), this.ID_Request, this.get_TrxName());
        String strMsg = "Ticket Procesado";
        if (req.get_ValueAsString("DocStatus").compareTo("DR") == 0) {
            if (req.get_ValueAsInt("C_BPartnerContact_ID") > 0) {
                boolean flag = false;
                if (req.get_ValueAsInt("C_BPartnerContact_ID") == req.getC_Order().getC_BPartner_ID()) {
                    flag = true;
                } else {
                    int cant = DB.getSQLValue((String)this.get_TrxName(), (String)("select count(1) FROM C_OrderLine WHERE C_Order_ID = " + req.getC_Order_ID() + " AND C_BpartnerRef_ID = " + req.get_ValueAsInt("C_BPartnerContact_ID")));
                    if (cant > 0) {
                        flag = true;
                    }
                }
                if (!flag) {
                    throw new AdempiereException("Error: El socio de contacto debe estar relacionada con la orden");
                }
            }
            String sql = "SELECT ol.Line, ol.C_BPartner_ID, ol.C_BPartnerRef_ID,ol.M_Product_ID, ol.DatePromised2, ol.DatePromised3, ol.C_BPartner_Location_ID,ol.QtyEntered, ol.C_OrderLine_ID  FROM C_OrderLine ol  INNER JOIN M_Product mp ON (ol.M_Product_ID = mp.M_Product_ID) INNER JOIN M_Product_Category pc ON (mp.M_Product_Category_ID = pc.M_Product_Category_ID)  WHERE pc.description like 'EDITORIAL'  AND ol.IsActive = 'Y' AND ol.M_Product_ID > 0 AND ol.C_Order_ID = " + req.get_ValueAsInt("C_Order_ID");
            if (req.get_ValueAsInt("C_BPartner_ID") > 0) {
                sql = String.valueOf(sql) + " AND ol.C_BPartnerRef_ID = " + req.get_ValueAsInt("C_BPartner_ID");
            }
            if (req.get_ValueAsInt("C_BPartner_Location_ID") > 0) {
                sql = String.valueOf(sql) + " AND ol.C_BPartner_Location_ID = " + req.get_ValueAsInt("C_BPartner_Location_ID");
            }
            if (req.get_ValueAsInt("C_OrderLine_ID") > 0) {
                sql = String.valueOf(sql) + " AND ol.C_OrderLine_ID = " + req.get_ValueAsInt("C_OrderLine_ID");
            }
            sql = String.valueOf(sql) + " ORDER BY ol.Line";
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            try {
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_R_RequestLine rLine = new X_R_RequestLine(this.getCtx(), 0, this.get_TrxName());
                    rLine.setR_Request_ID(req.get_ID());
                    rLine.setAD_Org_ID(req.getAD_Org_ID());
                    rLine.setLine(rs.getInt("Line"));
                    rLine.setC_BPartner_ID(rs.getInt("C_BPartner_ID"));
                    rLine.setC_BPartnerRef_ID(rs.getInt("C_BPartnerRef_ID"));
                    rLine.setM_Product_ID(rs.getInt("M_Product_ID"));
                    rLine.setDatePromised2(rs.getTimestamp("DatePromised2"));
                    rLine.setDatePromised3(rs.getTimestamp("DatePromised3"));
                    rLine.setC_BPartner_Location_ID(rs.getInt("C_BPartner_Location_ID"));
                    rLine.setQtyEntered(rs.getBigDecimal("QtyEntered"));
                    rLine.set_CustomColumn("C_OrderLine_ID", rs.getInt("C_OrderLine_ID"));
                    Timestamp inicio = (Timestamp)req.get_Value("StartDate");
                    Timestamp fin = (Timestamp)req.get_Value("EndDate");
                    if (req.get_ValueAsString("RequestAcction") != null && req.get_ValueAsString("RequestAcction").length() > 0) {
                        rLine.setRequestAcction(req.get_ValueAsString("RequestAcction"));
                    }
                    if (inicio != null) {
                        rLine.setDatePromised2Ref(inicio);
                    }
                    if (fin != null) {
                        rLine.setDatePromised3Ref(fin);
                    }
                    if (req.get_ValueAsInt("C_BPartner_LocationRef_ID") > 0) {
                        rLine.set_CustomColumn("C_BPartner_LocationRef_ID", req.get_ValueAsInt("C_BPartner_LocationRef_ID"));
                    }
                    rLine.save();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
            req.set_CustomColumn("DocStatus", (Object)"IP");
        } else if (req.get_ValueAsString("DocStatus").compareTo("IP") == 0) {
            if (req.get_ValueAsInt("C_BPartnerContact_ID") > 0) {
                boolean flag = false;
                if (req.get_ValueAsInt("C_BPartnerContact_ID") == req.getC_Order().getC_BPartner_ID()) {
                    flag = true;
                } else {
                    int cant = DB.getSQLValue((String)this.get_TrxName(), (String)("select count(1) FROM C_OrderLine WHERE C_Order_ID = " + req.getC_Order_ID() + " AND C_BpartnerRef_ID = " + req.get_ValueAsInt("C_BPartnerContact_ID")));
                    if (cant > 0) {
                        flag = true;
                    }
                }
                if (!flag) {
                    throw new AdempiereException("Error: El socio de contacto debe estar relacionada con la orden");
                }
            }
            if (req.get_ValueAsString("RequestAcction").compareTo("G") == 0) {
                X_R_ServiceRequest sReq = new X_R_ServiceRequest(this.getCtx(), 0, this.get_TrxName());
                sReq.setAD_Org_ID(0);
                sReq.setIsActive(true);
                sReq.setC_Order_ID(req.getC_Order_ID());
                sReq.setC_OrderLine_ID(req.get_ValueAsInt("C_OrderLine_ID"));
                sReq.setR_Request_ID(req.get_ID());
                if (req.getR_Resolution_ID() > 0) {
                    MResolution rType = new MResolution(this.getCtx(), req.getR_Resolution_ID(), this.get_TrxName());
                    if (rType.get_ValueAsInt("AD_Workflow_ID") > 0) {
                        sReq.setAD_Workflow_ID(rType.get_ValueAsInt("AD_Workflow_ID"));
                    }
                    if (rType.get_ValueAsInt("AD_WF_Node_ID") > 0) {
                        sReq.set_CustomColumn("AD_WF_Node_ID", rType.get_ValueAsInt("AD_WF_Node_ID"));
                        int cantUser = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_WF_Node_AccessCOPESA  WHERE AD_WF_Node_ID = " + rType.get_ValueAsInt("AD_WF_Node_ID") + " AND IsActive = 'Y'"));
                        if (cantUser >= 1) {
                            int ID_User = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MIN(AD_User_ID) FROM AD_WF_Node_AccessCOPESA  WHERE AD_WF_Node_ID = " + rType.get_ValueAsInt("AD_WF_Node_ID") + " AND IsActive = 'Y'"));
                            sReq.setAD_User_ID(ID_User);
                        }
                    }
                }
                sReq.setSR_AccountType(req.get_ValueAsString("SR_AccountType"));
                sReq.setSR_Amt((BigDecimal)req.get_Value("SR_Amt"));
                sReq.setSR_BPartner_Loaction_ID(req.get_ValueAsInt("SR_BPartner_Loaction_ID"));
                sReq.setSR_ChargeDate((Timestamp)req.get_Value("SR_ChargeDate"));
                sReq.setSR_Comments(req.get_ValueAsString("SR_Comments"));
                sReq.setSR_CorrectValue(req.get_ValueAsString("SR_CorrectValue"));
                sReq.setSR_CreditCardDueDate(req.get_ValueAsString("SR_CreditCardDueDate"));
                sReq.setSR_CreditCardNo(req.get_ValueAsString("SR_CreditCardNo"));
                sReq.setSR_Date((Timestamp)req.get_Value("SR_Date"));
                sReq.setSR_Description(req.get_ValueAsString("SR_Description"));
                sReq.setSR_DueDate((Timestamp)req.get_Value("SR_DueDate"));
                sReq.setSR_EditionNo(req.get_ValueAsString("SR_EditionNo"));
                sReq.setSR_EMail(req.get_ValueAsString("SR_EMail"));
                sReq.setSR_InvoiceNo(req.get_ValueAsString("SR_InvoiceNo"));
                sReq.setSR_Last4Digits(req.get_ValueAsString("SR_Last4Digits"));
                sReq.setSR_Name(req.get_ValueAsString("SR_Name"));
                sReq.setSR_OperationNo(req.get_ValueAsString("SR_OperationNo"));
                if (req.get_ValueAsString("SR_PartialOrTotal") != null && req.get_ValueAsString("SR_PartialOrTotal").trim().length() > 0) {
                    sReq.setSR_PartialOrTotal(req.get_ValueAsString("SR_PartialOrTotal"));
                }
                sReq.setSR_Phone(req.get_ValueAsString("SR_Phone"));
                if (req.get_ValueAsString("SR_Reason") != null && req.get_ValueAsString("SR_Reason").trim().length() > 0) {
                    sReq.setSR_Reason(req.get_ValueAsString("SR_Reason"));
                }
                sReq.setSR_Reference(req.get_ValueAsString("SR_Reference"));
                sReq.setSR_User_ID(req.get_ValueAsInt("SR_User_ID"));
                sReq.set_CustomColumn("SR_PhoneUser_ID", req.get_ValueAsInt("SR_PhoneUser_ID"));
                sReq.set_CustomColumn("CreditCardType", req.get_ValueAsInt("CreditCardType"));
                sReq.save();
                req.set_CustomColumn("DocStatus", (Object)"IS");
                req.setProcessed(true);
            } else {
                int cantFlag = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM R_RequestLine  WHERE R_Request_ID = " + req.get_ID() + " AND (RequestAcction IS NOT NULL AND RequestAcction <> '" + req.get_ValueAsString("RequestAcction") + "')"));
                if (cantFlag > 0) {
                    throw new AdempiereException("Acci\u00f3n en las lineas no concordante");
                }
                String sql = " SELECT R_RequestLine_ID  FROM R_RequestLine WHERE IsActive = 'Y'  AND R_Request_ID = " + req.get_ID();
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                try {
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ResultSet rsNLine;
                        CPreparedStatement pstmtNLine;
                        String sqlNLine;
                        X_R_RequestLineAction rLAction;
                        X_C_OrderShipCalendar oLineShip;
                        ResultSet rsZoom;
                        CPreparedStatement pstmtZoom;
                        String sqlZoom;
                        X_R_RequestLine rLine = new X_R_RequestLine(this.getCtx(), rs.getInt("R_RequestLine_ID"), this.get_TrxName());
                        if (rLine.getRequestAcction() != null && rLine.getRequestAcction().compareTo("Z") == 0) {
                            sqlZoom = " SELECT C_OrderShipCalendar_ID  FROM C_OrderShipCalendar WHERE IsActive = 'Y'  AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND dateTrx >= ? AND dateTrx <= ? ";
                            pstmtZoom = DB.prepareStatement((String)sqlZoom, (String)this.get_TrxName());
                            try {
                                pstmtZoom.setTimestamp(1, rLine.getDatePromised2Ref());
                                pstmtZoom.setTimestamp(2, rLine.getDatePromised3Ref());
                                rsZoom = pstmtZoom.executeQuery();
                                while (rsZoom.next()) {
                                    oLineShip = new X_C_OrderShipCalendar(this.getCtx(), rsZoom.getInt("C_OrderShipCalendar_ID"), this.get_TrxName());
                                    oLineShip.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                    oLineShip.setIsActive(false);
                                    oLineShip.save();
                                    rLAction = new X_R_RequestLineAction(this.getCtx(), 0, this.get_TrxName());
                                    rLAction.setR_Request_ID(rLine.getR_Request_ID());
                                    rLAction.setR_RequestLine_ID(rLine.get_ID());
                                    rLAction.setAD_Org_ID(rLine.getAD_Org_ID());
                                    rLAction.setTypeAcction(0);
                                    rLAction.setC_OrderShipCalendar_ID(oLineShip.get_ID());
                                    rLAction.save();
                                }
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                            sqlNLine = "SELECT *,(SELECT AD_Org_ID FROM C_Order WHERE C_Order_ID = " + req.getC_Order_ID() + " )as AD_Org_ID " + " FROM RVOFB_OrderShipFull co WHERE C_Order_ID = " + req.getC_Order_ID() + " AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND DateTrx >= ? AND DateTrx <= ?";
                            MOrderLine oLine = new MOrderLine(this.getCtx(), rLine.get_ValueAsInt("C_OrderLine_ID"), this.get_TrxName());
                            Timestamp DatePromise2New = (Timestamp)oLine.get_Value("DatePromised3");
                            long timeDif = rLine.getDatePromised3Ref().getTime() - rLine.getDatePromised2Ref().getTime();
                            Timestamp DatePromise3New = new Timestamp(DatePromise2New.getTime() + timeDif);
                            if (DatePromise2New != null && DatePromise3New != null) {
                                try {
                                    CPreparedStatement pstmtNLine2 = DB.prepareStatement((String)sqlNLine, (String)this.get_TrxName());
                                    pstmtNLine2.setTimestamp(1, DatePromise2New);
                                    pstmtNLine2.setTimestamp(2, DatePromise3New);
                                    ResultSet rsNLine2 = pstmtNLine2.executeQuery();
                                    while (rsNLine2.next()) {
                                        X_C_OrderShipCalendar sCal = new X_C_OrderShipCalendar(this.getCtx(), 0, this.get_TrxName());
                                        sCal.setC_Order_ID(rsNLine2.getInt("C_Order_ID"));
                                        sCal.setAD_Org_ID(rsNLine2.getInt("AD_Org_ID"));
                                        sCal.setIsActive(true);
                                        sCal.setC_OrderLine_ID(rsNLine2.getInt("C_OrderLine_ID"));
                                        sCal.setC_CalendarCOPESA_ID(rsNLine2.getInt("C_CalendarCOPESA_ID"));
                                        sCal.setC_CalendarCOPESALine_ID(rsNLine2.getInt("C_CalendarCOPESALine_ID"));
                                        sCal.setDateTrx(rsNLine2.getTimestamp("DateTrx"));
                                        sCal.set_CustomColumn("M_Product_ID", rsNLine2.getInt("M_Product_ID"));
                                        sCal.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                        sCal.save();
                                    }
                                }
                                catch (Exception e) {
                                    this.log.config(e.toString());
                                }
                            }
                            if (DatePromise3New != null) {
                                String sqlUpdate = "UPDATE C_OrderLine SET DatePromised3 = ? WHERE C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID");
                                CPreparedStatement pstmtUpdate = DB.prepareStatement((String)sqlUpdate, (String)this.get_TrxName());
                                pstmtUpdate.setTimestamp(1, DatePromise3New);
                                pstmtUpdate.executeUpdate();
                            }
                        }
                        if (rLine.getRequestAcction() != null && rLine.getRequestAcction().compareTo("A") == 0) {
                            sqlZoom = " SELECT C_OrderShipCalendar_ID  FROM C_OrderShipCalendar WHERE IsActive = 'N'  AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND dateTrx >= ? AND dateTrx <= ? AND R_Request_ID > 0";
                            pstmtZoom = DB.prepareStatement((String)sqlZoom, (String)this.get_TrxName());
                            try {
                                pstmtZoom.setTimestamp(1, rLine.getDatePromised2Ref());
                                pstmtZoom.setTimestamp(2, rLine.getDatePromised3Ref());
                                rsZoom = pstmtZoom.executeQuery();
                                while (rsZoom.next()) {
                                    oLineShip = new X_C_OrderShipCalendar(this.getCtx(), rsZoom.getInt("C_OrderShipCalendar_ID"), this.get_TrxName());
                                    oLineShip.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                    oLineShip.setIsActive(true);
                                    oLineShip.save();
                                    rLAction = new X_R_RequestLineAction(this.getCtx(), 0, this.get_TrxName());
                                    rLAction.setR_Request_ID(rLine.getR_Request_ID());
                                    rLAction.setR_RequestLine_ID(rLine.get_ID());
                                    rLAction.setAD_Org_ID(rLine.getAD_Org_ID());
                                    rLAction.setTypeAcction(1);
                                    rLAction.setC_OrderShipCalendar_ID(oLineShip.get_ID());
                                    rLAction.save();
                                }
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                            MOrderLine oLine = new MOrderLine(this.getCtx(), rLine.get_ValueAsInt("C_OrderLine_ID"), this.get_TrxName());
                            Timestamp DatePromise2New = (Timestamp)oLine.get_Value("DatePromised3");
                            long timeDif = rLine.getDatePromised3Ref().getTime() - rLine.getDatePromised2Ref().getTime();
                            Timestamp DatePromise3New = new Timestamp(DatePromise2New.getTime() - timeDif);
                            String sqlUp = " UPDATE C_OrderShipCalendar SET IsActive = 'N'  WHERE C_OrderShipCalendar_ID IN (SELECT C_OrderShipCalendar_ID  FROM C_OrderShipCalendar WHERE IsActive = 'Y'  AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND dateTrx > ? )";
                            CPreparedStatement pstmtUp = DB.prepareStatement((String)sqlUp, (String)this.get_TrxName());
                            try {
                                pstmtUp.setTimestamp(1, DatePromise3New);
                                pstmtUp.executeUpdate();
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                            if (DatePromise3New != null) {
                                String sqlUpdate = "UPDATE C_OrderLine SET DatePromised3 = ? WHERE C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID");
                                CPreparedStatement pstmtUpdate = DB.prepareStatement((String)sqlUpdate, (String)this.get_TrxName());
                                pstmtUpdate.setTimestamp(1, DatePromise3New);
                                pstmtUpdate.executeUpdate();
                            }
                        }
                        if (rLine.getRequestAcction() != null && rLine.getRequestAcction().compareTo("P") == 0) {
                            DB.executeUpdate((String)("UPDATE C_OrderLine SET C_Bpartner_Location_ID = " + rLine.getC_BPartner_LocationRef_ID() + " WHERE C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID")), (String)this.get_TrxName());
                            sqlZoom = " SELECT C_OrderShipCalendar_ID  FROM C_OrderShipCalendar WHERE IsActive = 'Y'  AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND dateTrx >= ? ";
                            pstmtZoom = DB.prepareStatement((String)sqlZoom, (String)this.get_TrxName());
                            try {
                                pstmtZoom.setTimestamp(1, rLine.getDatePromised2Ref());
                                rsZoom = pstmtZoom.executeQuery();
                                while (rsZoom.next()) {
                                    oLineShip = new X_C_OrderShipCalendar(this.getCtx(), rsZoom.getInt("C_OrderShipCalendar_ID"), this.get_TrxName());
                                    oLineShip.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                    oLineShip.setIsActive(false);
                                    oLineShip.save();
                                    rLAction = new X_R_RequestLineAction(this.getCtx(), 0, this.get_TrxName());
                                    rLAction.setR_Request_ID(rLine.getR_Request_ID());
                                    rLAction.setR_RequestLine_ID(rLine.get_ID());
                                    rLAction.setAD_Org_ID(rLine.getAD_Org_ID());
                                    rLAction.setTypeAcction(0);
                                    rLAction.setC_OrderShipCalendar_ID(oLineShip.get_ID());
                                    rLAction.save();
                                }
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                            sqlNLine = "SELECT *,(SELECT AD_Org_ID FROM C_Order WHERE C_Order_ID = " + req.getC_Order_ID() + " )as AD_Org_ID " + " FROM RVOFB_OrderShipFull co WHERE C_Order_ID = " + req.getC_Order_ID() + " AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND DateTrx >= ? AND DateTrx <= ?";
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(rLine.getDatePromised2Ref().getTime());
                            calendar.add(2, 2);
                            Timestamp dateFin = new Timestamp(calendar.getTimeInMillis());
                            if (rLine.getDatePromised2Ref() != null) {
                                try {
                                    CPreparedStatement pstmtNLine3 = DB.prepareStatement((String)sqlNLine, (String)this.get_TrxName());
                                    pstmtNLine3.setTimestamp(1, rLine.getDatePromised2Ref());
                                    pstmtNLine3.setTimestamp(2, dateFin);
                                    ResultSet rsNLine3 = pstmtNLine3.executeQuery();
                                    while (rsNLine3.next()) {
                                        X_C_OrderShipCalendar sCal = new X_C_OrderShipCalendar(this.getCtx(), 0, this.get_TrxName());
                                        sCal.setC_Order_ID(rsNLine3.getInt("C_Order_ID"));
                                        sCal.setAD_Org_ID(rsNLine3.getInt("AD_Org_ID"));
                                        sCal.setIsActive(true);
                                        sCal.setC_OrderLine_ID(rsNLine3.getInt("C_OrderLine_ID"));
                                        sCal.setC_CalendarCOPESA_ID(rsNLine3.getInt("C_CalendarCOPESA_ID"));
                                        sCal.setC_CalendarCOPESALine_ID(rsNLine3.getInt("C_CalendarCOPESALine_ID"));
                                        sCal.setDateTrx(rsNLine3.getTimestamp("DateTrx"));
                                        sCal.set_CustomColumn("M_Product_ID", rsNLine3.getInt("M_Product_ID"));
                                        sCal.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                        sCal.set_CustomColumn("C_BPartner_Location_ID ", rLine.getC_BPartner_LocationRef_ID());
                                        sCal.save();
                                    }
                                }
                                catch (Exception e) {
                                    this.log.config(e.toString());
                                }
                            }
                        }
                        if (rLine.getRequestAcction() != null && rLine.getRequestAcction().compareTo("T") == 0) {
                            sqlZoom = " SELECT C_OrderShipCalendar_ID  FROM C_OrderShipCalendar WHERE IsActive = 'Y'  AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND dateTrx >= ? AND DateTrx <= ?";
                            pstmtZoom = DB.prepareStatement((String)sqlZoom, (String)this.get_TrxName());
                            try {
                                pstmtZoom.setTimestamp(1, rLine.getDatePromised2Ref());
                                pstmtZoom.setTimestamp(2, rLine.getDatePromised3Ref());
                                rsZoom = pstmtZoom.executeQuery();
                                while (rsZoom.next()) {
                                    oLineShip = new X_C_OrderShipCalendar(this.getCtx(), rsZoom.getInt("C_OrderShipCalendar_ID"), this.get_TrxName());
                                    oLineShip.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                    oLineShip.setIsActive(false);
                                    oLineShip.save();
                                    rLAction = new X_R_RequestLineAction(this.getCtx(), 0, this.get_TrxName());
                                    rLAction.setR_Request_ID(rLine.getR_Request_ID());
                                    rLAction.setR_RequestLine_ID(rLine.get_ID());
                                    rLAction.setAD_Org_ID(rLine.getAD_Org_ID());
                                    rLAction.setTypeAcction(0);
                                    rLAction.setC_OrderShipCalendar_ID(oLineShip.get_ID());
                                    rLAction.save();
                                }
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                            sqlNLine = "SELECT *,(SELECT AD_Org_ID FROM C_Order WHERE C_Order_ID = " + req.getC_Order_ID() + " )as AD_Org_ID " + " FROM RVOFB_OrderShipFull co WHERE C_Order_ID = " + req.getC_Order_ID() + " AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND DateTrx >= ? AND DateTrx <= ?";
                            if (rLine.getDatePromised2Ref() != null) {
                                try {
                                    pstmtNLine = DB.prepareStatement((String)sqlNLine, (String)this.get_TrxName());
                                    pstmtNLine.setTimestamp(1, rLine.getDatePromised2Ref());
                                    pstmtNLine.setTimestamp(2, rLine.getDatePromised3Ref());
                                    rsNLine = pstmtNLine.executeQuery();
                                    while (rsNLine.next()) {
                                        X_C_OrderShipCalendar sCal = new X_C_OrderShipCalendar(this.getCtx(), 0, this.get_TrxName());
                                        sCal.setC_Order_ID(rsNLine.getInt("C_Order_ID"));
                                        sCal.setAD_Org_ID(rsNLine.getInt("AD_Org_ID"));
                                        sCal.setIsActive(true);
                                        sCal.setC_OrderLine_ID(rsNLine.getInt("C_OrderLine_ID"));
                                        sCal.setC_CalendarCOPESA_ID(rsNLine.getInt("C_CalendarCOPESA_ID"));
                                        sCal.setC_CalendarCOPESALine_ID(rsNLine.getInt("C_CalendarCOPESALine_ID"));
                                        sCal.setDateTrx(rsNLine.getTimestamp("DateTrx"));
                                        sCal.set_CustomColumn("M_Product_ID", rsNLine.getInt("M_Product_ID"));
                                        sCal.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                        sCal.set_CustomColumn("C_BPartner_Location_ID ", rLine.getC_BPartner_LocationRef_ID());
                                        sCal.save();
                                    }
                                }
                                catch (Exception e) {
                                    this.log.config(e.toString());
                                }
                            }
                        }
                        if (rLine.getRequestAcction() != null && rLine.getRequestAcction().compareTo("E") == 0) {
                            DB.executeUpdate((String)("UPDATE C_OrderLine SET IsActive = 'N' WHERE C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID")), (String)this.get_TrxName());
                            try {
                                String sqlPay = " DELETE FROM C_OrderPayCalendar WHERE C_Order_ID = " + rLine.getR_Request().getC_Order_ID() + " AND DateEnd >= ?";
                                CPreparedStatement pstmtPay = DB.prepareStatement((String)sqlPay, (String)this.get_TrxName());
                                pstmtPay.setTimestamp(1, rLine.getDatePromised2Ref());
                                pstmtPay.executeUpdate();
                                String sqlShip = " DELETE FROM C_OrderShipCalendar WHERE C_Order_ID = " + rLine.getR_Request().getC_Order_ID() + " AND DateTrx >= ?";
                                CPreparedStatement pstmtShip = DB.prepareStatement((String)sqlShip, (String)this.get_TrxName());
                                pstmtShip.setTimestamp(1, rLine.getDatePromised2Ref());
                                pstmtShip.executeUpdate();
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, sql, (Throwable)e);
                            }
                        }
                        if (rLine.getRequestAcction() == null || rLine.getRequestAcction().compareTo("R") != 0) continue;
                        sqlZoom = " SELECT C_OrderShipCalendar_ID  FROM C_OrderShipCalendar WHERE IsActive = 'Y'  AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND dateTrx = ? ";
                        pstmtZoom = DB.prepareStatement((String)sqlZoom, (String)this.get_TrxName());
                        try {
                            pstmtZoom.setTimestamp(1, rLine.getDatePromised2Ref());
                            rsZoom = pstmtZoom.executeQuery();
                            while (rsZoom.next()) {
                                oLineShip = new X_C_OrderShipCalendar(this.getCtx(), rsZoom.getInt("C_OrderShipCalendar_ID"), this.get_TrxName());
                                oLineShip.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                oLineShip.setIsActive(false);
                                oLineShip.save();
                                rLAction = new X_R_RequestLineAction(this.getCtx(), 0, this.get_TrxName());
                                rLAction.setR_Request_ID(rLine.getR_Request_ID());
                                rLAction.setR_RequestLine_ID(rLine.get_ID());
                                rLAction.setAD_Org_ID(rLine.getAD_Org_ID());
                                rLAction.setTypeAcction(3);
                                rLAction.setC_OrderShipCalendar_ID(oLineShip.get_ID());
                                rLAction.save();
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql, (Throwable)e);
                        }
                        sqlNLine = "SELECT *,(SELECT AD_Org_ID FROM C_Order WHERE C_Order_ID = " + req.getC_Order_ID() + " )as AD_Org_ID " + " FROM RVOFB_OrderShipFull co WHERE C_Order_ID = " + req.getC_Order_ID() + " AND C_OrderLine_ID = " + rLine.get_ValueAsInt("C_OrderLine_ID") + " AND DateTrx = ? ";
                        try {
                            pstmtNLine = DB.prepareStatement((String)sqlNLine, (String)this.get_TrxName());
                            pstmtNLine.setTimestamp(1, rLine.getDatePromised2Ref());
                            rsNLine = pstmtNLine.executeQuery();
                            while (rsNLine.next()) {
                                X_C_OrderShipCalendar sCal = new X_C_OrderShipCalendar(this.getCtx(), 0, this.get_TrxName());
                                sCal.setC_Order_ID(rsNLine.getInt("C_Order_ID"));
                                sCal.setAD_Org_ID(rsNLine.getInt("AD_Org_ID"));
                                sCal.setIsActive(true);
                                sCal.setC_OrderLine_ID(rsNLine.getInt("C_OrderLine_ID"));
                                sCal.setC_CalendarCOPESA_ID(rsNLine.getInt("C_CalendarCOPESA_ID"));
                                sCal.setC_CalendarCOPESALine_ID(rsNLine.getInt("C_CalendarCOPESALine_ID"));
                                sCal.setDateTrx(rsNLine.getTimestamp("DateTrx"));
                                sCal.set_CustomColumn("M_Product_ID", rsNLine.getInt("M_Product_ID"));
                                sCal.set_CustomColumn("R_Request_ID", rLine.getR_Request_ID());
                                sCal.save();
                            }
                        }
                        catch (Exception e) {
                            this.log.config(e.toString());
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                }
                req.set_CustomColumn("DocStatus", (Object)"CO");
                req.setProcessed(true);
            }
        } else if (req.get_ValueAsString("DocStatus").compareTo("ST") == 0) {
            block84: {
                String sql = " SELECT R_RequestLine_ID  FROM R_RequestLine WHERE IsActive = 'Y' AND C_OrderLine_ID > 0 AND R_Request_ID = " + req.get_ID();
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                ResultSet rs = null;
                try {
                    try {
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            X_R_RequestLine rLine = new X_R_RequestLine(this.getCtx(), rs.getInt("R_RequestLine_ID"), this.get_TrxName());
                            MOrderLine oLine = new MOrderLine(this.getCtx(), rLine.get_ValueAsInt("C_OrderLine_ID"), this.get_TrxName());
                            MBPartnerLocation bparL = new MBPartnerLocation(this.getCtx(), oLine.getC_BPartner_Location_ID(), this.get_TrxName());
                            bparL.set_CustomColumn("Zone", (Object)rLine.get_ValueAsString("Zone"));
                            bparL.set_CustomColumn("Sector", (Object)rLine.get_ValueAsInt("Sector"));
                            bparL.save();
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        pstmt.close();
                        rs.close();
                        pstmt = null;
                        rs = null;
                        break block84;
                    }
                }
                catch (Throwable throwable) {
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    throw throwable;
                }
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
            }
            req.set_CustomColumn("DocStatus", (Object)"CO");
            req.setProcessed(true);
            strMsg = "Direcciones Actualizadas. Debe ir a la NV y Completarla";
        }
        req.save();
        return strMsg;
    }
}

