/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_C_OrderShipCalendar;
import org.compiere.model.X_R_ServiceRLineAction;
import org.compiere.model.X_R_ServiceRequest;
import org.compiere.model.X_R_ServiceRequestLine;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.copesa.model.MapcityAddress;
import org.copesa.model.ZoneType;
import org.copesa.process.INodeAction;
import org.copesa.utils.DateUtils;

public class NodeActionT
implements INodeAction {
    private CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    public void execute(X_R_ServiceRequest _req, X_R_ServiceRequestLine _rline) throws Exception {
        this.changeLocationTemp(_req, _rline);
    }

    private boolean validateLocation(X_R_ServiceRequestLine _rline) {
        MapcityAddress mp = new MapcityAddress();
        String sql = "select sector || '-' || zone from c_bpartner_location loc where loc.c_bpartner_location_ID = ?";
        String sz = DB.getSQLValueString((String)_rline.get_TrxName(), (String)sql, (int)_rline.getC_BPartner_LocationRef_ID());
        if (!mp.validateSectorZone(sz)) {
            return false;
        }
        ZoneType zonetype = mp.getZoneType();
        if (zonetype.compareTo(ZoneType.ZONETYPE_SD) != 0) {
            return true;
        }
        sql = "select cal.isenabledSD from c_calendar_copesa cal   join c_orderline col on col.c_calendarcopesa_id = cal.c_calendarcopesa_id where col.c_orderline_id = " + _rline.getC_OrderLine_ID();
        String isenabledsd = DB.getSQLValueString((String)_rline.get_TrxName(), (String)sql, (Object[])new Object[]{null});
        return isenabledsd.equalsIgnoreCase("Y");
    }

    public void changeLocationPermanent(X_R_ServiceRequest _req, X_R_ServiceRequestLine _rline) throws Exception {
        if (!this.validateLocation(_rline)) {
            throw new AdempiereUserError("La direcci\u00f3n elegida no es v\u00e1lida, verifique cobertura de despacho.");
        }
        DB.executeUpdate((String)("UPDATE C_OrderLine SET C_Bpartner_Location_ID = " + _rline.getC_BPartner_LocationRef_ID() + " WHERE C_OrderLine_ID = " + _rline.get_ValueAsInt("C_OrderLine_ID")), (String)_rline.get_TrxName());
        this.changeLocation(_req, _rline, false);
    }

    public void changeLocationTemp(X_R_ServiceRequest _req, X_R_ServiceRequestLine _rline) throws Exception {
        this.changeLocation(_req, _rline, true);
    }

    public void deleteUselessLines(X_R_ServiceRequestLine _rline) throws Exception {
        String sql = "delete from c_ordershipcalendar where isactive = 'N' and isshipped = 'N' and C_OrderLine_ID = " + _rline.get_ValueAsInt("C_OrderLine_ID");
        DB.executeUpdate((String)sql, (String)_rline.get_TrxName());
    }

    public void changeLocation(X_R_ServiceRequest _req, X_R_ServiceRequestLine _rline, boolean _istemp) throws Exception {
        String sqlZoom = " SELECT C_OrderShipCalendar_ID  FROM C_OrderShipCalendar WHERE IsActive = 'Y'  AND C_OrderLine_ID = " + _rline.get_ValueAsInt("C_OrderLine_ID") + " AND dateTrx >= ? ";
        if (_istemp) {
            Timestamp sdate = _rline.getDatePromised2Ref();
            Timestamp edate = _rline.getDatePromised3Ref();
            if (sdate == null || edate == null) {
                throw new AdempiereUserError("Cambio direcci\u00f3n temporal requiere que especifique fechas de inicio y t\u00e9rmino");
            }
            if (DateUtils.getDifferenceDays(sdate, edate) > 60L) {
                throw new AdempiereUserError("Cambio direcci\u00f3n temporal no puede ser por un per\u00edodo superior a 60 d\u00edas");
            }
            sqlZoom = String.valueOf(sqlZoom) + " AND DateTrx <= ?";
        }
        CPreparedStatement pstmtZoom = DB.prepareStatement((String)sqlZoom, (String)_rline.get_TrxName());
        try {
            pstmtZoom.setTimestamp(1, _rline.getDatePromised2Ref());
            if (_istemp) {
                pstmtZoom.setTimestamp(2, _rline.getDatePromised3Ref());
            }
            ResultSet rsZoom = pstmtZoom.executeQuery();
            while (rsZoom.next()) {
                X_C_OrderShipCalendar oLineShip = new X_C_OrderShipCalendar(_rline.getCtx(), rsZoom.getInt("C_OrderShipCalendar_ID"), _rline.get_TrxName());
                oLineShip.set_CustomColumn("R_ServiceRequest_ID", _rline.getR_ServiceRequest_ID());
                oLineShip.setIsActive(false);
                oLineShip.save();
                X_R_ServiceRLineAction rLAction = new X_R_ServiceRLineAction(_rline.getCtx(), 0, _rline.get_TrxName());
                rLAction.setR_ServiceRequest_ID(_rline.getR_ServiceRequest_ID());
                rLAction.setR_ServiceRequestLine_ID(_rline.get_ID());
                rLAction.setAD_Org_ID(_rline.getAD_Org_ID());
                rLAction.setTypeAcction(0);
                rLAction.setC_OrderShipCalendar_ID(oLineShip.get_ID());
                rLAction.save();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sqlZoom, (Throwable)e);
        }
        String sqlNLine = "SELECT *,(SELECT AD_Org_ID FROM C_Order WHERE C_Order_ID = " + _req.getC_Order_ID() + " ) as AD_Org_ID " + " FROM RVOFB_OrderShipFull co WHERE C_Order_ID = " + _req.getC_Order_ID() + " AND C_OrderLine_ID = " + _rline.get_ValueAsInt("C_OrderLine_ID") + " AND DateTrx >= ?";
        if (_istemp) {
            sqlNLine = String.valueOf(sqlNLine) + " AND DateTrx <= ?";
        }
        if (_rline.getDatePromised2Ref() != null) {
            try {
                CPreparedStatement pstmtNLine = DB.prepareStatement((String)sqlNLine, (String)_req.get_TrxName());
                pstmtNLine.setTimestamp(1, _rline.getDatePromised2Ref());
                if (_istemp) {
                    pstmtNLine.setTimestamp(2, _rline.getDatePromised3Ref());
                }
                ResultSet rsNLine = pstmtNLine.executeQuery();
                while (rsNLine.next()) {
                    X_C_OrderShipCalendar sCal = new X_C_OrderShipCalendar(_rline.getCtx(), 0, _rline.get_TrxName());
                    sCal.setC_Order_ID(rsNLine.getInt("C_Order_ID"));
                    sCal.setAD_Org_ID(rsNLine.getInt("AD_Org_ID"));
                    sCal.setIsActive(true);
                    sCal.setC_OrderLine_ID(rsNLine.getInt("C_OrderLine_ID"));
                    sCal.setC_CalendarCOPESA_ID(rsNLine.getInt("C_CalendarCOPESA_ID"));
                    sCal.setC_CalendarCOPESALine_ID(rsNLine.getInt("C_CalendarCOPESALine_ID"));
                    sCal.setDateTrx(rsNLine.getTimestamp("DateTrx"));
                    sCal.set_CustomColumn("M_Product_ID", rsNLine.getInt("M_Product_ID"));
                    sCal.set_CustomColumn("R_ServiceRequest_ID", _rline.getR_ServiceRequest_ID());
                    sCal.set_CustomColumn("C_BPartner_Location_ID ", _rline.getC_BPartner_LocationRef_ID());
                    sCal.set_CustomColumn("R_Resolution_ID", _req.getR_Resolution_ID());
                    sCal.save();
                }
            }
            catch (Exception e) {
                this.log.config(e.toString());
            }
        }
        this.deleteUselessLines(_rline);
    }
}

