/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InvoiceGenerateCopesa
extends SvrProcess {
    private Timestamp p_DateInvoiced = null;
    private Timestamp p_DateOrdered = null;
    private Timestamp p_DateOrdered_To = null;
    private int p_C_BPartner_ID = 0;
    private int p_C_Order_ID = 0;
    private String p_docAction = "CO";
    private int m_created = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced = (Timestamp)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocAction")) {
                    this.p_docAction = (String)para[i].getParameter();
                } else if (name.equals("DateOrdered")) {
                    this.p_DateOrdered = para[i].getParameterAsTimestamp();
                    this.p_DateOrdered_To = para[i].getParameterToAsTimestamp();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        }
        if (this.p_DateInvoiced == null) {
            this.p_DateInvoiced = new Timestamp(System.currentTimeMillis());
        }
        if (!"CO".equals(this.p_docAction)) {
            this.p_docAction = "PR";
        }
    }

    protected String doIt() throws Exception {
        this.log.info("DateInvoiced=" + this.p_DateInvoiced + ",C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_Order_ID=" + this.p_C_Order_ID + ", DocAction=" + this.p_docAction);
        if (this.p_DateOrdered_To != null && this.p_DateOrdered_To.compareTo(this.p_DateInvoiced) > 0) {
            throw new AdempiereException("Error: Fecha nota de venta no puede ser mayor a fecha facturaci\u00f3n");
        }
        String sql = null;
        CPreparedStatement pstmt = null;
        String COPESA_GEN_FACT_CLOSED = MSysConfig.getValue((String)"COPESA_GEN_FACT_CLOSED");
        sql = "SELECT opc.C_Order_ID,opc.DateEnd,C_OrderPayCalendar_ID, opc.C_DocType_ID as F_DocType_ID, opc.periodno, co.* FROM C_OrderPayCalendar opc  INNER JOIN C_Order co ON (opc.C_Order_ID = co.C_Order_ID) ";
        sql = COPESA_GEN_FACT_CLOSED.equalsIgnoreCase("Y") ? String.valueOf(sql) + " WHERE co.DocStatus IN('CO','CL') AND co.IsSOTrx='Y' AND opc.IsInvoiced <> 'Y' " : String.valueOf(sql) + " WHERE co.DocStatus IN('CO') AND co.IsSOTrx='Y' AND opc.IsInvoiced <> 'Y' ";
        if (this.p_C_BPartner_ID != 0) {
            sql = String.valueOf(sql) + " AND co.C_BPartner_ID = ?";
        }
        if (this.p_C_Order_ID != 0) {
            sql = String.valueOf(sql) + " AND co.C_Order_ID = ?";
        }
        if (this.p_DateOrdered != null && this.p_DateOrdered_To != null) {
            sql = String.valueOf(sql) + " AND opc.DateEnd BETWEEN ? AND (date_trunc('day', ?::timestamp without time zone) +  '23:59:59.999'::interval)";
        }
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            int index = 1;
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            }
            if (this.p_C_Order_ID != 0) {
                pstmt.setInt(index++, this.p_C_Order_ID);
            }
            if (this.p_DateOrdered != null && this.p_DateOrdered_To != null) {
                pstmt.setTimestamp(index++, this.p_DateOrdered);
                pstmt.setTimestamp(index++, this.p_DateOrdered_To);
            }
            ResultSet rs = pstmt.executeQuery();
            long firstInvoice = 0L;
            long lastInvoice = 0L;
            while (rs.next()) {
                MOrder order = new MOrder(this.getCtx(), rs, this.get_TrxName());
                MInvoice inv = this.createInvoice(order, rs.getTimestamp("DateEnd"), rs.getInt("F_DocType_ID"), rs.getInt("C_OrderPayCalendar_ID"), rs.getInt("periodno"));
                if (inv == null) continue;
                lastInvoice = inv.getC_Invoice_ID();
                if (firstInvoice == 0L) {
                    firstInvoice = lastInvoice;
                }
                this.completeInvoice(inv);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            this.UpdateOrderPayCalendar(firstInvoice, lastInvoice);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return "Se han generado " + this.m_created + " facturas";
    }

    private void completeInvoice(MInvoice m_invoice) {
        if (m_invoice != null) {
            if (m_invoice.getC_BPartner().getSOCreditStatus().compareTo("W") == 0) {
                m_invoice.setDocStatus("IN");
            } else if (!m_invoice.processIt(this.p_docAction)) {
                this.log.warning("completeInvoice - failed: " + (Object)((Object)m_invoice));
                this.addLog("completeInvoice - failed: " + (Object)((Object)m_invoice));
            }
            m_invoice.saveEx();
            ++this.m_created;
        }
        m_invoice = null;
    }

    private MInvoice createInvoice(MOrder order, Timestamp dateInvoiced, int ID_DocType, int C_OrderPayCalendar_ID, int _periodno) {
        MInvoice m_invoice = new MInvoice(order, 0, dateInvoiced);
        if (ID_DocType > 0) {
            m_invoice.setC_DocType_ID(ID_DocType);
            m_invoice.setC_DocTypeTarget_ID(ID_DocType);
            m_invoice.set_CustomColumn("C_OrderPayCalendar_ID", C_OrderPayCalendar_ID);
            m_invoice.set_CustomColumn("IsHold", order.get_Value("IsHold"));
        }
        if (!m_invoice.save()) {
            throw new IllegalStateException("Could not create Invoice (o)");
        }
        String sqlDet = "SELECT * FROM co_factcalendar WHERE C_Order_ID = ? AND periodno = ?";
        try {
            CPreparedStatement pstmtLine = DB.prepareStatement((String)sqlDet, (String)this.get_TrxName());
            pstmtLine.setInt(1, order.get_ID());
            pstmtLine.setInt(2, _periodno);
            ResultSet rsLine = pstmtLine.executeQuery();
            while (rsLine.next()) {
                MOrderLine oLine = new MOrderLine(this.getCtx(), rsLine.getInt("C_OrderLine_ID"), this.get_TrxName());
                MInvoiceLine line = new MInvoiceLine(m_invoice);
                line.setOrderLine(oLine);
                line.setQtyInvoiced(oLine.getQtyEntered());
                line.setQtyEntered(oLine.getQtyEntered());
                BigDecimal price = rsLine.getBigDecimal("linenetamt");
                if (oLine.getQtyEntered().compareTo(Env.ONE) != 0) {
                    price = price.divide(oLine.getQtyEntered());
                }
                line.setPrice(price);
                line.setLineNetAmt();
                line.setTaxAmt();
                if (line.save()) continue;
                throw new IllegalStateException("Could not create Invoice Line (o)");
            }
        }
        catch (Exception e) {
            this.log.config("Error al generar linea:" + e.toString());
            return null;
        }
        return m_invoice;
    }

    private void UpdateOrderPayCalendar(long _firstInvoice, long _lastInvoice) {
        String sql = "UPDATE C_OrderPayCalendar as opc set C_Invoice_ID = inv.C_Invoice_ID, IsInvoiced = 'Y' ";
        sql = String.valueOf(sql) + "FROM C_Invoice inv where opc.C_OrderPayCalendar_ID = inv.C_OrderPayCalendar_ID ";
        sql = String.valueOf(sql) + " AND inv.C_Invoice_ID BETWEEN " + _firstInvoice + " AND " + _lastInvoice;
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }
}

