/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.copesa.model.COPESAOrderOps;

public class BulkCloseOrderCopesa
extends SvrProcess {
    private Timestamp p_FechaTermino = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("FechaTermino")) {
                    this.p_FechaTermino = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.p_FechaTermino == null) {
            this.p_FechaTermino = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        this.log.info("Inicio proceso cierre de contratos (FechaTermino=" + this.p_FechaTermino + ")");
        String sql = "select c_order_id from c_order where docstatus = 'CO' and FechaTermino <= ?";
        CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        pstmt.setTimestamp(1, this.p_FechaTermino);
        ResultSet rs = pstmt.executeQuery();
        int count = 0;
        while (rs.next()) {
            int c_order_id = rs.getInt(1);
            this.log.info(COPESAOrderOps.closeOrder(c_order_id, this.get_TrxName(), this.getCtx()));
            ++count;
        }
        rs.close();
        pstmt.close();
        return "Proceso de cierre de documentos finalizado (Cantidad de contratos=" + count + ")";
    }
}

