/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModCOPESAValidBPLocation
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAValidBPLocation.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner_Location", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MBPartnerLocation.Table_ID) {
            MBPartnerLocation loc = (MBPartnerLocation)po;
            int street_1 = loc.get_ValueAsInt("C_Street_ID");
            String Street_Name = "";
            if (loc.get_ValueAsString("StreetName") != null && loc.get_ValueAsString("StreetName").trim().length() > 0) {
                Street_Name = loc.get_ValueAsString("StreetName");
            }
            if (street_1 < 1 && Street_Name.length() < 1) {
                return "ERROR: Debe Ingresar calle";
            }
            if (street_1 > 0 && Street_Name.trim().length() > 0) {
                return "ERROR: Debe Ingresar solo 1 calle";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

