/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_Channel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModCOPESAUpdateShipLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAUpdateShipLine.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MOrderLine oLine;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == MOrder.Table_ID && (po.is_ValueChanged("DocStatus") || po.is_ValueChanged("C_Channel_ID")) && (order = (MOrder)((Object)po)).isSOTrx() && order.getDocStatus().compareToIgnoreCase("IP") == 0) {
            MOrderLine[] lines = order.getLines(false, null);
            int i = 0;
            while (i < lines.length) {
                MOrderLine oLine2 = lines[i];
                if (oLine2.getM_Product_ID() > 0) {
                    X_C_Channel channel;
                    MProduct prod = new MProduct(po.getCtx(), oLine2.getM_Product_ID(), po.get_TrxName());
                    String delivery = prod.get_ValueAsString("DeliveryViaRule");
                    if (prod.get_ValueAsBoolean("IsChannelDelivery") && order.get_ValueAsInt("C_Channel_ID") > 0 && (channel = new X_C_Channel(po.getCtx(), order.get_ValueAsInt("C_Channel_ID"), po.get_TrxName())).get_ValueAsString("DeliveryViaRule") != null && channel.get_ValueAsString("DeliveryViaRule") != "" && channel.get_ValueAsString("DeliveryViaRule").length() > 0) {
                        delivery = channel.get_ValueAsString("DeliveryViaRule");
                    }
                    String olddelivery = oLine2.get_ValueAsString("DeliveryViaRule");
                    if (delivery != null && delivery != "" && delivery.trim().length() > 0 && delivery.compareTo(olddelivery) != 0) {
                        oLine2.set_CustomColumn("DeliveryViaRule", delivery);
                        oLine2.save();
                    }
                }
                ++i;
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrderLine.Table_ID && po.is_ValueChanged("DeliveryViaRule")) {
            oLine = (MOrderLine)((Object)po);
            int ID_Shipper = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT MAX(M_Shipper_ID) FROM C_GeozoneShipper  WHERE C_Geozone_ID = " + oLine.get_ValueAsInt("C_Geozone_ID") + "AND DeliveryViaRule = '" + oLine.get_ValueAsString("DeliveryViaRule") + "' "));
            if (ID_Shipper > 0) {
                oLine.set_CustomColumn("M_Shipper_ID", ID_Shipper);
            }
        }
        if (type == 1 && po.get_Table_ID() == MOrderLine.Table_ID && (oLine = (MOrderLine)((Object)po)).getM_Product_ID() > 0) {
            Calendar calendar = Calendar.getInstance();
            Timestamp today = new Timestamp(calendar.getTimeInMillis());
            Timestamp movDate = null;
            movDate = DB.getSQLValueTS((String)po.get_TrxName(), (String)("SELECT MAX(MovementDate)  FROM M_ProductPrice pp  INNER JOIN M_PriceList_Version plv ON (pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID)  WHERE pp.IsActive = 'Y' AND pp.M_Product_ID = " + oLine.getM_Product_ID() + " AND M_PriceList_ID = " + oLine.getParent().getM_PriceList_ID()), (Object[])new Object[0]);
            if (movDate != null) {
                if (movDate != null && movDate.compareTo(today) < 0) {
                    movDate = today;
                }
                oLine.set_CustomColumn("MovementDate", movDate);
            } else {
                MOrder order2 = oLine.getParent();
                movDate = (Timestamp)order2.get_Value("DateCompleted");
                if (movDate != null && movDate.compareTo(today) < 0) {
                    movDate = today;
                }
                if (movDate != null) {
                    oLine.set_CustomColumn("MovementDate", movDate);
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

