/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.copesa.model.COPESAOrderOps;

public class ModCOPESAUpdateDateOLineOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAUpdateDateOLineOrder.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 2 && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order;
            if (po.is_ValueChanged("DatePromised") || po.is_ValueChanged("PaymentRule")) {
                order = (MOrder)((Object)po);
                if (!order.isSOTrx()) {
                    return null;
                }
                if (order.getDocStatus().compareToIgnoreCase("CO") != 0) {
                    MOrderLine[] oLines = order.getLines(false, null);
                    Timestamp dateStartO = order.getDatePromised();
                    int i = 0;
                    while (i < oLines.length) {
                        MOrderLine line = oLines[i];
                        if ((line.get_ValueAsBoolean("IsFree") || line.get_ValueAsInt("C_OrderLineRef_ID") <= 0) && line.getM_Product_ID() > 0) {
                            line.set_CustomColumn("DatePromised2", dateStartO);
                            line.set_CustomColumn("DatePromised3", null);
                            line.save();
                        }
                        ++i;
                    }
                }
            }
            if (po.is_ValueChanged("DateCompleted")) {
                order = (MOrder)((Object)po);
                if (!order.isSOTrx()) {
                    return null;
                }
                COPESAOrderOps.SetMovDates(order.getC_Order_ID(), order.get_TrxName());
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

