/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MClient;
import org.compiere.model.MResolution;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_R_ServiceRequest;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.copesa.model.COPESASROps;

public class ModCOPESAServiceRequest
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAServiceRequest.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("R_ServiceRequest", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_R_ServiceRequest.Table_ID) {
            X_R_ServiceRequest req = (X_R_ServiceRequest)po;
            MResolution rType = new MResolution(po.getCtx(), req.getR_Resolution_ID(), po.get_TrxName());
            if (rType.get_ValueAsInt("AD_Workflow_ID") > 0) {
                req.setAD_Workflow_ID(rType.get_ValueAsInt("AD_Workflow_ID"));
            }
            if (req.get_ValueAsInt("C_BPartner_LocationRef_ID") > 0 && req.get_Value("StartDate") == null) {
                return "Si registra nueva direcci\u00f3n tambi\u00e9n debe registrar fecha de inicio";
            }
            if (!this.validateFilter(req)) {
                return "Campos para filtrar no calzan con ninguna l\u00ednea del contrato/nota de venta";
            }
            int nodeid = req.getAD_WF_Node_ID();
            if ((nodeid < 1 || type == 1) && (nodeid = rType.get_ValueAsInt("AD_WF_Node_ID")) > 0) {
                req.setAD_WF_Node_ID(nodeid);
                COPESASROps.assignUser(req, nodeid);
            }
        }
        return null;
    }

    private boolean validateFilter(X_R_ServiceRequest _req) {
        String sql = "select C_OrderLine_ID from C_OrderLine where C_Order_ID = " + _req.getC_Order_ID();
        if (_req.get_ValueAsInt("C_BPartner_ID") > 0) {
            sql = String.valueOf(sql) + " and C_BPartnerRef_ID = " + _req.get_ValueAsInt("C_BPartner_ID");
        }
        if (_req.getC_OrderLine_ID() > 0) {
            sql = String.valueOf(sql) + " and C_OrderLine_ID = " + _req.getC_OrderLine_ID();
        }
        if (_req.get_ValueAsInt("C_BPartner_Location_ID") > 0) {
            sql = String.valueOf(sql) + " and C_BPartner_Location_ID = " + _req.get_ValueAsInt("C_BPartner_Location_ID");
        }
        sql = String.valueOf(sql) + " fetch first row only";
        int result = DB.getSQLValue((String)_req.get_TrxName(), (String)sql);
        return result > 0;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

