/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModCOPESAOrderQtyAvailable
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAOrderQtyAvailable.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx()) {
            MOrderLine[] oLines = order.getLines(false, null);
            int i = 0;
            while (i < oLines.length) {
                BigDecimal qty;
                MOrderLine line = oLines[i];
                if (!line.get_ValueAsBoolean("isconfirmed") && line.getM_Product_ID() > 0 && line.getM_Product().getProductType().compareToIgnoreCase("I") == 0 && (qty = DB.getSQLValueBD((String)po.get_TrxName(), (String)("select bomqtyavailablecopesa(" + line.getM_Product_ID() + "," + order.getM_Warehouse_ID() + "," + line.get_ValueAsInt("M_Locator_ID") + ")"), (Object[])new Object[0])).compareTo(Env.ZERO) < 0) {
                    return "Error de Stock: Producto " + line.getM_Product().getName() + " sin stock suficiente " + qty;
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

