/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModCOPESAOrderCopyCardName
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAOrderCopyCardName.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (!(type != 2 && type != 1 || po.get_Table_ID() != MOrder.Table_ID || !(order = (MOrder)((Object)po)).isSOTrx() || order.getDocStatus().compareToIgnoreCase("DR") != 0 && order.getDocStatus().compareToIgnoreCase("IP") != 0 && order.getDocStatus().compareToIgnoreCase("AP") != 0 && order.getDocStatus().compareToIgnoreCase("IN") != 0)) {
            String nameCC = "";
            if (order.get_ValueAsString("CreditCardNumber") != null && order.get_ValueAsString("CreditCardNumber").trim() != "" && ModCOPESAOrderCopyCardName.validateCC2(order.get_ValueAsString("CreditCardNumber")) && (nameCC = this.getNameCreditCard(order.get_ValueAsString("CreditCardNumber"))) != null && nameCC.trim() != "") {
                if (nameCC.compareToIgnoreCase("mastercard") == 0) {
                    order.set_CustomColumn("CreditCardType", "M");
                }
                if (nameCC.compareToIgnoreCase("visa") == 0) {
                    order.set_CustomColumn("CreditCardType", "V");
                }
                if (nameCC.compareToIgnoreCase("american express") == 0) {
                    order.set_CustomColumn("CreditCardType", "A");
                }
                if (nameCC.compareToIgnoreCase("diners club") == 0) {
                    order.set_CustomColumn("CreditCardType", "D");
                }
                if (nameCC.compareToIgnoreCase("discover") == 0) {
                    order.set_CustomColumn("CreditCardType", "N");
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public String getNameCreditCard(String sTarjeta) {
        double tarjeta = Integer.parseInt(sTarjeta.substring(0, 3));
        String nameTarjeta = "";
        if (tarjeta >= 510.0 && tarjeta <= 559.0) {
            nameTarjeta = "Mastercard";
        } else if (tarjeta >= 400.0 && tarjeta <= 499.0) {
            nameTarjeta = "Visa";
        } else if (tarjeta >= 340.0 && tarjeta <= 379.0) {
            nameTarjeta = "American Express";
        } else if (tarjeta >= 300.0 && tarjeta <= 305.0) {
            nameTarjeta = "Diners Club";
        } else if (tarjeta >= 400.0 && tarjeta <= 499.0) {
            nameTarjeta = "Visa";
        } else if (tarjeta == 601.0) {
            nameTarjeta = "Discover";
        } else if (tarjeta == 652.0) {
            nameTarjeta = "Palacio del Hierro";
        }
        return nameTarjeta;
    }

    public static boolean validateCC2(String numero) {
        int s1 = 0;
        int s2 = 0;
        String reversa = new StringBuffer(numero).reverse().toString();
        int i = 0;
        while (i < reversa.length()) {
            int digito = Character.digit(reversa.charAt(i), 10);
            if (i % 2 == 0) {
                s1 += digito;
            } else {
                s2 += 2 * digito;
                if (digito >= 5) {
                    s2 -= 9;
                }
            }
            ++i;
        }
        System.out.println("La tarjeta es:");
        return (s1 + s2) % 10 == 0;
    }
}

