/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.copesa.model.COPESAOrderOps;

public class ModCOPESAOLineFree
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAOLineFree.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx() && order.getDocStatus().compareToIgnoreCase("IP") == 0) {
            MOrderLine[] lines = order.getLines();
            String sql = "SELECT c_orderline_id, FreeDays, FreeAmt, PricePATFree, durationdays FROM M_ProductPrice pp INNER JOIN M_PriceList_Version plv ON pp.M_PriceList_Version_ID = plv.M_PriceList_Version_ID INNER JOIN M_PriceList pl ON plv.M_PriceList_ID = pl.M_PriceList_ID INNER JOIN c_orderline col on col.m_product_id = pp.m_product_id WHERE pp.IsActive = 'Y' AND pl.M_priceList_ID = ? AND col.c_order_id = ? AND pp.freedays >= 0 AND not exists (select * from c_orderline where c_orderlineref_id = col.c_orderline_id) ";
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)order.get_TrxName());
            pstmt.setInt(1, order.getM_PriceList_ID());
            pstmt.setInt(2, order.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int lineid = rs.getInt(1);
                if (lineid <= 0) continue;
                MOrderLine oLine = null;
                int i = 0;
                while (i < lines.length) {
                    if (lines[i].get_ID() == lineid) {
                        oLine = lines[i];
                    }
                    ++i;
                }
                if (oLine == null) continue;
                int freedays = rs.getInt(2);
                BigDecimal newAmt = rs.getBigDecimal(3);
                BigDecimal newAmtPAT = rs.getBigDecimal(4);
                int durationdays = rs.getInt(5);
                if (newAmt == null || newAmt.compareTo(Env.ZERO) <= 0) {
                    newAmt = Env.ONE;
                }
                if (newAmtPAT == null || newAmtPAT.compareTo(Env.ZERO) <= 0) {
                    newAmtPAT = Env.ONE;
                }
                if (freedays >= 0) {
                    COPESAOrderOps.createFreeLine(order, oLine, freedays, newAmt, newAmtPAT, durationdays);
                }
                freedays = -1;
                durationdays = -1;
                newAmt = null;
                newAmtPAT = null;
            }
            rs.close();
            pstmt.close();
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

