/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.copesa.model.COPESAOrderOps;

public class ModCOPESAGenOrderShip
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAGenOrderShip.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (po.get_Table_ID() != MOrder.Table_ID) {
            return null;
        }
        if (timing == 9 && !COPESAOrderOps.create_osc((MOrder)((Object)po))) {
            return "No se pudo crear calendario de despacho";
        }
        if ((timing == 10 || timing == 12) && (order = (MOrder)((Object)po)).isSOTrx()) {
            DB.executeUpdate((String)("DELETE FROM C_OrderShipCalendar WHERE C_Order_ID = " + order.get_ID()), (String)po.get_TrxName());
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public boolean reqApproval(MOrder order) {
        BigDecimal amt;
        return order.getPaymentRule().compareTo("D") != 0 || (amt = DB.getSQLValueBD(null, (String)"SELECT SUM(LineNetAmt)  FROM C_OrderLine WHERE C_Charge_ID > 0 AND C_Order_ID = ? ", (int)order.get_ID())).compareTo(Env.ONEHUNDRED) >= 0;
    }
}

