/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.copesa.model.COPESAOrderOps;

public class ModCOPESAFreightCategory
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESAFreightCategory.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_OrderLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)((Object)po);
            if ((po.is_ValueChanged("DocStatus") || po.is_ValueChanged("C_BPartner_Location_ID") || po.is_ValueChanged("C_Channel_ID") || po.is_ValueChanged("datePromised") || po.is_ValueChanged("PaymentRule") || po.is_ValueChanged("DateFinish")) && order.getDocStatus().compareTo("DR") != 0) {
                COPESAOrderOps.AddFreightLines(order.getC_Order_ID(), Integer.parseInt(Env.getContext((Properties)order.getCtx(), (String)"#AD_User_ID")), order.get_TrxName());
                COPESAOrderOps.UpdatePrices(order);
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

