/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_BPartnerRelated;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModCOPESABPBenefitsCheck
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCOPESABPBenefitsCheck.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_BPartnerRelated", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_C_BPartnerRelated.Table_ID) {
            X_C_BPartnerRelated BPRelated = (X_C_BPartnerRelated)po;
            int maxadic = MSysConfig.getIntValue((String)"COPESA_MAXADIC_CLUB", (int)5);
            if (BPRelated.get_ValueAsBoolean("IsBeneficiary")) {
                String sql = "SELECT COUNT(1) FROM C_BPartnerRelated WHERE IsActive = 'Y' AND  IsBeneficiary = 'Y' AND C_BPartner_ID = " + BPRelated.getC_BPartner_ID();
                int cant = DB.getSQLValue((String)po.get_TrxName(), (String)sql);
                if (BPRelated.isActive() && cant >= maxadic) {
                    return "ERROR: No se puede tener mas de " + maxadic + " adicionales activos";
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

