/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.copesa.model.ZoneType;

public class MapcityAddress {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private String nombre_via_largo;
    private double latitud;
    private double longitud;
    private String tipo_via_largo;
    private String altura;
    private String comuna_largo;
    private String provincia_largo;
    private int region_corto;
    private String sectorzona;
    private String sector;
    private String zona;
    private String[] invalid_sectorzona;
    private String codigo_postal;
    private String anexo;
    private String gse;
    private String geocoding;
    private boolean normalized = false;
    private boolean checked = false;
    private static String proxyhost = null;
    private static int proxyport = 0;
    public static final int COPESA_LAYER_ID = 2148;
    public static final int TIMEOUT_VALUE = 10000;

    private String[] getZones(String _configvar) {
        String[] zones;
        block3: {
            try {
                String zonelist = MSysConfig.getValue((String)_configvar);
                zones = zonelist.split(",");
                if (Array.getLength(zones) > 0) break block3;
                return null;
            }
            catch (Exception e) {
                this.log.warning(e.getMessage());
                return null;
            }
        }
        return zones;
    }

    public String[] getZonasSinReparto() {
        return this.getZones("COPESA_ZONAS_SINREPARTO");
    }

    public String[] getZonasSD() {
        return this.getZones("COPESA_ZONAS_SD");
    }

    public String getGse() {
        return this.gse;
    }

    public void setGse(String gse) {
        this.gse = gse;
    }

    public String getGeocoding() {
        return this.geocoding;
    }

    public void setGeocoding(String geocoding) {
        this.geocoding = geocoding;
    }

    private String getProxyhost() {
        if (proxyhost != null) {
            return proxyhost;
        }
        this.log.info("Obteniendo proxy COPESA");
        try {
            String prop = MSysConfig.getValue((String)"COPESA_MAPCITY_PROXY");
            this.log.info("Proxy COPESA: " + prop);
            String[] arr = prop.split(":");
            if (Array.getLength(arr) == 2) {
                proxyhost = arr[0];
                proxyport = Integer.parseInt(arr[1]);
            } else {
                proxyhost = null;
                proxyport = 0;
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
            return null;
        }
        return proxyhost;
    }

    private int getProxyport() {
        return proxyhost != null ? proxyport : 0;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean normalized) {
        this.normalized = normalized;
    }

    public String getAnexo() {
        return this.anexo;
    }

    public void setAnexo(String anexo) {
        this.anexo = anexo;
    }

    public String getCodigo_postal() {
        return this.codigo_postal;
    }

    public void setCodigo_postal(String codigo_postal) {
        this.codigo_postal = codigo_postal;
    }

    public String getSector() {
        return this.sector;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String getZona() {
        return this.zona;
    }

    public void setZona(String zona) {
        this.zona = zona;
    }

    public String getSectorzona() {
        return this.sectorzona;
    }

    public void setSectorzona(String sectorzona) {
        this.sectorzona = sectorzona;
        String[] sector_zona_arr = sectorzona.split("-");
        this.setSector(sector_zona_arr[0]);
        this.setZona(sector_zona_arr[1]);
    }

    public double getLatitud() {
        return this.latitud;
    }

    public void setLatitud(double latitud) {
        this.latitud = latitud;
    }

    public double getLongitud() {
        return this.longitud;
    }

    public void setLongitud(double longitud) {
        this.longitud = longitud;
    }

    public String getTipo_via_largo() {
        return this.tipo_via_largo;
    }

    public void setTipo_via_largo(String tipo_via_largo) {
        this.tipo_via_largo = tipo_via_largo;
    }

    public String getAltura() {
        return this.altura;
    }

    public void setAltura(String altura) {
        this.altura = altura;
    }

    public String getComuna_largo() {
        return this.comuna_largo;
    }

    public void setComuna_largo(String comuna_largo) {
        this.comuna_largo = comuna_largo;
    }

    public String getProvincia_largo() {
        return this.provincia_largo;
    }

    public void setProvincia_largo(String provincia_largo) {
        this.provincia_largo = provincia_largo;
    }

    public int getRegion_corto() {
        return this.region_corto;
    }

    public void setRegion_corto(int i) {
        this.region_corto = i;
    }

    public String getNombre_via_largo() {
        return this.nombre_via_largo;
    }

    public void setNombre_via_largo(String nombre_via_largo) {
        this.nombre_via_largo = nombre_via_largo;
    }

    public ZoneType getZoneType(String _sectorzone) {
        String[] zonassinreparto = this.getZonasSinReparto();
        String[] zonasrepartosd = this.getZonasSD();
        if (_sectorzone == null) {
            return ZoneType.ZONETYPE_EXCLUDED;
        }
        if (zonassinreparto != null && Arrays.asList(zonassinreparto).contains(_sectorzone.trim())) {
            return ZoneType.ZONETYPE_EXCLUDED;
        }
        if (zonasrepartosd != null && Arrays.asList(zonasrepartosd).contains(_sectorzone.trim())) {
            return ZoneType.ZONETYPE_SD;
        }
        return ZoneType.ZONETYPE_NORMAL;
    }

    public ZoneType getZoneType() {
        return this.getZoneType(this.getSectorzona());
    }

    public boolean normalize(String _address) {
        double longitud;
        double latitud;
        String response;
        block3: {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("direccion", _address);
                params.put("access_token", MSysConfig.getValue((String)"COPESA_MAPCITY_ACCESS_TOKEN"));
                response = this.httpPost("http://services.mapcity.com/nyg_chile/v2/normalizar.json", params);
                latitud = Double.parseDouble(JsonPath.read((String)response, (String)"$.results[0].location.lat", (Filter[])new Filter[0]).toString());
                longitud = Double.parseDouble(JsonPath.read((String)response, (String)"$.results[0].location.lng", (Filter[])new Filter[0]).toString());
                if (latitud != 0.0 && longitud != 0.0) break block3;
                return false;
            }
            catch (Exception e) {
                this.log.warning(e.getMessage());
                return false;
            }
        }
        this.setLatitud(latitud);
        this.setLongitud(longitud);
        this.setNombre_via_largo((String)JsonPath.read((String)response, (String)"$.results[0].direccion.nombre_via_largo", (Filter[])new Filter[0]));
        this.setTipo_via_largo((String)JsonPath.read((String)response, (String)"$.results[0].direccion.tipo_via_largo", (Filter[])new Filter[0]));
        this.setAltura((String)JsonPath.read((String)response, (String)"$.results[0].direccion.altura", (Filter[])new Filter[0]));
        this.setComuna_largo((String)JsonPath.read((String)response, (String)"$.results[0].direccion.comuna_largo", (Filter[])new Filter[0]));
        this.setProvincia_largo((String)JsonPath.read((String)response, (String)"$.results[0].direccion.provincia_largo", (Filter[])new Filter[0]));
        this.setRegion_corto((Integer)JsonPath.read((String)response, (String)"$.results[0].direccion.region_corto", (Filter[])new Filter[0]));
        this.setCodigo_postal((String)JsonPath.read((String)response, (String)"$.results[0].caracterizacion.codigo_postal", (Filter[])new Filter[0]));
        this.setGse((String)JsonPath.read((String)response, (String)"$.results[0].caracterizacion.gse", (Filter[])new Filter[0]));
        this.setGeocoding((String)JsonPath.read((String)response, (String)"$.results[0].location.metodo_geocoding", (Filter[])new Filter[0]));
        this.setAnexo((String)JsonPath.read((String)response, (String)"$.results[0].direccion.anexo", (Filter[])new Filter[0]));
        this.setNormalized(true);
        return true;
    }

    private int searchCopesaLayer(String _jsonstr) {
        try {
            int total_entries = Integer.parseInt(JsonPath.read((String)_jsonstr, (String)"$.pagination.total_entries_matching", (Filter[])new Filter[0]).toString());
            int i = 0;
            while (i < total_entries) {
                int layerid = Integer.parseInt(JsonPath.read((String)_jsonstr, (String)("$.features[" + i + "].properties.layer_id"), (Filter[])new Filter[0]).toString());
                if (layerid == 2148) {
                    return i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
        return -1;
    }

    public boolean checkCoverage() {
        int layerindex;
        String response;
        block3: {
            try {
                String latstr = new Double(this.getLatitud()).toString();
                String lonstr = new Double(this.getLongitud()).toString();
                String pointstr = "POINT(" + lonstr + "%20" + latstr + ")";
                String uri = "http://wm20.mapcity.com/layers/2148/features.json";
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                String datestr = sdf.format(new Date());
                int userid = 1017;
                String api_key = MSysConfig.getValue((String)"COPESA_MAPCITY_API_KEY");
                String canonical_string = ",,/layers/2148/features.json?intersects=" + pointstr + "," + datestr;
                byte[] hash = this.hash_hmac(canonical_string, api_key);
                byte[] encoded_bytes = Base64.encodeBase64((byte[])hash);
                String hash_base64 = new String(encoded_bytes, "UTF-8");
                String authorization = "APIAuth " + userid + ":" + hash_base64;
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("intersects", pointstr);
                LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
                headers.put("Authorization", authorization);
                headers.put("Date", datestr);
                response = this.httpGet(uri, params, headers);
                layerindex = this.searchCopesaLayer(response);
                if (layerindex >= 0) break block3;
                return false;
            }
            catch (Exception e) {
                this.log.warning(e.getMessage());
                return false;
            }
        }
        this.setSectorzona((String)JsonPath.read((String)response, (String)("$.features[" + layerindex + "].properties.zona"), (Filter[])new Filter[0]));
        return this.validateSectorZone(this.getSectorzona());
    }

    public boolean validateSectorZone(String _sectorzone) {
        block7: {
            block6: {
                block5: {
                    try {
                        this.setSectorzona(_sectorzone);
                        if (this.getSectorzona().length() == 5) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        this.log.warning(e.getMessage());
                        return false;
                    }
                }
                if (Integer.parseInt(this.getSector()) >= 0 && Integer.parseInt(this.getSector()) <= 99) break block6;
                return false;
            }
            if (Integer.parseInt(this.getZona()) >= 0 && Integer.parseInt(this.getZona()) <= 99) break block7;
            return false;
        }
        this.setChecked(true);
        this.invalid_sectorzona = this.getZonasSinReparto();
        return this.invalid_sectorzona == null || !Arrays.asList(this.invalid_sectorzona).contains(this.getSectorzona());
    }

    private byte[] hash_hmac(String data, String key) {
        try {
            byte[] keyBytes = key.getBytes("UTF-8");
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
            return rawHmac;
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
            return null;
        }
    }

    private String httpPost(String uri, Map<String, Object> params) throws UnsupportedEncodingException, IOException, ProtocolException {
        int c;
        URL url = new URL(uri);
        StringBuilder querystring = new StringBuilder();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (querystring.length() != 0) {
                querystring.append('&');
            }
            querystring.append(URLEncoder.encode(param.getKey(), "UTF-8"));
            querystring.append('=');
            querystring.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        byte[] postDataBytes = querystring.toString().getBytes("UTF-8");
        Proxy proxy = null;
        if (this.getProxyhost() != null) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyhost(), this.getProxyport()));
        }
        HttpURLConnection conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
        conn.setDoOutput(true);
        conn.getOutputStream().write(postDataBytes);
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((c = ((Reader)in).read()) >= 0) {
            sb.append((char)c);
        }
        String response = sb.toString();
        return response;
    }

    private String httpGet(String uri, Map<String, Object> params, Map<String, Object> headers) throws UnsupportedEncodingException, IOException, ProtocolException {
        int c;
        Proxy proxy = null;
        if (this.getProxyhost() != null) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyhost(), this.getProxyport()));
        }
        StringBuilder querystring = new StringBuilder();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (querystring.length() != 0) {
                querystring.append('&');
            }
            querystring.append(param.getKey());
            querystring.append('=');
            querystring.append(param.getValue());
        }
        URL url = new URL(String.valueOf(uri) + "?" + querystring);
        HttpURLConnection conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestMethod("GET");
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue().toString());
            this.log.info(header.getValue().toString());
        }
        conn.setDoOutput(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((c = ((Reader)in).read()) >= 0) {
            sb.append((char)c);
        }
        String response = sb.toString();
        return response;
    }
}

