/*
 * Decompiled with CFR 0.152.
 */
package org.copesa.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.copesa.model.MapcityAddress;

public class CalloutCOPESABPLocation
extends CalloutEngine {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public String checkAddress(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || value.toString().trim().compareTo("") == 0) {
            return "";
        }
        MapcityAddress mp = new MapcityAddress();
        if (!mp.normalize((String)value)) {
            return "No se pudo normalizar direcci\u00f3n";
        }
        boolean hascoverage = mp.checkCoverage();
        mTab.setValue("AddressNumber", (Object)mp.getAltura());
        mTab.setValue("StreetType", (Object)mp.getTipo_via_largo().substring(0, 1));
        mTab.setValue("ZipCode", (Object)mp.getCodigo_postal());
        mTab.setValue("HomeNumber", (Object)mp.getAnexo());
        mTab.setValue("latitud", (Object)Double.toString(mp.getLatitud()));
        mTab.setValue("longitud", (Object)Double.toString(mp.getLongitud()));
        mTab.setValue("gse", (Object)mp.getGse());
        mTab.setValue("geocoding", (Object)mp.getGeocoding());
        try {
            int[] addresdata = this.getAddressIds(mp, null);
            mTab.setValue("C_City_ID", (Object)addresdata[0]);
            mTab.setValue("C_Province_ID", (Object)addresdata[1]);
            mTab.setValue("C_Region_ID", (Object)addresdata[2]);
            mTab.setValue("C_Street_ID", (Object)addresdata[3]);
        }
        catch (Exception e) {
            this.log.warning("Error normalizando direcci\u00f3n " + value.toString() + ": " + e.getMessage());
        }
        if (!mp.isChecked()) {
            mTab.setValue("Sector", (Object)"");
            mTab.setValue("Zone", (Object)"");
            return "No se pudo determinar sector/zona de direcci\u00f3n";
        }
        mTab.setValue("Sector", (Object)mp.getSector());
        mTab.setValue("Zone", (Object)mp.getZona());
        if (!hascoverage) {
            return "Direcci\u00f3n no tiene cobertura de reparto";
        }
        return "";
    }

    private int[] getAddressIds(MapcityAddress _mp, String _trxname) throws Exception {
        int[] addressdata = new int[4];
        String sql = "SELECT c_city_id, c_province_id, c_region_id from c_city where lower(name) = lower(?)";
        CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)_trxname);
        pstmt.setString(1, _mp.getComuna_largo());
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            addressdata[0] = rs.getInt(1);
            addressdata[1] = rs.getInt(2);
            addressdata[2] = rs.getInt(3);
        }
        pstmt.close();
        sql = "SELECT c_street_id from c_street where lower(name) = lower(?) and c_city_id = ?";
        pstmt = DB.prepareStatement((String)sql, (String)_trxname);
        pstmt.setString(1, _mp.getNombre_via_largo());
        pstmt.setInt(2, addressdata[0]);
        rs = pstmt.executeQuery();
        if (rs.next()) {
            addressdata[3] = rs.getInt(1);
        }
        pstmt.close();
        return addressdata;
    }
}

