/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubSalesRep
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = 840666209988831145L;
    private CLabel f_label = null;
    private CButton f_button = null;
    private CButton f_plus;
    private CButton f_minus;
    public VNumber f_quantity;
    private static CLogger log = CLogger.getCLogger(SubSalesRep.class);

    public SubSalesRep(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate((Properties)Env.getCtx(), (String)"QtyPOS"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        this.f_label = new CLabel("Cantidad Producto  ", 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)this.f_label, gbc);
        this.f_minus = this.createButtonAction("Minus", null);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add((Component)this.f_minus, gbc);
        this.f_quantity = new VNumber("QtyOrdered", false, false, true, 29, Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"));
        this.f_quantity.addActionListener((ActionListener)this);
        this.f_quantity.setPreferredSize(new Dimension(50, 25));
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add((Component)this.f_quantity, gbc);
        this.setQty(Env.ONE);
        this.f_plus = this.createButtonAction("Plus", null);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add((Component)this.f_plus, gbc);
        this.f_button = new CButton("Confirmar");
        this.f_button = this.createButtonAction("Confirmar", null);
        this.f_button.setFocusable(false);
        this.f_button.addActionListener((ActionListener)this);
        this.f_button.setPreferredSize(new Dimension(70, 40));
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        this.add((Component)this.f_button, gbc);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubSalesRep - actionPerformed: " + action);
        log.info("PosSubSalesRep - actionPerformed: " + action);
        if (action.equals("Confirmar")) {
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            if (!SubSalesRep.validStockBeforeConfirm(order, null, (BigDecimal)this.f_quantity.getValue())) {
                this.p_posPanel.f_status.setStatusLine("ERROR: Problemas de Stock");
                JOptionPane.showMessageDialog(null, "ERROR: Problemas de Stock");
            } else if (SubSalesRep.validCantLinePL(order, order.get_TrxName()) > 0) {
                this.p_posPanel.f_status.setStatusLine("ERROR: Pedido debe incluir al menos " + SubSalesRep.validCantLinePL(order, order.get_TrxName()) + " l\u00edneas por restricci\u00f3n de la lista de precios");
                JOptionPane.showMessageDialog(null, "ERROR: Pedido debe incluir al menos " + SubSalesRep.validCantLinePL(order, order.get_TrxName()) + " l\u00edneas por restricci\u00f3n de la lista de precios");
            } else {
                order.setDatePromised((Timestamp)this.p_posPanel.f_checkout.dateField.getValue());
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Timestamp timeNow = new Timestamp(cal.getTimeInMillis());
                order.setDateOrdered(timeNow);
                order.set_CustomColumn("DateCompleted", timeNow);
                order.save();
                this.p_posPanel.f_checkout.dateField.setReadWrite(false);
                this.p_posPanel.f_checkout.f_PriceList.setReadWrite(false);
                this.p_posPanel.f_checkout.f_PriceList.setEditable(false);
                MOrderLine[] oLines = this.p_posPanel.f_curLine.getOrder().getLines(" AND IsConfirmed = 'N' ", "line");
                int i = 0;
                while (i < oLines.length) {
                    MOrderLine line = oLines[i];
                    line.setQty((BigDecimal)this.f_quantity.getValue());
                    line.setLineNetAmt();
                    line.setTax();
                    line.set_CustomColumn("IsConfirmed", true);
                    line.save();
                    ++i;
                }
                this.p_posPanel.updateInfo();
                this.setQty(Env.ONE);
                this.p_posPanel.f_bpartner.f_name.setReadWrite(false);
                this.p_posPanel.f_bpartner.f_bSearch.setReadWrite(false);
                this.p_posPanel.f_bpartner.f_location.setReadWrite(false);
                SubFunctionKeys.ID_Level = 1;
                SubFunctionKeys.ID_LevelPrice = 1;
                SubFunctionKeys.ID_BotonHide = "0";
                this.p_posPanel.updateBtn();
                this.p_posPanel.f_checkout.displaySummary();
            }
        } else if (action.equals("Plus")) {
            this.f_quantity.plus();
            this.p_posPanel.updateInfo();
        } else if (action.equals("Minus")) {
            this.f_quantity.minus(1);
            this.p_posPanel.updateInfo();
        } else if (e.getSource() == this.f_quantity) {
            this.f_quantity.setValue(this.f_quantity.getValue());
            this.p_posPanel.updateInfo();
        }
    }

    public void setQty(BigDecimal qty) {
        this.f_quantity.setValue((Object)qty);
    }

    public static boolean validStockBeforeConfirm(MOrder order, String Trx2, BigDecimal qtyToAdd) {
        MOrderLine[] oLines2 = order.getLines(false, null);
        int i = 0;
        while (i < oLines2.length) {
            MOrderLine line = oLines2[i];
            if (!line.get_ValueAsBoolean("IsConfirmed") && line.getM_Product_ID() > 0 && line.getM_Product().getProductType().compareToIgnoreCase("I") == 0) {
                BigDecimal qty = DB.getSQLValueBD((String)Trx2, (String)("select bomqtyavailablecopesa(" + line.getM_Product_ID() + "," + order.getM_Warehouse_ID() + "," + line.get_ValueAsInt("M_Locator_ID") + ")"), (Object[])new Object[0]);
                if ((qty = qty.subtract(qtyToAdd)).compareTo(Env.ZERO) < 0) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static int validCantLinePL(MOrder order, String Trx2) {
        MPriceList pList;
        int cantLinePL;
        int cant = DB.getSQLValue((String)Trx2, (String)("select count(1) from c_orderline col join c_order co on (co.c_order_id = col.c_order_id)  join m_product mp on (mp.m_product_id = col.m_product_id)  where mp.description not in ('FULLSD')  and col.isactive = 'Y' and c_orderlineref_id is null  and co.c_order_id = " + order.get_ID()));
        if (cant < (cantLinePL = (pList = new MPriceList(Env.getCtx(), order.getM_PriceList_ID(), Trx2)).get_ValueAsInt("minLevel"))) {
            return cantLinePL;
        }
        return 0;
    }
}

