/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.print.MPrintColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubFunctionKeys
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = 2131406504920855582L;
    private MPOSKey[] m_keys;
    private static CLogger log = CLogger.getCLogger(SubFunctionKeys.class);
    public static String ID_BotonHide = "0";
    public static int ID_Level = 1;
    public static int ID_LevelPrice = 1;

    public SubFunctionKeys(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate((Properties)Env.getCtx(), (String)"C_POSKeyLayout_ID"));
        this.setBorder(border);
        int C_POSKeyLayout_ID = this.p_pos.getC_POSKeyLayout_ID();
        if (C_POSKeyLayout_ID == 0) {
            return;
        }
        MPOSKeyLayout fKeys = MPOSKeyLayout.get(Env.getCtx(), C_POSKeyLayout_ID);
        if (fKeys.get_ID() == 0) {
            return;
        }
        int COLUMNS = 3;
        int ROWS = 6;
        this.m_keys = fKeys.getKeysLevelUnique(ID_Level, this.p_posPanel.f_bpartner.getM_PriceList_Version_ID(), ID_BotonHide, this.p_pos.getM_Warehouse_ID(), this.p_posPanel.f_curLine.getM_Locator_ID());
        int noKeys = this.m_keys.length;
        int rows = Math.max((noKeys - 1) / COLUMNS + 1, ROWS);
        int cols = (noKeys - 1) % COLUMNS + 1;
        cols = 3;
        rows = 8;
        log.fine("PosSubFunctionKeys.init - NoKeys=" + noKeys + " - Rows=" + rows + ", Cols=" + cols);
        CPanel content = new CPanel((LayoutManager)new GridLayout(Math.max(rows, 3), Math.max(cols, 3)));
        int i = 0;
        while (i < this.m_keys.length && i < cols * rows) {
            Color keyColor = Color.lightGray;
            MPOSKey key = this.m_keys[i];
            log.config("Entrada en ciclo que crea botones");
            StringBuffer buttonHTML = new StringBuffer("<html><p>");
            if (key.getAD_PrintColor_ID() != 0) {
                MPrintColor color = MPrintColor.get((Properties)Env.getCtx(), (int)key.getAD_PrintColor_ID());
                keyColor = color.getColor();
                buttonHTML.append("<table").append(">").append(key.getName()).append("</table>");
            } else {
                buttonHTML.append(key.getName());
            }
            buttonHTML.append("</p></html>");
            log.fine("#" + i + " - " + keyColor);
            CButton button = new CButton(buttonHTML.toString());
            button.setMargin(INSETS1);
            button.setBackground(keyColor);
            button.setFocusable(false);
            button.setActionCommand(String.valueOf(key.getC_POSKey_ID()));
            button.addActionListener((ActionListener)this);
            content.add((Component)button);
            ++i;
        }
        i = this.m_keys.length;
        while (i < rows * COLUMNS) {
            CButton button = new CButton("");
            button.setFocusable(false);
            button.setBackground(Color.cyan);
            button.setActionCommand("0");
            content.add((Component)button);
            ++i;
        }
        content.setPreferredSize(new Dimension(cols * 80, rows * 50));
        this.add((Component)content);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridheight = 3;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0 || this.m_keys == null) {
            return;
        }
        log.info("PosSubFunctionKeys - actionPerformed: " + action);
        try {
            int C_POSKey_ID = Integer.parseInt(action);
            int i = 0;
            while (i < this.m_keys.length) {
                MPOSKey key = this.m_keys[i];
                if (key.getC_POSKey_ID() == C_POSKey_ID) {
                    if (this.p_posPanel.f_bpartner.getC_BPartner_ID() <= 0 || this.p_posPanel.f_bpartner.getC_BPartner_Location_ID() <= 0 || this.p_posPanel.f_bpartner.getC_BpartnertRef_ID() <= 0 || this.p_posPanel.f_bpartner.getC_BPartner_LocationShip_ID() <= 0) {
                        JOptionPane.showMessageDialog(null, "ERROR: LLenar todos los campos");
                        this.p_posPanel.f_checkout.displayReturn();
                        return;
                    }
                    this.p_posPanel.f_product.setM_Product_ID(key.getM_Product_ID());
                    this.p_posPanel.f_product.setPrice();
                    this.p_posPanel.f_curLine.setQty(key.getQty());
                    this.p_posPanel.f_curLine.setLevelNo(ID_LevelPrice);
                    if (!this.p_posPanel.f_curLine.saveLine()) {
                        this.p_posPanel.f_checkout.displayReturn();
                        return;
                    }
                    log.config("guardamos variable product_id" + key.getM_Product_ID() + " poskey_id" + key.get_ID());
                    this.p_posPanel.updateBtn();
                    return;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

