/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class SubBPartner
extends PosSubPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 5895558315889871887L;
    public CTextField f_name;
    private CButton f_bNew;
    public CButton f_bSearch;
    public CComboBox f_location;
    private CComboBox f_user;
    public CComboBox f_Bpartner;
    public CComboBox f_locationShip;
    private CLabel f_lBPartner = null;
    private CLabel f_lBPLocation = null;
    private CLabel f_lBPartnerShip = null;
    private CLabel f_lBPLocationShip = null;
    private MBPartner m_bpartner;
    private int m_M_PriceList_Version_ID = 0;
    private static CLogger log = CLogger.getCLogger(SubBPartner.class);

    public SubBPartner(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate((Properties)this.p_ctx, (String)"C_BPartner_ID"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        this.f_bNew = this.createButtonAction("New", null);
        gbc.gridx = 0;
        gbc.gridheight = 2;
        gbc.anchor = 17;
        this.add((Component)this.f_bNew, gbc);
        this.f_lBPartner = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"C_BPartner_POS"));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 18;
        this.add((Component)this.f_lBPartner, gbc);
        this.f_lBPLocation = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"C_BPartner_Location_POS"));
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)this.f_lBPLocation, gbc);
        this.f_lBPartnerShip = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"C_BPartnerShip_POS"));
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add((Component)this.f_lBPartnerShip, gbc);
        this.f_lBPLocationShip = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"C_BPartner_LocationShip_POS"));
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.add((Component)this.f_lBPLocationShip, gbc);
        this.f_name = new CTextField("");
        this.f_name.setName("Name");
        this.f_name.addActionListener((ActionListener)this);
        this.f_name.addFocusListener((FocusListener)this);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        this.add((Component)this.f_name, gbc);
        this.f_location = new CComboBox();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        this.add((Component)this.f_location, gbc);
        this.f_user = new CComboBox();
        this.f_Bpartner = new CComboBox();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.fill = 2;
        this.add((Component)this.f_Bpartner, gbc);
        this.f_Bpartner.addActionListener((ActionListener)this);
        this.f_Bpartner.addFocusListener((FocusListener)this);
        this.f_locationShip = new CComboBox();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.fill = 2;
        this.add((Component)this.f_locationShip, gbc);
        this.f_bSearch = this.createButtonAction("BPartner", KeyStroke.getKeyStroke(73, 3));
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.fill = 0;
        this.add((Component)this.f_bSearch, gbc);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        return gbc;
    }

    @Override
    public void dispose() {
        if (this.f_name != null) {
            this.f_name.removeFocusListener((FocusListener)this);
        }
        this.f_name = null;
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubCustomer - actionPerformed: " + action);
        if (action.equals("New")) {
            int cantOLines = DB.getSQLValue(null, (String)("SELECT COUNT(1) FROM C_OrderLine WHERE C_Order_ID = " + this.p_posPanel.f_curLine.getOrder().get_ID()));
            if (cantOLines > 0) {
                this.p_posPanel.newOrder();
                SubFunctionKeys.ID_Level = 1;
                SubFunctionKeys.ID_LevelPrice = 1;
                SubFunctionKeys.ID_BotonHide = "0";
                this.p_posPanel.f_checkout.p_posPanel.f_functionKeys.removeAll();
                this.p_posPanel.f_functionKeys.init();
                this.p_posPanel.f_salesRep.setQty(Env.ONE);
                this.p_posPanel.f_checkout.f_PriceList.setEditable(true);
                this.p_posPanel.f_checkout.f_PriceList.setReadWrite(true);
                this.p_posPanel.f_checkout.dateField.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_name.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_name.setEditable(true);
                this.p_posPanel.f_bpartner.f_bSearch.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_location.setReadWrite(true);
                this.p_posPanel.f_bpartner.f_location.setEditable(true);
            }
        } else if (!action.equals("Edit")) {
            if (action.equals("BPartner")) {
                this.p_posPanel.openQuery(this.p_posPanel.f_queryBPartner);
            } else if (e.getSource() == this.f_name) {
                this.findBPartner();
            } else if (e.getSource() == this.f_Bpartner) {
                this.fillLocationShip();
            }
        }
        this.p_posPanel.updateInfo();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        log.info(e.toString());
        this.findBPartner();
    }

    private void findBPartner() {
        String query = this.f_name.getText();
        if (query == null || query.length() == 0) {
            return;
        }
        query = query.toUpperCase();
        boolean allNumber = true;
        boolean noNumber = true;
        char[] qq = query.toCharArray();
        int i = 0;
        while (i < qq.length) {
            if (Character.isDigit(qq[i])) {
                noNumber = false;
                break;
            }
            ++i;
        }
        try {
            Integer.parseInt(query);
        }
        catch (Exception e) {
            allNumber = false;
        }
        String Value = query;
        String Name2 = allNumber ? null : query;
        String EMail2 = query.indexOf(64) != -1 ? query : null;
        String Phone = noNumber ? null : query;
        String City = null;
        MBPartnerInfo[] results = MBPartnerInfo.find((Properties)this.p_ctx, (String)Value, (String)Name2, null, (String)EMail2, (String)Phone, City);
        if (results.length == 0) {
            this.setC_BPartner_ID(0);
        } else if (results.length == 1) {
            this.setC_BPartner_ID(results[0].getC_BPartner_ID());
            this.f_name.setText(results[0].getName());
        } else {
            this.p_posPanel.f_queryBPartner.setResults(results);
            this.p_posPanel.openQuery(this.p_posPanel.f_queryBPartner);
        }
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        log.fine("PosSubCustomer.setC_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID == 0) {
            this.m_bpartner = null;
        } else {
            this.m_bpartner = new MBPartner(this.p_ctx, C_BPartner_ID, null);
            if (this.m_bpartner.get_ID() == 0) {
                this.m_bpartner = null;
            }
        }
        if (this.m_bpartner != null) {
            this.f_name.setText(this.m_bpartner.getName());
        } else {
            this.f_name.setText(null);
        }
        this.m_M_PriceList_Version_ID = 0;
        this.getM_PriceList_Version_ID();
        this.fillCombos();
        this.fillLocationShip();
        this.p_posPanel.f_curLine.setBPartner();
        if (this.p_posPanel.f_bpartner.getC_BPartner_ID() > 0 && this.p_posPanel.f_checkout != null && this.p_posPanel.f_curLine.getOrderWhitOutCreate() != null) {
            this.p_posPanel.f_checkout.fillCombos();
        }
    }

    public void fillCombos() {
        Vector<KeyNamePair> BpartnerRefVector;
        block15: {
            Vector<KeyNamePair> locationVector;
            block13: {
                locationVector = new Vector<KeyNamePair>();
                if (this.m_bpartner != null) {
                    String sqlPList = "SELECT C_Bpartner_Location_ID FROM C_BPartner_Location WHERE IsActive = 'Y' AND C_BPartner_ID = " + this.m_bpartner.get_ID() + " AND AD_Client_ID = " + Env.getAD_Client_ID((Properties)Env.getCtx()) + " AND (StreetName IS NOT NULL OR NormalizedAddress IS NOT NULL)";
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sqlPList, null);
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                MBPartnerLocation BPartLoc = new MBPartnerLocation(Env.getCtx(), rs.getInt("C_Bpartner_Location_ID"), null);
                                locationVector.add(BPartLoc.getKeyNamePair());
                            }
                            rs.close();
                            pstmt.close();
                            pstmt = null;
                        }
                        catch (SQLException e3) {
                            log.config("error" + e3 + " SQL: " + sqlPList);
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            DefaultComboBoxModel locationModel = new DefaultComboBoxModel(locationVector);
            this.f_location.setModel(locationModel);
            BpartnerRefVector = new Vector<KeyNamePair>();
            if (this.m_bpartner != null) {
                String sqlPList = "SELECT pr.C_BpartnerRef_ID, sn.name FROM C_BPartnerRelated pr JOIN C_BPartner sn ON sn.C_Bpartner_ID = pr.C_BpartnerRef_ID WHERE pr.IsActive = 'Y'   AND pr.C_BPartner_ID = " + this.m_bpartner.get_ID() + "  AND pr.AD_Client_ID = 2000006";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sqlPList, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int id = rs.getInt(1);
                            String name = rs.getString(2);
                            BpartnerRefVector.add(new KeyNamePair(id, name));
                        }
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (SQLException e3) {
                        log.config("error" + e3 + " SQL: " + sqlPList);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DefaultComboBoxModel bpListModel = new DefaultComboBoxModel(BpartnerRefVector);
        this.f_Bpartner.setModel(bpListModel);
    }

    public int getC_BPartner_ID() {
        if (this.m_bpartner != null) {
            return this.m_bpartner.getC_BPartner_ID();
        }
        return 0;
    }

    public MBPartner getBPartner() {
        return this.m_bpartner;
    }

    public int getC_BPartner_Location_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_location.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getC_BPartner_LocationShip_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_locationShip.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getAD_User_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_user.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getC_BpartnertRef_ID() {
        KeyNamePair pp;
        if (this.m_bpartner != null && (pp = (KeyNamePair)this.f_Bpartner.getSelectedItem()) != null) {
            return pp.getKey();
        }
        return 0;
    }

    public int getM_PriceList_Version_ID() {
        if (this.m_M_PriceList_Version_ID == 0) {
            int M_PriceList_ID = this.p_pos.getM_PriceList_ID();
            if (this.m_bpartner != null && this.m_bpartner.getM_PriceList_ID() != 0) {
                M_PriceList_ID = this.m_bpartner.getM_PriceList_ID();
            }
            MPriceList pl = MPriceList.get((Properties)this.p_ctx, (int)M_PriceList_ID, null);
            this.p_posPanel.f_curLine.setCurrency(MCurrency.getISO_Code((Properties)this.p_ctx, (int)pl.getC_Currency_ID()));
            this.f_name.setToolTipText(pl.getName());
            MPriceListVersion plv = pl.getPriceListVersion(this.p_posPanel.getToday());
            if (plv != null && plv.getM_PriceList_Version_ID() != 0) {
                this.m_M_PriceList_Version_ID = plv.getM_PriceList_Version_ID();
            }
        }
        return this.m_M_PriceList_Version_ID;
    }

    public void setM_PriceList_Version_ID(int p_M_PriceList_ID) {
        if (p_M_PriceList_ID > 0) {
            int M_PriceList_ID = p_M_PriceList_ID;
            MPriceList pl = MPriceList.get((Properties)this.p_ctx, (int)M_PriceList_ID, null);
            this.p_posPanel.f_curLine.setCurrency(MCurrency.getISO_Code((Properties)this.p_ctx, (int)pl.getC_Currency_ID()));
            this.f_name.setToolTipText(pl.getName());
            MPriceListVersion plv = pl.getPriceListVersion(this.p_posPanel.getToday());
            if (plv != null && plv.getM_PriceList_Version_ID() != 0) {
                this.m_M_PriceList_Version_ID = plv.getM_PriceList_Version_ID();
            }
        }
    }

    private void fillLocationShip() {
        Vector<KeyNamePair> locationShipVector;
        block7: {
            locationShipVector = new Vector<KeyNamePair>();
            if (this.f_Bpartner != null && this.getC_BpartnertRef_ID() > 0) {
                String sqlPList = "SELECT C_Bpartner_Location_ID FROM C_BPartner_Location WHERE IsActive = 'Y' AND C_BPartner_ID = " + this.getC_BpartnertRef_ID() + " AND AD_Client_ID = " + Env.getAD_Client_ID((Properties)Env.getCtx()) + " AND (StreetName IS NOT NULL OR NormalizedAddress IS NOT NULL)";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sqlPList, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MBPartnerLocation BPartLoc = new MBPartnerLocation(Env.getCtx(), rs.getInt("C_Bpartner_Location_ID"), null);
                            locationShipVector.add(BPartLoc.getKeyNamePair());
                        }
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (SQLException e3) {
                        log.config("error" + e3 + " SQL: " + sqlPList);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                Object var3_3 = null;
            }
        }
        DefaultComboBoxModel bpLocationShip = new DefaultComboBoxModel(locationShipVector);
        this.f_locationShip.setModel(bpLocationShip);
    }
}

