/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLineMA;
import org.compiere.model.MQualityTest;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProductionLine
extends X_M_ProductionLine
implements IDocumentLine {
    private static final long serialVersionUID = 1L;
    private MProduction parent;

    public boolean isParent() {
        return this.getM_Product_ID() == this.getM_ProductionPlan().getM_Product_ID();
    }

    public MProductionLine(Properties ctx, int M_ProductionLine_ID, String trxName) {
        super(ctx, M_ProductionLine_ID, trxName);
        if (M_ProductionLine_ID == 0) {
            this.setLine(0);
            this.setM_AttributeSetInstance_ID(0);
            this.setM_Locator_ID(0);
            this.setM_Product_ID(0);
            this.setM_ProductionLine_ID(0);
            this.setM_Production_ID(0);
            this.setMovementQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MProductionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductionLine(MProduction header) {
        super(header.getCtx(), 0, header.get_TrxName());
        this.setM_Production_ID(header.get_ID());
        this.setAD_Client_ID(header.getAD_Client_ID());
        this.setAD_Org_ID(header.getAD_Org_ID());
        this.parent = header;
    }

    public String createTransactions(Timestamp date, boolean mustBeStocked) {
        MAttributeSetInstance slASI;
        String slASIString;
        BigDecimal lineQty;
        int deleted = this.deleteMA();
        this.log.log(Level.FINE, "Deleted " + deleted + " attribute records ");
        MProduct prod = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        this.log.log(Level.FINE, "Loaded Product " + prod.toString());
        if (prod.getProductType().compareTo("I") != 0) {
            this.log.log(Level.FINE, "Production Line " + this.getLine() + " does not require stock movement");
            return "";
        }
        StringBuffer errorString = new StringBuffer();
        MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        String asiString = asi.getDescription();
        if (asiString == null) {
            asiString = "";
        }
        this.log.log(Level.FINEST, "asi Description is: " + asiString);
        if (this.getMovementQty().compareTo(Env.ZERO) > 0) {
            MProductionLineMA lineMA = new MProductionLineMA(this, asi.get_ID(), this.getMovementQty());
            if (!lineMA.save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                errorString.append("Could not save MA for " + this.toString() + "\n");
            }
            MTransaction matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P+", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), this.getMovementQty(), date, this.get_TrxName());
            matTrx.setM_ProductionLine_ID(this.get_ID());
            if (!matTrx.save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                errorString.append("Could not save transaction for " + this.toString() + "\n");
            }
            MStorage storage = MStorage.getCreate(this.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), this.get_TrxName());
            storage.changeQtyOnHand(this.getMovementQty(), true);
            if (!storage.save(this.get_TrxName())) {
                this.log.log(Level.SEVERE, "Could not update storage for " + this.toString());
                errorString.append("Could not save transaction for " + this.toString() + "\n");
            }
            this.log.log(Level.FINE, "Created finished goods line " + this.getLine());
            return errorString.toString();
        }
        MStorage[] storages = MStorage.getAll(this.getCtx(), this.getM_Product_ID(), this.getM_Locator_ID(), this.get_TrxName());
        MProductionLineMA lineMA = null;
        MTransaction matTrx = null;
        BigDecimal qtyToMove = this.getMovementQty().negate();
        int sl = 0;
        while (sl < storages.length) {
            lineQty = storages[sl].getQtyOnHand();
            this.log.log(Level.FINE, "QtyAvailable " + lineQty);
            if (lineQty.signum() > 0) {
                if (lineQty.compareTo(qtyToMove) > 0) {
                    lineQty = qtyToMove;
                }
                if ((slASIString = (slASI = new MAttributeSetInstance(this.getCtx(), storages[sl].getM_AttributeSetInstance_ID(), this.get_TrxName())).getDescription()) == null) {
                    slASIString = "";
                }
                this.log.log(Level.FINEST, "slASI-Description =" + slASIString);
                if (slASIString.compareTo(asiString) == 0 || asi.getM_AttributeSet_ID() == 0) {
                    lineMA = MProductionLineMA.get((MProductionLine)this, (int)storages[sl].getM_AttributeSetInstance_ID());
                    lineMA.setMovementQty(lineMA.getMovementQty().add(lineQty.negate()));
                    if (!lineMA.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                        errorString.append("Could not save MA for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved MA for " + this.toString());
                    }
                    matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P-", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), lineQty.negate(), date, this.get_TrxName());
                    matTrx.setM_ProductionLine_ID(this.get_ID());
                    if (!matTrx.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                        errorString.append("Could not save transaction for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved transaction for " + this.toString());
                    }
                    storages[sl].changeQtyOnHand(lineQty, false);
                    if (!storages[sl].save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not update storage for " + this.toString());
                        errorString.append("Could not update storage for " + this.toString() + "\n");
                    }
                    qtyToMove = qtyToMove.subtract(lineQty);
                    this.log.log(Level.FINE, String.valueOf(this.getLine()) + " Qty moved = " + lineQty + ", Remaining = " + qtyToMove);
                }
            }
            if (qtyToMove.signum() == 0) break;
            ++sl;
        }
        if (qtyToMove.signum() != 0) {
            if (mustBeStocked) {
                MLocator loc = new MLocator(this.getCtx(), this.getM_Locator_ID(), this.get_TrxName());
                errorString.append("Insufficient qty on hand of " + prod.toString() + " at " + loc.toString() + "\n");
            } else {
                MStorage storage = MStorage.get(Env.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), 0, this.get_TrxName());
                if (storage == null) {
                    storage = new MStorage(Env.getCtx(), 0, this.get_TrxName());
                    storage.setM_Locator_ID(this.getM_Locator_ID());
                    storage.setM_Product_ID(this.getM_Product_ID());
                    storage.setM_AttributeSetInstance_ID(0);
                    storage.save();
                }
                lineQty = qtyToMove;
                slASI = new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName());
                slASIString = slASI.getDescription();
                if (slASIString == null) {
                    slASIString = "";
                }
                this.log.log(Level.FINEST, "slASI-Description =" + slASIString);
                if (slASIString.compareTo(asiString) == 0 || asi.getM_AttributeSet_ID() == 0) {
                    lineMA = MProductionLineMA.get((MProductionLine)this, (int)storage.getM_AttributeSetInstance_ID());
                    lineMA.setMovementQty(lineMA.getMovementQty().add(lineQty.negate()));
                    if (!lineMA.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save MA for " + this.toString());
                        errorString.append("Could not save MA for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved MA for " + this.toString());
                    }
                    matTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "P-", this.getM_Locator_ID(), this.getM_Product_ID(), asi.get_ID(), lineQty.negate(), date, this.get_TrxName());
                    matTrx.setM_ProductionLine_ID(this.get_ID());
                    if (!matTrx.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not save transaction for " + this.toString());
                        errorString.append("Could not save transaction for " + this.toString() + "\n");
                    } else {
                        this.log.log(Level.FINE, "Saved transaction for " + this.toString());
                    }
                    storage.changeQtyOnHand(lineQty, false);
                    if (!storage.save(this.get_TrxName())) {
                        this.log.log(Level.SEVERE, "Could not update storage for " + this.toString());
                        errorString.append("Could not update storage for " + this.toString() + "\n");
                    }
                    qtyToMove = qtyToMove.subtract(lineQty);
                    this.log.log(Level.FINE, String.valueOf(this.getLine()) + " Qty moved = " + lineQty + ", Remaining = " + qtyToMove);
                }
            }
        }
        return errorString.toString();
    }

    private int deleteMA() {
        String sql = "DELETE FROM M_ProductionLineMA WHERE M_ProductionLine_ID = " + this.get_ID();
        int count = DB.executeUpdateEx((String)sql, (String)this.get_TrxName());
        return count;
    }

    public String toString() {
        if (this.getM_Product_ID() == 0) {
            return "No product defined for production line " + this.getLine();
        }
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        return "Production line:" + this.getLine() + " -- " + this.getMovementQty() + " of " + product.getValue();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.parent == null) {
            this.parent = new MProduction(this.getCtx(), this.getM_Production_ID(), this.get_TrxName());
        }
        if (this.parent.getM_Product_ID() == this.getM_Product_ID() && this.parent.getProductionQty().signum() == this.getMovementQty().signum()) {
            this.setIsEndProduct(true);
        } else {
            this.setIsEndProduct(false);
        }
        if (this.isEndProduct() && this.getM_AttributeSetInstance_ID() != 0) {
            String where = "M_QualityTest_ID IN (SELECT M_QualityTest_ID FROM M_Product_QualityTest WHERE M_Product_ID=?) AND M_QualityTest_ID NOT IN (SELECT M_QualityTest_ID FROM M_QualityTestResult WHERE M_AttributeSetInstance_ID=?)";
            List tests = new Query(this.getCtx(), "M_QualityTest", where, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{this.getM_Product_ID(), this.getM_AttributeSetInstance_ID()}).list();
            for (MQualityTest test : tests) {
                test.createResult(this.getM_AttributeSetInstance_ID());
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        this.deleteMA();
        return true;
    }

    public Timestamp getDateAcct() {
        return this.getM_ProductionPlan().getM_Production().getMovementDate();
    }

    public boolean isSOTrx() {
        return false;
    }

    public int getReversalLine_ID() {
        return -1;
    }

    public BigDecimal getPriceActual() {
        return Env.ZERO;
    }

    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    public int getM_LocatorTo_ID() {
        return -1;
    }

    public int getC_DocType_ID() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("DocBaseType").append("=?");
        return new Query(this.getCtx(), "C_DocType", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{"MMP"}).firstId();
    }
}

