/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MPOSKey;
import org.compiere.model.X_C_POSKeyLayout;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MPOSKeyLayout
extends X_C_POSKeyLayout {
    private static final long serialVersionUID = 5047330258566607212L;
    private static CCache<Integer, MPOSKeyLayout> s_cache = new CCache("C_POSKeyLayout", 3);
    private MPOSKey[] m_keys = null;

    public static MPOSKeyLayout get(Properties ctx, int C_POSKeyLayout_ID) {
        Integer key = new Integer(C_POSKeyLayout_ID);
        MPOSKeyLayout retValue = (MPOSKeyLayout)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MPOSKeyLayout(ctx, C_POSKeyLayout_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MPOSKeyLayout(Properties ctx, int C_POSKeyLayout_ID, String trxName) {
        super(ctx, C_POSKeyLayout_ID, trxName);
    }

    public MPOSKeyLayout(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPOSKey[] getKeys(boolean requery) {
        if (this.m_keys != null && !requery) {
            return this.m_keys;
        }
        ArrayList<MPOSKey> list = new ArrayList<MPOSKey>();
        String sql = "SELECT * FROM C_POSKey WHERE C_POSKeyLayout_ID=? AND IsActive = 'Y' ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_POSKeyLayout_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPOSKey(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_keys = new MPOSKey[list.size()];
        list.toArray(this.m_keys);
        return this.m_keys;
    }

    public MPOSKey[] getKeysLevel(int ID_Level, int ID_PriceListVersion) {
        this.m_keys = null;
        ArrayList<MPOSKey> list = new ArrayList<MPOSKey>();
        String sqlProduct = "";
        if (ID_Level == 1) {
            sqlProduct = "(SELECT M_Product_ID FROM M_ProductPrice WHERE IsActive = 'Y' AND IsVisible = 'Y' AND Levels = " + ID_Level + " AND M_PriceList_Version_ID = " + ID_PriceListVersion + ")";
        } else if (ID_Level > 1) {
            sqlProduct = "(SELECT M_Product_ID FROM M_ProductPriceRef WHERE IsActive = 'Y' AND IsVisible = 'Y' AND Levels = " + ID_Level + " AND M_PriceList_Version_ID = " + ID_PriceListVersion + ")";
        }
        String sql = "SELECT * FROM C_POSKey WHERE C_POSKeyLayout_ID=? AND IsActive = 'Y'  AND M_Product_ID IN " + sqlProduct + " ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_POSKeyLayout_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPOSKey(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_keys = new MPOSKey[list.size()];
        list.toArray(this.m_keys);
        return this.m_keys;
    }

    public MPOSKey[] getKeysLevelUnique(int ID_Level, int ID_PriceListVersion, String ID_HideProduct, int _warehouseid, int _locatorid) {
        this.m_keys = null;
        ArrayList<MPOSKey> list = new ArrayList<MPOSKey>();
        String sqlProduct = "";
        if (ID_Level == 1) {
            sqlProduct = "(SELECT M_Product_ID FROM M_ProductPrice WHERE IsActive = 'Y' AND IsVisible = 'Y' AND Levels = " + ID_Level + " AND M_PriceList_Version_ID = " + ID_PriceListVersion + " AND bomqtyavailablecopesa(M_Product_ID," + _warehouseid + "," + _locatorid + ") > 0)";
        } else if (ID_Level > 1) {
            sqlProduct = "(SELECT M_Product_ID FROM M_ProductPriceRef WHERE IsActive = 'Y' AND IsVisible = 'Y' AND Levels = " + ID_Level + " AND M_PriceList_Version_ID = " + ID_PriceListVersion + " AND bomqtyavailablecopesa(M_Product_ID," + _warehouseid + "," + _locatorid + ") > 0)";
        }
        String sql = "SELECT * FROM C_POSKey WHERE C_POSKeyLayout_ID=? AND IsActive = 'Y'  AND M_Product_ID IN " + sqlProduct;
        if (ID_HideProduct != null && ID_HideProduct.trim().length() > 3) {
            sql = String.valueOf(sql) + " AND M_Product_ID NOT IN (" + ID_HideProduct.trim() + ")";
        }
        sql = String.valueOf(sql) + " ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_POSKeyLayout_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPOSKey(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_keys = new MPOSKey[list.size()];
        list.toArray(this.m_keys);
        return this.m_keys;
    }

    public int getNoOfKeys() {
        return this.getKeys(false).length;
    }
}

