/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BPartnerNoBillToAddressException;
import org.adempiere.exceptions.BPartnerNoShipToAddressException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.I_C_BPartner;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MColumn;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Order;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.ofb.model.OFBForward;
import org.ofb.utils.DateUtils;

public class MOrder
extends X_C_Order
implements DocAction {
    private static final long serialVersionUID = 6238231989649199067L;
    private MOrderLine[] m_lines = null;
    private MOrderTax[] m_taxes = null;
    private boolean m_forceCreation = false;
    public static final String DocSubTypeSO_Standard = "SO";
    public static final String DocSubTypeSO_Quotation = "OB";
    public static final String DocSubTypeSO_Proposal = "ON";
    public static final String DocSubTypeSO_Prepay = "PR";
    public static final String DocSubTypeSO_POS = "WR";
    public static final String DocSubTypeSO_Warehouse = "WP";
    public static final String DocSubTypeSO_OnCredit = "WI";
    public static final String DocSubTypeSO_RMA = "RM";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MInOut m_shipment = null;
    private int m_line = 0;
    private SParameter m_lastPP = null;
    private MStorage[] m_lastStorages = null;
    private HashMap<SParameter, MStorage[]> m_map = new HashMap();

    public static MOrder copyFrom(MOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, boolean copyASI, String trxName) {
        MOrder to = new MOrder(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues((PO)((Object)from), (PO)((Object)to), from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Order_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setIsSelected(false);
        to.setDateOrdered(dateDoc);
        to.setDateAcct(dateDoc);
        to.setDatePromised(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setIsCreditApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsDelivered(false);
        to.setIsInvoiced(false);
        to.setIsSelfService(false);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        if (counter) {
            to.setRef_Order_ID(from.getC_Order_ID());
        } else {
            to.setRef_Order_ID(0);
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Order");
        }
        if (counter) {
            from.setRef_Order_ID(to.getC_Order_ID());
        }
        if (to.copyLinesFrom(from, counter, copyASI) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        to.setLink_Order_ID(0);
        return to;
    }

    public MOrder(Properties ctx, int C_Order_ID, String trxName) {
        super(ctx, C_Order_ID, trxName);
        if (C_Order_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction(DocSubTypeSO_Prepay);
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setInvoiceRule("I");
            this.setPaymentRule("P");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsDiscountPrinted(false);
            this.setIsSelected(false);
            this.setIsTaxIncluded(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsCreditApproved(false);
            this.setIsDelivered(false);
            this.setIsInvoiced(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
        }
    }

    public MOrder(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setSalesRep_ID(project.getSalesRep_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        Timestamp ts = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if ((ts = project.getDateFinish()) != null) {
            this.setDatePromised(ts);
        }
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(project.getC_BPartner_Location_ID());
        this.setAD_User_ID(project.getAD_User_ID());
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setM_PriceList_ID(project.getM_PriceList_ID());
        this.setC_PaymentTerm_ID(project.getC_PaymentTerm_ID());
        this.setIsSOTrx(IsSOTrx);
        if (IsSOTrx) {
            if (DocSubTypeSO == null || DocSubTypeSO.length() == 0) {
                this.setC_DocTypeTarget_ID(DocSubTypeSO_OnCredit);
            } else {
                this.setC_DocTypeTarget_ID(DocSubTypeSO);
            }
        } else {
            this.setC_DocTypeTarget_ID();
        }
    }

    public MOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
        super.setBill_BPartner_ID(C_BPartner_ID);
    }

    public void setC_BPartner_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        super.setBill_Location_ID(C_BPartner_Location_ID);
    }

    public void setAD_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
        super.setBill_User_ID(AD_User_ID);
    }

    public void setShip_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setShip_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
    }

    public void setShip_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
    }

    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        super.setM_Warehouse_ID(M_Warehouse_ID);
    }

    public void setIsDropShip(boolean IsDropShip) {
        super.setIsDropShip(IsDropShip);
    }

    public void setC_DocTypeTarget_ID(String DocSubTypeSO_x) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocSubTypeSO=? " + " AND IsActive='Y' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID(), (String)DocSubTypeSO_x);
        if (C_DocType_ID <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", SubType=" + DocSubTypeSO_x);
        } else {
            this.log.fine("(SO) - " + DocSubTypeSO_x);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            this.setIsSOTrx(true);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
            return;
        }
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType='POO' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
        if (C_DocType_ID <= 0) {
            this.log.severe("No POO found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            this.log.fine("(PO) - " + C_DocType_ID);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
        }
    }

    public void setBPartner(MBPartner bp) {
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getDeliveryRule()) != null) {
            this.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            this.setDeliveryViaRule(ss);
        }
        if ((ss = bp.getInvoiceRule()) != null) {
            this.setInvoiceRule(ss);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((ii = bp.getSalesRep_ID()) != 0) {
            this.setSalesRep_ID(ii);
        }
        if ((locs = bp.getLocations(false)) != null) {
            int i = 0;
            while (i < locs.length) {
                if (locs[i].isShipTo()) {
                    super.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                if (locs[i].isBillTo()) {
                    this.setBill_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                ++i;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                super.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
            if (this.getBill_Location_ID() == 0 && locs.length > 0) {
                this.setBill_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            throw new BPartnerNoShipToAddressException((I_C_BPartner)bp);
        }
        if (this.getBill_Location_ID() == 0) {
            throw new BPartnerNoBillToAddressException((I_C_BPartner)bp);
        }
        MUser[] contacts = bp.getContacts(false);
        if (contacts != null && contacts.length == 1) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public int copyLinesFrom(MOrder otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MOrderLine line = new MOrderLine(this);
            PO.copyValues((PO)((Object)fromLines[i]), (PO)((Object)line), this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setC_Order_ID(this.getC_Order_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            line.setOrder(this);
            line.set_ValueNoCheck("C_OrderLine_ID", I_ZERO);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (this.getC_BPartner_ID() != otherOrder.getC_BPartner_ID()) {
                line.setTax();
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLines[i].setRef_OrderLine_ID(line.getC_OrderLine_ID());
                fromLines[i].save(this.get_TrxName());
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append(", GrandTotal=").append(this.getGrandTotal()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 0, this.getC_Order_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)M_PriceList_ID, null);
        if (pl.get_ID() == M_PriceList_ID) {
            super.setM_PriceList_ID(M_PriceList_ID);
            this.setC_Currency_ID(pl.getC_Currency_ID());
            this.setIsTaxIncluded(pl.isTaxIncluded());
        }
    }

    public MOrderLine[] getLines(String whereClause, String orderClause) {
        StringBuffer whereClauseFinal = new StringBuffer("C_Order_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "C_OrderLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        for (MOrderLine ol : list) {
            ol.setHeaderInfo(this);
        }
        return list.toArray(new MOrderLine[list.size()]);
    }

    public MOrderLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && !requery) {
            MOrder.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_lines = this.getLines(null, orderClause);
        return this.m_lines;
    }

    public MOrderLine[] getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int step) {
        int number = step;
        MOrderLine[] lines = this.getLines(true, null);
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            line.setLine(number);
            line.save(this.get_TrxName());
            number += step;
            ++i;
        }
        this.m_lines = null;
    }

    public boolean isOrderLine(int C_OrderLine_ID) {
        if (this.m_lines == null) {
            this.getLines();
        }
        int i = 0;
        while (i < this.m_lines.length) {
            if (this.m_lines[i].getC_OrderLine_ID() == C_OrderLine_ID) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MOrderTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        List list = new Query(this.getCtx(), "C_OrderTax", "C_Order_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_taxes = list.toArray(new MOrderTax[list.size()]);
        return this.m_taxes;
    }

    public MInvoice[] getInvoices() {
        String whereClause = "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List list = new Query(this.getCtx(), "C_Invoice", "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("C_Invoice_ID DESC").list();
        return list.toArray(new MInvoice[list.size()]);
    }

    public int getC_Invoice_ID() {
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? AND DocStatus IN ('CO','CL') ORDER BY C_Invoice_ID DESC";
        int C_Invoice_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.get_ID());
        return C_Invoice_ID;
    }

    public MInOut[] getShipments() {
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List list = new Query(this.getCtx(), "M_InOut", "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("M_InOut_ID DESC").list();
        return list.toArray(new MInOut[list.size()]);
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName((Properties)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public void setDocAction(String DocAction2) {
        this.setDocAction(DocAction2, false);
    }

    public void setDocAction(String DocAction2, boolean forceCreation) {
        super.setDocAction(DocAction2);
        this.m_forceCreation = forceCreation;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Order_ID=" + this.getC_Order_ID();
        int noLine = DB.executeUpdateEx((String)("UPDATE C_OrderLine " + set), (String)this.get_TrxName());
        int noTax = DB.executeUpdateEx((String)("UPDATE C_OrderTax " + set), (String)this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    protected boolean beforeSave(boolean newRecord) {
        int ii;
        MWarehouse wh;
        int context_AD_Org_ID;
        if (this.getAD_Org_ID() == 0 && (context_AD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx())) != 0) {
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (newRecord && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            int ii2 = Env.getContextAsInt((Properties)this.getCtx(), (String)"#M_Warehouse_ID");
            if (ii2 != 0) {
                this.setM_Warehouse_ID(ii2);
            } else {
                throw new FillMandatoryException(new String[]{"M_Warehouse_ID"});
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID())).getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveWarning("WarehouseOrgConflict", "");
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID")) {
            MOrderLine[] lines = this.getLines(false, null);
            int i = 0;
            while (i < lines.length) {
                if (!lines[i].canChangeWarehouse()) {
                    return false;
                }
                ++i;
            }
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getBill_BPartner_ID() == 0) {
            this.setBill_BPartner_ID(this.getC_BPartner_ID());
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getBill_Location_ID() == 0) {
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getM_PriceList_ID() == 0 && (ii = DB.getSQLValueEx(null, (String)"SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive=?ORDER BY IsDefault DESC", (Object[])new Object[]{this.getAD_Client_ID(), this.isSOTrx(), true})) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if (this.getC_Currency_ID() == 0) {
            String sql = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, (String)sql, (int)this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt((Properties)this.getCtx(), (String)"#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                String sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        String sql;
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            sql = "UPDATE C_Invoice i SET (Description,POReference)=(SELECT Description,POReference FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID) WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdateEx((String)sql, (String)this.get_TrxName());
            this.log.fine("Description -> #" + no);
        }
        if (this.is_ValueChanged("PaymentRule") || this.is_ValueChanged("C_PaymentTerm_ID") || this.is_ValueChanged("C_Payment_ID") || this.is_ValueChanged("C_CashLine_ID")) {
            sql = "UPDATE C_Invoice i SET (PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID)=(SELECT PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Payment -> #" + no);
        }
        if (this.is_ValueChanged("DateAcct")) {
            sql = "UPDATE C_Invoice i SET (DateAcct)=(SELECT DateAcct FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('CO','RE','CL') AND Processed='N' AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("DateAcct -> #" + no);
        }
        if (this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_BPartner_Location_ID") || this.is_ValueChanged("DateOrdered") || this.is_ValueChanged("DatePromised") || this.is_ValueChanged("M_Warehouse_ID") || this.is_ValueChanged("M_Shipper_ID") || this.is_ValueChanged("C_Currency_ID")) {
            MOrderLine[] lines;
            MOrderLine[] mOrderLineArray = lines = this.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MOrderLine line = mOrderLineArray[n2];
                if (this.is_ValueChanged("AD_Org_ID")) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
                if (this.is_ValueChanged("C_BPartner_ID")) {
                    line.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (!OFBForward.NoCopyLocationLineOrder() && this.is_ValueChanged("C_BPartner_Location_ID")) {
                    line.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                }
                if (this.is_ValueChanged("DateOrdered")) {
                    line.setDateOrdered(this.getDateOrdered());
                }
                if (this.is_ValueChanged("DatePromised")) {
                    line.setDatePromised(this.getDatePromised());
                }
                if (this.is_ValueChanged("M_Warehouse_ID")) {
                    line.setM_Warehouse_ID(this.getM_Warehouse_ID());
                }
                if (this.is_ValueChanged("M_Shipper_ID")) {
                    line.setM_Shipper_ID(this.getM_Shipper_ID());
                }
                if (this.is_ValueChanged("C_Currency_ID")) {
                    line.setC_Currency_ID(this.getC_Currency_ID());
                }
                line.saveEx();
                ++n2;
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        MOrderLine[] mOrderLineArray = this.getLines();
        int n = mOrderLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLine line = mOrderLineArray[n2];
            line.deleteEx(true);
            ++n2;
        }
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction(DocSubTypeSO_Prepay);
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocTypeTarget_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("O")) {
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                MProduct product = line.getProduct();
                if (product != null && product.isExcludeAutoDelivery()) {
                    this.m_processMsg = "@M_Product_ID@ " + product.getValue() + " @IsExcludeAutoDelivery@";
                    return "IN";
                }
                ++i;
            }
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            MDocType dtOld;
            if (this.getC_DocType_ID() != 0 && DocSubTypeSO_Standard.equals((dtOld = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID())).getDocSubTypeSO()) && !DocSubTypeSO_Standard.equals(dt.getDocSubTypeSO())) {
                int i = 0;
                while (i < lines.length) {
                    if (lines[i].getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
                        this.log.warning("different Warehouse " + (Object)((Object)lines[i]));
                        this.m_processMsg = "@CannotChangeDocType@";
                        return "IN";
                    }
                    ++i;
                }
            }
            if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else if (dt.isOffer()) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else {
                this.m_processMsg = "@CannotChangeDocType@";
                return "IN";
            }
        }
        this.isASIMandatory();
        if (this.explodeBOM()) {
            lines = this.getLines(true, "M_Product_ID");
        }
        if (!this.reserveStock(dt, lines)) {
            this.m_processMsg = "Cannot reserve Stock";
            return "IN";
        }
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating tax";
            return "IN";
        }
        if (!(!this.isSOTrx() || DocSubTypeSO_POS.equals(dt.getDocSubTypeSO()) && "B".equals(this.getPaymentRule()) && !MSysConfig.getBooleanValue((String)"CHECK_CREDIT_ON_CASH_POS_ORDER", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()) || DocSubTypeSO_Prepay.equals(dt.getDocSubTypeSO()) && !MSysConfig.getBooleanValue((String)"CHECK_CREDIT_ON_PREPAY_ORDER", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()))) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getBill_BPartner_ID(), this.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            BigDecimal grandTotal = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(), this.getC_Currency_ID(), this.getDateOrdered(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
            if ("H".equals(bp.getSOCreditStatus(grandTotal)) && OFBForward.CreditHoldArt().equals("Y") && (this.getPaymentRule().equals("P") || this.getPaymentRule().equals("S"))) {
                this.m_processMsg = "@BPartnerOverOCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @GrandTotal@=" + grandTotal + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    private boolean explodeBOM() {
        boolean retValue = false;
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? " + where;
        int count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Order_ID());
        while (count != 0) {
            retValue = true;
            this.renumberLines(1000);
            MOrderLine[] lines = this.getLines(where, "Line");
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                int lineNo = line.getLine();
                MPPProductBOM bom = MPPProductBOM.get((MProduct)product, (int)this.getAD_Org_ID(), (Timestamp)this.getDatePromised(), (String)this.get_TrxName());
                if (bom != null) {
                    MPPProductBOMLine[] bomlines = bom.getLines(this.getDatePromised());
                    int j = 0;
                    while (j < bomlines.length) {
                        MPPProductBOMLine bomline = bomlines[j];
                        MOrderLine newLine = new MOrderLine(this);
                        newLine.setLine(++lineNo);
                        newLine.setM_Product_ID(bomline.getM_Product_ID());
                        newLine.setC_UOM_ID(bomline.getC_UOM_ID());
                        newLine.setQty(line.getQtyOrdered().multiply(bomline.getQtyBOM()));
                        if (bomline.getDescription() != null) {
                            newLine.setDescription(bomline.getDescription());
                        }
                        newLine.setPrice();
                        newLine.save(this.get_TrxName());
                        ++j;
                    }
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPrice(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setFreightAmt(Env.ZERO);
                String description = product.getName();
                if (product.getDescription() != null) {
                    description = String.valueOf(description) + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = String.valueOf(description) + " " + line.getDescription();
                }
                line.setDescription(description);
                line.save(this.get_TrxName());
                ++i;
            }
            this.m_lines = null;
            count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
            this.renumberLines(10);
        }
        return retValue;
    }

    private boolean reserveStock(MDocType dt, MOrderLine[] lines) {
        boolean binding;
        if (dt == null) {
            dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        }
        boolean bl = binding = !dt.isProposal();
        if ("VO".equals(this.getDocAction()) || DocSubTypeSO_Quotation.equals(dt.getDocSubTypeSO()) && "CL".equals(this.getDocAction())) {
            binding = false;
        }
        boolean isSOTrx = this.isSOTrx();
        this.log.fine("Binding=" + binding + " - IsSOTrx=" + isSOTrx);
        int header_M_Warehouse_ID = this.getM_Warehouse_ID();
        if (DocSubTypeSO_Standard.equals(dt.getDocSubTypeSO()) || "POO".equals(dt.getDocBaseType())) {
            header_M_Warehouse_ID = 0;
        }
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MProduct product;
            BigDecimal target;
            BigDecimal difference;
            MOrderLine line = lines[i];
            if (header_M_Warehouse_ID != 0) {
                if (header_M_Warehouse_ID != line.getM_Warehouse_ID()) {
                    line.setM_Warehouse_ID(header_M_Warehouse_ID);
                }
                if (this.getAD_Org_ID() != line.getAD_Org_ID()) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
            }
            if ((difference = (target = binding ? line.getQtyOrdered() : Env.ZERO).subtract(line.getQtyReserved()).subtract(line.getQtyDelivered())).signum() == 0) {
                product = line.getProduct();
                if (product != null) {
                    Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                    Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                }
            } else {
                this.log.fine("Line=" + line.getLine() + " - Target=" + target + ",Difference=" + difference + " - Ordered=" + line.getQtyOrdered() + ",Reserved=" + line.getQtyReserved() + ",Delivered=" + line.getQtyDelivered());
                product = line.getProduct();
                if (product != null) {
                    if (product.isStocked()) {
                        BigDecimal ordered = isSOTrx ? Env.ZERO : difference;
                        BigDecimal reserved = isSOTrx ? difference : Env.ZERO;
                        int M_Locator_ID = 0;
                        if (line.getM_AttributeSetInstance_ID() != 0) {
                            M_Locator_ID = MStorage.getM_Locator_ID(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), ordered, this.get_TrxName());
                        }
                        if (M_Locator_ID == 0) {
                            MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)line.getM_Warehouse_ID());
                            M_Locator_ID = product.getM_Locator_ID();
                            if (M_Locator_ID != 0) {
                                MLocator locator = new MLocator(this.getCtx(), product.getM_Locator_ID(), this.get_TrxName());
                                if (locator.getM_Warehouse_ID() != wh.get_ID()) {
                                    M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                                }
                            } else {
                                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
                            }
                        }
                        if (OFBForward.UseOLLocatorToReserved() && line.get_ValueAsInt("M_Locator_ID") > 0) {
                            M_Locator_ID = line.get_ValueAsInt("M_Locator_ID");
                        }
                        if (!MStorage.add(this.getCtx(), line.getM_Warehouse_ID(), M_Locator_ID, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, reserved, ordered, this.get_TrxName())) {
                            return false;
                        }
                    }
                    line.setQtyReserved(line.getQtyReserved().add(difference));
                    if (!line.save(this.get_TrxName())) {
                        return false;
                    }
                    Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                    Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                }
            }
            ++i;
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
        return true;
    }

    public boolean calculateTaxTotal() {
        MOrderTax oTax;
        this.log.fine("");
        DB.executeUpdateEx((String)("DELETE C_OrderTax WHERE C_Order_ID=" + this.getC_Order_ID()), (String)this.get_TrxName());
        this.m_taxes = null;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MOrderLine[] lines = null;
        lines = OFBForward.NoUseDesactiveOrderLines() ? this.getLines(" AND IsActive = 'Y' ", " Line") : this.getLines();
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID)) {
                oTax = MOrderTax.get((MOrderLine)line, (int)this.getPrecision(), (boolean)false, (String)this.get_TrxName());
                oTax.setIsTaxIncluded(this.isTaxIncluded());
                if (!oTax.calculateTaxFromLines()) {
                    return false;
                }
                if (!oTax.save(this.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            totalLines = totalLines.add(line.getLineNetAmt());
            ++i;
        }
        BigDecimal grandTotal = totalLines;
        MOrderTax[] taxes = this.getTaxes(true);
        int i2 = 0;
        while (i2 < taxes.length) {
            oTax = taxes[i2];
            MTax tax = oTax.getTax();
            if (tax.isSummary()) {
                MTax[] cTaxes = tax.getChildTaxes(false);
                int j = 0;
                while (j < cTaxes.length) {
                    MTax cTax = cTaxes[j];
                    BigDecimal taxAmt = cTax.calculateTax(oTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision());
                    MOrderTax newOTax = new MOrderTax(this.getCtx(), 0, this.get_TrxName());
                    newOTax.setClientOrg((PO)((Object)this));
                    newOTax.setC_Order_ID(this.getC_Order_ID());
                    newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newOTax.setPrecision(this.getPrecision());
                    newOTax.setIsTaxIncluded(this.isTaxIncluded());
                    newOTax.setTaxBaseAmt(oTax.getTaxBaseAmt());
                    newOTax.setTaxAmt(taxAmt);
                    if (!newOTax.save(this.get_TrxName())) {
                        return false;
                    }
                    if (!this.isTaxIncluded()) {
                        grandTotal = grandTotal.add(taxAmt);
                    }
                    ++j;
                }
                if (!oTax.delete(true, this.get_TrxName())) {
                    return false;
                }
                if (!oTax.save(this.get_TrxName())) {
                    return false;
                }
            } else if (!this.isTaxIncluded()) {
                grandTotal = grandTotal.add(oTax.getTaxAmt());
            }
            ++i2;
        }
        this.setTotalLines(totalLines);
        this.setGrandTotal(grandTotal);
        return true;
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        MOrder counter;
        String status;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (DocSubTypeSO_Proposal.equals(DocSubTypeSO) || DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
            if (DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
                this.reserveStock(dt, this.getLines(true, "M_Product_ID"));
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 7);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 9);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.setDefiniteDocumentNo();
            this.setProcessed(true);
            return "CO";
        }
        if (!this.m_forceCreation && DocSubTypeSO_Prepay.equals(DocSubTypeSO) && this.getC_Payment_ID() == 0 && this.getC_CashLine_ID() == 0) {
            this.setProcessed(true);
            return DocSubTypeSO_Warehouse;
        }
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        boolean realTimePOS = MSysConfig.getBooleanValue((String)"REAL_TIME_POS", (boolean)false, (int)this.getAD_Client_ID());
        boolean flagws = false;
        if (OFBForward.NoCreateMinOutWSArtilec()) {
            flagws = this.get_ValueAsBoolean("FlagWS");
        }
        MInOut shipment = null;
        if (!flagws && (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO))) {
            if (OFBForward.SetDeliveryRuleOrderArtilec()) {
                this.setDeliveryRule("A");
            } else if (!"F".equals(this.getDeliveryRule())) {
                this.setDeliveryRule("F");
            }
            shipment = OFBForward.UseGenInOutARTILEC() ? this.generate(this) : this.createShipment(dt, realTimePOS ? null : this.getDateOrdered());
            if (shipment == null) {
                return "IN";
            }
            info.append("@M_InOut_ID@: ").append(shipment.getDocumentNo());
            String msg = shipment.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if (DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MInvoice invoice = this.createInvoice(dt, shipment, realTimePOS ? null : this.getDateOrdered());
            if (invoice == null) {
                return "IN";
            }
            info.append(" - @C_Invoice_ID@: ").append(invoice.getDocumentNo());
            String msg = invoice.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if ((counter = this.createCounterDoc()) != null) {
            info.append(" - @CounterDoc@: @Order@=").append(counter.getDocumentNo());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 9)) != null) {
            if (info.length() > 0) {
                info.append(" - ");
            }
            info.append(valid);
            this.m_processMsg = info.toString();
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.m_processMsg = info.toString();
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)((Object)this))) != null) {
            this.setDocumentNo(value);
        }
    }

    private MInOut createShipment(MDocType dt, Timestamp movementDate) {
        this.log.info("For " + dt);
        MInOut shipment = new MInOut(this, dt.getC_DocTypeShipment_ID(), movementDate);
        if (!shipment.save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Shipment";
            return null;
        }
        MOrderLine[] oLines = this.getLines(true, null);
        int i = 0;
        while (i < oLines.length) {
            MOrderLine oLine = oLines[i];
            MInOutLine ioLine = new MInOutLine(shipment);
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            int M_Locator_ID = MStorage.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, 4));
            }
            if (!ioLine.save(this.get_TrxName())) {
                this.m_processMsg = "Could not create Shipment Line";
                return null;
            }
            ++i;
        }
        if (!OFBForward.NoCompleteMinOutWOrderArtilec()) {
            shipment.processIt("CO");
        }
        shipment.saveEx(this.get_TrxName());
        if (!OFBForward.NoCompleteMinOutWOrderArtilec() && !"CO".equals(shipment.getDocStatus())) {
            this.m_processMsg = "@M_InOut_ID@: " + shipment.getProcessMsg();
            return null;
        }
        return shipment;
    }

    private MInvoice createInvoice(MDocType dt, MInOut shipment, Timestamp invoiceDate) {
        this.log.info(dt.toString());
        MInvoice invoice = new MInvoice(this, dt.getC_DocTypeInvoice_ID(), invoiceDate);
        if (!invoice.save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Invoice";
            return null;
        }
        if (shipment != null) {
            if (!"D".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("D");
            }
            MInOutLine[] sLines = shipment.getLines(false);
            int i = 0;
            while (i < sLines.length) {
                MInOutLine sLine = sLines[i];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setShipLine(sLine);
                if (sLine.sameOrderLineUOM()) {
                    iLine.setQtyEntered(sLine.getQtyEntered());
                } else {
                    iLine.setQtyEntered(sLine.getMovementQty());
                }
                iLine.setQtyInvoiced(sLine.getMovementQty());
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Shipment Line";
                    return null;
                }
                sLine.setIsInvoiced(true);
                if (!sLine.save(this.get_TrxName())) {
                    this.log.warning("Could not update Shipment line: " + (Object)((Object)sLine));
                }
                ++i;
            }
        } else {
            if (OFBForward.SetDeliveryRuleOrderArtilec()) {
                this.setInvoiceRule("D");
            } else if (!"I".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("I");
            }
            MOrderLine[] oLines = this.getLines();
            int i = 0;
            while (i < oLines.length) {
                MOrderLine oLine = oLines[i];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setOrderLine(oLine);
                iLine.setQtyInvoiced(oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced()));
                if (oLine.getQtyOrdered().compareTo(oLine.getQtyEntered()) == 0) {
                    iLine.setQtyEntered(iLine.getQtyInvoiced());
                } else {
                    iLine.setQtyEntered(iLine.getQtyInvoiced().multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4));
                }
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Order Line";
                    return null;
                }
                ++i;
            }
        }
        invoice.processIt("CO");
        invoice.saveEx(this.get_TrxName());
        this.setC_CashLine_ID(invoice.getC_CashLine_ID());
        if (!"CO".equals(invoice.getDocStatus())) {
            this.m_processMsg = "@C_Invoice_ID@: " + invoice.getProcessMsg();
            return null;
        }
        return invoice;
    }

    private MOrder createCounterDoc() {
        if (this.getRef_Order_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        MOrgInfo counterOrgInfo = MOrgInfo.get((Properties)this.getCtx(), (int)counterAD_Org_ID, (String)this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MOrder counter = MOrder.copyFrom(this, this.getDateOrdered(), C_DocTypeTarget_ID, !this.isSOTrx(), true, false, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setBPartner(counterBP);
        counter.setDatePromised(this.getDatePromised());
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        MOrderLine[] counterLines = counter.getLines(true, null);
        int i = 0;
        while (i < counterLines.length) {
            MOrderLine counterLine = counterLines[i];
            counterLine.setOrder(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.save(this.get_TrxName());
            ++i;
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    public boolean voidIt() {
        MOrderTax[] taxes;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            BigDecimal old = line.getQtyOrdered();
            if (old.signum() != 0) {
                line.addDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Voided")) + " (" + old + ")");
                line.setQty(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.save(this.get_TrxName());
            }
            if (!this.isSOTrx()) {
                this.deleteMatchPOCostDetail(line);
            }
            ++i;
        }
        MOrderTax[] mOrderTaxArray = taxes = this.getTaxes(true);
        int n = taxes.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderTax tax = mOrderTaxArray[n2];
            if (!tax.calculateTaxFromLines() || !tax.save()) {
                return false;
            }
            ++n2;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (void)";
            return false;
        }
        MRequisitionLine.unlinkC_Order_ID((Properties)this.getCtx(), (int)this.get_ID(), (String)this.get_TrxName());
        if (!this.createReversals()) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getC_Order_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private boolean createReversals() {
        if (!this.isSOTrx()) {
            return true;
        }
        this.log.info("createReversals");
        StringBuffer info = new StringBuffer();
        info.append("@M_InOut_ID@:");
        MInOut[] shipments = this.getShipments();
        int i = 0;
        while (i < shipments.length) {
            MInOut ship = shipments[i];
            if (!("CL".equals(ship.getDocStatus()) || "RE".equals(ship.getDocStatus()) || "VO".equals(ship.getDocStatus()))) {
                ship.set_TrxName(this.get_TrxName());
                if (!"CO".equals(ship.getDocStatus())) {
                    if (ship.voidIt()) {
                        ship.setDocStatus("VO");
                    }
                } else if (ship.reverseCorrectIt()) {
                    ship.setDocStatus("RE");
                    info.append(" ").append(ship.getDocumentNo());
                } else {
                    this.m_processMsg = "Could not reverse Shipment " + (Object)((Object)ship);
                    return false;
                }
                ship.setDocAction("--");
                ship.save(this.get_TrxName());
            }
            ++i;
        }
        info.append(" - @C_Invoice_ID@:");
        MInvoice[] invoices = this.getInvoices();
        int i2 = 0;
        while (i2 < invoices.length) {
            MInvoice invoice = invoices[i2];
            if (!("CL".equals(invoice.getDocStatus()) || "RE".equals(invoice.getDocStatus()) || "VO".equals(invoice.getDocStatus()))) {
                invoice.set_TrxName(this.get_TrxName());
                if (!"CO".equals(invoice.getDocStatus())) {
                    if (invoice.voidIt()) {
                        invoice.setDocStatus("VO");
                    }
                } else if (invoice.reverseCorrectIt()) {
                    invoice.setDocStatus("RE");
                    info.append(" ").append(invoice.getDocumentNo());
                } else {
                    this.m_processMsg = "Could not reverse Invoice " + (Object)((Object)invoice);
                    return false;
                }
                invoice.setDocAction("--");
                invoice.save(this.get_TrxName());
            }
            ++i2;
        }
        this.m_processMsg = info.toString();
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            BigDecimal old = line.getQtyOrdered();
            if (old.compareTo(line.getQtyDelivered()) != 0) {
                line.setQtyLostSales(line.getQtyOrdered().subtract(line.getQtyDelivered()));
                line.setQtyOrdered(line.getQtyDelivered());
                line.addDescription("Close (" + old + ")");
                line.save(this.get_TrxName());
            }
            ++i;
        }
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (close)";
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 11);
        return this.m_processMsg == null;
    }

    public String reopenIt() {
        this.log.info(this.toString());
        if (!"CL".equals(this.getDocStatus())) {
            return "Not closed - can't reopen";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            if (Env.ZERO.compareTo(line.getQtyLostSales()) != 0) {
                line.setQtyOrdered(line.getQtyLostSales().add(line.getQtyDelivered()));
                line.setQtyLostSales(Env.ZERO);
                String desc = line.getDescription();
                if (desc == null) {
                    desc = "";
                }
                Pattern pattern = Pattern.compile("( \\| )?Close \\(.*\\)");
                String[] parts = pattern.split(desc);
                desc = "";
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    desc = desc.concat(s);
                    ++n2;
                }
                line.setDescription(desc);
                if (!line.save(this.get_TrxName())) {
                    return "Couldn't save orderline";
                }
            }
            ++i;
        }
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (close)";
            return "Failed to update reservations";
        }
        this.setDocStatus("CO");
        this.setDocAction("CL");
        if (!this.save(this.get_TrxName())) {
            return "Couldn't save reopened order";
        }
        return "";
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return this.voidIt();
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MDocType newDT = null;
            MDocType[] dts = MDocType.getOfClient((Properties)this.getCtx());
            int i = 0;
            while (i < dts.length) {
                MDocType type = dts[i];
                if (DocSubTypeSO_Prepay.equals(type.getDocSubTypeSO()) && (type.isDefault() || newDT == null)) {
                    newDT = type;
                }
                ++i;
            }
            if (newDT == null) {
                return false;
            }
            this.setC_DocType_ID(newDT.getC_DocType_ID());
        }
        if (!this.isSOTrx()) {
            this.log.info("Existing documents not modified - " + dt);
        } else if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO)) {
            if (!this.createReversals()) {
                return false;
            }
        } else {
            this.log.info("Existing documents not modified - SubType=" + DocSubTypeSO);
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getC_Order_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"GrandTotal")).append("=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    private String deleteMatchPOCostDetail(MOrderLine line) {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        int asn = 0;
        while (asn < acctschemas.length) {
            MCostDetail cd;
            MMatchPO[] mPO;
            MAcctSchema as = acctschemas[asn];
            if (!as.isSkipOrg(this.getAD_Org_ID()) && (mPO = MMatchPO.getOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName())).length == 0 && (cd = MCostDetail.get(this.getCtx(), "C_OrderLine_ID=?", line.getC_OrderLine_ID(), line.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.get_TrxName())) != null) {
                cd.setProcessed(false);
                cd.delete(true);
            }
            ++asn;
        }
        return "";
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public void updateIsDelivered() throws SQLException {
        String query = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? and QtyOrdered > QtyDelivered ";
        CPreparedStatement ps = DB.prepareStatement((String)query, (String)this.get_TrxName());
        ps.setInt(1, this.get_ID());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            int delta = rs.getInt(1);
            if (delta == 0) {
                this.setIsDelivered(true);
            } else {
                this.setIsDelivered(false);
            }
        }
        rs.close();
        ps.close();
    }

    private void isASIMandatory() {
        MOrderLine[] mOrderLineArray = this.getLines();
        int n = mOrderLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MAttributeSet mas;
            MOrderLine ol = mOrderLineArray[n2];
            MProduct product = new MProduct(this.getCtx(), ol.getM_Product_ID(), this.get_TrxName());
            if (product.getM_AttributeSet_ID() > 0 && product.isASIMandatory(this.isSOTrx(), this.getAD_Org_ID()) && !(mas = MAttributeSet.get((Properties)this.getCtx(), (int)product.getM_AttributeSet_ID())).excludeEntry(MColumn.getColumn_ID((String)"C_OrderLine", (String)"C_OrderLine_ID"), this.isSOTrx()) && ol.getM_AttributeSetInstance_ID() == 0) {
                this.m_processMsg = "@LinesWithoutProductAttribute@ (" + ol.getLine() + ")";
                throw new AdempiereException(this.m_processMsg);
            }
            ++n2;
        }
    }

    public MStorage[] getWarehouse(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, boolean positiveOnly, int M_Locator_ID, String trxName) {
        ArrayList<MStorage> list;
        block17: {
            if (M_Warehouse_ID == 0 && M_Locator_ID == 0 || M_Product_ID == 0) {
                return new MStorage[0];
            }
            boolean allAttributeInstances = false;
            if (M_AttributeSetInstance_ID == 0) {
                allAttributeInstances = true;
            }
            list = new ArrayList<MStorage>();
            String sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) ";
            sql = M_Locator_ID > 0 ? String.valueOf(sql) + "WHERE l.M_Locator_ID = ?" : String.valueOf(sql) + "WHERE l.M_Warehouse_ID=?";
            sql = String.valueOf(sql) + " AND s.M_Product_ID=? AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            sql = String.valueOf(sql) + " AND s.QtyOnHand > 0 ";
            sql = String.valueOf(sql) + "ORDER BY s.QtyOnHand DESC,l.PriorityNo DESC, M_AttributeSetInstance_ID";
            if (!FiFo) {
                sql = String.valueOf(sql) + " DESC";
            }
            if (allAttributeInstances) {
                sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) ";
                sql = M_Locator_ID > 0 ? String.valueOf(sql) + "WHERE l.M_Locator_ID = ?" : String.valueOf(sql) + "WHERE l.M_Warehouse_ID=?";
                sql = String.valueOf(sql) + " AND s.M_Product_ID=? ";
                sql = String.valueOf(sql) + " AND s.QtyOnHand > 0 ";
                if (minGuaranteeDate != null) {
                    sql = String.valueOf(sql) + "AND (asi.GuaranteeDate IS NULL OR asi.GuaranteeDate>?) ";
                    sql = String.valueOf(sql) + "ORDER BY l.PriorityNo DESC, asi.GuaranteeDate, M_AttributeSetInstance_ID";
                    if (!FiFo) {
                        sql = String.valueOf(sql) + " DESC";
                    }
                    sql = String.valueOf(sql) + ", s.QtyOnHand DESC";
                } else {
                    sql = String.valueOf(sql) + "ORDER BY l.PriorityNo DESC, l.M_Locator_ID, s.M_AttributeSetInstance_ID";
                    if (!FiFo) {
                        sql = String.valueOf(sql) + " DESC";
                    }
                    sql = String.valueOf(sql) + ", s.QtyOnHand DESC";
                }
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    pstmt.setInt(1, M_Locator_ID > 0 ? M_Locator_ID : M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (!allAttributeInstances) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    } else if (minGuaranteeDate != null) {
                        pstmt.setTimestamp(3, minGuaranteeDate);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (rs.getBigDecimal(11).signum() == 0) continue;
                        list.add(new MStorage(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    this.log.config(e.toString());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private MStorage[] getStorages(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, boolean FiFo) {
        String sql;
        ArrayList<MStorage> list;
        block8: {
            this.m_lastStorages = null;
            list = new ArrayList<MStorage>();
            sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.QtyReserved,s.QtyOrdered,s.DateLastInventory FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE s.QtyOnHand> 0 and l.M_Warehouse_ID=? AND s.M_Product_ID=? ";
            sql = String.valueOf(sql) + " And l.M_Locator_ID IN " + this.getPositiveLocators(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID);
            if (M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            }
            sql = String.valueOf(sql) + " ORDER BY l.PriorityNo Desc, s.QtyOnHand- (select coalesce(sum(loc.movementqty),0) from m_inoutline loc inner join m_inout i on (i.m_inout_id=loc.m_inout_id) where i.DocStatus='IP' and loc.m_product_id= s.M_Product_ID  and loc.m_locator_id=l.m_locator_id) Asc";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MStorage(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.config("sql:" + sql);
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        this.m_lastStorages = retValue;
        return this.m_lastStorages;
    }

    private String getPositiveLocators(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        String out;
        block9: {
            out = "(0 ";
            String sql = "SELECT Sum(s.QtyOnHand),s.M_Locator_ID,l.PriorityNo FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE l.M_Warehouse_ID=?  AND s.M_Product_ID=? ";
            if (M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            }
            sql = String.valueOf(sql) + " Group by s.M_Locator_ID ,l.PriorityNo  Having Sum(s.QtyOnHand)>0 ";
            sql = String.valueOf(sql) + " ORDER BY l.PriorityNo Desc, Sum(s.QtyOnHand) Asc";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        out = String.valueOf(out) + "," + rs.getInt(2);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        out = String.valueOf(out) + ",0)";
        if (out.equals("(0, ,0)")) {
            out = "(0)";
        }
        return out;
    }

    private MInOut generate(MOrder order) {
        boolean p_ConsolidateDocument = true;
        if (!p_ConsolidateDocument || this.m_shipment != null && (this.m_shipment.getC_BPartner_Location_ID() != order.getC_BPartner_Location_ID() || this.m_shipment.getM_Shipper_ID() != order.getM_Shipper_ID())) {
            this.log.fine("check: " + (Object)((Object)order) + " - DeliveryRule=" + order.getDeliveryRule());
        }
        boolean completeOrder = "O".equals(order.getDeliveryRule());
        boolean completeLine = "L".equals(order.getDeliveryRule());
        boolean available = "A".equals(order.getDeliveryRule());
        String where = " AND M_Warehouse_ID=" + order.getM_Warehouse_ID();
        if (order.getDatePromised() != null) {
            where = String.valueOf(where) + " AND (TRUNC(DatePromised)<=" + DB.TO_DATE((Timestamp)order.getDatePromised(), (boolean)true) + " OR DatePromised IS NULL)";
        }
        MOrderLine[] lines = order.getLines(where, "ORDER BY C_BPartner_Location_ID, M_Product_ID");
        this.exploreLines(lines, completeOrder, completeLine, available, order);
        return this.m_shipment;
    }

    private void exploreLines(MOrderLine[] lines, boolean completeOrder, boolean completeLine, boolean available, MOrder order) {
        MOrderLine line;
        int i;
        boolean error = false;
        if (completeOrder || completeLine) {
            i = 0;
            while (i < lines.length) {
                line = lines[i];
                if (line.getM_Warehouse_ID() == order.getM_Warehouse_ID()) {
                    this.log.fine("check: " + (Object)((Object)line));
                    BigDecimal onHand = Env.ZERO;
                    BigDecimal toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                    MProduct product = line.getProduct();
                    if (!(product != null && toDeliver.signum() == 0 || line.getC_Charge_ID() != 0 && toDeliver.signum() == 0)) {
                        if (!(product != null && product.isStocked() || line.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                            if (!"O".equals(line.getParent().getDeliveryRule())) {
                                this.createLine(line.getParent(), line, toDeliver, null, false);
                            }
                        } else if (product.isItem()) {
                            String MMPolicy = product.getMMPolicy();
                            MStorage[] storages = this.getStorages(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), "F".equals(MMPolicy));
                            BigDecimal inProcess = this.getInProcessW(line.getM_Product_ID(), line.getM_Warehouse_ID());
                            int j = 0;
                            while (j < storages.length) {
                                MStorage storage = storages[j];
                                onHand = onHand.add(storage.getQtyOnHand());
                                this.log.config("storage " + j + ",id:" + storage.getM_Locator_ID() + " QtyOnHand:" + storage.getQtyOnHand());
                                ++j;
                            }
                            onHand = onHand.subtract(inProcess);
                        }
                    }
                }
                ++i;
            }
        }
        if (error) {
            return;
        }
        i = 0;
        while (i < lines.length) {
            line = lines[i];
            if (line.getM_Warehouse_ID() == order.getM_Warehouse_ID()) {
                this.log.fine("check: " + (Object)((Object)line));
                BigDecimal toDeliver = line.getQtyOrdered().subtract(line.getQtyDelivered());
                MProduct product = line.getProduct();
                if (!(product != null && toDeliver.signum() == 0 || line.getC_Charge_ID() != 0 && toDeliver.signum() == 0)) {
                    if (!(product != null && product.isStocked() || line.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                        if (!"O".equals(line.getParent().getDeliveryRule())) {
                            this.createLine(line.getParent(), line, toDeliver, null, false);
                        }
                    } else {
                        Integer[] storages = this.getLocators(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID());
                        this.createLine(line.getParent(), line, toDeliver, storages, false);
                    }
                }
            }
            ++i;
        }
    }

    private BigDecimal getInProcessW(int Product_ID, int Warehouse_ID) {
        BigDecimal reValue;
        block7: {
            String sql = "select sum(l.movementqty) from m_inoutline l inner join m_inout i on (i.m_inout_id=l.m_inout_id)  where i.DocStatus='IP' and l.m_product_id= ?  and i.M_WAREHOUSE_ID= ? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            reValue = new BigDecimal(0.0);
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, Product_ID);
                    pstmt.setInt(2, Warehouse_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        reValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (reValue == null) {
            reValue = new BigDecimal(0.0);
        }
        return reValue;
    }

    private Integer[] getLocators(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID) {
        String sql;
        ArrayList<Integer> locators;
        block8: {
            locators = new ArrayList<Integer>();
            sql = "SELECT s.M_Product_ID,s.M_Locator_ID,  SUM(s.QtyOnHand) as QtyOnHand, l.priorityNO FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID)  WHERE l.isactive='Y' and l.M_Warehouse_ID=? AND s.M_Product_ID=? ";
            if (M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
            }
            sql = String.valueOf(sql) + "   Group by s.M_Product_ID,s.M_Locator_ID, l.priorityNO  Having SUM(s.QtyOnHand)>0   order by 4 desc, 3 asc";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        locators.add(rs.getInt(2));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.config("sql:" + sql);
        Integer[] retValue = new Integer[locators.size()];
        locators.toArray(retValue);
        return retValue;
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qty, Integer[] storages, boolean force) {
        if (this.m_shipment == null) {
            this.m_shipment = new MInOut(order, order.getC_DocType().getC_DocTypeShipment_ID(), DateUtils.today());
            this.m_shipment.setM_Warehouse_ID(orderLine.getM_Warehouse_ID());
            if (order.getC_BPartner_ID() != orderLine.getC_BPartner_ID()) {
                this.m_shipment.setC_BPartner_ID(orderLine.getC_BPartner_ID());
            }
            if (order.getC_BPartner_Location_ID() != orderLine.getC_BPartner_Location_ID()) {
                this.m_shipment.setC_BPartner_Location_ID(orderLine.getC_BPartner_Location_ID());
            }
            if (!this.m_shipment.save()) {
                throw new IllegalStateException("Could not create Shipment");
            }
        }
        MProduct product = orderLine.getProduct();
        product.getValue();
        if (storages == null || !product.isItem() || storages.length == 0) {
            MInOutLine line = new MInOutLine(this.m_shipment);
            line.setOrderLine(orderLine, 0, Env.ZERO);
            line.setQty(qty);
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                line.setQtyEntered(qty.multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
            }
            line.setLine(this.m_line + orderLine.getLine());
            if (!line.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            this.log.fine(line.toString());
            return;
        }
        boolean linePerASI = false;
        if (product.getM_AttributeSet_ID() != 0) {
            MAttributeSet mas = MAttributeSet.get((Properties)this.getCtx(), (int)product.getM_AttributeSet_ID());
            linePerASI = mas.isInstanceAttribute();
        }
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        BigDecimal toDeliver = qty;
        int i = 0;
        while (i < storages.length) {
            int storage = storages[i];
            this.log.config("storage " + i + ",id:" + storage);
            BigDecimal deliver = toDeliver;
            MInOutLine line = null;
            if (deliver.signum() != 0) {
                int M_Locator_ID = storage;
                BigDecimal inProcess = this.getInProcess(orderLine.getM_Product_ID(), M_Locator_ID);
                BigDecimal total = this.getTotalLocator(M_Locator_ID, orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID());
                BigDecimal totalEff = total.subtract(inProcess);
                if (totalEff.signum() > 0) {
                    if (!linePerASI) {
                        int ll = 0;
                        while (ll < list.size()) {
                            MInOutLine test = (MInOutLine)((Object)list.get(ll));
                            if (test.getM_Locator_ID() == M_Locator_ID) {
                                line = test;
                                break;
                            }
                            ++ll;
                        }
                    }
                    if (line == null) {
                        MLocator locTemp;
                        line = new MInOutLine(this.m_shipment);
                        line.setOrderLine(orderLine, M_Locator_ID, order.isSOTrx() ? deliver : Env.ZERO);
                        if (totalEff.compareTo(deliver) < 0) {
                            deliver = totalEff;
                        }
                        if (totalEff.compareTo(qty) >= 0) {
                            deliver = toDeliver;
                        }
                        line.setQty(deliver);
                        String pickupDesc = "";
                        if (i + 1 < storages.length) {
                            locTemp = MLocator.get(this.getCtx(), storages[i + 1]);
                            pickupDesc = String.valueOf(pickupDesc) + locTemp.getValue() + " C:" + this.getTotalLocator(locTemp.getM_Locator_ID(), orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID());
                        }
                        if (i + 2 < storages.length) {
                            locTemp = MLocator.get(this.getCtx(), storages[i + 2]);
                            pickupDesc = String.valueOf(pickupDesc) + "/ " + locTemp.getValue() + " C:" + this.getTotalLocator(locTemp.getM_Locator_ID(), orderLine.getM_Product_ID(), orderLine.getM_AttributeSetInstance_ID());
                        }
                        list.add(line);
                        this.log.config("new line qty=" + deliver + " locator:" + M_Locator_ID);
                    } else {
                        line.setQty(line.getMovementQty().add(deliver));
                        this.log.config("old add line qty=" + deliver + " locator:" + M_Locator_ID);
                    }
                    if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                        line.setQtyEntered(line.getMovementQty().multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, 4));
                    }
                    line.setLine(this.m_line + orderLine.getLine());
                    if (linePerASI) {
                        line.setM_AttributeSetInstance_ID(orderLine.getM_AttributeSetInstance_ID());
                    }
                    if (!line.save()) {
                        throw new IllegalStateException("Could not create Shipment Line");
                    }
                    this.log.config("ToDeliver=" + qty + "/" + deliver + " - " + (Object)((Object)line));
                    toDeliver = toDeliver.subtract(deliver);
                    if (toDeliver.signum() == 0) break;
                }
            }
            ++i;
        }
        if (toDeliver.signum() != 0) {
            throw new IllegalStateException("Not All Delivered - Remainder=" + toDeliver);
        }
    }

    private BigDecimal getInProcess(int Product_ID, int Locator_ID) {
        BigDecimal reValue;
        block7: {
            String sql = "select sum(l.movementqty) from m_inoutline l inner join m_inout i on (i.m_inout_id=l.m_inout_id)  where i.DocStatus='IP' and l.m_product_id= ?  and l.m_locator_id= ? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            reValue = new BigDecimal(0.0);
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, Product_ID);
                    pstmt.setInt(2, Locator_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        reValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (reValue == null) {
            reValue = new BigDecimal(0.0);
        }
        return reValue;
    }

    private BigDecimal getTotalLocator(int Locator_ID, int Product_ID, int ATTRIBUTESETINSTANCE_ID) {
        String sql = " Select Sum(QtyOnhand) from M_Storage where M_Locator_ID=? and M_Product_ID=? ";
        if (ATTRIBUTESETINSTANCE_ID > 0) {
            sql = String.valueOf(sql) + " and M_ATTRIBUTESETINSTANCE_ID=?";
        }
        BigDecimal rvalue = new BigDecimal(0);
        rvalue = ATTRIBUTESETINSTANCE_ID > 0 ? DB.getSQLValueBD((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{Locator_ID, Product_ID, ATTRIBUTESETINSTANCE_ID}) : DB.getSQLValueBD((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{Locator_ID, Product_ID});
        return rvalue;
    }

    class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int p_Warehouse_ID, int p_Product_ID, int p_AttributeSetInstance_ID, int p_AttributeSet_ID, boolean p_allAttributeInstances, Timestamp p_minGuaranteeDate, boolean p_FiFo) {
            this.M_Warehouse_ID = p_Warehouse_ID;
            this.M_Product_ID = p_Product_ID;
            this.M_AttributeSetInstance_ID = p_AttributeSetInstance_ID;
            this.M_AttributeSet_ID = p_AttributeSet_ID;
            this.allAttributeInstances = p_allAttributeInstances;
            this.minGuaranteeDate = p_minGuaranteeDate;
            this.FiFo = p_FiFo;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SParameter) {
                boolean eq;
                SParameter cmp = (SParameter)obj;
                boolean bl = eq = cmp.M_Warehouse_ID == this.M_Warehouse_ID && cmp.M_Product_ID == this.M_Product_ID && cmp.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && cmp.M_AttributeSet_ID == this.M_AttributeSet_ID && cmp.allAttributeInstances == this.allAttributeInstances && cmp.FiFo == this.FiFo;
                if (!(!eq || cmp.minGuaranteeDate == null && this.minGuaranteeDate == null || cmp.minGuaranteeDate != null && this.minGuaranteeDate != null && cmp.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    eq = false;
                }
                return eq;
            }
            return false;
        }

        public int hashCode() {
            long hash = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                hash *= -1L;
            }
            if (this.FiFo) {
                // empty if block
            }
            if ((hash *= -2L) < 0L) {
                hash = -hash + 7L;
            }
            while (hash > Integer.MAX_VALUE) {
                hash -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                hash += (long)this.minGuaranteeDate.hashCode();
                while (hash > Integer.MAX_VALUE) {
                    hash -= Integer.MAX_VALUE;
                }
            }
            return (int)hash;
        }
    }
}

