/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.X_M_Locator;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MLocator
extends X_M_Locator {
    private static final long serialVersionUID = 6019655556196171287L;
    private static CCache<Integer, MLocator> s_cache;
    private static CLogger s_log;

    static {
        s_log = CLogger.getCLogger(MLocator.class);
    }

    public static MLocator getDefault(Properties ctx, int M_Locator_ID) {
        MLocator retValue;
        block6: {
            String trxName = null;
            retValue = null;
            String sql = "SELECT * FROM M_Locator l WHERE IsActive = 'Y' AND  IsDefault='Y' AND EXISTS (SELECT * FROM M_Locator lx WHERE l.M_Warehouse_ID=lx.M_Warehouse_ID AND lx.M_Locator_ID=?) ORDER BY Created";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    pstmt.setInt(1, M_Locator_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        retValue = new MLocator(ctx, rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static MLocator getDefault(MWarehouse warehouse) {
        MLocator retValue;
        block6: {
            String trxName = null;
            retValue = null;
            String sql = "SELECT * FROM M_Locator l WHERE IsActive = 'Y' AND IsDefault='Y' AND l.M_Warehouse_ID=? ORDER BY PriorityNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    pstmt.setInt(1, warehouse.getM_Warehouse_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        retValue = new MLocator(warehouse.getCtx(), rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static MLocator get(Properties ctx, int M_Warehouse_ID, String Value, String X, String Y, String Z) {
        MLocator retValue;
        block7: {
            retValue = null;
            String sql = "SELECT * FROM M_Locator WHERE IsActive = 'Y' AND M_Warehouse_ID=? AND X=? AND Y=? AND Z=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setString(2, X);
                    pstmt.setString(3, Y);
                    pstmt.setString(4, Z);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MLocator(ctx, rs, null);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, "get", (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            MWarehouse wh = MWarehouse.get((Properties)ctx, (int)M_Warehouse_ID);
            retValue = new MLocator(wh, Value);
            retValue.setXYZ(X, Y, Z);
            retValue.saveEx();
        }
        return retValue;
    }

    public static MLocator get(Properties ctx, int M_Locator_ID) {
        Integer key;
        MLocator retValue;
        if (s_cache == null) {
            s_cache = new CCache("M_Locator", 20);
        }
        if ((retValue = (MLocator)((Object)s_cache.get((Object)(key = new Integer(M_Locator_ID))))) != null) {
            return retValue;
        }
        retValue = new MLocator(ctx, M_Locator_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MLocator(Properties ctx, int M_Locator_ID, String trxName) {
        super(ctx, M_Locator_ID, trxName);
        if (M_Locator_ID == 0) {
            this.setIsDefault(false);
            this.setPriorityNo(50);
        }
    }

    public MLocator(MWarehouse warehouse, String Value) {
        this(warehouse.getCtx(), 0, warehouse.get_TrxName());
        this.setClientOrg((PO)warehouse);
        this.setM_Warehouse_ID(warehouse.getM_Warehouse_ID());
        this.setValue(Value);
        this.setXYZ("0", "0", "0");
    }

    public MLocator(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        return this.getValue();
    }

    public void setXYZ(String X, String Y, String Z) {
        this.setX(X);
        this.setY(Y);
        this.setZ(Z);
    }

    public String getWarehouseName() {
        MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID());
        if (wh.get_ID() == 0) {
            return "<" + this.getM_Warehouse_ID() + ">";
        }
        return wh.getName();
    }

    public boolean isCanStoreProduct(int M_Product_ID) {
        return true;
    }

    public static int getPatio(int warehouse_ID) {
        return DB.getSQLValue(null, (String)("select M_Locator_ID from M_Locator where isPatio='Y' and M_WareHouse_ID=" + warehouse_ID));
    }
}

