/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.I_C_BPartner;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceBatch;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRefList;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.OFBProductCost;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.model.X_C_Invoice;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class MInvoice
extends X_C_Invoice
implements DocAction {
    private static final long serialVersionUID = 816227083897031327L;
    private static CCache<Integer, MInvoice> s_cache = new CCache("C_Invoice", 20, 2);
    private BigDecimal m_openAmt = null;
    private MInvoiceLine[] m_lines;
    private MInvoiceTax[] m_taxes;
    private static CLogger s_log = CLogger.getCLogger(MInvoice.class);
    private boolean m_reversal = false;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    ArrayList<PO> docsPostProcess = new ArrayList();

    public static MInvoice[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List list = new Query(ctx, "C_Invoice", "C_BPartner_ID=?", trxName).setParameters(new Object[]{C_BPartner_ID}).list();
        return list.toArray(new MInvoice[list.size()]);
    }

    public static MInvoice copyFrom(MInvoice from, Timestamp dateDoc, Timestamp dateAcct, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInvoice to = new MInvoice(from.getCtx(), 0, trxName);
        PO.copyValues((PO)((Object)from), (PO)((Object)to), from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Invoice_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setDateInvoiced(dateDoc);
        to.setDateAcct(dateAcct);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setIsPaid(false);
        to.setIsInDispute(false);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.setIsSelfService(false);
        if (!setOrder) {
            to.setC_Order_ID(0);
        }
        if (counter) {
            MOrder peer;
            to.setRef_Invoice_ID(from.getC_Invoice_ID());
            if (from.getC_Order_ID() != 0 && (peer = new MOrder(from.getCtx(), from.getC_Order_ID(), from.get_TrxName())).getRef_Order_ID() != 0) {
                to.setC_Order_ID(peer.getRef_Order_ID());
            }
            if (from.getM_RMA_ID() != 0 && (peer = new MRMA(from.getCtx(), from.getM_RMA_ID(), from.get_TrxName())).getRef_RMA_ID() > 0) {
                to.setM_RMA_ID(peer.getRef_RMA_ID());
            }
        } else {
            to.setRef_Invoice_ID(0);
        }
        to.saveEx(trxName);
        if (counter) {
            from.setRef_Invoice_ID(to.getC_Invoice_ID());
        }
        if (from.getLines(true).length > 0 && to.copyLinesFrom(from, counter, setOrder) == 0) {
            throw new IllegalStateException("Could not create Invoice Lines");
        }
        return to;
    }

    public static MInvoice copyFrom(MInvoice from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInvoice to = MInvoice.copyFrom(from, dateDoc, dateDoc, C_DocTypeTarget_ID, isSOTrx, counter, trxName, setOrder);
        return to;
    }

    public static String getPDFFileName(String documentDir, int C_Invoice_ID) {
        StringBuffer sb = new StringBuffer(documentDir);
        if (sb.length() == 0) {
            sb.append(".");
        }
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("C_Invoice_ID_").append(C_Invoice_ID).append(".pdf");
        return sb.toString();
    }

    public static MInvoice get(Properties ctx, int C_Invoice_ID) {
        Integer key = new Integer(C_Invoice_ID);
        MInvoice retValue = (MInvoice)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInvoice(ctx, C_Invoice_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        super(ctx, C_Invoice_ID, trxName);
        if (C_Invoice_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setPaymentRule("P");
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
            this.setIsSOTrx(true);
            this.setIsTaxIncluded(false);
            this.setIsApproved(false);
            this.setIsDiscountPrinted(false);
            this.setIsPaid(false);
            this.setSendEMail(false);
            this.setIsPrinted(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            this.setIsPayScheduleValid(false);
            this.setIsInDispute(false);
            this.setPosted(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MInvoice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoice(MOrder order, int C_DocTypeTarget_ID, Timestamp invoiceDate) {
        this(order.getCtx(), 0, order.get_TrxName());
        MDocType odt;
        this.setClientOrg((PO)((Object)order));
        this.setOrder(order);
        if (C_DocTypeTarget_ID <= 0 && (odt = MDocType.get((Properties)order.getCtx(), (int)order.getC_DocType_ID())) != null && (C_DocTypeTarget_ID = odt.getC_DocTypeInvoice_ID()) <= 0) {
            throw new AdempiereException("@NotFound@ @C_DocTypeInvoice_ID@ - @C_DocType_ID@:" + odt.get_Translation("Name"));
        }
        this.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_BPartner_ID(order.getBill_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getBill_Location_ID());
        this.setAD_User_ID(order.getBill_User_ID());
    }

    public MInvoice(MInOut ship, Timestamp invoiceDate) {
        this(ship.getCtx(), 0, ship.get_TrxName());
        this.setClientOrg((PO)((Object)ship));
        this.setShipment(ship);
        this.setC_DocTypeTarget_ID();
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(ship.getSalesRep_ID());
    }

    public MInvoice(MInvoiceBatch batch, MInvoiceBatchLine line) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg((PO)line);
        this.setDocumentNo(line.getDocumentNo());
        this.setIsSOTrx(batch.isSOTrx());
        MBPartner bp = new MBPartner(line.getCtx(), line.getC_BPartner_ID(), line.get_TrxName());
        this.setBPartner(bp);
        this.setIsTaxIncluded(line.isTaxIncluded());
        this.setC_Currency_ID(batch.getC_Currency_ID());
        this.setC_ConversionType_ID(batch.getC_ConversionType_ID());
        this.setDescription(batch.getDescription());
        this.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
        this.setC_Project_ID(line.getC_Project_ID());
        this.setC_Activity_ID(line.getC_Activity_ID());
        this.setUser1_ID(line.getUser1_ID());
        this.setUser2_ID(line.getUser2_ID());
        this.setC_DocTypeTarget_ID(line.getC_DocType_ID());
        this.setDateInvoiced(line.getDateInvoiced());
        this.setDateAcct(line.getDateAcct());
        this.setSalesRep_ID(batch.getSalesRep_ID());
        this.setC_BPartner_ID(line.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(line.getC_BPartner_Location_ID());
        this.setAD_User_ID(line.getAD_User_ID());
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((locs = bp.getLocations(false)) != null) {
            int i = 0;
            while (i < locs.length) {
                if (locs[i].isBillTo() && this.isSOTrx() || locs[i].isPayFrom() && !this.isSOTrx()) {
                    this.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                ++i;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, new BPartnerNoAddressException((I_C_BPartner)bp).getLocalizedMessage());
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void setOrder(MOrder order) {
        if (order == null) {
            return;
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setIsSOTrx(order.isSOTrx());
        this.setIsDiscountPrinted(order.isDiscountPrinted());
        this.setIsSelfService(order.isSelfService());
        this.setSendEMail(order.isSendEMail());
        this.setM_PriceList_ID(order.getM_PriceList_ID());
        this.setIsTaxIncluded(order.isTaxIncluded());
        this.setC_Currency_ID(order.getC_Currency_ID());
        this.setC_ConversionType_ID(order.getC_ConversionType_ID());
        this.setPaymentRule(order.getPaymentRule());
        this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
        this.setPOReference(order.getPOReference());
        this.setDescription(order.getDescription());
        this.setDateOrdered(order.getDateOrdered());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
    }

    public void setShipment(MInOut ship) {
        MDocType dt;
        if (ship == null) {
            return;
        }
        this.setIsSOTrx(ship.isSOTrx());
        MBPartner bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), null);
        this.setBPartner(bp);
        this.setAD_User_ID(ship.getAD_User_ID());
        this.setSendEMail(ship.isSendEMail());
        this.setPOReference(ship.getPOReference());
        this.setDescription(ship.getDescription());
        this.setDateOrdered(ship.getDateOrdered());
        this.setAD_OrgTrx_ID(ship.getAD_OrgTrx_ID());
        this.setC_Project_ID(ship.getC_Project_ID());
        this.setC_Campaign_ID(ship.getC_Campaign_ID());
        this.setC_Activity_ID(ship.getC_Activity_ID());
        this.setUser1_ID(ship.getUser1_ID());
        this.setUser2_ID(ship.getUser2_ID());
        if (ship.getC_Order_ID() != 0) {
            this.setC_Order_ID(ship.getC_Order_ID());
            MOrder order = new MOrder(this.getCtx(), ship.getC_Order_ID(), this.get_TrxName());
            this.setIsDiscountPrinted(order.isDiscountPrinted());
            this.setM_PriceList_ID(order.getM_PriceList_ID());
            this.setIsTaxIncluded(order.isTaxIncluded());
            this.setC_Currency_ID(order.getC_Currency_ID());
            this.setC_ConversionType_ID(order.getC_ConversionType_ID());
            this.setPaymentRule(order.getPaymentRule());
            this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            dt = MDocType.get((Properties)this.getCtx(), (int)order.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setC_BPartner_ID(order.getBill_BPartner_ID());
            this.setC_BPartner_Location_ID(order.getBill_Location_ID());
            this.setAD_User_ID(order.getBill_User_ID());
        }
        if (ship.getM_RMA_ID() != 0) {
            this.setM_RMA_ID(ship.getM_RMA_ID());
            MRMA rma = new MRMA(this.getCtx(), ship.getM_RMA_ID(), this.get_TrxName());
            dt = MDocType.get((Properties)this.getCtx(), (int)rma.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setIsSOTrx(rma.isSOTrx());
            MOrder rmaOrder = rma.getOriginalOrder();
            if (rmaOrder != null) {
                this.setM_PriceList_ID(rmaOrder.getM_PriceList_ID());
                this.setIsTaxIncluded(rmaOrder.isTaxIncluded());
                this.setC_Currency_ID(rmaOrder.getC_Currency_ID());
                this.setC_ConversionType_ID(rmaOrder.getC_ConversionType_ID());
                this.setPaymentRule(rmaOrder.getPaymentRule());
                this.setC_PaymentTerm_ID(rmaOrder.getC_PaymentTerm_ID());
                this.setC_BPartner_Location_ID(rmaOrder.getBill_Location_ID());
            }
        }
    }

    public void setC_DocTypeTarget_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID in (0,?) AND DocBaseType=? AND IsActive='Y' ORDER BY IsDefault DESC, AD_Org_ID DESC";
        int C_DocType_ID = DB.getSQLValueEx(null, (String)sql, (Object[])new Object[]{this.getAD_Client_ID(), this.getAD_Org_ID(), DocBaseType});
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AD_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            this.log.fine(DocBaseType);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            boolean isSOTrx = "ARI".equals(DocBaseType) || "ARC".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID("ARI");
        } else {
            this.setC_DocTypeTarget_ID("API");
        }
    }

    public BigDecimal getGrandTotal(boolean creditMemoAdjusted) {
        if (!creditMemoAdjusted) {
            return super.getGrandTotal();
        }
        BigDecimal amt = this.getGrandTotal();
        if (this.isCreditMemo()) {
            return amt.negate();
        }
        return amt;
    }

    private MInvoiceLine[] getLines(String whereClause) {
        String whereClauseFinal = "C_Invoice_ID=? ";
        if (whereClause != null) {
            whereClauseFinal = String.valueOf(whereClauseFinal) + whereClause;
        }
        List list = new Query(this.getCtx(), "C_InvoiceLine", whereClauseFinal, this.get_TrxName()).setParameters(new Object[]{this.getC_Invoice_ID()}).setOrderBy("Line").list();
        return list.toArray(new MInvoiceLine[list.size()]);
    }

    public MInvoiceLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines(null);
        }
        MInvoice.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
        return this.m_lines;
    }

    public MInvoiceLine[] getLines() {
        return this.getLines(false);
    }

    public void renumberLines(int step) {
        int number = step;
        MInvoiceLine[] lines = this.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceLine line = lines[i];
            line.setLine(number);
            line.saveEx();
            number += step;
            ++i;
        }
        this.m_lines = null;
    }

    public int copyLinesFrom(MInvoice otherInvoice, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || otherInvoice == null) {
            return 0;
        }
        MInvoiceLine[] fromLines = otherInvoice.getLines(false);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MInvoiceLine line = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
            MInvoiceLine fromLine = fromLines[i];
            if (counter) {
                PO.copyValues((PO)((Object)fromLine), (PO)((Object)line), this.getAD_Client_ID(), this.getAD_Org_ID());
            } else {
                PO.copyValues((PO)((Object)fromLine), (PO)((Object)line), fromLine.getAD_Client_ID(), fromLine.getAD_Org_ID());
            }
            line.setC_Invoice_ID(this.getC_Invoice_ID());
            line.setInvoice(this);
            line.set_ValueNoCheck("C_InvoiceLine_ID", I_ZERO);
            if (!setOrder) {
                line.setC_OrderLine_ID(0);
            }
            line.setRef_InvoiceLine_ID(0);
            line.setM_InOutLine_ID(0);
            line.setA_Asset_ID(0);
            line.setM_AttributeSetInstance_ID(0);
            line.setS_ResourceAssignment_ID(0);
            if (this.getC_BPartner_ID() != otherInvoice.getC_BPartner_ID()) {
                line.setTax();
            }
            if (counter) {
                Object peer;
                line.setRef_InvoiceLine_ID(fromLine.getC_InvoiceLine_ID());
                if (fromLine.getC_OrderLine_ID() != 0 && (peer = new MOrderLine(this.getCtx(), fromLine.getC_OrderLine_ID(), this.get_TrxName())).getRef_OrderLine_ID() != 0) {
                    line.setC_OrderLine_ID(peer.getRef_OrderLine_ID());
                }
                line.setM_InOutLine_ID(0);
                if (fromLine.getM_InOutLine_ID() != 0 && (peer = new MInOutLine(this.getCtx(), fromLine.getM_InOutLine_ID(), this.get_TrxName())).getRef_InOutLine_ID() != 0) {
                    line.setM_InOutLine_ID(peer.getRef_InOutLine_ID());
                }
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLine.setRef_InvoiceLine_ID(line.getC_InvoiceLine_ID());
                fromLine.save(this.get_TrxName());
            }
            line.copyLandedCostFrom(fromLine);
            line.allocateLandedCosts();
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    public boolean isReversal() {
        return this.m_reversal;
    }

    public MInvoiceTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        String whereClause = "C_Invoice_ID=?";
        List list = new Query(this.getCtx(), "C_InvoiceTax", "C_Invoice_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_taxes = list.toArray(new MInvoiceTax[list.size()]);
        return this.m_taxes;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public boolean isCreditMemo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)(this.getC_DocType_ID() == 0 ? this.getC_DocTypeTarget_ID() : this.getC_DocType_ID()));
        return "APC".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType());
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Invoice_ID=" + this.getC_Invoice_ID();
        int noLine = DB.executeUpdate((String)("UPDATE C_InvoiceLine " + set), (String)this.get_TrxName());
        int noTax = DB.executeUpdate((String)("UPDATE C_InvoiceTax " + set), (String)this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        this.log.fine(String.valueOf(processed) + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    public boolean validatePaySchedule() {
        MInvoicePaySchedule[] schedule = MInvoicePaySchedule.getInvoicePaySchedule((Properties)this.getCtx(), (int)this.getC_Invoice_ID(), (int)0, (String)this.get_TrxName());
        this.log.fine("#" + schedule.length);
        if (schedule.length == 0) {
            this.setIsPayScheduleValid(false);
            return false;
        }
        BigDecimal total = Env.ZERO;
        int i = 0;
        while (i < schedule.length) {
            schedule[i].setParent(this);
            BigDecimal due = schedule[i].getDueAmt();
            if (due != null) {
                total = total.add(due);
            }
            ++i;
        }
        boolean valid = this.getGrandTotal().compareTo(total) == 0;
        this.setIsPayScheduleValid(valid);
        int i2 = 0;
        while (i2 < schedule.length) {
            if (schedule[i2].isValid() != valid) {
                schedule[i2].setIsValid(valid);
                schedule[i2].saveEx(this.get_TrxName());
            }
            ++i2;
        }
        return valid;
    }

    protected boolean beforeSave(boolean newRecord) {
        int ii;
        String sql;
        this.log.fine("");
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getM_PriceList_ID() == 0) {
            int ii2 = Env.getContextAsInt((Properties)this.getCtx(), (String)"#M_PriceList_ID");
            if (ii2 != 0) {
                this.setM_PriceList_ID(ii2);
            } else {
                sql = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii2 = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
                if (ii2 != 0) {
                    this.setM_PriceList_ID(ii2);
                }
            }
        }
        if (this.getC_Currency_ID() == 0) {
            String sql2 = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, (String)sql2, (int)this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt((Properties)this.getCtx(), (String)"#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(this.isSOTrx() ? "ARI" : "API");
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.getC_Order_ID() != 0) {
            this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"CannotDelete"));
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoice[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",GrandTotal=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            String sql = "UPDATE C_InvoiceLine ol SET AD_Org_ID =(SELECT AD_Org_ID FROM C_Invoice o WHERE ol.C_Invoice_ID=o.C_Invoice_ID) WHERE C_Invoice_ID=" + this.getC_Invoice_ID();
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Lines -> #" + no);
        }
        return true;
    }

    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)M_PriceList_ID, null);
        if (pl != null) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
            super.setM_PriceList_ID(M_PriceList_ID);
        }
    }

    public BigDecimal getAllocatedAmt() {
        BigDecimal retValue = null;
        String sql = "SELECT SUM(currencyConvert(al.Amount+al.DiscountAmt+al.WriteOffAmt,ah.C_Currency_ID, i.C_Currency_ID,ah.DateTrx,COALESCE(i.C_ConversionType_ID,0), al.AD_Client_ID,al.AD_Org_ID)) FROM C_AllocationLine al INNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID) INNER JOIN C_Invoice i ON (al.C_Invoice_ID=i.C_Invoice_ID) WHERE al.C_Invoice_ID=? AND ah.IsActive='Y' AND al.IsActive='Y'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getC_Invoice_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                throw new DBException((Exception)e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public boolean testAllocation() {
        boolean change = false;
        if (this.isProcessed()) {
            boolean test;
            BigDecimal alloc = this.getAllocatedAmt();
            if (alloc == null) {
                alloc = Env.ZERO;
            }
            BigDecimal total = this.getGrandTotal();
            if (!this.isSOTrx()) {
                total = total.negate();
            }
            if (this.isCreditMemo()) {
                total = total.negate();
            }
            if (change = (test = total.compareTo(alloc) == 0) ^ this.isPaid()) {
                this.setIsPaid(test);
            }
            this.log.fine("Paid=" + test + " (" + alloc + "=" + total + ")");
        }
        return change;
    }

    public static void setIsPaid(Properties ctx, int C_BPartner_ID, String trxName) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer("IsPaid='N' AND DocStatus IN ('CO','CL')");
        if (C_BPartner_ID > 1) {
            whereClause.append(" AND C_BPartner_ID=?");
            params.add(C_BPartner_ID);
        } else {
            whereClause.append(" AND AD_Client_ID=?");
            params.add(Env.getAD_Client_ID((Properties)ctx));
        }
        POResultSet rs = new Query(ctx, "C_Invoice", whereClause.toString(), trxName).setParameters(params).scroll();
        int counter = 0;
        try {
            while (rs.hasNext()) {
                MInvoice invoice = (MInvoice)((Object)rs.next());
                if (!invoice.testAllocation() || !invoice.save()) continue;
                ++counter;
            }
        }
        finally {
            DB.close((POResultSet)rs);
        }
        s_log.config("#" + counter);
    }

    public BigDecimal getOpenAmt() {
        return this.getOpenAmt(true, null);
    }

    public BigDecimal getOpenAmt(boolean creditMemoAdjusted, Timestamp paymentDate) {
        if (this.isPaid()) {
            return Env.ZERO;
        }
        if (this.m_openAmt == null) {
            this.m_openAmt = this.getGrandTotal();
            BigDecimal allocated = this.getAllocatedAmt();
            if (allocated != null) {
                allocated = allocated.abs();
                this.m_openAmt = this.m_openAmt.subtract(allocated);
            }
        }
        if (!creditMemoAdjusted) {
            return this.m_openAmt;
        }
        if (this.isCreditMemo()) {
            return this.m_openAmt.negate();
        }
        return this.m_openAmt;
    }

    public String getDocStatusName() {
        return MRefList.getListName((Properties)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 2, this.getC_Invoice_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getPDFFileName(String documentDir) {
        return MInvoice.getPDFFileName(documentDir, this.getC_Invoice_ID());
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        MBPartner bp;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocTypeTarget_ID(), (int)this.getAD_Org_ID());
        MInvoiceLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if ("B".equals(this.getPaymentRule()) && MCashBook.get((Properties)this.getCtx(), (int)this.getAD_Org_ID(), (int)this.getC_Currency_ID()) == null) {
            this.m_processMsg = "@NoCashBook@";
            return "IN";
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (this.getC_DocType_ID() == 0) {
            this.m_processMsg = "No Document Type";
            return "IN";
        }
        this.explodeBOM();
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating Tax";
            return "IN";
        }
        this.createPaySchedule();
        if (this.isSOTrx() && !this.isReversal() && "S".equals((bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null)).getSOCreditStatus())) {
            this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
            return "IN";
        }
        if (!this.isSOTrx()) {
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                String error = line.allocateLandedCosts();
                if (error != null && error.length() > 0) {
                    this.m_processMsg = error;
                    return "IN";
                }
                ++i;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void explodeBOM() {
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_InvoiceLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_InvoiceLine WHERE C_Invoice_ID=? " + where;
        int count = DB.getSQLValueEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{this.getC_Invoice_ID()});
        while (count != 0) {
            this.renumberLines(100);
            MInvoiceLine[] lines = this.getLines(where);
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                int lineNo = line.getLine();
                MPPProductBOM bom = MPPProductBOM.get((MProduct)product, (int)this.getAD_Org_ID(), (Timestamp)this.getDateInvoiced(), (String)this.get_TrxName());
                if (bom != null) {
                    MPPProductBOMLine[] bomlines = bom.getLines(this.getDateInvoiced());
                    int j = 0;
                    while (j < bomlines.length) {
                        MPPProductBOMLine bomline = bomlines[j];
                        MInvoiceLine newLine = new MInvoiceLine(this);
                        newLine.setLine(++lineNo);
                        newLine.setM_Product_ID(bomline.getM_Product_ID());
                        newLine.setC_UOM_ID(bomline.getC_UOM_ID());
                        newLine.setQty(line.getQtyInvoiced().multiply(bomline.getQtyBOM()));
                        if (bomline.getDescription() != null) {
                            newLine.setDescription(bomline.getDescription());
                        }
                        newLine.setPrice();
                        newLine.saveEx(this.get_TrxName());
                        ++j;
                    }
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPriceEntered(Env.ZERO);
                line.setPriceActual(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                String description = product.getName();
                if (product.getDescription() != null) {
                    description = String.valueOf(description) + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = String.valueOf(description) + " " + line.getDescription();
                }
                line.setDescription(description);
                line.saveEx(this.get_TrxName());
                ++i;
            }
            this.m_lines = null;
            count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
            this.renumberLines(10);
        }
    }

    public boolean calculateTaxTotal() {
        this.log.fine("");
        DB.executeUpdateEx((String)("DELETE C_InvoiceTax WHERE C_Invoice_ID=" + this.getC_Invoice_ID()), (String)this.get_TrxName());
        this.m_taxes = null;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MInvoiceLine[] lines = this.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceTax iTax;
            MInvoiceLine line = lines[i];
            if (!taxList.contains(line.getC_Tax_ID()) && (iTax = MInvoiceTax.get((MInvoiceLine)line, (int)this.getPrecision(), (boolean)false, (String)this.get_TrxName())) != null) {
                iTax.setIsTaxIncluded(this.isTaxIncluded());
                if (!iTax.calculateTaxFromLines()) {
                    return false;
                }
                iTax.saveEx();
                taxList.add(line.getC_Tax_ID());
            }
            totalLines = totalLines.add(line.getLineNetAmt());
            ++i;
        }
        BigDecimal grandTotal = totalLines;
        MInvoiceTax[] taxes = this.getTaxes(true);
        int i2 = 0;
        while (i2 < taxes.length) {
            MInvoiceTax iTax = taxes[i2];
            MTax tax = iTax.getTax();
            if (tax.isSummary()) {
                MTax[] cTaxes = tax.getChildTaxes(false);
                int j = 0;
                while (j < cTaxes.length) {
                    MTax cTax = cTaxes[j];
                    BigDecimal taxAmt = cTax.calculateTax(iTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision());
                    MInvoiceTax newITax = new MInvoiceTax(this.getCtx(), 0, this.get_TrxName());
                    newITax.setClientOrg((PO)((Object)this));
                    newITax.setC_Invoice_ID(this.getC_Invoice_ID());
                    newITax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newITax.setPrecision(this.getPrecision());
                    newITax.setIsTaxIncluded(this.isTaxIncluded());
                    newITax.setTaxBaseAmt(iTax.getTaxBaseAmt());
                    newITax.setTaxAmt(taxAmt);
                    newITax.saveEx(this.get_TrxName());
                    if (!this.isTaxIncluded()) {
                        grandTotal = grandTotal.add(taxAmt);
                    }
                    ++j;
                }
                iTax.deleteEx(true, this.get_TrxName());
            } else if (!this.isTaxIncluded()) {
                grandTotal = grandTotal.add(iTax.getTaxAmt());
            }
            ++i2;
        }
        this.setTotalLines(totalLines);
        this.setGrandTotal(grandTotal);
        return true;
    }

    private boolean createPaySchedule() {
        if (this.getC_PaymentTerm_ID() == 0) {
            return false;
        }
        MPaymentTerm pt = new MPaymentTerm(this.getCtx(), this.getC_PaymentTerm_ID(), null);
        this.log.fine(pt.toString());
        return pt.apply(this);
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        boolean fromPOS = false;
        if (this.getC_Order_ID() > 0) {
            boolean bl = fromPOS = this.getC_Order().getC_POS_ID() > 0;
        }
        if ("B".equals(this.getPaymentRule()) && !fromPOS) {
            MCash cash;
            int posId = Env.getContextAsInt((Properties)this.getCtx(), (String)"#POS_ID");
            if (posId != 0) {
                MPOS pos = new MPOS(this.getCtx(), posId, this.get_TrxName());
                int cashBookId = pos.getC_CashBook_ID();
                cash = MCash.get(this.getCtx(), cashBookId, this.getDateInvoiced(), this.get_TrxName());
            } else {
                cash = MCash.get(this.getCtx(), this.getAD_Org_ID(), this.getDateInvoiced(), this.getC_Currency_ID(), this.get_TrxName());
            }
            if (cash == null || cash.get_ID() == 0) {
                this.m_processMsg = "@NoCashBook@";
                return "IN";
            }
            MCashLine cl = new MCashLine(cash);
            cl.setInvoice(this);
            if (!cl.save(this.get_TrxName())) {
                this.m_processMsg = "Could not save Cash Journal Line";
                return "IN";
            }
            info.append("@C_Cash_ID@: " + cash.getName() + " #" + cl.getLine());
            this.setC_CashLine_ID(cl.getC_CashLine_ID());
        }
        int matchInv = 0;
        int matchPO = 0;
        MInvoiceLine[] lines = this.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceLine line = lines[i];
            MOrderLine ol = null;
            if (line.getC_OrderLine_ID() != 0) {
                if (this.isSOTrx() || line.getM_Product_ID() == 0) {
                    if (this.getC_DocType().getDocBaseType().compareTo("ARC") != 0) {
                        ol = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName());
                        if (line.getQtyInvoiced() != null) {
                            ol.setQtyInvoiced(ol.getQtyInvoiced().add(line.getQtyInvoiced()));
                        }
                        if (!ol.save(this.get_TrxName())) {
                            this.m_processMsg = "Could not update Order Line";
                            return "IN";
                        }
                    }
                } else if (!this.isSOTrx() && line.getM_Product_ID() != 0 && !this.isReversal()) {
                    BigDecimal matchQty = line.getQtyInvoiced();
                    MMatchPO po = MMatchPO.create(line, null, this.getDateInvoiced(), matchQty);
                    boolean isNewMatchPO = false;
                    if (po.get_ID() == 0) {
                        isNewMatchPO = true;
                    }
                    if (!po.save(this.get_TrxName())) {
                        this.m_processMsg = "Could not create PO Matching";
                        return "IN";
                    }
                    ++matchPO;
                    if (isNewMatchPO) {
                        this.addDocsPostProcess((PO)((Object)po));
                    }
                }
            }
            if (line.getM_RMALine_ID() != 0) {
                MRMALine rmaLine = new MRMALine(this.getCtx(), line.getM_RMALine_ID(), this.get_TrxName());
                if (rmaLine.getQtyInvoiced() != null) {
                    rmaLine.setQtyInvoiced(rmaLine.getQtyInvoiced().add(line.getQtyInvoiced()));
                } else {
                    rmaLine.setQtyInvoiced(line.getQtyInvoiced());
                }
                if (!rmaLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not update RMA Line";
                    return "IN";
                }
            }
            if (!this.isSOTrx() && line.getM_InOutLine_ID() != 0 && line.getM_Product_ID() != 0 && !this.isReversal()) {
                MInOutLine receiptLine = new MInOutLine(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                BigDecimal matchQty = line.getQtyInvoiced();
                if (receiptLine.getMovementQty().compareTo(matchQty) < 0) {
                    matchQty = receiptLine.getMovementQty();
                }
                MMatchInv inv = new MMatchInv(line, this.getDateInvoiced(), matchQty);
                boolean isNewMatchInv = false;
                if (inv.get_ID() == 0) {
                    isNewMatchInv = true;
                }
                if (!inv.save(this.get_TrxName())) {
                    this.m_processMsg = CLogger.retrieveErrorString((String)"Could not create Invoice Matching");
                    return "IN";
                }
                ++matchInv;
                if (isNewMatchInv) {
                    this.addDocsPostProcess((PO)((Object)inv));
                }
            }
            ++i;
        }
        if (matchInv > 0) {
            info.append(" @M_MatchInv_ID@#").append(matchInv).append(" ");
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        BigDecimal invAmt = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(true), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        if (invAmt == null) {
            this.m_processMsg = "Could not convert C_Currency_ID=" + this.getC_Currency_ID() + " to base C_Currency_ID=" + MClient.get((Properties)Env.getCtx()).getC_Currency_ID();
            return "IN";
        }
        BigDecimal newBalance = bp.getTotalOpenBalance(false);
        if (newBalance == null) {
            newBalance = Env.ZERO;
        }
        if (this.isSOTrx()) {
            BigDecimal newLifeAmt;
            newBalance = newBalance.add(invAmt);
            if (bp.getFirstSale() == null) {
                bp.setFirstSale(this.getDateInvoiced());
            }
            newLifeAmt = (newLifeAmt = bp.getActualLifeTimeValue()) == null ? invAmt : newLifeAmt.add(invAmt);
            BigDecimal newCreditAmt = bp.getSO_CreditUsed();
            newCreditAmt = newCreditAmt == null ? invAmt : newCreditAmt.add(invAmt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") BP Life=" + bp.getActualLifeTimeValue() + "->" + newLifeAmt + ", Credit=" + bp.getSO_CreditUsed() + "->" + newCreditAmt + ", Balance=" + bp.getTotalOpenBalance(false) + " -> " + newBalance);
            bp.setActualLifeTimeValue(newLifeAmt);
            bp.setSO_CreditUsed(newCreditAmt);
        } else {
            newBalance = newBalance.subtract(invAmt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") Balance=" + bp.getTotalOpenBalance(false) + " -> " + newBalance);
        }
        bp.setTotalOpenBalance(newBalance);
        bp.setSOCreditStatus();
        if (!bp.save(this.get_TrxName())) {
            this.m_processMsg = "Could not update Business Partner";
            return "IN";
        }
        if (this.getAD_User_ID() != 0) {
            MUser user = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
            user.setLastContact(new Timestamp(System.currentTimeMillis()));
            user.setLastResult(String.valueOf(Msg.translate((Properties)this.getCtx(), (String)"C_Invoice_ID")) + ": " + this.getDocumentNo());
            if (!user.save(this.get_TrxName())) {
                this.m_processMsg = "Could not update Business Partner User";
                return "IN";
            }
        }
        if (this.isSOTrx() && this.getC_Project_ID() != 0) {
            MProject project = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
            BigDecimal amt = this.getGrandTotal(true);
            int C_CurrencyTo_ID = project.getC_Currency_ID();
            if (C_CurrencyTo_ID != this.getC_Currency_ID()) {
                amt = MConversionRate.convert(this.getCtx(), amt, this.getC_Currency_ID(), C_CurrencyTo_ID, this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID());
            }
            if (amt == null) {
                this.m_processMsg = "Could not convert C_Currency_ID=" + this.getC_Currency_ID() + " to Project C_Currency_ID=" + C_CurrencyTo_ID;
                return "IN";
            }
            BigDecimal newAmt = project.getInvoicedAmt();
            newAmt = newAmt == null ? amt : newAmt.add(amt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + amt + ") Project " + project.getName() + " - Invoiced=" + project.getInvoicedAmt() + "->" + newAmt);
            project.setInvoicedAmt(newAmt);
            if (!project.save(this.get_TrxName())) {
                this.m_processMsg = "Could not update Project";
                return "IN";
            }
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        MInvoice counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @C_Invoice_ID@=").append(counter.getDocumentNo());
        }
        this.m_processMsg = info.toString().trim();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void addDocsPostProcess(PO doc) {
        this.docsPostProcess.add(doc);
    }

    public ArrayList<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)((Object)this))) != null) {
            this.setDocumentNo(value);
        }
    }

    private MInvoice createCounterDoc() {
        if (this.getRef_Invoice_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MInvoice counter = MInvoice.copyFrom(this, this.getDateInvoiced(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), true, this.get_TrxName(), true);
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setBPartner(counterBP);
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        MInvoiceLine[] counterLines = counter.getLines(true);
        int i = 0;
        while (i < counterLines.length) {
            MInvoiceLine counterLine = counterLines[i];
            counterLine.setClientOrg((PO)((Object)counter));
            counterLine.setInvoice(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.save(this.get_TrxName());
            ++i;
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInvoiceLine[] lines = this.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                BigDecimal old = line.getQtyInvoiced();
                if (old.compareTo(Env.ZERO) != 0) {
                    line.setQty(Env.ZERO);
                    line.setTaxAmt(Env.ZERO);
                    line.setLineNetAmt(Env.ZERO);
                    line.setLineTotalAmt(Env.ZERO);
                    line.addDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Voided")) + " (" + old + ")");
                    if (line.getM_InOutLine_ID() != 0) {
                        MInOutLine ioLine = new MInOutLine(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                        ioLine.setIsInvoiced(false);
                        ioLine.save(this.get_TrxName());
                        line.setM_InOutLine_ID(0);
                    }
                    line.save(this.get_TrxName());
                }
                ++i;
            }
        } else {
            if (this.getPayments() > 0) {
                this.m_processMsg = "Este Documento tiene pagos asociados no puede ser ANULADO";
                return false;
            }
            this.setC_CashLine_ID(0);
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.setIsPaid(true);
        this.setC_Payment_ID(0);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
        MAllocationHdr[] allocations = MAllocationHdr.getOfInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        int i = 0;
        while (i < allocations.length) {
            allocations[i].setDocAction("RC");
            allocations[i].reverseCorrectIt();
            allocations[i].save(this.get_TrxName());
            ++i;
        }
        if (!this.isSOTrx()) {
            MMatchInv[] mInv = MMatchInv.getInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            int i2 = 0;
            while (i2 < mInv.length) {
                mInv[i2].delete(true);
                ++i2;
            }
            MMatchPO[] mPO = MMatchPO.getInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            int i3 = 0;
            while (i3 < mPO.length) {
                if (mPO[i3].getM_InOutLine_ID() == 0) {
                    mPO[i3].delete(true);
                } else {
                    mPO[i3].setC_InvoiceLine_ID(null);
                    mPO[i3].save(this.get_TrxName());
                }
                ++i3;
            }
        }
        this.load(this.get_TrxName());
        MInvoiceLine[] iLines = this.getLines(false);
        int i4 = 0;
        while (i4 < iLines.length) {
            MInvoiceLine iLine = iLines[i4];
            if (iLine.getM_InOutLine_ID() != 0) {
                MInOutLine ioLine = new MInOutLine(this.getCtx(), iLine.getM_InOutLine_ID(), this.get_TrxName());
                ioLine.setIsInvoiced(false);
                ioLine.save(this.get_TrxName());
                iLine.setM_InOutLine_ID(0);
                iLine.save(this.get_TrxName());
            }
            if (iLine.getC_OrderLine_ID() != 0) {
                MOrderLine oline = new MOrderLine(this.getCtx(), iLine.getC_OrderLine_ID(), this.get_TrxName());
                oline.setQtyInvoiced(Env.ZERO);
                oline.save();
            }
            this.resetCost();
            iLine.addDescription(":" + iLine.get_ValueAsInt("C_Payment_ID"));
            iLine.setQty(Env.ZERO);
            iLine.setTaxAmt(Env.ZERO);
            iLine.setLineNetAmt(Env.ZERO);
            iLine.setLineTotalAmt(Env.ZERO);
            iLine.set_ValueOfColumn("C_Payment_ID", 0);
            iLine.setQtyInvoiced(Env.ZERO);
            iLine.save();
            ++i4;
        }
        this.setProcessed(true);
        this.setDocStatus("VO");
        this.setDocAction("--");
        this.setC_Payment_ID(0);
        this.setIsPaid(true);
        this.setTotalLines(Env.ZERO);
        this.setGrandTotal(Env.ZERO);
        i4 = this.resetPost(this.getC_Invoice_ID(), X_C_Invoice.Table_ID);
        this.log.config("reset post:" + i4);
        i4 = DB.executeUpdate((String)("update C_INVOICETAX set TAXAMT=0 where C_Invoice_ID=" + this.getC_Invoice_ID()), (String)this.get_TrxName());
        MFactAcct.deleteEx((int)Table_ID, (int)this.getC_Invoice_ID(), (String)this.get_TrxName());
        if (!this.isSOTrx()) {
            int count = DB.getSQLValue((String)this.get_TrxName(), (String)("select count(1) from C_Invoice where DocStatus='VO' and  AD_Org_ID=" + this.getAD_Org_ID() + " and C_DocType_ID=" + this.getC_DocType_ID() + " and documentno='" + this.getDocumentNo() + "' and C_Invoice_ID<>" + this.getC_Invoice_ID()));
            if (count < 0) {
                count = 0;
            }
            this.setDocumentNo(String.valueOf(this.getDocumentNo()) + "_Anulada_" + ++count);
        }
        return true;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"GrandTotal")).append("=").append(this.getGrandTotal()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    public void setRMA(MRMA rma) {
        this.setM_RMA_ID(rma.getM_RMA_ID());
        this.setAD_Org_ID(rma.getAD_Org_ID());
        this.setDescription(rma.getDescription());
        this.setC_BPartner_ID(rma.getC_BPartner_ID());
        this.setSalesRep_ID(rma.getSalesRep_ID());
        this.setGrandTotal(rma.getAmt());
        this.setIsSOTrx(rma.isSOTrx());
        this.setTotalLines(rma.getAmt());
        MInvoice originalInvoice = rma.getOriginalInvoice();
        if (originalInvoice == null) {
            throw new IllegalStateException("Not invoiced - RMA: " + rma.getDocumentNo());
        }
        this.setC_BPartner_Location_ID(originalInvoice.getC_BPartner_Location_ID());
        this.setAD_User_ID(originalInvoice.getAD_User_ID());
        this.setC_Currency_ID(originalInvoice.getC_Currency_ID());
        this.setIsTaxIncluded(originalInvoice.isTaxIncluded());
        this.setM_PriceList_ID(originalInvoice.getM_PriceList_ID());
        this.setC_Project_ID(originalInvoice.getC_Project_ID());
        this.setC_Activity_ID(originalInvoice.getC_Activity_ID());
        this.setC_Campaign_ID(originalInvoice.getC_Campaign_ID());
        this.setUser1_ID(originalInvoice.getUser1_ID());
        this.setUser2_ID(originalInvoice.getUser2_ID());
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public void resetCost() {
        if (this.isSOTrx()) {
            return;
        }
        MAcctSchema as = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID())[0];
        MInvoiceLine[] iLines = this.getLines(false);
        int i = 0;
        while (i < iLines.length) {
            MInvoiceLine iLine = iLines[i];
            MCostDetail cd = OFBProductCost.get(as.getCtx(), "C_InvoiceLine_ID=?", iLine.getC_InvoiceLine_ID(), iLine.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.get_TrxName());
            if (cd != null) {
                if (cd.isProcessed()) {
                    OFBProductCost.createInvoice(as, cd.getAD_Org_ID(), cd.getM_Product_ID(), cd.getM_AttributeSetInstance_ID(), cd.getC_InvoiceLine_ID(), cd.getM_CostElement_ID(), cd.getAmt().negate(), Env.ZERO, "Anulacion Factura", this.get_TrxName());
                } else {
                    String sql = "DELETE From M_CostDetail WHERE Processed='N'  AND C_InvoiceLine_ID=" + iLine.getC_InvoiceLine_ID() + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID();
                    int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
                    if (no != 0) {
                        this.log.config("Deleted #" + no);
                    }
                }
            }
            ++i;
        }
    }

    public String getTenderType() {
        MInvoiceLine[] lines = this.getLines(false);
        String tendertype = "K";
        int i = 0;
        while (i < lines.length) {
            MInvoiceLine line = lines[i];
            if (line.get_ValueAsInt("C_Payment_ID") > 0) {
                MPayment pay = new MPayment(this.getCtx(), line.get_ValueAsInt("C_Payment_ID"), this.get_TrxName());
                tendertype = pay.getTenderType();
            }
            ++i;
        }
        return tendertype;
    }

    public String getDocBase() {
        String base = DB.getSQLValueString((String)this.get_TrxName(), (String)"select docbasetype from c_doctype where c_doctype_id=?", (int)this.getC_DocTypeTarget_ID());
        return base;
    }

    public int getPayments() {
        int payments = DB.getSQLValue((String)"C_Payment", (String)("select count(1) from C_payment where docstatus<>'VO' and c_invoice_id=" + this.getC_Invoice_ID()));
        if (payments <= 0) {
            payments = DB.getSQLValue((String)"C_Payment", (String)("select count(1) from C_allocationLine A where A.C_Payment_ID is not null AND A.c_invoice_id=" + this.getC_Invoice_ID() + " and 'CO' = (select B.docstatus from C_allocationhdr B where B.c_allocationhdr_ID=A.c_allocationhdr_ID)"));
        }
        int cashs = 0;
        cashs = DB.getSQLValue((String)"C_CashLine", (String)("select count(1) from C_CashLine A where  A.c_invoice_id=" + this.getC_Invoice_ID() + " and processed='Y' And Not exists (select * from C_Cash b where a.C_Cash_id=b.C_Cash_ID and b.docstatus='VO')"));
        if (cashs > 0) {
            return 0;
        }
        return payments;
    }
}

