/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.exceptions.WarehouseLocatorConflictException;
import org.compiere.model.I_M_Locator;
import org.compiere.model.I_M_Warehouse;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOutLine;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.ofb.model.OFBForward;

public class MInOutLine
extends X_M_InOutLine
implements IDocumentLine {
    private static final long serialVersionUID = 8630611882798722864L;
    private static CCache<Integer, MInOutLine> s_cache = new CCache("M_InOutLine", 40, 5);
    private MProduct m_product = null;
    private int m_M_Warehouse_ID = 0;
    private MInOut m_parent = null;

    public static MInOutLine[] getOfOrderLine(Properties ctx, int C_OrderLine_ID, String where, String trxName) {
        String whereClause = "C_OrderLine_ID=?" + (!Util.isEmpty((String)where, (boolean)true) ? " AND " + where : "");
        List list = new Query(ctx, "M_InOutLine", whereClause, trxName).setParameters(new Object[]{C_OrderLine_ID}).list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public static MInOutLine[] getOfRMALine(Properties ctx, int M_RMALine_ID, String where, String trxName) {
        String whereClause = "M_RMALine_ID=? " + (!Util.isEmpty((String)where, (boolean)true) ? " AND " + where : "");
        List list = new Query(ctx, "M_InOutLine", whereClause, trxName).setParameters(new Object[]{M_RMALine_ID}).list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public static MInOutLine[] get(Properties ctx, int C_OrderLine_ID, String trxName) {
        return MInOutLine.getOfOrderLine(ctx, C_OrderLine_ID, null, trxName);
    }

    public static MInOutLine get(Properties ctx, int M_InOutLine_ID) {
        if (M_InOutLine_ID <= 0) {
            return null;
        }
        Integer key = new Integer(M_InOutLine_ID);
        MInOutLine retValue = (MInOutLine)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInOutLine(ctx, M_InOutLine_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MInOutLine(Properties ctx, int M_InOutLine_ID, String trxName) {
        super(ctx, M_InOutLine_ID, trxName);
        if (M_InOutLine_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setConfirmedQty(Env.ZERO);
            this.setPickedQty(Env.ZERO);
            this.setScrappedQty(Env.ZERO);
            this.setTargetQty(Env.ZERO);
            this.setIsInvoiced(false);
            this.setIsDescription(false);
        }
    }

    public MInOutLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutLine(MInOut inout) {
        this(inout.getCtx(), 0, inout.get_TrxName());
        this.setClientOrg((PO)((Object)inout));
        this.setM_InOut_ID(inout.getM_InOut_ID());
        this.setM_Warehouse_ID(inout.getM_Warehouse_ID());
        this.setC_Project_ID(inout.getC_Project_ID());
        this.m_parent = inout;
    }

    public MInOut getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        MProduct product = oLine.getProduct();
        if (product == null) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
        } else {
            this.setM_Product_ID(oLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
            if (product.isItem()) {
                if (M_Locator_ID == 0) {
                    this.setM_Locator_ID(Qty);
                } else {
                    this.setM_Locator_ID(M_Locator_ID);
                }
            } else {
                this.set_ValueNoCheck("M_Locator_ID", null);
            }
        }
        this.setC_Charge_ID(oLine.getC_Charge_ID());
        this.setDescription(oLine.getDescription());
        this.setIsDescription(oLine.isDescription());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
    }

    public void setInvoiceLine(MInvoiceLine iLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        this.setLine(iLine.getLine());
        this.setC_UOM_ID(iLine.getC_UOM_ID());
        int M_Product_ID = iLine.getM_Product_ID();
        if (M_Product_ID == 0) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
        } else {
            this.setM_Product_ID(M_Product_ID);
            this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
            if (M_Locator_ID == 0) {
                this.setM_Locator_ID(Qty);
            } else {
                this.setM_Locator_ID(M_Locator_ID);
            }
        }
        this.setC_Charge_ID(iLine.getC_Charge_ID());
        this.setDescription(iLine.getDescription());
        this.setIsDescription(iLine.isDescription());
        this.setC_Project_ID(iLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(iLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(iLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(iLine.getC_Activity_ID());
        this.setC_Campaign_ID(iLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(iLine.getAD_OrgTrx_ID());
        this.setUser1_ID(iLine.getUser1_ID());
        this.setUser2_ID(iLine.getUser2_ID());
    }

    public int getM_Warehouse_ID() {
        if (this.m_M_Warehouse_ID == 0) {
            this.m_M_Warehouse_ID = this.getParent().getM_Warehouse_ID();
        }
        return this.m_M_Warehouse_ID;
    }

    public void setM_Warehouse_ID(int warehouse_ID) {
        this.m_M_Warehouse_ID = warehouse_ID;
    }

    public void setM_Locator_ID(int M_Locator_ID) {
        if (M_Locator_ID < 0) {
            throw new IllegalArgumentException("M_Locator_ID is mandatory.");
        }
        this.set_Value("M_Locator_ID", new Integer(M_Locator_ID));
    }

    public void setM_Locator_ID(BigDecimal Qty) {
        if (this.getM_Locator_ID() != 0) {
            return;
        }
        if (this.getM_Product_ID() == 0) {
            this.set_ValueNoCheck("M_Locator_ID", null);
            return;
        }
        int M_Locator_ID = MStorage.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), Qty, this.get_TrxName());
        if (M_Locator_ID == 0) {
            MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID());
            M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        }
        this.setM_Locator_ID(M_Locator_ID);
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setMovementQty(this.getQtyEntered());
    }

    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    public void setMovementQty(BigDecimal MovementQty) {
        MProduct product = this.getProduct();
        if (MovementQty != null && product != null) {
            int precision = product.getUOMPrecision();
            MovementQty = MovementQty.setScale(precision, 4);
        }
        super.setMovementQty(MovementQty);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        if (M_Product_ID != 0) {
            super.setM_Product_ID(M_Product_ID);
        }
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
        this.m_product = null;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    protected boolean beforeSave(boolean newRecord) {
        int C_UOM_ID;
        this.log.fine("");
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate((Properties)this.getCtx(), (String)"M_InOutLine"));
            return false;
        }
        if (this.getProduct() != null && "I".equals(this.getProduct().getProductType()) && this.getM_Locator_ID() <= 0 && this.getC_Charge_ID() <= 0) {
            throw new FillMandatoryException(new String[]{"M_Locator_ID"});
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM M_InOutLine WHERE M_InOut_ID=?";
            int ii = DB.getSQLValueEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{this.getM_InOut_ID()});
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_UOM_ID"));
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID((Properties)this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("MovementQty")) {
            this.setMovementQty(this.getMovementQty());
        }
        if (this.getC_OrderLine_ID() == 0 && this.getM_RMALine_ID() == 0 && this.getParent().isSOTrx() && !OFBForward.UseReturnWhitoutRMA()) {
            this.log.saveError("FillMandatory", Msg.translate((Properties)this.getCtx(), (String)"C_Order_ID"));
            return false;
        }
        if (this.getM_RMALine_ID() > 0) {
            this.setC_OrderLine_ID(this.getM_RMALine().getM_InOutLine().getC_OrderLine_ID());
        }
        if (this.getM_Locator_ID() > 0) {
            MLocator locator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
            if (this.getM_Warehouse_ID() != locator.getM_Warehouse_ID()) {
                throw new WarehouseLocatorConflictException((I_M_Warehouse)MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID()), (I_M_Locator)locator, this.getLine());
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.getParent().getDocStatus().equals("DR")) {
            return true;
        }
        this.log.saveError("Error", Msg.getMsg((Properties)this.getCtx(), (String)"CannotDelete"));
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutLine[").append(this.get_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",QtyEntered=").append(this.getQtyEntered()).append(",MovementQty=").append(this.getMovementQty()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    public BigDecimal getBase(String CostDistribution) {
        if ("C".equals(CostDistribution)) {
            MInvoiceLine m_il = MInvoiceLine.getOfInOutLine(this);
            if (m_il == null) {
                StringBuilder whereClause = new StringBuilder("C_OrderLine_ID").append("=? AND ");
                whereClause.append("M_Product_ID").append("=? AND ");
                whereClause.append("C_InvoiceLine_ID").append("<> 0");
                MMatchPO matchPO = (MMatchPO)((Object)new Query(this.getCtx(), "M_MatchPO", whereClause.toString(), this.get_TrxName()).setParameters(new Object[]{this.getC_OrderLine_ID(), this.getM_Product_ID()}).first());
                if (matchPO != null) {
                    m_il = matchPO.getInvoiceLine();
                }
            }
            if (m_il == null) {
                this.log.severe("No Invoice Line for: " + this.toString());
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(m_il.getPriceActual());
        }
        if ("L".equals(CostDistribution)) {
            return Env.ONE;
        }
        if ("Q".equals(CostDistribution)) {
            return this.getMovementQty();
        }
        if ("V".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getVolume());
        }
        if ("W".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getWeight());
        }
        this.log.severe("Invalid Criteria: " + CostDistribution);
        return Env.ZERO;
    }

    public boolean sameOrderLineUOM() {
        if (this.getC_OrderLine_ID() <= 0) {
            return false;
        }
        MOrderLine oLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
        return oLine.getC_UOM_ID() == this.getC_UOM_ID();
    }

    public BigDecimal getPriceActual() {
        BigDecimal price = null;
        if (this.getC_OrderLine_ID() > 0) {
            price = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)"SELECT currencyBase(ol.PriceActual,o.C_Currency_ID,o.DateAcct,o.AD_Client_ID,o.AD_Org_ID) AS price  FROM C_OrderLine ol INNER JOIN C_Order o ON (o.C_Order_ID=ol.C_Order_ID)  WHERE C_OrderLine_ID=?", (Object[])new Object[]{this.getC_OrderLine_ID()});
            if (price == null || price.signum() == 0) {
                price = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)" SELECT currencyBase(ol.PriceActual,o.C_Currency_ID,o.DateAcct,o.AD_Client_ID,o.AD_Org_ID) AS price FROM M_MatchPO mpo LEFT JOIN C_OrderLine ol ON ( mpo.C_OrderLine_ID=ol.C_OrderLine_ID)  INNER JOIN C_Order o ON (o.C_Order_ID=ol.C_Order_ID)  WHERE  mpo.M_InOutLine_ID=?", (Object[])new Object[]{this.getM_InOutLine_ID()});
            }
            if (price == null || price.signum() == 0) {
                price = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)" SELECT currencyBase(il.PriceActual,i.C_Currency_ID,i.DateAcct,i.AD_Client_ID,i.AD_Org_ID) AS price  FROM M_MatchInv mi LEFT JOIN C_InvoiceLine il ON (il.C_InvoiceLine_ID=mi.C_InvoiceLine_ID)  INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID)  WHERE  mi.M_InOutLine_ID=?", (Object[])new Object[]{this.getM_InOutLine_ID()});
            }
        }
        if (this.getM_RMALine_ID() > 0) {
            price = DB.getSQLValueBDEx((String)this.get_TrxName(), (String)"SELECT Amt FROM M_RMALine WHERE M_RMALine_ID=?", (Object[])new Object[]{this.getM_RMALine_ID()});
        }
        if (price == null) {
            price = Env.ZERO;
        }
        return price;
    }

    public boolean isSOTrx() {
        return this.getParent().isSOTrx();
    }

    public Timestamp getDateAcct() {
        return this.getParent().getDateAcct();
    }

    public IDocumentLine getReversalDocumentLine() {
        return (IDocumentLine)this.getReversalLine();
    }

    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    public int getM_LocatorTo_ID() {
        return -1;
    }

    public int getC_DocType_ID() {
        return this.getParent().getC_DocType_ID();
    }
}

