/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MRefList;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostElement;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MCostElement
extends X_M_CostElement {
    private static final long serialVersionUID = 3196322266971717530L;
    private static CCache<Integer, MCostElement> s_cache = new CCache("M_CostElement", 20);
    private static CLogger s_log = CLogger.getCLogger(MCostElement.class);

    public static List<MCostElement> getDefaultElements(PO po) {
        String whereClause = "IsDefault=?";
        ArrayList<MCostElement> elements = new Query(po.getCtx(), "M_CostElement", "IsDefault=?", po.get_TrxName()).setParameters(new Object[]{true}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("AD_Org_ID DESC").list();
        if (elements != null && elements.size() > 0) {
            return elements;
        }
        MCostElement costElement = MCostElement.getByMaterialCostElementType(po);
        if (costElement != null) {
            if (!costElement.isActive()) {
                costElement.setIsActive(true);
                costElement.saveEx();
            }
        } else {
            costElement = new MCostElement(po.getCtx(), 0, po.get_TrxName());
            costElement.setClientOrg(po.getAD_Client_ID(), 0);
            costElement.setName("Material");
            costElement.setIsDefault(true);
            costElement.setIsActive(true);
            costElement.setCostElementType("M");
            costElement.saveEx();
        }
        elements = new ArrayList<MCostElement>();
        elements.add(costElement);
        return elements;
    }

    public static MCostElement getByMaterialCostElementType(PO po) {
        String whereClause = "CostElementType=?";
        MCostElement retValue = (MCostElement)((Object)new Query(po.getCtx(), "M_CostElement", "CostElementType=?", po.get_TrxName()).setParameters(new Object[]{"M"}).setClient_ID().setOrderBy("M_CostElement_ID ,IsDefault, AD_Org_ID DESC").first());
        return retValue;
    }

    public static List<MCostElement> getCostElement(Properties ctx, String trxName) {
        return new Query(ctx, "M_CostElement", null, trxName).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Created").list();
    }

    public static MCostElement getMaterialCostElement(PO po) {
        MCostElement costElement = MCostElement.getByMaterialCostElementType(po);
        if (costElement != null) {
            return costElement;
        }
        costElement = new MCostElement(po.getCtx(), 0, po.get_TrxName());
        costElement.setClientOrg(po.getAD_Client_ID(), 0);
        String name = MRefList.getListName((Properties)po.getCtx(), (int)338, (String)"M");
        if (name == null || name.length() == 0) {
            name = "M";
        }
        costElement.setName(name);
        costElement.setCostElementType("M");
        costElement.saveEx();
        return costElement;
    }

    public static MCostElement get(Properties ctx, int M_CostElement_ID) {
        Integer key = new Integer(M_CostElement_ID);
        MCostElement retValue = (MCostElement)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostElement(ctx, M_CostElement_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    @Deprecated
    public static MCostElement[] getElements(Properties ctx, String trxName) {
        int AD_Org_ID = 0;
        String whereClause = "AD_Client_ID = ? AND AD_Org_ID=?";
        List list = new Query(ctx, "M_CostElement", "AD_Client_ID = ? AND AD_Org_ID=?", trxName).setParameters(new Object[]{Env.getAD_Client_ID((Properties)ctx), AD_Org_ID}).list();
        MCostElement[] retValue = new MCostElement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MCostElement(Properties ctx, int M_CostElement_ID, String trxName) {
        super(ctx, M_CostElement_ID, trxName);
        if (M_CostElement_ID == 0) {
            this.setCostElementType("M");
            this.setIsCalculated(false);
        }
    }

    public MCostElement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (("M".equals(this.getCostElementType()) || "X".equals(this.getCostElementType())) && (newRecord || this.is_ValueChanged("CostingMethod"))) {
            String sql = "SELECT  COALESCE(MAX(M_CostElement_ID),0) FROM M_CostElement WHERE AD_Client_ID=? AND CostingMethod=? AND CostElementType=?";
            int id = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{this.getAD_Client_ID(), this.getCostingMethod(), this.getCostElementType()});
            if (id > 0 && id != this.get_ID()) {
                this.log.saveError("AlreadyExists", Msg.getElement((Properties)this.getCtx(), (String)"CostingMethod"));
                return false;
            }
        }
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    protected boolean beforeDelete() {
        String cm = this.getCostingMethod();
        if (cm == null || !"M".equals(this.getCostElementType())) {
            return true;
        }
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        int i = 0;
        while (i < ass.length) {
            if (ass[i].getCostingMethod().equals(this.getCostingMethod())) {
                this.log.saveError("CannotDeleteUsed", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"C_AcctSchema_ID")) + " - " + ass[i].getName());
                return false;
            }
            ++i;
        }
        int M_Product_Category_ID = 0;
        String whereClause = "CostingMethod=?";
        MProductCategoryAcct retValue = (MProductCategoryAcct)new Query(this.getCtx(), "M_Product_Category_Acct", "CostingMethod=?", null).setParameters(new Object[]{this.getCostingMethod()}).setClient_ID().first();
        if (retValue != null) {
            M_Product_Category_ID = retValue.getM_Product_Category_ID();
        }
        if (M_Product_Category_ID != 0) {
            this.log.saveError("CannotDeleteUsed", String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"M_Product_Category_ID")) + " (ID=" + M_Product_Category_ID + ")");
            return false;
        }
        return true;
    }

    public boolean isCostingMethod() {
        return "M".equals(this.getCostElementType()) && this.getCostingMethod() != null;
    }

    public boolean isAverageInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("I") && "M".equals(this.getCostElementType());
    }

    public boolean isAveragePO() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("A") && "M".equals(this.getCostElementType());
    }

    public boolean isFifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("F") && "M".equals(this.getCostElementType());
    }

    public boolean isLastInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("i") && "M".equals(this.getCostElementType());
    }

    public boolean isLastPOPrice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("p") && "M".equals(this.getCostElementType());
    }

    public boolean isLifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("L") && "M".equals(this.getCostElementType());
    }

    public boolean isStandardCosting() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("S") && "M".equals(this.getCostElementType());
    }

    public boolean isUserDefined() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("U") && "M".equals(this.getCostElementType());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MCostElement[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getCostElementType()).append(",Method=").append(this.getCostingMethod()).append("]");
        return sb.toString();
    }

    public static List<MCostElement> getByCostingMethod(Properties ctx, String CostingMethod) {
        String whereClause = "AD_Client_ID = ? AND CostingMethod=?";
        return new Query(ctx, "M_CostElement", "AD_Client_ID = ? AND CostingMethod=?", null).setOnlyActiveRecords(true).setParameters(new Object[]{Env.getAD_Client_ID((Properties)ctx), CostingMethod}).list();
    }

    public static MCostElement getMaterialCostElement(PO po, String CostingMethod) {
        if (CostingMethod == null || CostingMethod.length() == 0) {
            s_log.severe("No CostingMethod");
            return null;
        }
        String whereClause = "AD_Client_ID=? AND CostingMethod=? AND CostElementType=?";
        MCostElement retValue = (MCostElement)((Object)new Query(po.getCtx(), "M_CostElement", "AD_Client_ID=? AND CostingMethod=? AND CostElementType=?", po.get_TrxName()).setParameters(new Object[]{po.getAD_Client_ID(), CostingMethod, "M"}).setOrderBy("AD_Org_ID").firstOnly());
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostElement(po.getCtx(), 0, po.get_TrxName());
        retValue.setClientOrg(po.getAD_Client_ID(), 0);
        String name = MRefList.getListName((Properties)po.getCtx(), (int)122, (String)CostingMethod);
        if (name == null || name.length() == 0) {
            name = CostingMethod;
        }
        retValue.setName(name);
        retValue.setCostElementType("M");
        retValue.setCostingMethod(CostingMethod);
        retValue.saveEx();
        return retValue;
    }

    public static List<MCostElement> getCostElementsWithCostingMethods(PO po) {
        String whereClause = "AD_Client_ID=? AND CostingMethod IS NOT NULL";
        return new Query(po.getCtx(), "M_CostElement", "AD_Client_ID=? AND CostingMethod IS NOT NULL", po.get_TrxName()).setParameters(new Object[]{po.getAD_Client_ID()}).setOnlyActiveRecords(true).list();
    }
}

