/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.IDocumentLine;
import org.compiere.acct.DocLine;
import org.compiere.model.I_M_CostType;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovement;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.model.X_M_CostDetail;
import org.compiere.model.X_M_Production;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPCostCollector;

public class MCostDetail
extends X_M_CostDetail {
    private static final long serialVersionUID = -7882724307127281675L;
    private static CLogger s_log = CLogger.getCLogger(MCostDetail.class);
    private MCost m_cost = null;

    public static BigDecimal getCostByModel(int accountSchemaId, int costTypeId, int costElementId, IDocumentLine model) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("M_CostType_ID").append("=? AND ");
        whereClause.append("M_CostElement_ID").append("=? AND ");
        whereClause.append(CostEngine.getIDColumnName(model)).append("=? ");
        return new Query(model.getCtx(), "M_CostDetail", whereClause.toString(), model.get_TrxName()).setClient_ID().setParameters(new Object[]{accountSchemaId, costTypeId, costElementId, model.get_ID()}).sum("(Amt+AmtLL)");
    }

    public static BigDecimal getQtyOnHandByASIAndSeqNo(Properties context, int productId, int costTypeId, int costElementId, int attributeSetInstanceId, int seqNo, String trxName) {
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Product_ID").append("=? AND ");
        parameters.add(productId);
        whereClause.append("M_CostType_ID").append("=? AND ");
        parameters.add(costTypeId);
        whereClause.append("M_CostElement_ID").append("=? AND ");
        parameters.add(costElementId);
        whereClause.append("M_AttributeSetInstance_ID").append("=? AND");
        parameters.add(attributeSetInstanceId);
        whereClause.append("SeqNo").append("<=?");
        parameters.add(seqNo);
        return new Query(context, "M_CostDetail", whereClause.toString(), trxName).setParameters(parameters).sum("Qty");
    }

    public static List<MCostDetail> getByTransaction(MTransaction transaction, int accountSchemaId, int costTypeId, int costElementId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("M_CostType_ID").append("=? AND ");
        whereClause.append("M_CostElement_ID").append("=? AND ");
        whereClause.append("M_Transaction_ID").append("=?");
        return new Query(transaction.getCtx(), "M_CostDetail", whereClause.toString(), transaction.get_TrxName()).setParameters(new Object[]{accountSchemaId, costTypeId, costElementId, transaction.getM_Transaction_ID()}).setOrderBy("SeqNo").list();
    }

    public static MCostDetail getCostDetail(MPPCostCollector cc, int M_CostElement_ID) {
        String whereClause = "PP_Cost_Collector_ID=? AND M_CostElement_ID=?";
        MCostDetail cd = (MCostDetail)((Object)new Query(cc.getCtx(), "M_CostDetail", "PP_Cost_Collector_ID=? AND M_CostElement_ID=?", cc.get_TrxName()).setClient_ID().setParameters(new Object[]{cc.getPP_Cost_Collector_ID(), M_CostElement_ID}).firstOnly());
        return cd;
    }

    public static boolean existsCost(MCostDetail cost) {
        return cost.getCostAmt().add(cost.getCostAdjustment()).add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL()).signum() != 0;
    }

    public static BigDecimal getTotalCost(MCostDetail cost, MAcctSchema as) {
        return cost.getCostAmt().add(cost.getCostAdjustment()).add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL()).setScale(as.getCostingPrecision(), 4);
    }

    public static List<MCostDetail> getByCollectorCost(MPPCostCollector costCollector) {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("PP_Cost_Collector_ID").append("=? ");
        return new Query(costCollector.getCtx(), "M_CostDetail", whereClause.toString(), costCollector.get_TrxName()).setClient_ID().setParameters(new Object[]{costCollector.getPP_Cost_Collector_ID()}).list();
    }

    public static MCostDetail getLastTransaction(IDocumentLine model, MTransaction transaction, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID, Timestamp dateAcct, String costingLevel) {
        ArrayList<Constable> params = new ArrayList<Constable>();
        StringBuffer whereClause = new StringBuffer();
        StringBuffer orderBy = new StringBuffer();
        if (model instanceof MLandedCostAllocation || model instanceof MMatchInv) {
            Timestamp dateacct = transaction.getDocumentLine().getDateAcct();
            MDocType dt = new MDocType(transaction.getCtx(), transaction.getDocumentLine().getC_DocType_ID(), transaction.get_TrxName());
            if (MPeriod.isOpen((Properties)transaction.getCtx(), (Timestamp)dateacct, (String)dt.getDocBaseType(), (int)transaction.getAD_Org_ID())) {
                whereClause.append("M_Transaction_ID=? AND ");
                params.add(Integer.valueOf(transaction.getM_Transaction_ID()));
            } else {
                whereClause.append("DateAcct <= " + DB.TO_DATE((Timestamp)dateAcct) + " AND ");
            }
        } else {
            whereClause.append("DateAcct <= " + DB.TO_DATE((Timestamp)dateAcct) + " AND ");
        }
        orderBy.append("SeqNo").append(" DESC");
        whereClause.append("AD_Client_ID=? AND ");
        params.add(Integer.valueOf(transaction.getAD_Client_ID()));
        if ("O".equals(costingLevel)) {
            whereClause.append("AD_Org_ID=? AND ");
            params.add(Integer.valueOf(transaction.getAD_Org_ID()));
        }
        if ("W".equals(costingLevel)) {
            whereClause.append("M_Warehouse_ID=? AND ");
            params.add(Integer.valueOf(transaction.getM_Warehouse_ID()));
        }
        whereClause.append("C_AcctSchema_ID=? AND ");
        params.add(Integer.valueOf(C_AcctSchema_ID));
        whereClause.append("M_Product_ID=? AND ");
        params.add(Integer.valueOf(transaction.getM_Product_ID()));
        if ("B".equals(costingLevel)) {
            whereClause.append("M_AttributeSetInstance_ID=? AND ");
            params.add(Integer.valueOf(transaction.getM_AttributeSetInstance_ID()));
        }
        whereClause.append("M_CostElement_ID=? AND ");
        params.add(Integer.valueOf(M_CostElement_ID));
        whereClause.append("M_CostType_ID=? AND ");
        params.add(Integer.valueOf(M_CostType_ID));
        whereClause.append("Processing = ? ");
        params.add(Boolean.valueOf(false));
        String sql_Back = whereClause.toString().replace("current_date", "now");
        whereClause.delete(0, whereClause.length());
        whereClause.append(sql_Back);
        return (MCostDetail)((Object)new Query(transaction.getCtx(), "M_CostDetail", whereClause.toString(), transaction.get_TrxName()).setParameters(params).setOrderBy(orderBy.toString()).first());
    }

    public static MCostDetail getLastTransaction(MTransaction mtrx, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID, String costingLevel) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=? AND ");
        params.add(mtrx.getAD_Client_ID());
        if ("O".equals(costingLevel)) {
            whereClause.append("AD_Org_ID").append("=? AND ");
            params.add(mtrx.getAD_Org_ID());
        }
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        params.add(C_AcctSchema_ID);
        whereClause.append("M_Product_ID").append("=? AND ");
        params.add(mtrx.getM_Product_ID());
        if ("B".equals(costingLevel)) {
            whereClause.append("M_AttributeSetInstance_ID").append("=? AND ");
            params.add(mtrx.getM_AttributeSetInstance_ID());
        }
        whereClause.append("M_CostElement_ID").append("=? AND ");
        params.add(M_CostElement_ID);
        whereClause.append("M_CostType_ID").append("=? AND ");
        params.add(M_CostType_ID);
        whereClause.append("M_Transaction_ID").append("<?  ");
        params.add(mtrx.getM_Transaction_ID());
        return (MCostDetail)((Object)new Query(mtrx.getCtx(), "M_CostDetail", whereClause.toString(), mtrx.get_TrxName()).setParameters(params).setOrderBy("SeqNo DESC").first());
    }

    public static boolean isEarlierTransaction(MCostDetail cd, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID, String costingLevel) {
        MTransaction trx = new MTransaction(cd.getCtx(), cd.getM_Transaction_ID(), cd.get_TrxName());
        MCostDetail last_cd = MCostDetail.getLastTransaction(trx, C_AcctSchema_ID, M_CostType_ID, M_CostElement_ID, costingLevel);
        if (last_cd == null) {
            return false;
        }
        return cd.getSeqNo() <= last_cd.getSeqNo() && cd.getM_Transaction_ID() != last_cd.getM_Transaction_ID();
    }

    public static MCostDetail getByTransaction(IDocumentLine model, MTransaction mtrx, int C_AcctSchema_ID, int M_CostType_ID, int M_CostElement_ID) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=? AND ");
        params.add(mtrx.getAD_Client_ID());
        whereClause.append("AD_Org_ID").append("=? AND ");
        params.add(mtrx.getAD_Org_ID());
        whereClause.append("M_Warehouse_ID").append("=? AND ");
        params.add(mtrx.getM_Warehouse_ID());
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        params.add(C_AcctSchema_ID);
        whereClause.append("M_Product_ID").append("=? AND ");
        params.add(mtrx.getM_Product_ID());
        if (mtrx.getM_AttributeSetInstance_ID() > 0) {
            whereClause.append("M_AttributeSetInstance_ID").append("=?  AND ");
            params.add(mtrx.getM_AttributeSetInstance_ID());
        }
        whereClause.append("M_CostElement_ID").append("=? AND ");
        params.add(M_CostElement_ID);
        whereClause.append("M_CostType_ID").append("=? AND ");
        params.add(M_CostType_ID);
        whereClause.append("M_Transaction_ID").append("=? ");
        params.add(mtrx.getM_Transaction_ID());
        if (model instanceof MMatchInv) {
            MMatchInv matchInv = (MMatchInv)model;
            whereClause.append(" AND ").append("C_InvoiceLine_ID").append("=? AND ");
            params.add(matchInv.getC_InvoiceLine_ID());
            whereClause.append("Qty").append("=0 ");
        } else if (model instanceof MLandedCostAllocation) {
            whereClause.append(" AND ").append("C_LandedCostAllocation_ID").append("=? ");
            params.add(model.get_ID());
        } else {
            whereClause.append(" AND ").append(model.get_TableName()).append("_ID=? AND ");
            params.add(model.get_ID());
            whereClause.append("Qty").append("<>0 ");
        }
        return (MCostDetail)((Object)new Query(mtrx.getCtx(), "M_CostDetail", whereClause.toString(), mtrx.get_TrxName()).setParameters(params).setOrderBy("SeqNo DESC").first());
    }

    public static List<MCostDetail> getByDocLine(DocLine docLine, int accountSchemaId, int costTypeId, boolean isExcludeLandedCost) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AD_Client_ID").append("=? AND ");
        whereClause.append("C_AcctSchema_ID").append("=? AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("M_CostType_ID").append("=? AND ");
        if (isExcludeLandedCost) {
            whereClause.append("C_LandedCostAllocation_ID").append(" IS NULL AND ");
        }
        whereClause.append(docLine.getTableName()).append("_ID=?");
        return new Query(docLine.getCtx(), "M_CostDetail", whereClause.toString(), docLine.getTrxName()).setParameters(new Object[]{docLine.getAD_Client_ID(), accountSchemaId, docLine.getM_Product_ID(), costTypeId, docLine.get_ID()}).list();
    }

    public static List<MCostDetail> getAfterDate(MCostDetail cd, String costingLevel) {
        ArrayList<Constable> params = new ArrayList<Constable>();
        StringBuffer whereClause = new StringBuffer("C_AcctSchema_ID=? AND ");
        params.add(Integer.valueOf(cd.getC_AcctSchema_ID()));
        whereClause.append("M_Product_ID").append("=? AND ");
        params.add(Integer.valueOf(cd.getM_Product_ID()));
        if ("O".equals(costingLevel)) {
            whereClause.append("AD_Org_ID").append("=? AND ");
            params.add(Integer.valueOf(cd.getAD_Org_ID()));
        }
        if ("W".equals(costingLevel)) {
            whereClause.append("M_Warehouse_ID").append("=? AND ");
            params.add(Integer.valueOf(cd.getM_Warehouse_ID()));
        }
        if ("B".equals(costingLevel)) {
            whereClause.append("M_AttributeSetInstance_ID").append("=? AND ");
            params.add(Integer.valueOf(cd.getM_AttributeSetInstance_ID()));
        }
        whereClause.append("M_CostType_ID").append("=? AND ");
        params.add(Integer.valueOf(cd.getM_CostType_ID()));
        whereClause.append("M_CostElement_ID").append("=? AND ");
        params.add(Integer.valueOf(cd.getM_CostElement_ID()));
        whereClause.append("M_CostDetail_ID").append("<>? AND ");
        params.add(Integer.valueOf(cd.getM_CostDetail_ID()));
        whereClause.append("M_Transaction_ID").append("<>? AND ");
        params.add(Integer.valueOf(cd.getM_Transaction_ID()));
        whereClause.append("SeqNo").append(">=? AND ");
        params.add(Integer.valueOf(cd.getSeqNo()));
        whereClause.append("Processing").append("=? ");
        params.add(Boolean.valueOf(false));
        return new Query(cd.getCtx(), "M_CostDetail", whereClause.toString(), cd.get_TrxName()).setClient_ID().setParameters(params).setOrderBy("SeqNo ASC").list();
    }

    public static boolean createOrder(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_OrderLine_ID=" + C_OrderLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_OrderLine_ID=?", C_OrderLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_OrderLine_ID(C_OrderLine_ID);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_InvoiceLine_ID=" + C_InvoiceLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "C_InvoiceLine_ID=?", C_InvoiceLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_InvoiceLine_ID(C_InvoiceLine_ID);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createShipment(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, boolean IsSOTrx, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InOutLine_ID=" + M_InOutLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InOutLine_ID=?", M_InOutLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InOutLine_ID(M_InOutLine_ID);
            cd.setIsSOTrx(IsSOTrx);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createInventory(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InventoryLine_ID=" + M_InventoryLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_InventoryLine_ID=?", M_InventoryLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InventoryLine_ID(M_InventoryLine_ID);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createMovement(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, boolean from, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_MovementLine_ID=" + M_MovementLine_ID + " AND IsSOTrx=" + (from ? "'Y'" : "'N'") + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_MovementLine_ID=? AND IsSOTrx=" + (from ? "'Y'" : "'N'"), M_MovementLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_MovementLine_ID(M_MovementLine_ID);
            cd.setIsSOTrx(from);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static boolean createProduction(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_ProductionLine_ID=" + M_ProductionLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        if (no != 0) {
            s_log.config("Deleted #" + no);
        }
        if ((cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", M_ProductionLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_ProductionLine_ID(M_ProductionLine_ID);
            s_log.config("mark 1");
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            s_log.config("mark 2");
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        s_log.config("mark 3");
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        X_M_ProductionLine MProdL = new X_M_ProductionLine(as.getCtx(), M_ProductionLine_ID, trxName);
        X_M_ProductionPlan MProdP = new X_M_ProductionPlan(as.getCtx(), MProdL.getM_ProductionPlan_ID(), trxName);
        X_M_Production MProdC = new X_M_Production(as.getCtx(), MProdP.getM_Production_ID(), trxName);
        cd.set_CustomColumn("DateAcct", MProdC.getMovementDate());
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get((Properties)as.getCtx(), (int)as.getAD_Client_ID())).isCostImmediate()) {
            cd.process();
        }
        s_log.config("(" + ok + ") " + (Object)((Object)cd));
        return ok;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, String trxName) {
        MCostDetail retValue;
        block8: {
            int C_AcctSchema_ID;
            String sql = "SELECT * FROM M_CostDetail WHERE " + whereClause;
            MClientInfo clientInfo = MClientInfo.get((Properties)ctx);
            MAcctSchema primary = clientInfo.getMAcctSchema1();
            int n = C_AcctSchema_ID = primary != null ? primary.getC_AcctSchema_ID() : 0;
            if (C_AcctSchema_ID > 0) {
                sql = String.valueOf(sql) + " AND C_AcctSchema_ID=?";
            }
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, ID);
                    pstmt.setInt(2, M_AttributeSetInstance_ID);
                    if (C_AcctSchema_ID > 0) {
                        pstmt.setInt(3, C_AcctSchema_ID);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        retValue = new MCostDetail(ctx, rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, String.valueOf(sql) + " - " + ID, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        return retValue;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, String trxName) {
        String localWhereClause = String.valueOf(whereClause) + " AND M_AttributeSetInstance_ID=?" + " AND C_AcctSchema_ID=?";
        MCostDetail retValue = (MCostDetail)((Object)new Query(ctx, "M_CostDetail", localWhereClause, trxName).setParameters(new Object[]{ID, M_AttributeSetInstance_ID, C_AcctSchema_ID}).first());
        return retValue;
    }

    public static boolean processProduct(MProduct product, String trxName) {
        String whereClause = "M_Product_ID=? AND Processed=?";
        int counterOK = 0;
        int counterError = 0;
        List list = new Query(product.getCtx(), "M_CostDetail", "M_Product_ID=? AND Processed=?", trxName).setParameters(new Object[]{product.getM_Product_ID(), false}).setOrderBy("C_AcctSchema_ID, M_CostElement_ID, AD_Org_ID, M_Warehouse_ID, M_AttributeSetInstance_ID, Created").list();
        for (MCostDetail cd : list) {
            if (cd.process()) {
                ++counterOK;
                continue;
            }
            ++counterError;
        }
        s_log.config("OK=" + counterOK + ", Errors=" + counterError);
        return counterError == 0;
    }

    public MCostDetail(Properties ctx, int M_CostDetail_ID, String trxName) {
        super(ctx, M_CostDetail_ID, trxName);
        if (M_CostDetail_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setProcessed(false);
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setIsSOTrx(false);
            this.setDeltaAmt(Env.ZERO);
            this.setDeltaQty(Env.ZERO);
        }
    }

    public MCostDetail(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName, int M_CostType_ID) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setM_CostType_ID(M_CostType_ID);
        MCostType ct = new MCostType(as.getCtx(), M_CostType_ID, trxName);
        this.setCostingMethod(ct.getCostingMethod());
        this.setAmt(Amt);
        this.setQty(Qty);
        this.setDescription(Description);
    }

    public MCostDetail(MTransaction transaction, int acctSchemaId, int costTypeId, int costElementId, BigDecimal amt, BigDecimal amtLL, BigDecimal qty, String trxName) {
        this(transaction.getCtx(), 0, trxName);
        this.setAD_Client_ID(transaction.getAD_Client_ID());
        this.setAD_Org_ID(transaction.getAD_Org_ID());
        this.setM_Warehouse_ID(transaction.getM_Warehouse_ID());
        this.setC_AcctSchema_ID(acctSchemaId);
        this.setM_Product_ID(transaction.getM_Product_ID());
        this.setM_CostType_ID(costTypeId);
        this.setM_CostElement_ID(costElementId);
        this.setM_AttributeSetInstance_ID(transaction.getM_AttributeSetInstance_ID());
        MCostType ct = new MCostType(transaction.getCtx(), costTypeId, transaction.get_TrxName());
        this.setCostingMethod(ct.getCostingMethod());
        this.setAmt(amt);
        this.setAmtLL(amtLL);
        this.setQty(qty);
        this.setCostAdjustment(Env.ZERO);
        this.setCostAdjustmentLL(Env.ZERO);
        this.setCumulatedQty(Env.ZERO);
        this.setCumulatedAmt(Env.ZERO);
        this.setCumulatedAmtLL(Env.ZERO);
        this.setCurrentQty(Env.ZERO);
        this.setCurrentCostPrice(Env.ZERO);
        this.setCurrentCostPriceLL(Env.ZERO);
        this.setCumulatedQty(Env.ZERO);
    }

    public MCostDetail(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        this(as.getCtx(), 0, trxName);
        this.setClientOrg(as.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
        this.setAmt(Amt);
        this.setQty(Qty);
        this.setDescription(Description);
    }

    public void setAmt(BigDecimal Amt) {
        if (Amt == null) {
            super.setAmt(Env.ZERO);
        } else {
            super.setAmt(Amt);
        }
    }

    public void setQty(BigDecimal Qty) {
        if (Qty == null) {
            super.setQty(Env.ZERO);
        } else {
            super.setQty(Qty);
        }
    }

    public boolean isOrder() {
        return this.getC_OrderLine_ID() != 0;
    }

    public boolean isInvoice() {
        return this.getC_InvoiceLine_ID() != 0;
    }

    public boolean isShipment() {
        return this.isSOTrx() && this.getM_InOutLine_ID() != 0;
    }

    public boolean isDelta() {
        return this.getDeltaAmt().signum() != 0 || this.getDeltaQty().signum() != 0;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return true;
    }

    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MCostDetail[");
        sb.append(this.get_ID());
        sb.append(",SeqNo=").append(this.getSeqNo());
        sb.append(",AD_Org_ID=").append(this.getAD_Org_ID());
        sb.append(",C_AcctSchema_ID=").append(this.getC_AcctSchema_ID());
        sb.append(",M_CostType_ID=").append(this.getM_CostType_ID());
        sb.append(",M_CostElement_ID=").append(this.getM_CostElement_ID());
        sb.append(",M_Transaction_ID=").append(this.getM_Transaction_ID());
        sb.append(",DateAcct=").append(this.getDateAcct());
        if (this.getC_OrderLine_ID() != 0) {
            sb.append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sb.append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID());
        }
        if (this.getC_InvoiceLine_ID() != 0) {
            sb.append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID());
        }
        if (this.getC_ProjectIssue_ID() != 0) {
            sb.append(",C_ProjectIssue_ID=").append(this.getC_ProjectIssue_ID());
        }
        if (this.getM_MovementLine_ID() != 0) {
            sb.append(",M_MovementLine_ID=").append(this.getM_MovementLine_ID());
        }
        if (this.getM_InventoryLine_ID() != 0) {
            sb.append(",M_InventoryLine_ID=").append(this.getM_InventoryLine_ID());
        }
        if (this.getM_ProductionLine_ID() != 0) {
            sb.append(",M_ProductionLine_ID=").append(this.getM_ProductionLine_ID());
        }
        if (this.getC_LandedCostAllocation_ID() != 0) {
            sb.append(",C_LandedCostAllocation_ID=").append(this.getC_LandedCostAllocation_ID());
        }
        sb.append(",Cost =").append(this.getAmt());
        sb.append(",Cost Amt=").append(this.getCostAmt());
        sb.append(",Qty=").append(this.getQty());
        sb.append(",CumulatedQty =").append(this.getCumulatedQty());
        sb.append(",Qty Onhand =").append(this.getQty().add(this.getCumulatedQty()));
        sb.append(",Current Qty =").append(this.getCurrentQty());
        sb.append(",Cumulated Amt =").append(this.getCumulatedAmt());
        sb.append(",Cumulated Amt LL =").append(this.getCumulatedAmtLL());
        sb.append(",Current Price =").append(this.getCurrentCostPrice());
        sb.append(",Current Proce TL =").append(this.getCurrentCostPriceLL());
        if (this.isDelta()) {
            sb.append(",DeltaAmt=").append(this.getDeltaAmt()).append(",DeltaQty=").append(this.getDeltaQty());
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized boolean process() {
        if (this.isProcessed()) {
            this.log.info("Already processed");
            return true;
        }
        boolean ok = false;
        MAcctSchema as = MAcctSchema.get((Properties)this.getCtx(), (int)this.getC_AcctSchema_ID());
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        String CostingLevel = product.getCostingLevel(as);
        int organizationId = this.getAD_Org_ID();
        int warehouseId = this.getM_Warehouse_ID();
        int attributeSetInstanceId = this.getM_AttributeSetInstance_ID();
        if ("C".equals(CostingLevel)) {
            organizationId = 0;
            warehouseId = 0;
            attributeSetInstanceId = 0;
        } else if ("O".equals(CostingLevel)) {
            warehouseId = 0;
            attributeSetInstanceId = 0;
        } else if ("B".equals(CostingLevel)) {
            warehouseId = 0;
            organizationId = 0;
        }
        if (this.getM_CostElement_ID() == 0) {
            for (MCostElement costElement : MCostElement.getCostElement(this.getCtx(), this.get_TrxName())) {
                ok = this.process(as, product, costElement, organizationId, warehouseId, attributeSetInstanceId);
                if (ok) {
                    continue;
                }
                break;
            }
        } else {
            MCostElement ce = MCostElement.get(this.getCtx(), this.getM_CostElement_ID());
            ok = this.process(as, product, ce, organizationId, warehouseId, attributeSetInstanceId);
        }
        if (ok) {
            this.setDeltaAmt(null);
            this.setDeltaQty(null);
            this.setProcessed(true);
            ok = this.save();
        }
        this.log.info(String.valueOf(ok) + " - " + this.toString());
        return ok;
    }

    private boolean process(MAcctSchema as, MProduct product, MCostElement costElement, int OrgId, int warehouseId, int attributeSetInstanceId) {
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (success) {
            boolean ok = false;
            MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), null);
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            String CostingLevel = product.getCostingLevel(as);
            int organizationId = this.getAD_Org_ID();
            int warehouseId = this.getM_Warehouse_ID();
            int attributeSetInstanceId = this.getM_AttributeSetInstance_ID();
            if ("C".equals(CostingLevel)) {
                organizationId = 0;
                warehouseId = 0;
                attributeSetInstanceId = 0;
            } else if ("O".equals(CostingLevel)) {
                warehouseId = 0;
                attributeSetInstanceId = 0;
            } else if ("B".equals(CostingLevel)) {
                warehouseId = 0;
                organizationId = 0;
            }
            if (this.getM_CostElement_ID() == 0) {
                for (MCostElement costElement : MCostElement.getCostElement(this.getCtx(), this.get_TrxName())) {
                    ok = this.process(as, product, costElement, organizationId, warehouseId, attributeSetInstanceId);
                    if (ok) {
                        continue;
                    }
                    break;
                }
            } else {
                MCostElement ce = MCostElement.get(this.getCtx(), this.getM_CostElement_ID());
                ok = this.process(as, product, ce, organizationId, warehouseId, attributeSetInstanceId);
            }
            return ok;
        }
        return super.afterDelete(success);
    }

    private void setDateAcct(boolean force) {
        Timestamp dateAcct = this.getDateAcct();
        if (dateAcct != null && !force) {
            return;
        }
        String sql = null;
        int param1 = -1;
        if (this.getC_InvoiceLine_ID() > 0) {
            sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE il.C_InvoiceLine_ID=?";
            param1 = this.getC_InvoiceLine_ID();
        } else if (this.getM_InOutLine_ID() > 0) {
            sql = "SELECT i.DateAcct FROM M_InOutLine il INNER JOIN M_InOut i ON (i.M_InOut_ID = il.M_InOut_ID) WHERE il.M_InOutLine_ID=?";
            param1 = this.getM_InOutLine_ID();
        } else if (this.getC_OrderLine_ID() > 0) {
            sql = "SELECT i.DateAcct FROM C_OrderLine il INNER JOIN C_Order i ON (i.C_Order_ID = il.C_Order_ID) WHERE il.C_OrderLine_ID=?";
            param1 = this.getC_OrderLine_ID();
        } else if (this.getM_InventoryLine_ID() > 0) {
            sql = "SELECT i.MovementDate FROM M_InventoryLine il INNER JOIN M_Inventory i ON (i.M_Inventory_ID = il.M_Inventory_ID) WHERE il.M_InventoryLine_ID=?";
            param1 = this.getM_InventoryLine_ID();
        } else if (this.getM_MovementLine_ID() > 0) {
            sql = "SELECT i.MovementDate FROM M_MovementLine il INNER JOIN M_Movement i ON (i.M_Movement_ID = il.M_Movement_ID) WHERE il.M_MovementLine_ID=?";
            param1 = this.getM_MovementLine_ID();
        } else if (this.getC_LandedCostAllocation_ID() > 0) {
            sql = "SELECT i.DateAcct FROM C_Invoice i INNER JOIN C_InvoiceLine il ON (i.C_Invoice_ID=il.C_Invoice_ID) INNER JOIN C_LandedCostAllocation la ON (il.C_InvoiceLine_ID=la.C_InvoiceLine_ID) WHERE la.C_LandedCostAllocation_ID=?";
            param1 = this.getC_LandedCostAllocation_ID();
        }
        dateAcct = DB.getSQLValueTSEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{param1});
        this.setDateAcct(dateAcct);
    }

    private void rePosted() {
        if (this.getC_InvoiceLine_ID() > 0) {
            int id = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_MatchInv_ID FROM M_MatchInv WHERE C_InvoiceLine_ID=?", (int)this.getC_InvoiceLine_ID());
            if (id > 0) {
                DB.executeUpdate((String)"UPDATE M_MatchInv SET Posted='N', Processing='N', ProcessedOn=null WHERE M_MatchInv_ID=? AND Processed='Y'", (int)id, (String)this.get_TrxName());
                MFactAcct.deleteEx((int)MMatchInv.Table_ID, (int)id, (String)this.get_TrxName());
            }
        } else if (this.getM_InOutLine_ID() > 0) {
            int id = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_InOut_ID FROM M_InOutLine WHERE M_InOutLine_ID=? ", (int)this.getM_InOutLine_ID());
            if (id > 0) {
                DB.executeUpdate((String)"UPDATE M_InOut SET Posted='N', Processing='N', ProcessedOn=null WHERE M_InOut_ID=? AND Processed='Y'", (int)id, (String)this.get_TrxName());
                MFactAcct.deleteEx((int)MInOut.Table_ID, (int)id, (String)this.get_TrxName());
            }
        } else if (this.getC_OrderLine_ID() > 0) {
            int id = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_MatchPO_ID FROM M_MatchPO WHERE C_OrderLine_ID=?", (int)this.getC_OrderLine_ID());
            if (id > 0) {
                DB.executeUpdate((String)"UPDATE M_MatchPO SET Posted='N', Processing='N', ProcessedOn=null WHERE M_MatchPO_ID=? AND Processed='Y'", (int)id, (String)this.get_TrxName());
                MFactAcct.deleteEx((int)MMatchPO.Table_ID, (int)id, (String)this.get_TrxName());
            }
        } else if (this.getM_InventoryLine_ID() > 0) {
            int id = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_Inventory_ID FROM M_InventoryLine WHERE M_InventoryLine_ID=?", (int)this.getM_InventoryLine_ID());
            if (id > 0) {
                DB.executeUpdate((String)"UPDATE M_Inventory SET Posted='N', Processing='N', ProcessedOn=null WHERE M_Inventory_ID=? AND Processed='Y'", (int)id, (String)this.get_TrxName());
                MFactAcct.deleteEx((int)MInventory.Table_ID, (int)id, (String)this.get_TrxName());
            }
        } else if (this.getM_MovementLine_ID() > 0) {
            int id = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT M_Movement_ID FROM M_MovementLine WHERE M_MovementLine_ID=?", (int)this.getM_MovementLine_ID());
            if (id > 0) {
                DB.executeUpdate((String)"UPDATE M_Movement SET Posted='N', Processing='N', ProcessedOn=null WHERE M_Movement_ID=? AND Processed='Y'", (int)id, (String)this.get_TrxName());
                MFactAcct.deleteEx((int)MMovement.Table_ID, (int)id, (String)this.get_TrxName());
            }
        } else {
            this.getC_LandedCostAllocation_ID();
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setDateAcct(false);
        return true;
    }

    public I_M_CostType getM_CostType() throws RuntimeException {
        return super.getM_CostType();
    }

    public MCost getM_Cost() {
        return this.m_cost;
    }

    public int getM_Warehouse_ID() {
        String whereClause = "SELECT l.M_Warehouse_ID FROM M_CostDetail cd INNER JOIN  M_Transaction t ON (cd.M_Transaction_ID=t.M_Transaction_ID) INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) WHERE cd.M_CostDetail_ID=? ";
        return DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT l.M_Warehouse_ID FROM M_CostDetail cd INNER JOIN  M_Transaction t ON (cd.M_Transaction_ID=t.M_Transaction_ID) INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) WHERE cd.M_CostDetail_ID=? ", (int)this.getM_CostDetail_ID());
    }

    public static BigDecimal getByDocLineLandedCost(MLandedCostAllocation landedCostAllocation, int acctSchemaId, int costTypeId) {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID").append("=? AND ").append("C_AcctSchema_ID").append("=? AND ").append("M_Product_ID").append("=? AND ").append("M_AttributeSetInstance_ID").append("=? AND ").append("M_CostType_ID").append("=? AND ").append("C_InvoiceLine_ID").append("=? AND ").append("M_InOutLine_ID").append("=? ");
        return new Query(landedCostAllocation.getCtx(), "M_CostDetail", whereClause.toString(), landedCostAllocation.get_TrxName()).setParameters(new Object[]{landedCostAllocation.getAD_Client_ID(), acctSchemaId, landedCostAllocation.getM_Product_ID(), costTypeId, landedCostAllocation.getC_InvoiceLine_ID(), landedCostAllocation.getM_InOutLine_ID()}).aggregate("CostAmt + CostAdjustment + CostAmtLL + CostAdjustmentLL", "SUM");
    }

    public static BigDecimal getByDocLineMatchInv(MInvoiceLine invoiceLine, MInOutLine inOutLine, int acctSchemaId, int costTypeId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AD_Client_ID").append("=? AND ").append("C_AcctSchema_ID").append("=? AND ").append("M_Product_ID").append("=? AND ").append("M_AttributeSetInstance_ID=? AND ").append("M_CostType_ID").append("=? AND ").append("C_InvoiceLine_ID").append("=? AND ").append("M_InOutLine_ID").append("=?");
        return new Query(invoiceLine.getCtx(), "M_CostDetail", whereClause.toString(), invoiceLine.get_TrxName()).setParameters(new Object[]{invoiceLine.getAD_Client_ID(), acctSchemaId, invoiceLine.getM_Product_ID(), costTypeId, invoiceLine.getC_InvoiceLine_ID(), inOutLine.getM_InOutLine_ID()}).aggregate("CostAdjustment + CostAdjustmentLL", "SUM");
    }
}

