/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import com.akunagroup.uk.postcode.AddressLookupInterface;
import com.akunagroup.uk.postcode.Postcode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.CityAutoCompleter;
import org.compiere.model.MCity;
import org.compiere.model.MCountry;
import org.compiere.model.MLocation;
import org.compiere.model.MRefList;
import org.compiere.model.MRegion;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VLocationDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 6952838437136830975L;
    private Object[] header = null;
    private int m_WindowNo = 0;
    private boolean m_change = false;
    private MLocation m_location;
    private int m_origCountry_ID;
    private int s_oldCountry_ID = 0;
    private static CLogger log = CLogger.getCLogger(VLocationDialog.class);
    private CPanel panel = new CPanel();
    private CPanel mainPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private BorderLayout panelLayout = new BorderLayout();
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private BorderLayout southLayout = new BorderLayout();
    private CLabel lAddress1 = new CLabel(Msg.getElement((Properties)Env.getCtx(), (String)"Address1"));
    private CLabel lAddress2 = new CLabel(Msg.getElement((Properties)Env.getCtx(), (String)"Address2"));
    private CLabel lAddress3 = new CLabel(Msg.getElement((Properties)Env.getCtx(), (String)"Address3"));
    private CLabel lAddress4 = new CLabel(Msg.getElement((Properties)Env.getCtx(), (String)"Address4"));
    private CLabel lCity = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"City"));
    private CLabel lCountry = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Country"));
    private CLabel lRegion = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
    private CLabel lPostal = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Postal"));
    private CLabel lPostalAdd = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"PostalAdd"));
    private CLabel lOnline = new CLabel("");
    private CTextField fAddress1 = new CTextField(20);
    private CTextField fAddress2 = new CTextField(20);
    private CTextField fAddress3 = new CTextField(20);
    private CTextField fAddress4 = new CTextField(20);
    private CTextField fCity = new CTextField(20);
    private CComboBox fCity2;
    private CityAutoCompleter fCityAutoCompleter;
    private CComboBox fCountry;
    private CComboBox fRegion;
    private CTextField fPostal = new CTextField(5);
    private CTextField fPostalAdd = new CTextField(5);
    private CButton fOnline = new CButton();
    private GridBagConstraints gbc = new GridBagConstraints();
    private Insets labelInsets = new Insets(2, 15, 2, 0);
    private Insets fieldInsets = new Insets(2, 5, 2, 10);
    private boolean isCityMandatory = false;
    private boolean isRegionMandatory = false;
    private boolean isAddress1Mandatory = false;
    private boolean isAddress2Mandatory = false;
    private boolean isAddress3Mandatory = false;
    private boolean isAddress4Mandatory = false;
    private boolean isPostalMandatory = false;
    private boolean isPostalAddMandatory = false;
    private boolean inCountryAction;
    private boolean inOKAction;

    public VLocationDialog(Frame frame, String title, MLocation location) {
        super(frame, title, true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.m_location = location;
        if (this.m_location == null) {
            this.m_location = new MLocation(Env.getCtx(), 0, null);
        }
        if (this.m_location.getC_Location_ID() == 0) {
            this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"LocationNew"));
        } else {
            this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"LocationUpdate"));
        }
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Region_ID", null);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Country_ID", null);
        this.fCountry = new CComboBox((Object[])MCountry.getCountries((Properties)Env.getCtx()));
        this.fCountry.setSelectedItem((Object)this.m_location.getCountry());
        this.m_origCountry_ID = this.m_location.getC_Country_ID();
        this.fRegion = new CComboBox((Object[])MRegion.getRegions(Env.getCtx(), this.m_origCountry_ID));
        if (this.m_location.getCountry().isHasRegion()) {
            if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                this.lRegion.setText(this.m_location.getCountry().get_Translation("RegionName"));
            } else {
                this.lRegion.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
            }
        }
        this.fRegion.setSelectedItem((Object)this.m_location.getRegion());
        this.fOnline.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Online"));
        this.initLocation();
        this.fCountry.addActionListener((ActionListener)this);
        this.fOnline.addActionListener((ActionListener)this);
        this.fRegion.addActionListener((ActionListener)this);
        AEnv.positionCenterWindow((Window)frame, (Window)((Object)this));
    }

    void jbInit() throws Exception {
        this.panel.setLayout((LayoutManager)this.panelLayout);
        this.southPanel.setLayout((LayoutManager)this.southLayout);
        this.mainPanel.setLayout((LayoutManager)this.gridBagLayout);
        this.panelLayout.setHgap(5);
        this.panelLayout.setVgap(10);
        this.getContentPane().add((Component)this.panel);
        this.panel.add((Component)this.mainPanel, (Object)"Center");
        this.panel.add((Component)this.southPanel, (Object)"South");
        this.southPanel.add((Component)this.confirmPanel, (Object)"North");
        this.confirmPanel.addActionListener((ActionListener)this);
        this.fCityAutoCompleter = new CityAutoCompleter((JTextComponent)this.fCity, this.m_WindowNo);
    }

    private void initLocation() {
        MCountry country = this.m_location.getCountry();
        log.fine(String.valueOf(country.getName()) + ", Region=" + country.isHasRegion() + " " + country.getCaptureSequence() + ", C_Location_ID=" + this.m_location.getC_Location_ID());
        if (country.getC_Country_ID() != this.s_oldCountry_ID) {
            this.fRegion.removeAllItems();
            if (country.isHasRegion()) {
                MRegion[] mRegionArray = MRegion.getRegions(Env.getCtx(), country.getC_Country_ID());
                int n = mRegionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MRegion region = mRegionArray[n2];
                    this.fRegion.addItem((Object)region);
                    ++n2;
                }
                if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                    this.lRegion.setText(this.m_location.getCountry().get_Translation("RegionName"));
                } else {
                    this.lRegion.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
                }
            }
            this.s_oldCountry_ID = this.m_location.getC_Country_ID();
        }
        if (this.m_location.getC_Region_ID() > 0 && this.m_location.getC_Region().getC_Country_ID() == country.getC_Country_ID()) {
            this.fRegion.setSelectedItem((Object)this.m_location.getC_Region());
        } else {
            this.fRegion.setSelectedItem(null);
            this.m_location.setC_Region_ID(0);
        }
        if (country.isHasRegion() && this.m_location.getC_Region_ID() > 0) {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Region_ID", (String)String.valueOf(this.m_location.getC_Region_ID()));
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Region_ID", (String)"0");
        }
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)1113, (String)"C_Country_ID", (String)String.valueOf(country.get_ID()));
        this.fCityAutoCompleter.fillList();
        boolean createcitys = false;
        if (this.fRegion.getItemCount() > 0 && country.isHasRegion()) {
            MRegion r;
            log.info("*fRegion.getItemCount():" + this.fRegion.getItemCount());
            if (this.fRegion.getSelectedItem() != null && MRegion.HasCitys((r = (MRegion)this.fRegion.getSelectedItem()).getC_Region_ID())) {
                createcitys = true;
                log.info("carga citys de region:" + this.m_location.getC_Region_ID());
                this.fCity2 = new CComboBox((Object[])MCity.getCitys(Env.getCtx(), r.getC_Region_ID()));
                if (this.m_location.getC_City_ID() != 0) {
                    this.fCity2.setSelectedItem((Object)this.m_location.getMCity());
                }
            }
        }
        this.gbc.anchor = 18;
        this.gbc.gridy = 0;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.fieldInsets;
        this.gbc.fill = 2;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.mainPanel.removeAll();
        this.mainPanel.add(Box.createVerticalStrut(5), (Object)this.gbc);
        int line = 1;
        String ds = country.getCaptureSequence();
        if (ds == null || ds.length() == 0) {
            log.log(Level.SEVERE, "CaptureSequence empty - " + country);
            ds = "";
        }
        this.isCityMandatory = false;
        this.isRegionMandatory = false;
        this.isAddress1Mandatory = false;
        this.isAddress2Mandatory = false;
        this.isAddress3Mandatory = false;
        this.isAddress4Mandatory = false;
        this.isPostalMandatory = false;
        this.isPostalAddMandatory = false;
        StringTokenizer st = new StringTokenizer(ds, "@", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("CO")) {
                this.addLine(line++, (JLabel)this.lCountry, (JComponent)this.fCountry);
                if (!this.m_location.getCountry().isPostcodeLookup()) continue;
                this.addLine(line++, (JLabel)this.lOnline, (JComponent)this.fOnline);
                continue;
            }
            if (s.startsWith("A1")) {
                this.addLine(line++, (JLabel)this.lAddress1, (JComponent)this.fAddress1);
                this.isAddress1Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A2")) {
                this.addLine(line++, (JLabel)this.lAddress2, (JComponent)this.fAddress2);
                this.isAddress2Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A3")) {
                this.addLine(line++, (JLabel)this.lAddress3, (JComponent)this.fAddress3);
                this.isAddress3Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A4")) {
                this.addLine(line++, (JLabel)this.lAddress4, (JComponent)this.fAddress4);
                this.isAddress4Mandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("C")) {
                if (createcitys) {
                    this.addLine(line++, (JLabel)this.lCity, (JComponent)this.fCity2);
                } else {
                    this.addLine(line++, (JLabel)this.lCity, (JComponent)this.fCity);
                }
                this.isCityMandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("P")) {
                this.addLine(line++, (JLabel)this.lPostal, (JComponent)this.fPostal);
                this.isPostalMandatory = s.endsWith("!");
                continue;
            }
            if (s.startsWith("A")) {
                this.addLine(line++, (JLabel)this.lPostalAdd, (JComponent)this.fPostalAdd);
                this.isPostalAddMandatory = s.endsWith("!");
                continue;
            }
            if (!s.startsWith("R") || !this.m_location.getCountry().isHasRegion()) continue;
            this.addLine(line++, (JLabel)this.lRegion, (JComponent)this.fRegion);
            this.isRegionMandatory = s.endsWith("!");
        }
        if (this.m_location.getC_Location_ID() != 0) {
            this.fAddress1.setText(this.m_location.getAddress1());
            this.fAddress2.setText(this.m_location.getAddress2());
            this.fAddress3.setText(this.m_location.getAddress3());
            this.fAddress4.setText(this.m_location.getAddress4());
            this.fCity.setText(this.m_location.getCity());
            this.fPostal.setText(this.m_location.getPostal());
            this.fPostalAdd.setText(this.m_location.getPostal_Add());
            if (this.m_location.getCountry().isHasRegion()) {
                if (this.m_location.getCountry().get_Translation("RegionName") != null && this.m_location.getCountry().get_Translation("RegionName").trim().length() > 0) {
                    this.lRegion.setText(this.m_location.getCountry().get_Translation("RegionName"));
                } else {
                    this.lRegion.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Region"));
                }
                this.fRegion.setSelectedItem((Object)this.m_location.getRegion());
            }
            if (!this.fCountry.getSelectedItem().equals(country)) {
                this.fCountry.setSelectedItem((Object)country);
            }
        }
        this.pack();
    }

    private void addLine(int line, JLabel label, JComponent field) {
        this.gbc.gridy = line;
        this.gbc.insets = this.labelInsets;
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 2;
        label.setHorizontalAlignment(4);
        this.mainPanel.add((Component)label, (Object)this.gbc);
        this.gbc.insets = this.fieldInsets;
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 0;
        this.gbc.insets = this.fieldInsets;
        this.mainPanel.add((Component)field, (Object)this.gbc);
    }

    public void dispose() {
        if (!this.m_change && this.m_location != null && !this.m_location.is_new()) {
            this.m_location = new MLocation(this.m_location.getCtx(), this.m_location.get_ID(), null);
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MCountry c;
        if (e.getActionCommand().equals("Ok")) {
            String msg;
            this.inOKAction = true;
            if (this.m_location.getCountry().isHasRegion() && this.fRegion.getSelectedItem() == null && this.fCityAutoCompleter.getC_Region_ID() > 0 && this.fCityAutoCompleter.getC_Region_ID() != this.m_location.getC_Region_ID()) {
                this.fRegion.setSelectedItem((Object)MRegion.get(Env.getCtx(), this.fCityAutoCompleter.getC_Region_ID()));
                this.m_location.setRegion(MRegion.get(Env.getCtx(), this.fCityAutoCompleter.getC_Region_ID()));
            }
            if ((msg = this.validate_OK()) != null) {
                ADialog.error((int)0, (Container)((Object)this), (String)"FillMandatory", (String)Msg.parseTranslation((Properties)Env.getCtx(), (String)msg));
                this.inOKAction = false;
                return;
            }
            if (this.action_OK()) {
                this.m_change = true;
                this.dispose();
            } else {
                ADialog.error((int)this.m_WindowNo, (Container)((Object)this), (String)"CityNotFound");
            }
            this.inOKAction = false;
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_change = false;
            this.dispose();
        } else if (e.getSource() == this.fCountry) {
            this.inCountryAction = true;
            MCountry c2 = (MCountry)this.fCountry.getSelectedItem();
            this.m_location.setCountry(c2);
            this.initLocation();
            this.fCountry.requestFocus();
            this.inCountryAction = false;
        } else if (e.getSource() == this.fRegion) {
            if (this.inCountryAction || this.inOKAction) {
                return;
            }
            MRegion r = (MRegion)this.fRegion.getSelectedItem();
            this.m_location.setRegion(r);
            this.m_location.setC_City_ID(0);
            this.m_location.setMCity(null);
            this.initLocation();
            this.fRegion.requestFocus();
        } else if (e.getSource() == this.fOnline && (c = (MCountry)this.fCountry.getSelectedItem()).isPostcodeLookup()) {
            this.lookupPostcode(c, this.fPostal.getText());
        }
    }

    private String validate_OK() {
        String fields = "";
        if (this.isAddress1Mandatory && this.fAddress1.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address1@, ";
        }
        if (this.isAddress2Mandatory && this.fAddress2.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address2@, ";
        }
        if (this.isAddress3Mandatory && this.fAddress3.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address3@, ";
        }
        if (this.isAddress4Mandatory && this.fAddress4.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Address4@, ";
        }
        if (this.isCityMandatory && this.fCity.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@C_City_ID@, ";
        }
        if (this.isRegionMandatory && this.fRegion.getSelectedItem() == null) {
            fields = String.valueOf(fields) + " " + "@C_Region_ID@, ";
        }
        if (this.isPostalMandatory && this.fPostal.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@Postal@, ";
        }
        if (this.isPostalAddMandatory && this.fPostalAdd.getText().trim().length() == 0) {
            fields = String.valueOf(fields) + " " + "@PostalAdd@, ";
        }
        if (fields.trim().length() > 0) {
            return fields.substring(0, fields.length() - 2);
        }
        return null;
    }

    private boolean action_OK() {
        this.m_location.setAddress1(this.fAddress1.getText());
        this.m_location.setAddress2(this.fAddress2.getText());
        this.m_location.setAddress3(this.fAddress3.getText());
        this.m_location.setAddress4(this.fAddress4.getText());
        this.m_location.setCity(this.fCity.getText());
        this.m_location.setC_City_ID(this.fCityAutoCompleter.getC_City_ID());
        this.m_location.setPostal(this.fPostal.getText());
        this.m_location.setPostal_Add(this.fPostalAdd.getText());
        MCountry c = (MCountry)this.fCountry.getSelectedItem();
        this.m_location.setCountry(c);
        if (this.m_location.getCountry().isHasRegion()) {
            MRegion r = (MRegion)this.fRegion.getSelectedItem();
            this.m_location.setRegion(r);
            if (r != null && MRegion.HasCitys(r.getC_Region_ID())) {
                MCity ct = (MCity)this.fCity2.getSelectedItem();
                this.m_location.setMCity(ct);
            }
        } else {
            this.m_location.setC_Region_ID(0);
        }
        return this.m_location.save();
    }

    public boolean isChanged() {
        return this.m_change;
    }

    public MLocation getValue() {
        return this.m_location;
    }

    private String lookupPostcode(MCountry country, String postcode) {
        AddressLookupInterface pcLookup = null;
        try {
            AddressLookupInterface pcLookupTmp = (AddressLookupInterface)Class.forName(country.getLookupClassName()).newInstance();
            pcLookup = pcLookupTmp.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "lookupAddress(): " + e.getMessage();
        }
        postcode = postcode.replaceAll(" ", "").toUpperCase();
        log.fine("Looking up postcode: " + postcode);
        pcLookup.setServerUrl(country.getLookupUrl());
        pcLookup.setClientID(country.getLookupClientID());
        pcLookup.setPassword(country.getLookupPassword());
        if (pcLookup.lookupPostcode(postcode) != 1) {
            return "Postcode Lookup Error";
        }
        this.fillLocation(pcLookup.getAddressData(), country);
        this.fAddress1.requestFocusInWindow();
        return "";
    }

    private void fillLocation(HashMap<String, Object> postcodeData, MCountry country) {
        String warningTitle;
        String warningMsg;
        int response;
        if ((this.fAddress1 != null || this.fAddress2 != null || this.fAddress3 != null || this.fAddress4 != null || this.fCity != null) && (response = JOptionPane.showConfirmDialog(null, warningMsg = "Existing address information will be overwritten. Proceed?", warningTitle = "Warning", 0)) == 1) {
            return;
        }
        Set<String> pcodeKeys = postcodeData.keySet();
        Iterator<String> iterator = pcodeKeys.iterator();
        this.header = null;
        this.header = new Object[pcodeKeys.size()];
        String headerStr = null;
        if (pcodeKeys.size() > 2) {
            System.out.println("Too many postcodes returned from Postcode Lookup - need to Implement ResultData");
        } else {
            int i = 0;
            while ((headerStr = iterator.hasNext() ? iterator.next() : null) != null || iterator.hasNext()) {
                this.header[i] = headerStr;
                Postcode values = (Postcode)postcodeData.get(headerStr);
                this.fAddress1.setText(values.getStreet1());
                this.fAddress2.setText(values.getStreet2());
                this.fAddress3.setText(values.getStreet3());
                this.fAddress4.setText(values.getStreet4());
                this.fCity.setText(values.getCity());
                this.fPostal.setText(values.getPostcode());
                if (country.isHasRegion()) {
                    MRegion[] regions = MRegion.getRegions(country.getCtx(), country.getC_Country_ID());
                    if (regions.length > 0) {
                        boolean found = false;
                        i = 0;
                        while (i < regions.length && !found) {
                            if (regions[i].getName().equals(values.getRegion())) {
                                this.fRegion.setSelectedItem((Object)regions[i]);
                                log.fine("Found region: " + regions[i].getName());
                                found = true;
                            }
                            ++i;
                        }
                        if (!found) {
                            MRegion region = new MRegion(country, values.getRegion());
                            if (region.save()) {
                                log.fine("Added new region from web service: " + values.getRegion());
                                Env.reset((boolean)false);
                                this.fRegion = new CComboBox((Object[])MRegion.getRegions(Env.getCtx(), country.getC_Country_ID()));
                                this.fRegion.setSelectedItem((Object)values);
                            } else {
                                log.severe("Error saving new region: " + region.getName());
                            }
                        }
                    } else {
                        log.severe("Region lookup failed for Country: " + country.getName());
                    }
                }
                ++i;
            }
        }
    }

    public static MRefList[] getZones(Properties ctx) {
        ArrayList<MRefList> list = new ArrayList<MRefList>();
        String sql = "SELECT * FROM AD_Ref_List WHERE IsActive='Y' and AD_reference_ID=900000";
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                MRefList r = new MRefList(ctx, rs.getInt("AD_Ref_List_ID"), null);
                list.add(r);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        MRefList[] retValue = new MRefList[list.size()];
        list.toArray(retValue);
        Arrays.sort(retValue, new MRefList(ctx, 0, null));
        return retValue;
    }
}

