/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.CreateFromStatement;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VString;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MBankAccount;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VCreateFromStatementUI
extends CreateFromStatement
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private JLabel bankAccountLabel = new JLabel();
    protected VLookup bankAccountField;
    private CLabel documentNoLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
    protected CTextField documentNoField = new CTextField(10);
    private JLabel documentTypeLabel = new JLabel();
    protected VLookup documentTypeField;
    private JLabel authorizationLabel = new JLabel();
    protected VString authorizationField = new VString();
    private JLabel tenderTypeLabel = new JLabel();
    protected VLookup tenderTypeField;
    private CLabel amtFromLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"PayAmt"));
    protected VNumber amtFromField = new VNumber("AmtFrom", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
    private CLabel amtToLabel = new CLabel("-");
    protected VNumber amtToField = new VNumber("AmtTo", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
    protected CLabel BPartner_idLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    protected VLookup bPartnerLookup;
    private CLabel dateFromLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DateTrx"));
    protected VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    protected VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));

    public VCreateFromStatementUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow((Window)Env.getWindow((int)this.p_WindowNo), (Window)((Object)this.dialog));
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        CButton refreshButton = ConfirmPanel.createRefreshButton((boolean)false);
        refreshButton.setMargin(new Insets(1, 10, 0, 10));
        refreshButton.setDefaultCapable(true);
        refreshButton.addActionListener((ActionListener)this);
        this.dialog.getConfirmPanel().addButton((JButton)refreshButton);
        this.dialog.getRootPane().setDefaultButton((JButton)refreshButton);
        if (this.getGridTab().getValue("C_BankStatement_ID") == null) {
            ADialog.error((int)0, (Container)((Object)this.dialog), (String)"SaveErrorRowNotFound");
            return false;
        }
        this.dialog.setTitle(this.getTitle());
        int AD_Column_ID = 4917;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
        this.bankAccountField = new VLookup("C_BankAccount_ID", true, false, true, (Lookup)lookup);
        int C_BankAccount_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BankAccount_ID");
        this.bankAccountField.setValue(new Integer(C_BankAccount_ID));
        this.authorizationField = new VString("authorization", false, false, true, 10, 30, null, null);
        this.authorizationField.addActionListener((ActionListener)this);
        MLookup lookupDocument = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_Payment", (String)"C_DocType_ID"), (int)19);
        this.documentTypeField = new VLookup("C_DocType_ID", false, false, true, (Lookup)lookupDocument);
        this.documentTypeField.addActionListener(this);
        MLookup lookupTender = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_Payment", (String)"TenderType"), (int)17);
        this.tenderTypeField = new VLookup("TenderType", false, false, true, (Lookup)lookupTender);
        this.tenderTypeField.addActionListener(this);
        this.bPartnerLookup = new VLookup("C_BPartner_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)3499, (int)30));
        this.BPartner_idLabel.setLabelFor((Component)this.bPartnerLookup);
        Timestamp date = Env.getContextAsDate((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"StatementDate");
        this.dateToField.setValue((Object)date);
        this.bankAccount = new MBankAccount(Env.getCtx(), C_BankAccount_ID, null);
        this.loadBankAccount();
        return true;
    }

    private void jbInit() throws Exception {
        this.bankAccountLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BankAccount_ID"));
        this.authorizationLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"R_AuthCode"));
        this.documentTypeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        this.tenderTypeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"TenderType"));
        this.documentNoLabel.setLabelFor((Component)this.documentNoField);
        this.dateFromLabel.setLabelFor((Component)this.dateFromField);
        this.dateFromField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateToLabel.setLabelFor((Component)this.dateToField);
        this.dateToField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        this.amtFromLabel.setLabelFor((Component)this.amtFromField);
        this.amtFromField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
        this.amtToLabel.setLabelFor((Component)this.amtToField);
        this.amtToField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout((LayoutManager)new BorderLayout());
        CPanel parameterBankPanel = new CPanel();
        parameterBankPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)parameterBankPanel, (Object)"Center");
        parameterBankPanel.add((Component)this.bankAccountLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bankAccountField != null) {
            parameterBankPanel.add((Component)this.bankAccountField, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.documentTypeLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.documentTypeField != null) {
            parameterBankPanel.add((Component)this.documentTypeField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.tenderTypeLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.tenderTypeField != null) {
            parameterBankPanel.add((Component)this.tenderTypeField, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.BPartner_idLabel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.bPartnerLookup, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.documentNoLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.documentNoField, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.authorizationLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.authorizationField, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.amtFromLabel, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.amtFromField, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.amtToLabel, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.amtToField, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.dateFromLabel, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.dateFromField, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.dateToLabel, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.dateToField, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (e.getActionCommand().equals("Refresh")) {
            Cursor.getPredefinedCursor(3);
            this.loadBankAccount();
            this.dialog.tableChanged(null);
            Cursor.getPredefinedCursor(0);
        }
    }

    protected void loadBankAccount() {
        this.loadTableOIS(this.getBankData(this.documentNoField.getText(), this.bPartnerLookup.getValue(), this.dateFromField.getValue(), this.dateToField.getValue(), this.amtFromField.getValue(), this.amtToField.getValue(), this.documentTypeField.getValue(), this.tenderTypeField.getValue(), this.authorizationField.getText()));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
        model.addTableModelListener(this.dialog);
    }

    @Override
    public void info() {
        DecimalFormat format = DisplayType.getNumberFormat((int)12);
        BigDecimal total = new BigDecimal(0.0);
        int rows = this.dialog.getMiniTable().getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)this.dialog.getMiniTable().getValueAt(i, 0)).booleanValue()) {
                total = total.add((BigDecimal)this.dialog.getMiniTable().getValueAt(i, 4));
                ++count;
            }
            ++i;
        }
        this.dialog.setStatusLine(count, String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Sum")) + "  " + format.format(total));
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }
}

