/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.X_C_PaymentMassive;
import org.compiere.model.X_C_PaymentMassiveLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromPaymentMassive
extends CreateFrom {
    public CreateFromPaymentMassive(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle("Pago Masivo");
        return true;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX='N' AND r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND NOT EXISTS (SELECT * FROM C_Invoice inv WHERE inv.M_RMA_ID=r.M_RMA_ID AND inv.DocStatus IN ('CO', 'CL'))";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, String.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, BigDecimal.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, Timestamp.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.config("");
        int rows = miniTable.getRowCount();
        if (rows == 0) {
            return false;
        }
        BigDecimal TotalAmt = new BigDecimal("0.0");
        X_C_PaymentMassive massive = new X_C_PaymentMassive(Env.getCtx(), (Integer)this.getGridTab().getValue("C_PaymentMassive_ID"), null);
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                int C_Invoice_ID = 0;
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal openAmt = (BigDecimal)miniTable.getValueAt(i, 4);
                X_C_PaymentMassiveLine line = new X_C_PaymentMassiveLine(Env.getCtx(), 0, null);
                line.setC_Invoice_ID(C_Invoice_ID);
                line.setAD_Org_ID(massive.getAD_Org_ID());
                line.setPayAmt(openAmt);
                line.setC_PaymentMassive_ID(massive.getC_PaymentMassive_ID());
                line.saveEx();
                TotalAmt = TotalAmt.add(openAmt);
            }
            ++i;
        }
        TotalAmt = DB.getSQLValueBD(null, (String)("select sum(payamt) from C_PaymentMassiveLine where C_PaymentMassive_ID=" + massive.getC_PaymentMassive_ID()), (Object[])new Object[0]);
        massive.setPayAmt(TotalAmt);
        massive.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add("Documento");
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"));
        columnNames.add("Pendiente");
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        return columnNames;
    }
}

