/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisitionLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromOrder
extends CreateFrom {
    public CreateFromOrder(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID", (boolean)false)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX='N' AND r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND NOT EXISTS (SELECT * FROM C_Invoice inv WHERE inv.M_RMA_ID=r.M_RMA_ID AND inv.DocStatus IN ('CO', 'CL'))";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, BigDecimal.class, true);
        miniTable.setColumnClass(9, BigDecimal.class, true);
        miniTable.setColumnClass(10, Integer.class, true);
        miniTable.setColumnClass(11, Integer.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.config("");
        int Order_ID = (Integer)this.getGridTab().getValue("C_Order_ID");
        MOrder newOrder = new MOrder(Env.getCtx(), Order_ID, null);
        this.log.config("**doctype " + newOrder.getC_DocTypeTarget_ID());
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                boolean OK;
                KeyNamePair charge_id;
                MOrderLine line = new MOrderLine(newOrder);
                BigDecimal valor = (BigDecimal)miniTable.getValueAt(i, 9);
                this.log.config("valor:" + valor);
                line.setPrice(valor);
                KeyNamePair product_id = (KeyNamePair)miniTable.getValueAt(i, 5);
                if (product_id.getKey() > 0) {
                    line.setProduct(new MProduct(Env.getCtx(), product_id.getKey(), null));
                }
                if ((charge_id = (KeyNamePair)miniTable.getValueAt(i, 6)).getKey() > 0) {
                    line.setC_Charge_ID(charge_id.getKey());
                }
                if (product_id.getKey() <= 0 && charge_id.getKey() <= 0) {
                    int prod = DB.getSQLValue((String)trxName, (String)"SELECT m_product_id from m_product where value like 'EST'");
                    line.setM_Product_ID(prod);
                }
                line.setQtyOrdered((BigDecimal)miniTable.getValueAt(i, 8));
                line.setQtyEntered((BigDecimal)miniTable.getValueAt(i, 8));
                Integer project = (Integer)miniTable.getValueAt(i, 11);
                if (project > 0) {
                    line.set_ValueOfColumn("C_Project_ID", (int)project);
                }
                Integer requiline = (Integer)miniTable.getValueAt(i, 10);
                line.set_ValueOfColumn("M_RequisitionLine_ID", (int)requiline);
                line.setDescription((String)miniTable.getValueAt(i, 7));
                line.setAD_Org_ID(new MRequisitionLine(Env.getCtx(), requiline.intValue(), null).getAD_Org_ID());
                MRequisitionLine rLine = new MRequisitionLine(Env.getCtx(), requiline.intValue(), null);
                if (!rLine.get_ValueAsString("Help").equals("")) {
                    line.set_CustomColumn("Help", rLine.get_ValueAsString("Help"));
                }
                if (OK = line.save()) {
                    DB.executeUpdate((String)("update M_RequisitionLine set C_ORDERLINE_ID=" + line.getC_OrderLine_ID() + " where M_RequisitionLine_ID=" + (Integer)miniTable.getValueAt(i, 10)), null);
                }
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"DateRequired"));
        columnNames.add("Usuario");
        columnNames.add("NoSolicitud");
        columnNames.add("Proyecto/OT");
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"ProductName"));
        columnNames.add("Cargo");
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Price"));
        columnNames.add("Control");
        columnNames.add("Seguimiento");
        return columnNames;
    }
}

