/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class InfoInvoice
extends Info {
    private static final long serialVersionUID = 2119484421367033632L;
    private int fieldID = 0;
    private CLabel lDocumentNo = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lDescription = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private CTextField fDescription = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lOrder_ID = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"C_Order_ID"));
    private VLookup fOrder_ID;
    private VCheckBox fIsPaid = new VCheckBox("IsPaid", false, false, true, Msg.translate((Properties)Env.getCtx(), (String)"IsPaid"), "", false);
    private VCheckBox fIsSOTrx = new VCheckBox("IsSOTrx", false, false, true, Msg.translate((Properties)Env.getCtx(), (String)"IsSOTrx"), "", false);
    private CLabel lDateFrom = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DateInvoiced"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private CLabel lDateTo = new CLabel("-  ");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
    private CLabel lAmtTo = new CLabel("-  ");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
    private int m_C_Invoice_ID = 0;
    private MiniTable scheduleTbl = new MiniTable();
    private String m_sqlSchedule;
    private CPanel tablePanel = new CPanel();
    private static String s_From = " C_Invoice i";
    private static String s_Order = "2,3";
    private static final Info_Column[] s_Layout = new Info_Column[]{new Info_Column(" ", "i.C_Invoice_ID", IDColumn.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"DateInvoiced"), "i.DateInvoiced", Timestamp.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"), "i.DocumentNo", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=i.C_Currency_ID)", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"), "i.GrandTotal", BigDecimal.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"ConvertedAmount"), "currencyBase(i.GrandTotal, i.C_Currency_ID, i.DateAcct, i.AD_Client_ID, i.AD_Org_ID)", BigDecimal.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"OpenAmt"), "invoiceOpen(C_Invoice_ID,0)", BigDecimal.class, true, true, null), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"C_PaymentTerm_ID"), "(SELECT pt.Name FROM C_PaymentTerm pt WHERE pt.C_PaymentTerm_ID = i.C_PaymentTerm_ID)", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"IsPaid"), "i.IsPaid", Boolean.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"IsSOTrx"), "i.IsSOTrx", Boolean.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Description"), "i.Description", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"POReference"), "i.POReference", String.class), new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"DocStatus"), "i.docstatus", String.class)};
    private static String s_subFrom = " C_Invoice_v i";
    private static String s_subWhere = "i.C_Invoice_ID = ?";
    private static String numPayments = "COALESCE((SELECT COUNT(ps.C_PaymentTerm_ID) \t\tFROM \t\t\tC_PaySchedule ps, C_InvoicePaySchedule cips \t\tWHERE \t\t\tps.C_PaySchedule_ID = cips.C_PaySchedule_ID \t\t\tAND cips.C_INVOICE_ID = i.C_Invoice_ID \t\t\tAND cips.duedate <= i.duedate \t\tGROUP BY ps.C_PaymentTerm_ID),1)  || ' / ' || \t\tCOALESCE((SELECT COUNT(ps.C_PaymentTerm_ID) AS maxpayno \t\t    FROM  \t\t\tC_PaySchedule ps, C_InvoicePaySchedule cips \t\tWHERE  \t\t\tps.C_PaySchedule_ID = cips.C_PaySchedule_ID \t\t\tAND cips.C_INVOICE_ID = i.C_Invoice_ID \t\tGROUP BY ps.C_PaymentTerm_ID),1)";
    private static ColumnInfo[] s_subLayout = new ColumnInfo[]{new ColumnInfo(" ", "i.C_InvoicePaySchedule_ID", IDColumn.class), new ColumnInfo(Msg.getMsg((Properties)Env.getCtx(), (String)"Payment #"), numPayments, String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"DueDate"), "i.DueDate", Timestamp.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=i.C_Currency_ID)", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"), "i.GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"ConvertedAmount"), "currencyBase(i.GrandTotal, i.C_Currency_ID, i.DateAcct, i.AD_Client_ID, i.AD_Org_ID)", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"OpenAmt"), "invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID)", BigDecimal.class, true, true, null), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"IsPaid"), "CASE WHEN invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID) <= 0 THEN 'Y' ELSE 'N' END", Boolean.class)};

    @Deprecated
    protected InfoInvoice(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, multiSelection, true, whereClause);
    }

    protected InfoInvoice(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "i", "C_Invoice_ID", multiSelection, saveResults, whereClause);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoInvoice"));
        StringBuffer where = new StringBuffer("i.IsActive='Y'");
        if (whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace((String)whereClause, (String)"C_Invoice.", (String)"i."));
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause(s_Order);
        this.setShowTotals(true);
        this.statInit();
        this.initInfo(record_id, value);
        this.m_heldLastFocus = this.fDocumentNo;
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow((Window)frame, (Window)((Object)this));
    }

    private void statInit() {
        this.lDocumentNo.setLabelFor((Component)this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener((ActionListener)((Object)this));
        this.lDescription.setLabelFor((Component)this.fDescription);
        this.fDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fDescription.addActionListener((ActionListener)((Object)this));
        this.fIsPaid.setSelected(false);
        this.fIsPaid.addActionListener((ActionListener)((Object)this));
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"IsSOTrx")));
        this.fIsSOTrx.addActionListener((ActionListener)((Object)this));
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_Invoice", (String)"C_BPartner_ID"), (int)30));
        this.lBPartner_ID.setLabelFor((Component)this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBPartner_ID.addActionListener((ActionListener)((Object)this));
        this.fOrder_ID = new VLookup("C_Order_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_Invoice", (String)"C_Order_ID"), (int)30));
        this.lOrder_ID.setLabelFor((Component)this.fOrder_ID);
        this.fOrder_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fOrder_ID.addActionListener((ActionListener)((Object)this));
        this.lDateFrom.setLabelFor((Component)this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.lDateTo.setLabelFor((Component)this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        this.lAmtFrom.setLabelFor((Component)this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"AmtFrom"));
        this.lAmtTo.setLabelFor((Component)this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"AmtTo"));
        CPanel amtPanel = new CPanel();
        CPanel datePanel = new CPanel();
        amtPanel.setLayout((LayoutManager)new ALayout(0, 0, true));
        amtPanel.add((Component)this.fAmtFrom, (Object)new ALayoutConstraint(0, 0));
        amtPanel.add((Component)this.lAmtTo, null);
        amtPanel.add((Component)this.fAmtTo, null);
        datePanel.setLayout((LayoutManager)new ALayout(0, 0, true));
        datePanel.add((Component)this.fDateFrom, (Object)new ALayoutConstraint(0, 0));
        datePanel.add((Component)this.lDateTo, null);
        datePanel.add((Component)this.fDateTo, null);
        this.p_criteriaGrid.add((Component)this.lDocumentNo, (Object)new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fDocumentNo, null);
        this.p_criteriaGrid.add((Component)this.lBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.fBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.fIsSOTrx, (Object)new ALayoutConstraint(0, 5));
        this.p_criteriaGrid.add((Component)this.lDescription, (Object)new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fDescription, null);
        this.p_criteriaGrid.add((Component)this.lDateFrom, null);
        this.p_criteriaGrid.add((Component)datePanel, null);
        this.p_criteriaGrid.add((Component)this.fIsPaid, (Object)new ALayoutConstraint(1, 5));
        this.p_criteriaGrid.add((Component)this.lOrder_ID, (Object)new ALayoutConstraint(2, 0));
        this.p_criteriaGrid.add((Component)this.fOrder_ID, null);
        this.p_criteriaGrid.add((Component)this.lAmtFrom, null);
        this.p_criteriaGrid.add((Component)amtPanel, null);
        this.m_sqlSchedule = this.scheduleTbl.prepareTable(s_subLayout, s_subFrom, s_subWhere, false, "i");
        this.scheduleTbl.setRowSelectionAllowed(true);
        this.scheduleTbl.setMultiSelection(false);
        this.scheduleTbl.addMouseListener((MouseListener)((Object)this));
        this.scheduleTbl.setShowTotals(true);
        this.scheduleTbl.autoSize();
        this.tablePanel.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 255 : 110));
        this.tablePanel.setLayout((LayoutManager)new BorderLayout());
        this.tablePanel.add((Component)new JScrollPane((Component)((Object)this.scheduleTbl)), (Object)"Center");
        this.p_detailTaskPane.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"C_InvoicePaySchedule_ID"));
        this.p_detailTaskPane.add((Component)this.tablePanel, (Object)"Center");
        this.p_detailTaskPane.setVisible(true);
    }

    @Override
    protected void initInfo(int record_id, String value) {
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
            String trxName = Trx.createTrxName();
            MInvoice mi = new MInvoice(Env.getCtx(), record_id, trxName);
            this.fIsPaid.setSelected(mi.isPaid());
            this.fIsSOTrx.setSelected(mi.isSOTrx());
            mi = null;
            Trx.get((String)trxName, (boolean)false).close();
        } else {
            String id = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)this.p_TabNo, (String)"C_BPartner_ID", (boolean)true);
            if (id != null && id.length() != 0 && new Integer(id) > 0) {
                this.fBPartner_ID.setValue(new Integer(id));
            }
            if ((id = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)this.p_TabNo, (String)"C_Order_ID", (boolean)true)) != null && id.length() != 0 && new Integer(id) > 0) {
                this.fOrder_ID.setValue(new Integer(id));
            }
            if ((id = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"IsSOTrx", (boolean)true)) != null && id.length() != 0 && (id == "Y" || id == "N")) {
                this.fIsSOTrx.setSelected(id == "Y");
            }
            if (value != null && value.length() > 0) {
                this.fDocumentNo.setValue((Object)value);
            } else {
                id = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)this.p_TabNo, (String)"C_Invoice_ID", (boolean)true);
                if (id != null && id.length() != 0 && new Integer(id) > 0) {
                    this.fieldID = new Integer(id);
                    String trxName = Trx.createTrxName();
                    MInvoice mi = new MInvoice(Env.getCtx(), record_id, trxName);
                    this.fIsPaid.setSelected(mi.isPaid());
                    this.fIsSOTrx.setSelected(mi.isSOTrx());
                    mi = null;
                    Trx.get((String)trxName, (boolean)false).close();
                }
            }
        }
    }

    @Override
    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            sql.append(" AND i.C_Invoice_ID = ?");
        }
        if (InfoInvoice.isValidSQLText(this.fDocumentNo)) {
            sql.append(" AND UPPER(i.DocumentNo) LIKE ?");
        }
        if (InfoInvoice.isValidSQLText(this.fDescription)) {
            sql.append(" AND UPPER(i.Description) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND i.C_BPartner_ID=?");
        }
        if (this.fOrder_ID.getValue() != null) {
            sql.append(" AND i.C_Order_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(i.DateInvoiced, 'DD') <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(i.DateInvoiced, 'DD') >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(i.DateInvoiced, 'DD') BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND i.GrandTotal <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND i.GrandTotal >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND i.GrandTotal BETWEEN ? AND ?");
            }
        }
        sql.append(" AND i.IsPaid=? AND i.IsSOTrx=?");
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
        }
        if (InfoInvoice.isValidSQLText(this.fDocumentNo)) {
            pstmt.setString(index++, InfoInvoice.getSQLText(this.fDocumentNo));
        }
        if (InfoInvoice.isValidSQLText(this.fDescription)) {
            pstmt.setString(index++, InfoInvoice.getSQLText(this.fDescription));
        }
        if (this.fBPartner_ID.getValue() != null) {
            Integer bp = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (this.fOrder_ID.getValue() != null) {
            Integer order = (Integer)this.fOrder_ID.getValue();
            pstmt.setInt(index++, order);
            this.log.fine("Order=" + order);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        pstmt.setString(index++, this.fIsPaid.isSelected() ? "Y" : "N");
        pstmt.setString(index++, this.fIsSOTrx.isSelected() ? "Y" : "N");
    }

    @Override
    protected void recordSelected(int key) {
        if (this.m_C_Invoice_ID != key) {
            this.refresh();
        }
        this.p_detailTaskPane.setCollapsed(false);
    }

    @Override
    protected void noRecordSelected() {
        this.m_C_Invoice_ID = 0;
        this.p_detailTaskPane.setCollapsed(true);
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block6: {
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    int leadRowKey = InfoInvoice.this.p_table.getLeadRowKey();
                    if (InfoInvoice.this.m_C_Invoice_ID != leadRowKey) {
                        InfoInvoice.this.m_C_Invoice_ID = leadRowKey;
                        String sql = InfoInvoice.this.m_sqlSchedule;
                        InfoInvoice.this.log.finest(sql);
                        try {
                            try {
                                pstmt = DB.prepareStatement((String)sql, null);
                                pstmt.setInt(1, InfoInvoice.this.m_C_Invoice_ID);
                                rs = pstmt.executeQuery();
                                InfoInvoice.this.scheduleTbl.loadTable(rs);
                                rs.close();
                            }
                            catch (Exception e) {
                                InfoInvoice.this.log.log(Level.WARNING, sql, (Throwable)e);
                                DB.close(rs, (Statement)pstmt);
                                rs = null;
                                pstmt = null;
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                    }
                }
            }
        });
    }

    @Override
    protected void zoom(int record_ID) {
        this.log.info("InfoInvoice.zoom");
        Integer C_Invoice_ID = record_ID;
        if (C_Invoice_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_Invoice");
        query.addRestriction("C_Invoice_ID", "=", (Object)C_Invoice_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Invoice", this.fIsSOTrx.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected void saveSelectionDetail() {
        Integer ID = this.getSelectedRowKey();
        Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_Invoice_ID", (String)(ID == null ? "0" : ID.toString()));
        int C_InvoicePaySchedule_ID = this.scheduleTbl.getSelectedRowKey();
        if (C_InvoicePaySchedule_ID <= 0) {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID", (String)"0");
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID", (String)String.valueOf(C_InvoicePaySchedule_ID));
        }
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fDocumentNo.hasChanged() || this.fDescription.hasChanged() || this.fIsPaid.hasChanged() || this.fIsSOTrx.hasChanged() || this.fBPartner_ID.hasChanged() || this.fOrder_ID.hasChanged() || this.fAmtFrom.hasChanged() || this.fAmtTo.hasChanged() || this.fDateFrom.hasChanged() || this.fDateTo.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fAmtFrom.set_oldValue();
        this.fAmtTo.set_oldValue();
        this.fDocumentNo.set_oldValue();
        this.fDescription.set_oldValue();
        this.fIsPaid.set_oldValue();
        this.fIsSOTrx.set_oldValue();
        this.fBPartner_ID.set_oldValue();
        this.fOrder_ID.set_oldValue();
        this.fDateFrom.set_oldValue();
        this.fDateTo.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        Object nullObject = null;
        this.fDocumentNo.setValue((Object)"");
        this.fDescription.setValue((Object)"");
        this.fIsPaid.setSelected(false);
        this.fBPartner_ID.setValue(null);
        this.fOrder_ID.setValue(null);
        this.fDateFrom.setValue(nullObject);
        this.fDateTo.setValue(nullObject);
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"IsSOTrx")));
    }
}

