/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_MP_OT;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.print.ReportViewerProvider;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VMPProgrammingOT
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener,
ASyncProcess {
    private static final long serialVersionUID = -5322824600164192235L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VMPProgrammingOT.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private CPanel mainPanel = new CPanel();
    private CPanel parameterPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel allocationPanel = new CPanel();
    private MiniTable otTable = new MiniTable();
    private CPanel infoPanel = new CPanel();
    private int m_A_Asset_ID = 0;
    private int m_AD_User_ID = 0;
    private CPanel otPanel = new CPanel();
    private JLabel otLabel = new JLabel();
    private BorderLayout otLayout = new BorderLayout();
    private JLabel otInfo = new JLabel();
    private JScrollPane otScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton ProcessButton = new JButton();
    private JButton searchButton = new JButton();
    private JButton setButton = new JButton();
    private JButton EnableButton = new JButton();
    private JButton ChangeButton = new JButton();
    private JLabel assetLabel = new JLabel();
    private JCheckBox selectall = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private VLookup assetSearch = null;
    private VLookup userSearch = null;

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)"Y");
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)((Object)this));
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.dateLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.dateLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocDate", (boolean)false));
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.allocationPanel.setLayout((LayoutManager)this.allocationLayout);
        this.otLabel.setRequestFocusEnabled(false);
        this.otLabel.setText("OT List");
        this.otPanel.setLayout((LayoutManager)this.otLayout);
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.ProcessButton.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Print"));
        this.ProcessButton.addActionListener(this);
        this.searchButton.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Search"));
        this.searchButton.addActionListener(this);
        this.setButton.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"set User"));
        this.setButton.addActionListener(this);
        this.EnableButton.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Enable Editing"));
        this.EnableButton.addActionListener(this);
        this.ChangeButton.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"set Date"));
        this.ChangeButton.addActionListener(this);
        this.assetLabel.setText("Usuario");
        this.selectall.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Seleccionar Todo"));
        this.selectall.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.otScrollPane.setPreferredSize(new Dimension(300, 300));
        this.mainPanel.add((Component)this.parameterPanel, (Object)"North");
        this.parameterPanel.add((Component)this.dateLabel, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.ChangeButton, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.selectall, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.assetLabel, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.userSearch, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.setButton, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, (Object)"South");
        this.allocationPanel.add((Component)this.selectall, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.ProcessButton, (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.otPanel.add((Component)this.otLabel, (Object)"North");
        this.otPanel.add((Component)this.otInfo, (Object)"South");
        this.otPanel.add((Component)this.otScrollPane, (Object)"Center");
        this.otScrollPane.getViewport().add((Component)((Object)this.otTable), null);
        this.mainPanel.add((Component)this.infoPanel, (Object)"Center");
        this.infoPanel.setLayout((LayoutManager)new BorderLayout());
        this.infoPanel.add((Component)this.otPanel, (Object)"Center");
        this.infoPanel.setPreferredSize(new Dimension(1000, 450));
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID((String)"MP_OT", (String)"AD_User_ID");
        MLookup lookupUs = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.userSearch = new VLookup("AD_User_ID", true, false, true, (Lookup)lookupUs);
        this.userSearch.addVetoableChangeListener(this);
        this.dateField.setValue((Object)Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.statusBar.setStatusLine("Seleccione la mantencion, cambie la fecha pronosticada o genere directamente la OT ");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select o.DATETRX,doc.name,o.DOCUMENTNO,o.AD_USER_ID,o.DESCRIPTION, o.MP_OT_ID, u.name, o.A_Asset_ID, a.name as AssetName From MP_OT o  inner join A_Asset a on (o.A_Asset_ID=a.A_Asset_ID) inner join C_DocType doc on (o.C_DocType_ID=doc.C_DocType_ID) Left Outer Join AD_User u on(o.AD_User_ID=u.AD_User_ID) where o.DOCSTATUS='DR' and not exists  (select * from MP_OT_TASK t where t.STATUS<>'NS' and t.MP_OT_ID=o.MP_OT_ID)");
        sql.append(" and o.AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
        log.config("ot=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                line.add(rs.getString(2));
                KeyNamePair pp = new KeyNamePair(rs.getInt(6), rs.getString(3));
                line.add(pp);
                KeyNamePair pp3 = new KeyNamePair(rs.getInt(8), rs.getString(9));
                line.add(pp3);
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(4), rs.getString(7));
                line.add(pp2);
                line.add(rs.getString(5));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.otTable.getModel().removeTableModelListener(this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Seleccionar");
        columnNames.add("Fecha Programada");
        columnNames.add("Tipo OT");
        columnNames.add("Documento");
        columnNames.add("Activo");
        columnNames.add("Usuario");
        columnNames.add("Descripcion");
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.otTable.setModel(modelP);
        int i = 0;
        this.otTable.setColumnClass(i++, Boolean.class, false);
        this.otTable.setColumnClass(i++, Timestamp.class, false);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.autoSize();
        this.otTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.ProcessButton)) {
            this.saveData();
        } else if (e.getSource().equals(this.ChangeButton)) {
            this.ProcessButton.setEnabled(true);
            TableModel ot = this.otTable.getModel();
            int rows = ot.getRowCount();
            Timestamp DateTrx = (Timestamp)this.dateField.getValue();
            int i = 0;
            while (i < rows) {
                if (((Boolean)ot.getValueAt(i, 0)).booleanValue()) {
                    KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 3);
                    int OT_ID = pp.getKey();
                    X_MP_OT currentOT = new X_MP_OT(Env.getCtx(), OT_ID, null);
                    currentOT.setDateTrx(DateTrx);
                    currentOT.save();
                }
                ++i;
            }
            this.loadMPs();
        } else if (e.getSource().equals(this.setButton)) {
            TableModel ot = this.otTable.getModel();
            int rows = ot.getRowCount();
            if (this.m_AD_User_ID != 0) {
                int i = 0;
                while (i < rows) {
                    if (((Boolean)ot.getValueAt(i, 0)).booleanValue()) {
                        KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 3);
                        int OT_ID = pp.getKey();
                        X_MP_OT currentOT = new X_MP_OT(Env.getCtx(), OT_ID, null);
                        currentOT.setAD_User_ID(this.m_AD_User_ID);
                        currentOT.save();
                    }
                    ++i;
                }
                this.loadMPs();
            }
        } else if (e.getSource().equals(this.selectall)) {
            TableModel ot = this.otTable.getModel();
            int rows = ot.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    ot.setValueAt(this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 6);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        ot.setValueAt(this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            this.m_A_Asset_ID = (Integer)value;
        } else if (name.equals("AD_User_ID")) {
            this.userSearch.setValue(value);
            this.m_AD_User_ID = (Integer)value;
        }
    }

    private void saveData() {
        TableModel ot = this.otTable.getModel();
        int rows = ot.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((Boolean)ot.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 3);
                int OT_ID = pp.getKey();
                try {
                    X_MP_OT currentOT = new X_MP_OT(Env.getCtx(), OT_ID, null);
                    MDocType doc = new MDocType(Env.getCtx(), currentOT.getC_DocType_ID(), null);
                    int AD_PrintFormat_ID = doc.getAD_PrintFormat_ID();
                    int C_BPartner_ID = 0;
                    String DocumentNo = currentOT.getDocumentNo();
                    int copies = 1;
                    MPrintFormat format = MPrintFormat.get((Properties)Env.getCtx(), (int)AD_PrintFormat_ID, (boolean)false);
                    MQuery query = new MQuery("MP_OT");
                    query.addRestriction("MP_OT_ID", "=", (Object)new Integer(OT_ID));
                    PrintInfo info = new PrintInfo(DocumentNo, X_MP_OT.Table_ID, OT_ID, C_BPartner_ID);
                    info.setCopies(copies);
                    info.setDocumentCopy(false);
                    info.setPrinterName(format.getPrinterName());
                    ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info, null);
                    ReportViewerProvider provider = ReportCtl.getReportViewerProvider();
                    provider.openViewer(re);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No se Encuetra bien definido el formato de impresion", "Error", 0);
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    public void lockUI(ProcessInfo pi) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setEnabled(false);
    }

    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean isUILocked() {
        return this.isEnabled();
    }

    public void executeASync(ProcessInfo pi) {
    }
}

