/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.AllocationBL360;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.VAllocation;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.Lookup;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MRole;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class VAllocationBp
extends AllocationBL360
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    private static final int INDICATOR_NONE = 0;
    private static final int INDICATOR_TOTAL_PAY = 1;
    private static final int INDICATOR_SUBPAYMENT_SO = 2;
    private static final int INDICATOR_GREATER_PAYMENT_SO = 3;
    private static final int INDICATOR_GREATER_PAYMENT_PO = 5;
    private static final int INDICATOR_SUBPAYMENT_PO = 6;
    private static final int INDICATOR_VERSUS_INVOICE = 7;
    private static final int INDICATOR_VERSUS_SUBINVOICE = 8;
    private static final int INDICATOR_VERSUS_PAYMENT = 10;
    private static final int INDICATOR_VERSUS_SUBPAYMENT = 11;
    BigDecimal totalPayment = new BigDecimal(0.0);
    BigDecimal totalInvoiced = new BigDecimal(0.0);
    BigDecimal totalCredit = new BigDecimal(0.0);
    BigDecimal pvspamt = new BigDecimal(0.0);
    int indicator = 0;
    boolean multiprocess = false;
    private static final long serialVersionUID = -5322824600164192235L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VAllocation.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private int m_C_BPartner_ID = 0;
    private int m_C_BPartner2_ID = 0;
    private int m_noInvoices = 0;
    private int m_noPayments = 0;
    private BigDecimal totalInv = new BigDecimal(0.0);
    private BigDecimal totalPay = new BigDecimal(0.0);
    private BigDecimal totalDiff = new BigDecimal(0.0);
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    private int i_overUnder = 10;
    private int i_cuota = 11;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel allocationPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel bpartnerLabel = new JLabel();
    private VLookup bpartnerSearch = null;
    private JLabel bpartnerLabel2 = new JLabel();
    private VLookup bpartnerSearch2 = null;
    private MiniTable invoiceTable = new MiniTable();
    private MiniTable paymentTable = new MiniTable();
    private JSplitPane infoPanel = new JSplitPane();
    private CPanel paymentPanel = new CPanel();
    private CPanel invoicePanel = new CPanel();
    private JLabel paymentLabel = new JLabel();
    private JLabel invoiceLabel = new JLabel();
    private BorderLayout paymentLayout = new BorderLayout();
    private BorderLayout invoiceLayout = new BorderLayout();
    private JLabel paymentInfo = new JLabel();
    private JLabel invoiceInfo = new JLabel();
    private JScrollPane paymentScrollPane = new JScrollPane();
    private JScrollPane invoiceScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton allocateButton = new JButton();
    private JLabel currencyLabel = new JLabel();
    private VLookup currencyPick = null;
    private JCheckBox multiCurrency = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private JCheckBox autoWriteOff = new JCheckBox();
    private int m_AD_Org_ID = 0;
    private JLabel organizationLabel = new JLabel();
    private VLookup organizationPick = null;
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)"Y");
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.jbInit();
            this.calculate();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)this.panel);
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.dateLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.dateLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocDate", (boolean)false));
        this.autoWriteOff.setSelected(false);
        this.autoWriteOff.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)true));
        this.autoWriteOff.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)false));
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.allocationPanel.setLayout((LayoutManager)this.allocationLayout);
        this.bpartnerLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.paymentLabel.setRequestFocusEnabled(false);
        this.paymentLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Payment_ID"));
        this.invoiceLabel.setRequestFocusEnabled(false);
        this.invoiceLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
        this.paymentPanel.setLayout((LayoutManager)this.paymentLayout);
        this.invoicePanel.setLayout((LayoutManager)this.invoiceLayout);
        this.invoiceInfo.setHorizontalAlignment(4);
        this.invoiceInfo.setHorizontalTextPosition(4);
        this.invoiceInfo.setText(".");
        this.paymentInfo.setHorizontalAlignment(4);
        this.paymentInfo.setHorizontalTextPosition(4);
        this.paymentInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.allocateButton.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"));
        this.allocateButton.addActionListener(this);
        this.currencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.multiCurrency.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"MultiCurrency"));
        this.multiCurrency.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.invoiceScrollPane.setPreferredSize(new Dimension(200, 200));
        this.paymentScrollPane.setPreferredSize(new Dimension(200, 200));
        this.mainPanel.add((Component)this.parameterPanel, (Object)"North");
        this.organizationLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.parameterPanel.add((Component)this.organizationLabel, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.organizationPick, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerSearch, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerLabel2, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerSearch2, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyPick, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.multiCurrency, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.autoWriteOff, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, (Object)"South");
        this.allocationPanel.add((Component)this.differenceLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.allocationPanel.add((Component)this.differenceField, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocateButton, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocCurrencyLabel, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.paymentPanel.add((Component)this.paymentLabel, (Object)"North");
        this.paymentPanel.add((Component)this.paymentInfo, (Object)"South");
        this.paymentPanel.add((Component)this.paymentScrollPane, (Object)"Center");
        this.paymentScrollPane.getViewport().add((Component)((Object)this.paymentTable), null);
        this.invoicePanel.add((Component)this.invoiceLabel, (Object)"North");
        this.invoicePanel.add((Component)this.invoiceInfo, (Object)"South");
        this.invoicePanel.add((Component)this.invoiceScrollPane, (Object)"Center");
        this.invoiceScrollPane.getViewport().add((Component)((Object)this.invoiceTable), null);
        this.mainPanel.add((Component)this.infoPanel, (Object)"Center");
        this.infoPanel.setOrientation(0);
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.infoPanel.setTopComponent((Component)this.paymentPanel);
        this.infoPanel.setBottomComponent((Component)this.invoicePanel);
        this.infoPanel.add((Component)this.paymentPanel, "top");
        this.infoPanel.add((Component)this.invoicePanel, "bottom");
        this.infoPanel.setContinuousLayout(true);
        this.infoPanel.setPreferredSize(new Dimension(800, 250));
        this.infoPanel.setDividerLocation(110);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void dynInit() throws Exception {
        int AD_Column_ID = 3505;
        MLookup lookupCur = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
        this.currencyPick = new VLookup("C_Currency_ID", true, false, true, (Lookup)lookupCur);
        this.currencyPick.setValue(new Integer(this.m_C_Currency_ID));
        this.currencyPick.addVetoableChangeListener(this);
        AD_Column_ID = 1404;
        MLookup lookupOrg = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)19);
        this.organizationPick = new VLookup("AD_Org_ID", true, false, true, (Lookup)lookupOrg);
        this.organizationPick.setValue(Env.getAD_Org_ID((Properties)Env.getCtx()));
        this.organizationPick.addVetoableChangeListener(this);
        this.m_AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
        AD_Column_ID = 3499;
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bpartnerSearch = new VLookup("C_BPartner_ID", true, false, true, (Lookup)lookupBP);
        this.bpartnerSearch.addVetoableChangeListener(this);
        AD_Column_ID = 5398;
        MLookup lookupBP2 = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bpartnerSearch2 = new VLookup("C_BPartner_ID", true, false, true, (Lookup)lookupBP2);
        this.bpartnerSearch2.addVetoableChangeListener(this);
        this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocateStatus"));
        this.statusBar.setStatusDB("");
        this.dateField.setValue((Object)Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.dateField.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private void loadBPartner() {
        log.config("BPartner=" + this.m_C_BPartner_ID + ", Cur=" + this.m_C_Currency_ID);
        if (this.m_C_BPartner_ID == 0 && this.m_C_BPartner2_ID == 0) {
            return;
        }
        if (this.m_C_BPartner_ID == 0 || this.m_C_BPartner2_ID == 0) {
            return;
        }
        Integer key = new Integer(this.m_C_BPartner_ID);
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MPayment.setIsAllocated(Env.getCtx(), VAllocationBp.this.m_C_BPartner_ID, null);
                    MInvoice.setIsPaid(Env.getCtx(), VAllocationBp.this.m_C_BPartner_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("SELECT p.DateAcct,p.DocumentNo,p.C_Payment_ID,c.ISO_Code,p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,?,p.dateacct,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),currencyConvert(paymentAvailable(C_Payment_ID),p.C_Currency_ID,?,p.dateacct,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),p.MultiplierAP, doc.name||'-'||l2.name, bp.name FROM C_Payment_v p INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)  INNER join C_Doctype doc ON (p.C_DocType_ID=doc.C_DocType_ID)  LEFT OUTER JOIN AD_Ref_List l2 ON (p.TenderType=l2.value and l2.AD_Reference_ID=214)  INNER join C_bpartner bp ON (bp.C_bpartner_ID=p.C_bpartner_ID) WHERE p.IsAllocated='N' AND p.Processed='Y' AND p.C_Charge_ID IS NULL");
        if (this.m_C_BPartner_ID > 0) {
            sql.append(" AND p.C_BPartner_ID=" + this.m_C_BPartner_ID);
        }
        if (!this.multiCurrency.isSelected()) {
            sql.append(" AND p.C_Currency_ID=?");
        }
        if (this.m_AD_Org_ID != 0) {
            sql.append(" AND p.AD_Org_ID=" + this.m_AD_Org_ID);
        }
        sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "p", true, false));
        log.fine("PaySQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setInt(2, this.m_C_Currency_ID);
            if (!this.multiCurrency.isSelected()) {
                pstmt.setInt(3, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (this.multiCurrency.isSelected()) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal available = rs.getBigDecimal(7);
                if (available == null || available.signum() == 0) continue;
                line.add(available);
                line.add(Env.ZERO);
                line.add(rs.getString(9));
                line.add(rs.getString(10));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.paymentTable.getModel().removeTableModelListener(this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (this.multiCurrency.isSelected()) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add("Tipo");
        columnNames.add("Socio");
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.paymentTable.setModel(modelP);
        int i = 0;
        this.paymentTable.setColumnClass(i++, Boolean.class, false);
        this.paymentTable.setColumnClass(i++, Timestamp.class, true);
        this.paymentTable.setColumnClass(i++, String.class, true);
        if (this.multiCurrency.isSelected()) {
            this.paymentTable.setColumnClass(i++, String.class, true);
            this.paymentTable.setColumnClass(i++, BigDecimal.class, true);
        }
        this.paymentTable.setColumnClass(i++, BigDecimal.class, true);
        this.paymentTable.setColumnClass(i++, BigDecimal.class, true);
        this.paymentTable.setColumnClass(i++, BigDecimal.class, false);
        this.paymentTable.setColumnClass(i++, String.class, false);
        this.paymentTable.setColumnClass(i++, String.class, false);
        this.i_payment = this.multiCurrency.isSelected() ? 7 : 5;
        this.paymentTable.autoSize();
        data = new Vector();
        sql = new StringBuffer("SELECT i.DateAcct,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID,?,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, currencyConvert(invoiceDiscount(i.C_Invoice_ID,i.DateAcct,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP,i.MultiplierAP, doc.name, bp.name as Partner,  i.c_invoicepayschedule_id FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID)  INNER JOIN C_DocType doc ON (i.C_Doctype_ID=doc.C_DocType_ID)  INNER join C_bpartner bp ON (bp.C_bpartner_ID=i.C_bpartner_ID) WHERE i.IsPaid='N' AND i.Processed='Y'");
        if (this.m_C_BPartner2_ID > 0) {
            sql.append(" AND i.C_BPartner_ID=" + this.m_C_BPartner2_ID);
        }
        if (!this.multiCurrency.isSelected()) {
            sql.append(" AND i.C_Currency_ID=?");
        }
        if (this.m_AD_Org_ID != 0) {
            sql.append(" AND i.AD_Org_ID=" + this.m_AD_Org_ID);
        }
        sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
        log.fine("InvSQL=" + sql.toString());
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "i", true, false));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setInt(2, this.m_C_Currency_ID);
            pstmt.setInt(3, this.m_C_Currency_ID);
            if (!this.multiCurrency.isSelected()) {
                pstmt.setInt(4, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (this.multiCurrency.isSelected()) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal open = rs.getBigDecimal(7);
                if (open == null) {
                    open = Env.ZERO;
                }
                line.add(open);
                BigDecimal discount = rs.getBigDecimal(8);
                if (discount == null) {
                    discount = Env.ZERO;
                }
                line.add(discount);
                line.add(Env.ZERO);
                line.add(Env.ZERO);
                line.add(open);
                line.add(rs.getString(10));
                line.add(rs.getString(11));
                line.add(rs.getInt(12));
                if (Env.ZERO.compareTo(open) == 0) continue;
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.invoiceTable.getModel().removeTableModelListener(this);
        columnNames = new Vector();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (this.multiCurrency.isSelected()) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Discount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"WriteOff"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OverUnderAmt"));
        columnNames.add("Tipo");
        columnNames.add("Partner");
        columnNames.add("ID Cuota");
        DefaultTableModel modelI = new DefaultTableModel(data, columnNames);
        modelI.addTableModelListener(this);
        this.invoiceTable.setModel(modelI);
        i = 0;
        this.invoiceTable.setColumnClass(i++, Boolean.class, false);
        this.invoiceTable.setColumnClass(i++, Timestamp.class, true);
        this.invoiceTable.setColumnClass(i++, String.class, true);
        if (this.multiCurrency.isSelected()) {
            this.invoiceTable.setColumnClass(i++, String.class, true);
            this.invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        }
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        this.invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        this.invoiceTable.setColumnClass(i++, String.class, false);
        this.invoiceTable.setColumnClass(i++, String.class, false);
        this.invoiceTable.setColumnClass(i++, Integer.TYPE, false);
        this.invoiceTable.autoSize();
        this.i_open = this.multiCurrency.isSelected() ? 6 : 4;
        this.i_discount = this.multiCurrency.isSelected() ? 7 : 5;
        this.i_writeOff = this.multiCurrency.isSelected() ? 8 : 6;
        this.i_applied = this.multiCurrency.isSelected() ? 9 : 7;
        this.i_overUnder = this.multiCurrency.isSelected() ? 10 : 8;
        this.i_cuota = this.multiCurrency.isSelected() ? 13 : 11;
        this.calculate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.multiCurrency)) {
            this.loadBPartner();
        } else if (e.getSource().equals(this.allocateButton)) {
            this.allocateButton.setEnabled(false);
            this.saveData();
            this.loadBPartner();
            this.allocateButton.setEnabled(true);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.multiprocess) {
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        int row = e.getFirstRow();
        int col = e.getColumn();
        boolean isInvoice = e.getSource().equals(this.invoiceTable.getModel());
        log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        if (!isInvoice) {
            TableModel payment = this.paymentTable.getModel();
            BigDecimal open = (BigDecimal)payment.getValueAt(row, this.i_open);
            BigDecimal applied = (BigDecimal)payment.getValueAt(row, this.i_payment);
            if (col == 0) {
                if (((Boolean)payment.getValueAt(row, 0)).booleanValue()) {
                    applied = open;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == -applied.signum()) {
                        applied = this.totalDiff.negate();
                    }
                } else {
                    applied = Env.ZERO;
                }
            }
            if (col == this.i_payment) {
                if (applied.signum() == -open.signum()) {
                    applied = applied.negate();
                }
                if (open.abs().compareTo(applied.abs()) < 0) {
                    applied = open;
                }
            }
            payment.setValueAt(applied, row, this.i_payment);
        } else {
            TableModel invoice = this.invoiceTable.getModel();
            boolean selected = (Boolean)invoice.getValueAt(row, 0);
            BigDecimal open = (BigDecimal)invoice.getValueAt(row, this.i_open);
            BigDecimal discount = (BigDecimal)invoice.getValueAt(row, this.i_discount);
            BigDecimal applied = (BigDecimal)invoice.getValueAt(row, this.i_applied);
            BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, this.i_writeOff);
            BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, this.i_overUnder);
            int openSign = open.signum();
            if (col == 0) {
                if (selected) {
                    applied = open;
                    applied = applied.subtract(discount);
                    writeOff = Env.ZERO;
                    overUnder = Env.ZERO;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                        applied = this.totalDiff;
                    }
                    if (this.autoWriteOff.isSelected()) {
                        writeOff = open.subtract(applied.add(discount));
                    } else {
                        overUnder = open.subtract(applied.add(discount));
                    }
                } else {
                    writeOff = Env.ZERO;
                    applied = Env.ZERO;
                    overUnder = Env.ZERO;
                }
            }
            if (selected && col != 0) {
                if (discount.signum() == -openSign) {
                    discount = discount.negate();
                }
                if (writeOff.signum() == -openSign) {
                    writeOff = writeOff.negate();
                }
                if (applied.signum() == -openSign) {
                    applied = applied.negate();
                }
                if (discount.abs().compareTo(open.abs()) > 0) {
                    discount = open;
                }
                if (writeOff.abs().compareTo(open.abs()) > 0) {
                    writeOff = open;
                }
                BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
                BigDecimal difference = newTotal.subtract(open);
                BigDecimal diffWOD = writeOff.add(discount).subtract(open);
                if (diffWOD.signum() == open.signum()) {
                    if (col == this.i_discount) {
                        writeOff = writeOff.subtract(diffWOD);
                    } else {
                        discount = discount.subtract(diffWOD);
                    }
                    difference = difference.subtract(diffWOD);
                }
                if (col == this.i_applied) {
                    overUnder = overUnder.subtract(difference);
                } else {
                    applied = applied.subtract(difference);
                }
            }
            if (this.autoWriteOff.isSelected() && writeOff.doubleValue() / open.doubleValue() > 0.3) {
                ADialog.warn((int)this.m_WindowNo, (Container)this.panel, (String)"AllocationWriteOffWarn");
            }
            invoice.setValueAt(discount, row, this.i_discount);
            invoice.setValueAt(applied, row, this.i_applied);
            invoice.setValueAt(writeOff, row, this.i_writeOff);
            invoice.setValueAt(overUnder, row, this.i_overUnder);
            this.invoiceTable.repaint();
        }
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
        DecimalFormat format = DisplayType.getNumberFormat((int)12);
        Timestamp allocDate = null;
        TableModel payment = this.paymentTable.getModel();
        this.totalPay = new BigDecimal(0.0);
        int rows = payment.getRowCount();
        this.m_noPayments = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)payment.getValueAt(i, 1);
                if (!this.multiCurrency.isSelected()) {
                    allocDate = TimeUtil.max(allocDate, (Timestamp)ts);
                }
                BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_payment);
                this.totalPay = this.totalPay.add(bd);
                ++this.m_noPayments;
                log.fine("Payment_" + i + " = " + bd + " - Total=" + this.totalPay);
            }
            ++i;
        }
        this.paymentInfo.setText(String.valueOf(String.valueOf(this.m_noPayments)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + format.format(this.totalPay) + " ");
        TableModel invoice = this.invoiceTable.getModel();
        this.totalInv = new BigDecimal(0.0);
        rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int i2 = 0;
        while (i2 < rows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)invoice.getValueAt(i2, 1);
                if (!this.multiCurrency.isSelected()) {
                    allocDate = TimeUtil.max((Timestamp)allocDate, (Timestamp)ts);
                }
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i2, this.i_applied);
                this.totalInv = this.totalInv.add(bd);
                ++this.m_noInvoices;
                log.fine("Invoice_" + i2 + " = " + bd + " - Total=" + this.totalPay);
            }
            ++i2;
        }
        this.invoiceInfo.setText(String.valueOf(String.valueOf(this.m_noInvoices)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + format.format(this.totalInv) + " ");
        this.allocCurrencyLabel.setText(this.currencyPick.getDisplay());
        this.totalDiff = this.totalPay.subtract(this.totalInv);
        this.differenceField.setText(format.format(this.totalDiff));
        int p_case = this.revision_multiallocation();
        if (p_case != 0) {
            log.info("Indicator:" + p_case);
            this.indicator = p_case;
            this.allocateButton.setEnabled(true);
        } else {
            this.allocateButton.setEnabled(false);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("AD_Org_ID")) {
            this.m_AD_Org_ID = value == null ? 0 : (Integer)value;
            this.loadBPartner();
        }
        if (value == null) {
            return;
        }
        if (e.getSource().equals(this.bpartnerSearch)) {
            log.config("**e.getSource().equals(bpartnerSearch)");
            this.bpartnerSearch.setValue(value);
            this.m_C_BPartner_ID = (Integer)value;
            this.loadBPartner();
        } else if (e.getSource().equals(this.bpartnerSearch2)) {
            log.config("**e.getSource().equals(bpartnerSearch2)");
            this.bpartnerSearch2.setValue(value);
            this.m_C_BPartner2_ID = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("C_Currency_ID")) {
            this.m_C_Currency_ID = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("Date") && this.multiCurrency.isSelected()) {
            this.loadBPartner();
        }
    }

    private void saveData() {
        int C_Invoice_ID;
        KeyNamePair pp;
        if (this.m_noInvoices + this.m_noPayments == 0) {
            return;
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"AD_Org_ID");
        AD_Org_ID = this.m_AD_Org_ID;
        int C_BPartner_ID = this.m_C_BPartner_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)this.dateField.getValue();
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            AD_Org_ID = this.m_AD_OrgDoc_ID;
        }
        if (!MPeriod.isOpen((Properties)Env.getCtx(), (Timestamp)DateTrx, (String)"CMA")) {
            ADialog.error((int)this.m_WindowNo, (Container)this.panel, (String)"Period Close", null);
            return;
        }
        log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        Trx trx = Trx.get((String)Trx.createTrxName((String)"AL"), (boolean)true);
        int pRows = this.paymentTable.getRowCount();
        TableModel payment = this.paymentTable.getModel();
        ArrayList<Integer> paymentList = new ArrayList<Integer>(pRows);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        int i = 0;
        while (i < pRows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp2 = (KeyNamePair)payment.getValueAt(i, 2);
                int C_Payment_ID = pp2.getKey();
                paymentList.add(new Integer(C_Payment_ID));
                BigDecimal PaymentAmt = (BigDecimal)payment.getValueAt(i, this.i_payment);
                amountList.add(PaymentAmt);
                paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
                log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
            }
            ++i;
        }
        log.config("Number of Payments=" + paymentList.size() + " - Total=" + paymentAppliedAmt);
        int iRows = this.invoiceTable.getRowCount();
        TableModel invoice = this.invoiceTable.getModel();
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, C_Currency_ID, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), trx.getTrxName());
        alloc.setAD_Org_ID(AD_Org_ID);
        if (!alloc.save()) {
            log.log(Level.SEVERE, "Allocation not created");
            return;
        }
        int invoiceLines = 0;
        BigDecimal unmatchedApplied = Env.ZERO;
        int i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                ++invoiceLines;
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i2, this.i_applied);
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i2, this.i_discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i2, this.i_writeOff);
                BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i2, this.i_open)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                int ID_InvoiceSchedule = 0;
                if ((Integer)invoice.getValueAt(i2, this.i_cuota) != null && (Integer)invoice.getValueAt(i2, this.i_cuota) > 0) {
                    ID_InvoiceSchedule = (Integer)invoice.getValueAt(i2, this.i_cuota);
                }
                log.config("Invoice #" + i2 + " - AppliedAmt=" + AppliedAmt);
                int j = 0;
                while (j < paymentList.size() && AppliedAmt.signum() != 0) {
                    int C_Payment_ID = (Integer)paymentList.get(j);
                    BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                    if (PaymentAmt.signum() == AppliedAmt.signum()) {
                        log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                        BigDecimal amount = AppliedAmt;
                        if (amount.abs().compareTo(PaymentAmt.abs()) > 0) {
                            amount = PaymentAmt;
                        }
                        MAllocationLine aLine = new MAllocationLine(alloc, amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
                        aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                        aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                        if (!aLine.save()) {
                            log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);
                        }
                        String sqlInvoiceSchedule = "";
                        try {
                            if (ID_InvoiceSchedule > 0) {
                                sqlInvoiceSchedule = "UPDATE c_allocationline SET c_invoicepayschedule_id = " + ID_InvoiceSchedule + " WHERE C_AllocationLine_ID = " + aLine.get_ID();
                                int no = DB.executeUpdate((String)sqlInvoiceSchedule, (String)trx.getTrxName());
                                log.config("InvoiceSchedule #" + i2 + " is paid - updated=" + no);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, sqlInvoiceSchedule.toString(), (Throwable)e);
                        }
                        DiscountAmt = Env.ZERO;
                        WriteOffAmt = Env.ZERO;
                        AppliedAmt = AppliedAmt.subtract(amount);
                        PaymentAmt = PaymentAmt.subtract(amount);
                        log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                        amountList.set(j, PaymentAmt);
                    }
                    ++j;
                }
                if (AppliedAmt.signum() != 0 || DiscountAmt.signum() != 0 || WriteOffAmt.signum() != 0) {
                    int C_Payment_ID = 0;
                    MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                    aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                    aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                    if (!aLine.save(trx.getTrxName())) {
                        log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);
                    }
                    log.fine("Allocation Amount=" + AppliedAmt);
                    unmatchedApplied = unmatchedApplied.add(AppliedAmt);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            BigDecimal payAmt = (BigDecimal)amountList.get(i2);
            if (payAmt.signum() != 0) {
                int C_Payment_ID = (Integer)paymentList.get(i2);
                log.fine("Payment=" + C_Payment_ID + ", Amount=" + payAmt);
                MAllocationLine aLine = new MAllocationLine(alloc, payAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(C_BPartner_ID, 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                if (!aLine.save(trx.getTrxName())) {
                    log.log(Level.SEVERE, "Allocation Line not saved - Payment=" + C_Payment_ID);
                }
                unmatchedApplied = unmatchedApplied.subtract(payAmt);
            }
            ++i2;
        }
        if (unmatchedApplied.signum() != 0) {
            log.log(Level.SEVERE, "Allocation not balanced -- out by " + unmatchedApplied);
        }
        if (alloc.get_ID() != 0) {
            alloc.processIt("CO");
            alloc.save();
        }
        i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                BigDecimal open = DB.getSQLValueBD((String)trx.getTrxName(), (String)sql, (int)C_Invoice_ID);
                if (open != null && open.signum() == 0) {
                    sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                    int no = DB.executeUpdate((String)sql, (String)trx.getTrxName());
                    log.config("Invoice #" + i2 + " is paid - updated=" + no);
                } else {
                    log.config("Invoice #" + i2 + " is not paid - " + open);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            int C_Payment_ID = (Integer)paymentList.get(i2);
            MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, trx.getTrxName());
            if (pay.testAllocation()) {
                pay.save();
            }
            log.config("Payment #" + i2 + (pay.isAllocated() ? " not" : " is") + " fully allocated");
            ++i2;
        }
        paymentList.clear();
        amountList.clear();
        trx.commit();
        trx.close();
        this.autoWriteOff.setSelected(false);
        this.statusBar.setStatusLine(alloc.getDocumentNo());
    }

    private int revision_multiallocation() {
        this.multiprocess = true;
        log.info("multiallocation custom method");
        TableModel payment = this.paymentTable.getModel();
        BigDecimal totalPay = new BigDecimal(0.0);
        BigDecimal payamt1 = new BigDecimal(0.0);
        BigDecimal payamt2 = new BigDecimal(0.0);
        int lastPayment_ID = 0;
        int lastInvoice_ID = 0;
        int rows = payment.getRowCount();
        this.m_noPayments = 0;
        int payrow = -1;
        int payrow2 = -1;
        int RetValue = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_open);
                totalPay = totalPay.add(bd);
                if (payamt1.intValue() == 0) {
                    payamt1 = (BigDecimal)payment.getValueAt(i, this.i_open);
                } else {
                    payamt2 = (BigDecimal)payment.getValueAt(i, this.i_open);
                }
                ++this.m_noPayments;
                if (payrow < 0) {
                    payrow = i;
                } else {
                    payrow2 = i;
                }
                KeyNamePair pp = (KeyNamePair)payment.getValueAt(i, 2);
                lastPayment_ID = pp.getKey();
                log.fine("Payment_" + i + " = " + bd + " - Total=" + totalPay);
            }
            ++i;
        }
        TableModel invoice = this.invoiceTable.getModel();
        BigDecimal totalInv = new BigDecimal(0.0);
        BigDecimal invamt1 = new BigDecimal(0.0);
        BigDecimal invamt2 = new BigDecimal(0.0);
        rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int invrow = -1;
        int invrow2 = -1;
        int i2 = 0;
        while (i2 < rows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i2, this.i_open);
                totalInv = totalInv.add(bd);
                if (invamt1.intValue() == 0) {
                    invamt1 = (BigDecimal)invoice.getValueAt(i2, this.i_open);
                } else {
                    invamt2 = (BigDecimal)invoice.getValueAt(i2, this.i_open);
                }
                ++this.m_noInvoices;
                if (invrow < 0) {
                    invrow = i2;
                } else {
                    invrow2 = i2;
                }
                KeyNamePair pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                lastInvoice_ID = pp.getKey();
                log.fine("Invoice_" + i2 + " = " + bd + " - Total=" + totalPay);
            }
            ++i2;
        }
        this.totalPayment = totalPay;
        this.totalInvoiced = totalInv;
        log.config("noInvoices:" + this.m_noInvoices + " total: " + this.totalInvoiced + " noPayments:" + this.m_noPayments + "total:" + totalPay);
        if (this.m_noInvoices > 1 && this.m_noPayments > 1) {
            RetValue = 0;
            this.statusBar.setStatusLine("Muchos vs Muchos no permitido");
        }
        if (this.autoWriteOff.isSelected()) {
            RetValue = 0;
            this.statusBar.setStatusLine("debe usar la ventana comun");
        }
        if (this.m_noPayments == 1 && this.m_noInvoices == 1) {
            if (this.totalInvoiced.intValue() > 0 && totalPay.intValue() > 0) {
                if (this.totalInvoiced.compareTo(totalPay) == 0) {
                    payment.setValueAt(totalPay, payrow, this.i_payment);
                    invoice.setValueAt(this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 1;
                } else if (this.totalInvoiced.compareTo(totalPay) > 0) {
                    payment.setValueAt(totalPay, payrow, this.i_payment);
                    invoice.setValueAt(totalPay, invrow, this.i_applied);
                    RetValue = 2;
                } else {
                    payment.setValueAt(this.totalInvoiced, payrow, this.i_payment);
                    invoice.setValueAt(this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 3;
                }
            }
            if (this.totalInvoiced.intValue() < 0 && totalPay.intValue() < 0) {
                if (this.totalInvoiced.abs().compareTo(totalPay.abs()) == 0) {
                    payment.setValueAt(totalPay, payrow, this.i_payment);
                    invoice.setValueAt(this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 1;
                } else if (this.totalInvoiced.abs().compareTo(totalPay.abs()) > 0) {
                    payment.setValueAt(totalPay, payrow, this.i_payment);
                    invoice.setValueAt(totalPay, invrow, this.i_applied);
                    RetValue = 6;
                } else {
                    payment.setValueAt(this.totalInvoiced, payrow, this.i_payment);
                    invoice.setValueAt(this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 5;
                }
            }
        } else if (this.m_noPayments == 2 && this.m_noInvoices == 0) {
            if (payamt1.intValue() > 0 && payamt2.intValue() < 0 || payamt1.intValue() < 0 && payamt2.intValue() > 0) {
                log.info("payrow:" + payrow + "payrow2:" + payrow2 + ",payamt1:" + payamt1 + " ,payamt2:" + payamt2);
                if (payamt1.abs().compareTo(payamt2.abs()) > 0) {
                    if (payamt2.intValue() < 0) {
                        payment.setValueAt(payamt2.abs(), payrow, this.i_payment);
                    } else {
                        payment.setValueAt(payamt2.negate(), payrow, this.i_payment);
                    }
                    payment.setValueAt(payamt2, payrow2, this.i_payment);
                    RetValue = 11;
                } else if (payamt2.abs().compareTo(payamt1.abs()) > 0) {
                    if (payamt1.intValue() < 0) {
                        payment.setValueAt(payamt1.abs(), payrow2, this.i_payment);
                    } else {
                        payment.setValueAt(payamt1.negate(), payrow2, this.i_payment);
                    }
                    payment.setValueAt(payamt1, payrow, this.i_payment);
                    RetValue = 11;
                } else if (payamt2.abs().compareTo(payamt1.abs()) == 0) {
                    payment.setValueAt(payamt1, payrow, this.i_payment);
                    payment.setValueAt(payamt2, payrow2, this.i_payment);
                    RetValue = 10;
                }
            }
        } else if (this.m_noPayments == 0 && this.m_noInvoices == 2 && (invamt1.intValue() > 0 && invamt2.intValue() < 0 || invamt1.intValue() < 0 && invamt2.intValue() > 0)) {
            log.info("invrow:" + invrow + "invrow2:" + invrow2 + ",invamt1:" + invamt1 + " ,invamt2:" + invamt2);
            if (invamt1.abs().compareTo(invamt2.abs()) > 0) {
                if (invamt2.intValue() < 0) {
                    invoice.setValueAt(invamt2.abs(), invrow, this.i_applied);
                } else {
                    invoice.setValueAt(invamt2.negate(), invrow, this.i_applied);
                }
                invoice.setValueAt(invamt2, invrow2, this.i_applied);
                RetValue = 8;
            } else if (invamt2.abs().compareTo(invamt1.abs()) > 0) {
                if (invamt1.intValue() < 0) {
                    invoice.setValueAt(invamt1.abs(), invrow2, this.i_applied);
                } else {
                    invoice.setValueAt(invamt1.negate(), invrow2, this.i_applied);
                }
                invoice.setValueAt(invamt1, invrow, this.i_applied);
                RetValue = 8;
            } else if (invamt2.abs().compareTo(invamt1.abs()) == 0) {
                invoice.setValueAt(invamt1, invrow, this.i_applied);
                invoice.setValueAt(invamt2, invrow2, this.i_applied);
                RetValue = 7;
            }
        }
        this.m_AD_OrgDoc_ID = lastPayment_ID > 0 ? DB.getSQLValue(null, (String)("select ad_org_id from c_payment where c_payment_id=" + lastPayment_ID)) : DB.getSQLValue(null, (String)("select ad_org_id from c_invoice where c_invoice_id=" + lastInvoice_ID));
        this.multiprocess = false;
        return RetValue;
    }
}

