/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MPayment;
import org.compiere.model.X_CC_Hospitalization;
import org.compiere.model.X_MED_Appointment;
import org.compiere.model.X_MED_ScheduleDay;
import org.compiere.model.X_MED_ScheduleTime;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class Reserva {
    public DecimalFormat format = DisplayType.getNumberFormat((int)12);
    public static CLogger log = CLogger.getCLogger(Reserva.class);
    public int m_C_Currency_ID = 0;
    public int m_C_BPartner_ID = 0;
    private int m_noInvoices = 0;
    private int m_noPayments = 0;
    public BigDecimal totalInv = new BigDecimal(0.0);
    public BigDecimal totalPay = new BigDecimal(0.0);
    public BigDecimal totalDiff = new BigDecimal(0.0);
    public Timestamp allocDate = null;
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    public int m_AD_Org_ID = 0;

    public void dynInit() throws Exception {
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        this.m_AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
    }

    public Vector<Vector<Object>> gethorasData(Object tratante, Object date, Object especialidad, IMiniTable paymentTable) {
        int flag = 0;
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT hh.timerequested,hh.med_specialty_id, h.c_bpartnermed_id ,esp.name,  tr.name, h.type, hh.med_scheduletime_id, hh.state, hh.Description    from  MED_ScheduleTime hh  Inner Join MED_ScheduleDay p on (hh.MED_ScheduleDay_ID=p.MED_ScheduleDay_ID)  Inner join MED_Schedule h on (p.MED_Schedule_ID=h.MED_Schedule_ID)  Inner Join MED_Specialty esp on (h.MED_Specialty_ID=esp.MED_Specialty_ID) Inner join C_BPartner tr on (h.C_BPartnerMed_ID=tr.C_BPartner_ID) WHERE (p.DateTrx = ? or p.DateTrx between ? and (?::date + cast('10 day' as interval))) and h.MED_Specialty_ID=?  and h.C_BPartnerMed_ID=?  AND hh.state='DI' order by hh.timerequested ");
        if (tratante == null) {
            sql = new StringBuffer("SELECT hh.timerequested,hh.med_specialty_id, h.c_bpartnermed_id ,esp.name,  tr.name, h.type, hh.med_scheduletime_id, hh.state, hh.Description    from  MED_ScheduleTime hh  Inner Join MED_ScheduleDay p on (hh.MED_ScheduleDay_ID=p.MED_ScheduleDay_ID)  Inner join MED_Schedule h on (p.MED_Schedule_ID=h.MED_Schedule_ID)  Inner Join MED_Specialty esp on (h.MED_Specialty_ID=esp.MED_Specialty_ID) Inner join C_BPartner tr on (h.C_BPartnerMed_ID=tr.C_BPartner_ID) WHERE (p.DateTrx = ? or p.DateTrx between ? and (?::date + cast('10 day' as interval))) and h.MED_Specialty_ID=?  AND hh.state='DI' order by hh.timerequested ");
            flag = 1;
        }
        if (especialidad == null) {
            sql = new StringBuffer("SELECT hh.timerequested,hh.med_specialty_id, h.c_bpartnermed_id ,esp.name,  tr.name, h.type, hh.med_scheduletime_id, hh.state, hh.Description    from  MED_ScheduleTime hh  Inner Join MED_ScheduleDay p on (hh.MED_ScheduleDay_ID=p.MED_ScheduleDay_ID)  Inner join MED_Schedule h on (p.MED_Schedule_ID=h.MED_Schedule_ID)  Inner Join MED_Specialty esp on (h.MED_Specialty_ID=esp.MED_Specialty_ID) Inner join C_BPartner tr on (h.C_BPartnerMed_ID=tr.C_BPartner_ID) WHERE (p.DateTrx = ? or p.DateTrx between ? and (?::date + cast('10 day' as interval))) and h.C_BPartnerMed_ID=?  AND hh.state='DI' order by hh.timerequested ");
            flag = 2;
        }
        log.fine("SQL=" + sql.toString());
        log.fine("parameters: " + TimeUtil.getDay((long)((Timestamp)date).getTime()) + "-" + especialidad + "-" + tratante);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setTimestamp(1, TimeUtil.getDay((long)((Timestamp)date).getTime()));
            pstmt.setTimestamp(2, TimeUtil.getDay((long)((Timestamp)date).getTime()));
            pstmt.setTimestamp(3, TimeUtil.getDay((long)((Timestamp)date).getTime()));
            if (flag == 0) {
                pstmt.setInt(4, (Integer)especialidad);
                pstmt.setInt(5, (Integer)tratante);
            } else if (flag == 1) {
                pstmt.setInt(4, (Integer)especialidad);
            } else if (flag == 2) {
                pstmt.setInt(4, (Integer)tratante);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                KeyNamePair pp = new KeyNamePair(rs.getInt(7), rs.getString(1));
                line.add(pp);
                line.add(1);
                String txtRef = DB.getSQLValueString(null, (String)("SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID = 1000073 AND value = '" + rs.getString(8) + "'"), (Object[])new Object[0]);
                line.add(txtRef == null ? "Consulta" : txtRef);
                String NameValue = DB.getSQLValueString(null, (String)("SELECT name FROM AD_Ref_List where AD_Reference_ID = 2000195  and value like '" + rs.getString(8) + "'"), (Object[])new Object[0]);
                line.add(NameValue == null ? "Desconocido" : NameValue);
                line.add(rs.getString(9) == null ? "Desconocido" : rs.getString(9));
                line.add(rs.getString(4) == null ? "-" : rs.getString(4));
                line.add(rs.getString(5) == null ? "-" : rs.getString(5));
                data.add(line);
                log.fine(" line added");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return data;
    }

    public Vector<String> gethorasColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"N. Reservas"));
        columnNames.add("Tipo");
        columnNames.add("Estado");
        columnNames.add("Desc. Estado");
        columnNames.add("Especialidad");
        columnNames.add("Tratante");
        return columnNames;
    }

    public void sethorasColumnClass(IMiniTable horasTable) {
        int i = 0;
        horasTable.setColumnClass(i++, Boolean.class, false);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.setColumnClass(i++, Integer.class, true);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.autoSize();
    }

    public Vector<Vector<Object>> getReservaData(Object tratante, Object date, Object especialidad, IMiniTable paymentTable) {
        log.config("-getReservaData");
        int flag = 0;
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT c.MED_Appointment_id, c.MED_AttentionType_ID, ti.name,  c.State, c.description , p.name  as paciente,  c.c_bpartner_id, c.AttentionTime  from MED_Appointment c inner join MED_AttentionType ti on (c.MED_AttentionType_ID=ti.MED_AttentionType_ID)  left outer join c_bpartner p on (c.c_bpartner_id=p.c_bpartner_id)  inner join MED_scheduletime h on (c.MED_ScheduleTime_id=h.MED_ScheduleTime_ID)  inner join MED_ScheduleDay sd on (sd.MED_ScheduleDay_ID = h.MED_ScheduleDay_ID) WHERE (sd.DateTrx::date = ?::date  or (sd.DateTrx::date - cast('1 day' as interval)) = ?::date) and c.MED_Specialty_ID=? and c.C_BPartnerMed_ID=? AND c.state!='DI'");
        if (tratante == null) {
            sql = new StringBuffer("SELECT c.MED_Appointment_id, c.MED_AttentionType_ID, ti.name,  c.State, c.description , p.name  as paciente,  c.c_bpartner_id, c.AttentionTime  from MED_Appointment c inner join MED_AttentionType ti on (c.MED_AttentionType_ID=ti.MED_AttentionType_ID)  left outer join c_bpartner p on (c.c_bpartner_id=p.c_bpartner_id)  inner join MED_scheduletime h on (c.MED_ScheduleTime_id=h.MED_ScheduleTime_ID)  inner join MED_ScheduleDay sd on (sd.MED_ScheduleDay_ID = h.MED_ScheduleDay_ID) WHERE (sd.DateTrx::date = ?::date or (sd.DateTrx::date - cast('1 day' as interval))  = ?::date) and c.MED_Specialty_ID=?  AND c.state!='DI'");
            flag = 1;
        }
        if (especialidad == null) {
            sql = new StringBuffer("SELECT c.MED_Appointment_id, c.MED_AttentionType_ID, ti.name,  c.State, c.description , p.name  as paciente,  c.c_bpartner_id, c.AttentionTime  from MED_Appointment c inner join MED_AttentionType ti on (c.MED_AttentionType_ID=ti.MED_AttentionType_ID)  left outer join c_bpartner p on (c.c_bpartner_id=p.c_bpartner_id)  inner join MED_scheduletime h on (c.MED_ScheduleTime_id=h.MED_ScheduleTime_ID)  inner join MED_ScheduleDay sd on (sd.MED_ScheduleDay_ID = h.MED_ScheduleDay_ID) WHERE (sd.DateTrx::date = ?::date or (sd.DateTrx::date - cast('1 day' as interval)) = ?::date) and c.C_BPartnerMed_ID=?  AND c.state!='DI'");
            flag = 2;
        }
        log.fine("SQL=" + sql.toString());
        log.config("parameter : " + date);
        log.config("parameter : " + especialidad);
        log.config("parameter : " + tratante);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setTimestamp(1, TimeUtil.getDay((long)((Timestamp)date).getTime()));
            pstmt.setTimestamp(2, TimeUtil.getDay((long)((Timestamp)date).getTime()));
            if (flag == 0) {
                pstmt.setInt(3, (Integer)especialidad);
                pstmt.setInt(4, (Integer)tratante);
            } else if (flag == 1) {
                pstmt.setInt(3, (Integer)especialidad);
            } else if (flag == 2) {
                pstmt.setInt(3, (Integer)tratante);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(8));
                line.add(pp);
                String tipo = "";
                if (rs.getString("State").equals("AN")) {
                    tipo = "Anulada";
                } else if (rs.getString("State").equals("RC")) {
                    tipo = "Reservada / Confirmada";
                } else if (rs.getString("State").equals("RN")) {
                    tipo = "Reservada / No Confirmada";
                } else if (rs.getString("State").equals("RL")) {
                    tipo = "Recepcionado";
                }
                line.add(tipo);
                line.add(rs.getString("paciente"));
                line.add(rs.getString("name"));
                line.add(rs.getString("description"));
                line.add(rs.getString("Description"));
                data.add(line);
                log.fine("--line added");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return data;
    }

    public Vector<String> getReservaColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Fecha Reserva"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Estado"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Paciente"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Tipo Atencion"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)""));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)""));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)""));
        return columnNames;
    }

    public void setReservaColumnClass(IMiniTable reservaTable) {
        int i = 0;
        reservaTable.setColumnClass(i++, Boolean.class, false);
        reservaTable.setColumnClass(i++, String.class, true);
        reservaTable.setColumnClass(i++, String.class, true);
        reservaTable.setColumnClass(i++, String.class, true);
        reservaTable.setColumnClass(i++, String.class, true);
        reservaTable.setColumnClass(i++, String.class, true);
        reservaTable.autoSize();
    }

    public String saveData(int m_WindowNo, Object date, IMiniTable payment, IMiniTable invoice, String trxName) {
        int C_Invoice_ID;
        KeyNamePair pp;
        if (this.m_noInvoices + this.m_noPayments == 0) {
            return "";
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Org_ID");
        int C_BPartner_ID = this.m_C_BPartner_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)date;
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        int pRows = payment.getRowCount();
        ArrayList<Integer> paymentList = new ArrayList<Integer>(pRows);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        int i = 0;
        while (i < pRows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp2 = (KeyNamePair)payment.getValueAt(i, 2);
                int C_Payment_ID = pp2.getKey();
                paymentList.add(new Integer(C_Payment_ID));
                BigDecimal PaymentAmt = (BigDecimal)payment.getValueAt(i, this.i_payment);
                amountList.add(PaymentAmt);
                paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
                log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
            }
            ++i;
        }
        log.config("Number of Payments=" + paymentList.size() + " - Total=" + paymentAppliedAmt);
        int iRows = invoice.getRowCount();
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, C_Currency_ID, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(AD_Org_ID);
        alloc.saveEx();
        BigDecimal unmatchedApplied = Env.ZERO;
        int i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i2, this.i_applied);
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i2, this.i_discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i2, this.i_writeOff);
                BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i2, this.i_open)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                log.config("Invoice #" + i2 + " - AppliedAmt=" + AppliedAmt);
                int j = 0;
                while (j < paymentList.size() && AppliedAmt.signum() != 0) {
                    int C_Payment_ID = (Integer)paymentList.get(j);
                    BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                    if (PaymentAmt.signum() == AppliedAmt.signum()) {
                        log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                        BigDecimal amount = AppliedAmt;
                        if (amount.abs().compareTo(PaymentAmt.abs()) > 0) {
                            amount = PaymentAmt;
                        }
                        MAllocationLine aLine = new MAllocationLine(alloc, amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
                        aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                        aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                        aLine.saveEx();
                        DiscountAmt = Env.ZERO;
                        WriteOffAmt = Env.ZERO;
                        AppliedAmt = AppliedAmt.subtract(amount);
                        PaymentAmt = PaymentAmt.subtract(amount);
                        log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                        amountList.set(j, PaymentAmt);
                    }
                    ++j;
                }
                if (AppliedAmt.signum() != 0 || DiscountAmt.signum() != 0 || WriteOffAmt.signum() != 0) {
                    int C_Payment_ID = 0;
                    MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                    aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                    aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                    aLine.saveEx();
                    log.fine("Allocation Amount=" + AppliedAmt);
                    unmatchedApplied = unmatchedApplied.add(AppliedAmt);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            BigDecimal payAmt = (BigDecimal)amountList.get(i2);
            if (payAmt.signum() != 0) {
                int C_Payment_ID = (Integer)paymentList.get(i2);
                log.fine("Payment=" + C_Payment_ID + ", Amount=" + payAmt);
                MAllocationLine aLine = new MAllocationLine(alloc, payAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(C_BPartner_ID, 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                aLine.saveEx();
                unmatchedApplied = unmatchedApplied.subtract(payAmt);
            }
            ++i2;
        }
        if (unmatchedApplied.signum() != 0) {
            log.log(Level.SEVERE, "Allocation not balanced -- out by " + unmatchedApplied);
        }
        if (alloc.get_ID() != 0) {
            alloc.processIt("CO");
            alloc.saveEx();
        }
        i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal open = DB.getSQLValueBD((String)trxName, (String)sql, (int)C_Invoice_ID);
                if (open != null && open.signum() == 0) {
                    sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                    int no = DB.executeUpdate((String)sql, (String)trxName);
                    log.config("Invoice #" + i2 + " is paid - updated=" + no);
                } else {
                    log.config("Invoice #" + i2 + " is not paid - " + open);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            int C_Payment_ID = (Integer)paymentList.get(i2);
            MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, trxName);
            if (pay.testAllocation()) {
                pay.saveEx();
            }
            log.config("Payment #" + i2 + (pay.isAllocated() ? " not" : " is") + " fully allocated");
            ++i2;
        }
        paymentList.clear();
        amountList.clear();
        return alloc.getDocumentNo();
    }

    public int saveReserva(int m_WindowNo, IMiniTable horas, String pacienteDesc, Object dateField, Object especialidadPick, Object pacienteSearch, Object tipoHoraPick, String trxName, Object curso, Object acargo, Object academia, Object tratante) {
        log.config("--saveReserva");
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Org_ID");
        if (AD_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        int validacionHora = 0;
        if ((Integer)tipoHoraPick == 1000000 || (Integer)tipoHoraPick == 1000001) {
            int pRows2 = horas.getRowCount();
            int i2 = 0;
            while (i2 < pRows2) {
                if (((Boolean)horas.getValueAt(i2, 0)).booleanValue()) {
                    KeyNamePair pp = (KeyNamePair)horas.getValueAt(i2, 1);
                    X_MED_ScheduleTime hora = new X_MED_ScheduleTime(Env.getCtx(), pp.getKey(), trxName);
                    if (!hora.getState().equalsIgnoreCase("DI") && !hora.getState().equalsIgnoreCase("AN")) {
                        validacionHora = 1;
                    }
                }
                ++i2;
            }
        }
        if (validacionHora > 0) {
            throw new AdempiereException("Hora no Disponible, No se puede agendar cita.");
        }
        int pRowsValid = horas.getRowCount();
        int cantHorasTomadas = 0;
        int iValid = 0;
        while (iValid < pRowsValid) {
            if (((Boolean)horas.getValueAt(iValid, 0)).booleanValue()) {
                ++cantHorasTomadas;
            }
            ++iValid;
        }
        if (cantHorasTomadas > 1) {
            throw new AdempiereException("Solo se puede tomar 1 hora a a vez.");
        }
        X_MED_Appointment cita = null;
        int pRows = horas.getRowCount();
        int i = 0;
        while (i < pRows) {
            if (((Boolean)horas.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)horas.getValueAt(i, 1);
                X_MED_ScheduleTime hora = new X_MED_ScheduleTime(Env.getCtx(), pp.getKey(), trxName);
                if (hora.getTimeRequested().compareTo(Env.getContextAsDate((Properties)Env.getCtx(), (String)trxName)) < 0) {
                    return 0;
                }
                if (cita == null) {
                    cita = new X_MED_Appointment(Env.getCtx(), 0, trxName);
                    cita.setAD_Org_ID(AD_Org_ID);
                    cita.setState("RN");
                    cita.setDescription(pacienteDesc);
                    cita.setReservationDate(Env.getContextAsDate((Properties)Env.getCtx(), (String)trxName));
                    cita.setMED_Specialty_ID((Integer)especialidadPick);
                    cita.setC_BPartner_ID((Integer)pacienteSearch);
                    cita.setMED_AttentionType_ID((Integer)tipoHoraPick);
                    cita.save();
                }
                cita.set_CustomColumn("MED_ScheduleTime_ID", hora.getMED_ScheduleTime_ID());
                cita.setAttentionTime(hora.getTimeRequested());
                log.config("1.Tratante ID = " + (Integer)tratante);
                cita.set_CustomColumn("C_BPartnerMED_ID", (Integer)tratante);
                cita.save();
                hora.setState("RN");
                hora.save();
            }
            ++i;
        }
        return cita.getMED_Appointment_ID();
    }

    public String updateCita(int m_WindowNo, IMiniTable reservas, Object nuevoEstadoBox, String trxName) {
        log.config("--updateCita");
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Org_ID");
        if (AD_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        int pRows = reservas.getRowCount();
        int i = 0;
        while (i < pRows) {
            if (((Boolean)reservas.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)reservas.getValueAt(i, 1);
                String nEstado = (String)nuevoEstadoBox;
                if (nEstado.compareTo("DI") == 0) {
                    log.config("Dentro de if DI. Ininoles");
                } else {
                    X_MED_Appointment cita = new X_MED_Appointment(Env.getCtx(), pp.getKey(), trxName);
                    if (nEstado.compareTo("Reserva Confirmada") == 0) {
                        nEstado = "RC";
                    }
                    if (nEstado.compareTo("Anular") == 0) {
                        nEstado = "AN";
                    }
                    if (nEstado.compareTo("Recepcionado") == 0) {
                        nEstado = "RL";
                    }
                    cita.setState(nEstado);
                    cita.save();
                    if (nEstado.compareTo("RL") == 0) {
                        BigDecimal montocorrecto;
                        int convenio;
                        X_CC_Hospitalization hosp = new X_CC_Hospitalization(Env.getCtx(), 0, trxName);
                        hosp.setC_BPartner_ID(cita.getC_BPartner_ID());
                        hosp.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
                        int scheduletime = cita.get_ValueAsInt("MED_ScheduleTime_ID");
                        int locator = DB.getSQLValue((String)trxName, (String)("SELECT coalesce(m_locator_id, 0) from med_scheduletime where med_scheduletime_id = " + scheduletime));
                        hosp.set_CustomColumn("M_Locator1_ID", locator);
                        hosp.set_CustomColumn("IsPayable", "N");
                        hosp.set_CustomColumn("Payamt", new BigDecimal(50000));
                        hosp.set_CustomColumn("MED_Appointment_ID", cita.getMED_Appointment_ID());
                        int isapre = DB.getSQLValue((String)trxName, (String)("SELECT coalesce(cc_isapre_id,0) from c_bpartner  WHERE c_bpartner_id = " + cita.getC_BPartner_ID()));
                        if (isapre > 0) {
                            hosp.setCC_Isapre_ID(isapre);
                        }
                        if ((convenio = DB.getSQLValue((String)trxName, (String)("SELECT coalesce(cc_agreement_id,0) FROM c_bpartner  WHERE c_bpartner_id = " + cita.getC_BPartner_ID()))) > 0) {
                            hosp.setCC_Agreement_ID(convenio);
                        }
                        String nivel = DB.getSQLValueString((String)trxName, (String)"SELECT coalesce(ISAPRE,  '-') FROM c_bpartner  WHERE c_bpartner_id = ?", (int)cita.getC_BPartner_ID());
                        int productoasociado = DB.getSQLValue((String)trxName, (String)("SELECT coalesce(m_product_id, 0) FROM MED_Specialty  WHERE MED_Specialty_ID = " + cita.getMED_Specialty_ID()));
                        int pricelistversion = DB.getSQLValue((String)trxName, (String)("SELECT coalesce(m_pricelist_version_id,0) FROM cc_agreement  WHERE cc_Agreement_id in (select cc_agreement_id from c_bpartner  where c_bpartner_id = " + cita.getC_BPartner_ID() + " )"));
                        if (productoasociado > 0 && pricelistversion > 0 && (montocorrecto = DB.getSQLValueBD((String)trxName, (String)("SELECT coalesce(pricelist,0) from m_productprice  WHERE m_product_id = ? and m_pricelist_version_id = " + pricelistversion), (int)productoasociado)) != null && montocorrecto.compareTo(Env.ZERO) > 0) {
                            hosp.set_CustomColumn("Payamt", montocorrecto);
                        }
                        hosp.set_CustomColumn("M_Product_ID", productoasociado);
                        hosp.set_CustomColumn("MED_Specialty_ID", cita.getMED_Specialty_ID());
                        hosp.save();
                    }
                    if (nEstado.compareTo("AN") == 0) {
                        X_MED_ScheduleTime sched = new X_MED_ScheduleTime(Env.getCtx(), cita.get_ValueAsInt("MED_ScheduleTime_ID"), trxName);
                        sched.setState("DI");
                        sched.save();
                    }
                }
            }
            ++i;
        }
        return "";
    }

    public Vector<Vector<Object>> getdiasData(Object especialidad, Object date, Object tratante, Object tipo) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT p.datetrx,p.med_scheduleday_ID,p.dia, ref.name as dianombre, (SELECT COUNT(1)FROM med_scheduletime WHERE state = 'DI' AND med_Scheduleday_ID = p.med_Scheduleday_ID) as cant  FROM  med_Scheduleday p INNER JOIN med_schedule h ON (p.med_schedule_ID=h.med_schedule_ID) INNER JOIN AD_Ref_List ref ON (AD_Reference_ID=2000193 AND ref.value = p.dia) WHERE p.fecha BETWEEN ? AND  ?  AND p.IsActive = 'Y' AND h.IsActive = 'Y' AND h.med_specialty_ID = ? AND h.c_bpartnermed_ID = ? AND h.type = '" + tipo.toString() + "' " + "ORDER BY p.datetrx");
        log.fine("SQL=" + sql.toString());
        Timestamp fechaInicio = (Timestamp)date;
        Calendar calCalendario = Calendar.getInstance();
        calCalendario.setTimeInMillis(fechaInicio.getTime());
        calCalendario.add(5, 2);
        fechaInicio = new Timestamp(calCalendario.getTimeInMillis());
        calCalendario.add(5, 30);
        Timestamp fechaFin = new Timestamp(calCalendario.getTimeInMillis());
        log.fine("parameters: " + fechaInicio + ":" + fechaFin + "-" + especialidad + "-" + tratante);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setTimestamp(1, fechaInicio);
            pstmt.setTimestamp(2, fechaFin);
            pstmt.setInt(3, (Integer)especialidad);
            pstmt.setInt(4, Integer.valueOf(tratante.toString()));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(1).substring(0, 10));
                line.add(pp);
                line.add(rs.getString(4) == null ? "Desconocido" : rs.getString(4));
                line.add(rs.getInt(5));
                data.add(line);
                log.fine(" line added");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return data;
    }

    public Vector<String> getdiasColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Dia"));
        columnNames.add("Horas Disponibles");
        return columnNames;
    }

    public void setdiasColumnClass(IMiniTable horasTable) {
        int i = 0;
        horasTable.setColumnClass(i++, Boolean.class, false);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.setColumnClass(i++, Integer.class, true);
        horasTable.autoSize();
    }

    public Vector<Vector<Object>> gethorasDataExterno(IMiniTable diasTable) {
        log.config("-getHorasData");
        int hRows = diasTable.getRowCount();
        String where = "(0";
        int i = 0;
        while (i < hRows) {
            if (((Boolean)diasTable.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)diasTable.getValueAt(i, 1);
                where = String.valueOf(where) + "," + pp.getKey();
            }
            ++i;
        }
        where = String.valueOf(where) + ")";
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT hh.timerequested,hh.med_scheduletime_id,refEstado.name as estado,  refTipo.name as tipo  FROM  med_scheduletime hh  INNER JOIN med_scheduleday p on (hh.med_Scheduleday_ID=p.med_Scheduleday_ID)  INNER JOIN med_schedule h on (p.med_schedule_ID=h.med_Schedule_ID)  LEFT JOIN AD_Ref_List refTipo ON (refTipo.AD_Reference_ID=1000073 AND refTipo.value = h.tipo)  LEFT JOIN AD_Ref_List refEstado ON (refEstado.AD_Reference_ID=1000110  AND refEstado.value = hh.estado)  WHERE hh.med_Scheduleday_ID IN " + where + " AND hh.IsActive = 'Y' AND hh.state = 'DI' " + " order by hh.timerequested ");
        log.fine("SQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(1).substring(11));
                line.add(pp);
                line.add(rs.getString(3) == null ? "Desconocido" : rs.getString(3));
                line.add(rs.getString(4) == null ? "Desconocido" : rs.getString(4));
                data.add(line);
                log.fine(" line added");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return data;
    }

    public Vector<String> gethorasExternoColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add("Estado");
        columnNames.add("Tipo");
        return columnNames;
    }

    public void sethorasExternoColumnClass(IMiniTable horasTable) {
        int i = 0;
        horasTable.setColumnClass(i++, Boolean.class, false);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.setColumnClass(i++, String.class, true);
        horasTable.autoSize();
    }

    public int saveReservaExterno(int m_WindowNo, IMiniTable horas, String pacienteDesc, Object especialidadPick, Object pacienteSearch, String trxName, Object curso, Object acargo, Object academia, Object tratante) {
        log.config("--saveReserva");
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Org_ID");
        if (AD_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        int validacionHora = 0;
        int pRows2 = horas.getRowCount();
        int cantHorasTomadas = 0;
        int i2 = 0;
        while (i2 < pRows2) {
            if (((Boolean)horas.getValueAt(i2, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)horas.getValueAt(i2, 1);
                X_MED_ScheduleTime hora = new X_MED_ScheduleTime(Env.getCtx(), pp.getKey(), trxName);
                if (!hora.getState().equalsIgnoreCase("DI") && !hora.getState().equalsIgnoreCase("AN")) {
                    validacionHora = 1;
                }
                ++cantHorasTomadas;
            }
            ++i2;
        }
        if (cantHorasTomadas > 1) {
            throw new AdempiereException("Solo se puede tomar 1 hora a a vez.");
        }
        if (validacionHora > 0) {
            throw new AdempiereException("Hora no Disponible, No se puede agendar cita.");
        }
        X_MED_Appointment cita = null;
        int pRows = horas.getRowCount();
        int i = 0;
        while (i < pRows) {
            if (((Boolean)horas.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)horas.getValueAt(i, 1);
                X_MED_ScheduleTime hora = new X_MED_ScheduleTime(Env.getCtx(), pp.getKey(), trxName);
                X_MED_ScheduleDay horaDia = new X_MED_ScheduleDay(Env.getCtx(), hora.getMED_ScheduleDay_ID(), trxName);
                if (cita == null) {
                    cita = new X_MED_Appointment(Env.getCtx(), 0, trxName);
                    cita.setAD_Org_ID(AD_Org_ID);
                    cita.setState("RN");
                    cita.setDescription(pacienteDesc);
                    cita.setReservationDate(horaDia.getDateTrx());
                    cita.setMED_Specialty_ID((Integer)especialidadPick);
                    cita.setC_BPartner_ID((Integer)pacienteSearch);
                    cita.save();
                    cita.setAttentionTime(hora.getTimeRequested());
                    cita.save();
                }
            }
            ++i;
        }
        return cita.getMED_Appointment_ID();
    }

    public static List<KeyNamePair> getEspecialidad(int ID_Tratante) {
        ArrayList<KeyNamePair> arrayList;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        KeyNamePair pp = new KeyNamePair(0, "");
        list.add(pp);
        String sql = "SELECT MED_Specialty_ID, name  FROM MED_Specialty WHERE IsActive = 'Y' ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            list.add(new KeyNamePair(0, "--Seleccione--"));
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                list.add(pp);
            }
            arrayList = list;
        }
        catch (SQLException e) {
            ArrayList<KeyNamePair> arrayList2;
            try {
                log.log(Level.SEVERE, sql, (Throwable)e);
                arrayList2 = list;
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return arrayList2;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return arrayList;
    }

    public static List<KeyNamePair> getTratante(int ID_Especialidad) {
        ArrayList<KeyNamePair> arrayList;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        KeyNamePair pp = new KeyNamePair(0, "");
        list.add(pp);
        String sql = "SELECT C_BPartner_ID, apellidopaterno||' '||apellidomaterno||' '||nombres as name FROM C_BPartner WHERE IsActive = 'Y' ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            list.add(new KeyNamePair(0, "--Seleccione--"));
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                list.add(pp);
            }
            arrayList = list;
        }
        catch (SQLException e) {
            ArrayList<KeyNamePair> arrayList2;
            try {
                log.log(Level.SEVERE, sql, (Throwable)e);
                arrayList2 = list;
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return arrayList2;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return arrayList;
    }
}

