/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.ofb.model.OFBForward;
import org.ofb.utils.DateUtils;

public class AllocationWS36090 {
    public DecimalFormat format = DisplayType.getNumberFormat((int)12);
    public static CLogger log = CLogger.getCLogger(AllocationWS36090.class);
    private boolean m_calculating = false;
    public int m_C_Currency_ID = 0;
    public int m_C_BPartner_ID = 0;
    private int m_noInvoices = 0;
    private int m_noPayments = 0;
    public BigDecimal totalInv = new BigDecimal(0.0);
    public BigDecimal totalPay = new BigDecimal(0.0);
    public BigDecimal totalDiff = new BigDecimal(0.0);
    protected static final int INDICATOR_NONE = 0;
    protected static final int INDICATOR_TOTAL_PAY = 1;
    protected static final int INDICATOR_SUBPAYMENT_SO = 2;
    protected static final int INDICATOR_GREATER_PAYMENT_SO = 3;
    protected static final int INDICATOR_CREDIT_MEMO = 4;
    protected static final int INDICATOR_GREATER_PAYMENT_PO = 5;
    protected static final int INDICATOR_SUBPAYMENT_PO = 6;
    protected static final int INDICATOR_VERSUS_INVOICE = 7;
    protected static final int INDICATOR_VERSUS_SUBINVOICE = 8;
    protected static final int INDICATOR_WRITEOFF_INVOICE = 9;
    protected static final int INDICATOR_VERSUS_PAYMENT = 10;
    protected static final int INDICATOR_VERSUS_SUBPAYMENT = 11;
    protected static final int INDICATOR_CURRENCY_DIFF = 12;
    BigDecimal totalPayment = new BigDecimal(0.0);
    BigDecimal totalInvoiced = new BigDecimal(0.0);
    BigDecimal totalCredit = new BigDecimal(0.0);
    BigDecimal pvspamt = new BigDecimal(0.0);
    int indicator = 0;
    boolean multiprocess = false;
    public Timestamp allocDate = null;
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    private int i_overUnder = 10;
    private int i_cuota = 11;
    public int m_AD_Org_ID = 0;
    public int m_AD_OrgDoc_ID = 0;
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();

    public void dynInit() throws Exception {
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        this.m_AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
    }

    public void checkBPartner() {
        log.config("BPartner=" + this.m_C_BPartner_ID + ", Cur=" + this.m_C_Currency_ID);
        if (this.m_C_BPartner_ID == 0 || this.m_C_Currency_ID == 0) {
            return;
        }
        Integer key = new Integer(this.m_C_BPartner_ID);
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MPayment.setIsAllocated(Env.getCtx(), AllocationWS36090.this.m_C_BPartner_ID, null);
                    MInvoice.setIsPaid(Env.getCtx(), AllocationWS36090.this.m_C_BPartner_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
    }

    public Vector<Vector<Object>> getPaymentData(boolean isMultiCurrency, Object date, IMiniTable paymentTable) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT p.DateAcct,p.DocumentNo,p.C_Payment_ID,c.ISO_Code,p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,?,?,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),currencyConvert(paymentAvailable(C_Payment_ID),p.C_Currency_ID,?,?,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),p.MultiplierAP, doc.name||'-'||l2.name FROM C_Payment_v p INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)  INNER join C_Doctype doc ON (p.C_DocType_ID=doc.C_DocType_ID)  LEFT OUTER JOIN AD_Ref_List l2 ON (p.TenderType=l2.value and l2.AD_Reference_ID=214) WHERE p.IsAllocated='N' AND p.Processed='Y' AND p.C_Charge_ID IS NULL AND p.C_BPartner_ID=?");
        Timestamp dateEnd = new Timestamp(DateUtils.today().getTime());
        dateEnd = DateUtils.addDays(dateEnd, -90);
        sql.append(" AND p.DateTrx > ? ");
        if (!isMultiCurrency) {
            sql.append(" AND p.C_Currency_ID=?");
        }
        if (this.m_AD_Org_ID != 0) {
            sql.append(" AND p.AD_Org_ID=" + this.m_AD_Org_ID);
        }
        sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "p", true, false));
        log.fine("PaySQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setTimestamp(2, (Timestamp)date);
            pstmt.setInt(3, this.m_C_Currency_ID);
            pstmt.setTimestamp(4, (Timestamp)date);
            pstmt.setInt(5, this.m_C_BPartner_ID);
            pstmt.setTimestamp(6, dateEnd);
            if (!isMultiCurrency) {
                pstmt.setInt(7, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (isMultiCurrency) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal available = rs.getBigDecimal(7);
                if (available == null || available.signum() == 0) continue;
                line.add(available);
                line.add(Env.ZERO);
                line.add(rs.getString(9));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return data;
    }

    public Vector<String> getPaymentColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add("Tipo");
        return columnNames;
    }

    public void setPaymentColumnClass(IMiniTable paymentTable, boolean isMultiCurrency) {
        int i = 0;
        paymentTable.setColumnClass(i++, Boolean.class, false);
        paymentTable.setColumnClass(i++, Timestamp.class, true);
        paymentTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            paymentTable.setColumnClass(i++, String.class, true);
            paymentTable.setColumnClass(i++, BigDecimal.class, true);
        }
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, false);
        paymentTable.setColumnClass(i++, String.class, false);
        this.i_payment = isMultiCurrency ? 7 : 5;
        paymentTable.autoSize();
    }

    public Vector<Vector<Object>> getInvoiceData(boolean isMultiCurrency, Object date, IMiniTable invoiceTable) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT i.DueDate,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID,?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, currencyConvert(invoiceDiscount(i.C_Invoice_ID,?,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP,i.MultiplierAP, doc.name, i.c_invoicepayschedule_id FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID)  INNER JOIN C_DocType doc ON (i.C_Doctype_ID=doc.C_DocType_ID) WHERE i.IsPaid='N' AND i.Processed='Y' AND i.DocStatus <> 'VO'  AND i.C_BPartner_ID=?");
        Timestamp dateEndInv = new Timestamp(DateUtils.today().getTime());
        dateEndInv = DateUtils.addDays(dateEndInv, -90);
        sql.append(" AND i.DateInvoiced > ? ");
        if (!isMultiCurrency) {
            sql.append(" AND i.C_Currency_ID=?");
        }
        if (this.m_AD_Org_ID != 0) {
            sql.append(" AND i.AD_Org_ID=" + this.m_AD_Org_ID);
        }
        sql.append(" AND i.Extinta='N' AND i.ISFACTORING='N' ");
        sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
        log.fine("InvSQL=" + sql.toString());
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "i", true, false));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setTimestamp(2, (Timestamp)date);
            pstmt.setInt(3, this.m_C_Currency_ID);
            pstmt.setTimestamp(4, (Timestamp)date);
            pstmt.setTimestamp(5, (Timestamp)date);
            pstmt.setInt(6, this.m_C_Currency_ID);
            pstmt.setInt(7, this.m_C_BPartner_ID);
            pstmt.setTimestamp(8, dateEndInv);
            if (!isMultiCurrency) {
                pstmt.setInt(9, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (isMultiCurrency) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal open = rs.getBigDecimal(7);
                if (open == null) {
                    open = Env.ZERO;
                }
                line.add(open);
                BigDecimal discount = rs.getBigDecimal(8);
                if (discount == null) {
                    discount = Env.ZERO;
                }
                line.add(discount);
                line.add(Env.ZERO);
                line.add(Env.ZERO);
                line.add(open);
                line.add(rs.getString(10));
                line.add(rs.getInt(11));
                if (Env.ZERO.compareTo(open) == 0) continue;
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        return data;
    }

    public Vector<String> getInvoiceColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Discount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"WriteOff"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OverUnderAmt"));
        columnNames.add("Tipo");
        columnNames.add("ID Cuota");
        return columnNames;
    }

    public void setInvoiceColumnClass(IMiniTable invoiceTable, boolean isMultiCurrency) {
        int i = 0;
        invoiceTable.setColumnClass(i++, Boolean.class, false);
        invoiceTable.setColumnClass(i++, Timestamp.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            invoiceTable.setColumnClass(i++, String.class, true);
            invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        }
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, String.class, false);
        invoiceTable.setColumnClass(i++, Integer.TYPE, true);
        invoiceTable.autoSize();
    }

    public void calculate(boolean isMultiCurrency) {
        this.i_open = isMultiCurrency ? 6 : 4;
        this.i_discount = isMultiCurrency ? 7 : 5;
        this.i_writeOff = isMultiCurrency ? 8 : 6;
        this.i_applied = isMultiCurrency ? 9 : 7;
        this.i_overUnder = isMultiCurrency ? 10 : 8;
        this.i_cuota = isMultiCurrency ? 12 : 10;
    }

    public String writeOff(int row, int col, boolean isInvoice, IMiniTable payment, IMiniTable invoice, boolean isAutoWriteOff) {
        String msg = "";
        if (this.m_calculating) {
            return msg;
        }
        this.m_calculating = true;
        log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        if (!isInvoice) {
            BigDecimal open = (BigDecimal)payment.getValueAt(row, this.i_open);
            BigDecimal applied = (BigDecimal)payment.getValueAt(row, this.i_payment);
            if (col == 0) {
                if (((Boolean)payment.getValueAt(row, 0)).booleanValue()) {
                    applied = open;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == -applied.signum()) {
                        applied = this.totalDiff.negate();
                    }
                } else {
                    applied = Env.ZERO;
                }
            }
            if (col == this.i_payment) {
                if (applied.signum() == -open.signum()) {
                    applied = applied.negate();
                }
                if (open.abs().compareTo(applied.abs()) < 0) {
                    applied = open;
                }
            }
            payment.setValueAt((Object)applied, row, this.i_payment);
        } else {
            boolean selected = (Boolean)invoice.getValueAt(row, 0);
            BigDecimal open = (BigDecimal)invoice.getValueAt(row, this.i_open);
            BigDecimal discount = (BigDecimal)invoice.getValueAt(row, this.i_discount);
            BigDecimal applied = (BigDecimal)invoice.getValueAt(row, this.i_applied);
            BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, this.i_writeOff);
            BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, this.i_overUnder);
            int openSign = open.signum();
            if (col == 0) {
                if (selected) {
                    applied = open;
                    applied = applied.subtract(discount);
                    writeOff = Env.ZERO;
                    overUnder = Env.ZERO;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                        applied = this.totalDiff;
                    }
                    if (isAutoWriteOff) {
                        writeOff = open.subtract(applied.add(discount));
                    } else {
                        overUnder = open.subtract(applied.add(discount));
                    }
                } else {
                    writeOff = Env.ZERO;
                    applied = Env.ZERO;
                    overUnder = Env.ZERO;
                }
            }
            if (selected && col != 0) {
                if (discount.signum() == -openSign) {
                    discount = discount.negate();
                }
                if (writeOff.signum() == -openSign) {
                    writeOff = writeOff.negate();
                }
                if (applied.signum() == -openSign) {
                    applied = applied.negate();
                }
                if (discount.abs().compareTo(open.abs()) > 0) {
                    discount = open;
                }
                if (writeOff.abs().compareTo(open.abs()) > 0) {
                    writeOff = open;
                }
                BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
                BigDecimal difference = newTotal.subtract(open);
                BigDecimal diffWOD = writeOff.add(discount).subtract(open);
                if (diffWOD.signum() == open.signum()) {
                    if (col == this.i_discount) {
                        writeOff = writeOff.subtract(diffWOD);
                    } else {
                        discount = discount.subtract(diffWOD);
                    }
                    difference = difference.subtract(diffWOD);
                }
                if (col == this.i_applied) {
                    overUnder = overUnder.subtract(difference);
                } else {
                    applied = applied.subtract(difference);
                }
            }
            if (isAutoWriteOff && writeOff.doubleValue() / open.doubleValue() > 0.3) {
                msg = "AllocationWriteOffWarn";
            }
            invoice.setValueAt((Object)discount, row, this.i_discount);
            invoice.setValueAt((Object)applied, row, this.i_applied);
            invoice.setValueAt((Object)writeOff, row, this.i_writeOff);
            invoice.setValueAt((Object)overUnder, row, this.i_overUnder);
            invoice.repaint();
        }
        return msg;
    }

    public String calculatePayment(IMiniTable payment, boolean isMultiCurrency) {
        log.config("");
        this.totalPay = new BigDecimal(0.0);
        int rows = payment.getRowCount();
        this.m_noPayments = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)payment.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max((Timestamp)this.allocDate, (Timestamp)ts);
                    if (OFBForward.AllocationUseActualDate()) {
                        KeyNamePair pp = (KeyNamePair)payment.getValueAt(i, 2);
                        int C_Payment_ID = pp.getKey();
                        MPayment payN = new MPayment(Env.getCtx(), C_Payment_ID, null);
                        this.allocDate = payN.getDateAcct();
                    }
                }
                BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_payment);
                this.totalPay = this.totalPay.add(bd);
                ++this.m_noPayments;
                log.fine("Payment_" + i + " = " + bd + " - Total=" + this.totalPay);
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noPayments)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + this.format.format(this.totalPay) + " ";
    }

    public String calculateInvoice(IMiniTable invoice, boolean isMultiCurrency) {
        this.totalInv = new BigDecimal(0.0);
        int rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)invoice.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max((Timestamp)this.allocDate, (Timestamp)ts);
                }
                if (OFBForward.AllocationUseActualDate()) {
                    KeyNamePair pp = (KeyNamePair)invoice.getValueAt(i, 2);
                    int Invoice_ID = pp.getKey();
                    MInvoice invN = new MInvoice(Env.getCtx(), Invoice_ID, null);
                    this.allocDate = invN.getDateAcct();
                }
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i, this.i_applied);
                this.totalInv = this.totalInv.add(bd);
                ++this.m_noInvoices;
                log.fine("Invoice_" + i + " = " + bd + " - Total=" + this.totalPay);
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noInvoices)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + this.format.format(this.totalInv) + " ";
    }

    public String saveData(int m_WindowNo, Object date, IMiniTable payment, IMiniTable invoice, String trxName) {
        int C_Invoice_ID;
        KeyNamePair pp;
        if (this.m_noInvoices + this.m_noPayments == 0) {
            return "";
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Org_ID");
        AD_Org_ID = this.m_AD_Org_ID;
        int C_BPartner_ID = this.m_C_BPartner_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)date;
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            AD_Org_ID = this.m_AD_OrgDoc_ID;
        }
        if (!MPeriod.isOpen((Properties)Env.getCtx(), (Timestamp)DateTrx, (String)"CMA")) {
            new AdempiereException("Period Closed");
        }
        log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        int pRows = payment.getRowCount();
        ArrayList<Integer> paymentList = new ArrayList<Integer>(pRows);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        int i = 0;
        while (i < pRows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp2 = (KeyNamePair)payment.getValueAt(i, 2);
                int C_Payment_ID = pp2.getKey();
                paymentList.add(new Integer(C_Payment_ID));
                if (OFBForward.AllocationUsePayDate()) {
                    MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, null);
                    DateTrx = pay.getDateAcct();
                }
                BigDecimal PaymentAmt = (BigDecimal)payment.getValueAt(i, this.i_payment);
                amountList.add(PaymentAmt);
                paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
                log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
            }
            ++i;
        }
        log.config("Number of Payments=" + paymentList.size() + " - Total=" + paymentAppliedAmt);
        int iRows = invoice.getRowCount();
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, C_Currency_ID, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(AD_Org_ID);
        alloc.saveEx();
        int invoiceLines = 0;
        BigDecimal unmatchedApplied = Env.ZERO;
        int i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                ++invoiceLines;
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i2, this.i_applied);
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i2, this.i_discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i2, this.i_writeOff);
                BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i2, this.i_open)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                int ID_InvoiceSchedule = 0;
                if ((Integer)invoice.getValueAt(i2, this.i_cuota) != null) {
                    ID_InvoiceSchedule = (Integer)invoice.getValueAt(i2, this.i_cuota);
                }
                log.config("Invoice #" + i2 + " - AppliedAmt=" + AppliedAmt);
                int j = 0;
                while (j < paymentList.size() && AppliedAmt.signum() != 0) {
                    int C_Payment_ID = (Integer)paymentList.get(j);
                    BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                    if (PaymentAmt.signum() == AppliedAmt.signum()) {
                        log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                        BigDecimal amount = AppliedAmt;
                        if (amount.abs().compareTo(PaymentAmt.abs()) > 0) {
                            amount = PaymentAmt;
                        }
                        MAllocationLine aLine = null;
                        aLine = this.indicator != 9 ? new MAllocationLine(alloc, PaymentAmt, Env.ZERO, Env.ZERO, Env.ZERO) : new MAllocationLine(alloc, Env.ZERO, Env.ZERO, PaymentAmt, Env.ZERO);
                        aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                        aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                        aLine.saveEx();
                        String sqlInvoiceSchedule = "";
                        try {
                            if (ID_InvoiceSchedule > 0) {
                                sqlInvoiceSchedule = "UPDATE c_allocationline SET c_invoicepayschedule_id = " + ID_InvoiceSchedule + " WHERE C_AllocationLine_ID = " + aLine.get_ID();
                                int no = DB.executeUpdate((String)sqlInvoiceSchedule, (String)trxName);
                                log.config("InvoiceSchedule #" + i2 + " is paid - updated=" + no);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, sqlInvoiceSchedule.toString(), (Throwable)e);
                        }
                        DiscountAmt = Env.ZERO;
                        WriteOffAmt = Env.ZERO;
                        AppliedAmt = AppliedAmt.subtract(amount);
                        PaymentAmt = PaymentAmt.subtract(amount);
                        log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                        amountList.set(j, PaymentAmt);
                    }
                    ++j;
                }
                if (AppliedAmt.signum() != 0 || DiscountAmt.signum() != 0 || WriteOffAmt.signum() != 0) {
                    int C_Payment_ID = 0;
                    MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                    aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                    aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                    aLine.saveEx();
                    log.fine("Allocation Amount=" + AppliedAmt);
                    unmatchedApplied = unmatchedApplied.add(AppliedAmt);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            BigDecimal payAmt = (BigDecimal)amountList.get(i2);
            if (payAmt.signum() != 0) {
                int C_Payment_ID = (Integer)paymentList.get(i2);
                log.fine("Payment=" + C_Payment_ID + ", Amount=" + payAmt);
                MAllocationLine aLine = null;
                aLine = this.indicator != 9 ? new MAllocationLine(alloc, payAmt, Env.ZERO, Env.ZERO, Env.ZERO) : new MAllocationLine(alloc, Env.ZERO, Env.ZERO, payAmt, Env.ZERO);
                aLine.setDocInfo(C_BPartner_ID, 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                aLine.saveEx();
                if (this.indicator != 9) {
                    unmatchedApplied = unmatchedApplied.subtract(payAmt);
                }
            }
            ++i2;
        }
        if (unmatchedApplied.signum() != 0) {
            log.log(Level.SEVERE, "Allocation not balanced -- out by " + unmatchedApplied);
        }
        if (alloc.get_ID() != 0) {
            alloc.processIt("CO");
            alloc.saveEx();
        }
        i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal open = DB.getSQLValueBD((String)trxName, (String)sql, (int)C_Invoice_ID);
                if (open != null && open.signum() == 0) {
                    sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                    int no = DB.executeUpdate((String)sql, (String)trxName);
                    log.config("Invoice #" + i2 + " is paid - updated=" + no);
                } else {
                    log.config("Invoice #" + i2 + " is not paid - " + open);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            int C_Payment_ID = (Integer)paymentList.get(i2);
            MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, trxName);
            if (pay.testAllocation()) {
                pay.saveEx();
            }
            log.config("Payment #" + i2 + (pay.isAllocated() ? " not" : " is") + " fully allocated");
            ++i2;
        }
        paymentList.clear();
        amountList.clear();
        return alloc.getDocumentNo();
    }

    protected int revision_multiallocation(IMiniTable payment, IMiniTable invoice, boolean autoWriteOff) {
        this.multiprocess = true;
        log.info("multiallocation custom method");
        BigDecimal totalPay = new BigDecimal(0.0);
        BigDecimal payamt1 = new BigDecimal(0.0);
        BigDecimal payamt2 = new BigDecimal(0.0);
        int rows = payment.getRowCount();
        int lastPayment_ID = 0;
        int lastInvoice_ID = 0;
        int lastInvoice2_ID = 0;
        this.m_noPayments = 0;
        int payrow = -1;
        int payrow2 = -1;
        int RetValue = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_open);
                totalPay = totalPay.add(bd);
                if (payamt1.intValue() == 0) {
                    payamt1 = (BigDecimal)payment.getValueAt(i, this.i_open);
                } else {
                    payamt2 = (BigDecimal)payment.getValueAt(i, this.i_open);
                }
                ++this.m_noPayments;
                if (payrow < 0) {
                    payrow = i;
                } else {
                    payrow2 = i;
                }
                KeyNamePair pp = (KeyNamePair)payment.getValueAt(i, 2);
                lastPayment_ID = pp.getKey();
                log.fine("Payment_" + i + " = " + bd + " - Total=" + totalPay);
            }
            ++i;
        }
        BigDecimal totalInv = new BigDecimal(0.0);
        BigDecimal invamt1 = new BigDecimal(0.0);
        BigDecimal invamt2 = new BigDecimal(0.0);
        rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int invrow = -1;
        int invrow2 = -1;
        int i2 = 0;
        while (i2 < rows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i2, this.i_open);
                totalInv = totalInv.add(bd);
                if (invamt1.intValue() == 0) {
                    invamt1 = (BigDecimal)invoice.getValueAt(i2, this.i_open);
                } else {
                    invamt2 = (BigDecimal)invoice.getValueAt(i2, this.i_open);
                }
                ++this.m_noInvoices;
                if (invrow < 0) {
                    invrow = i2;
                } else {
                    invrow2 = i2;
                }
                KeyNamePair pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                if (lastInvoice_ID == 0) {
                    lastInvoice_ID = pp.getKey();
                } else {
                    lastInvoice2_ID = pp.getKey();
                }
                log.fine("Invoice_" + i2 + " = " + bd + " - Total=" + totalPay);
            }
            ++i2;
        }
        this.totalPayment = totalPay;
        this.totalInvoiced = totalInv;
        log.config("noInvoices:" + this.m_noInvoices + " total: " + this.totalInvoiced + " noPayments:" + this.m_noPayments + " total:" + totalPay);
        if (this.m_noInvoices > 1 && this.m_noPayments > 1) {
            RetValue = 0;
        }
        if (autoWriteOff && this.m_noInvoices > 0 && this.m_noPayments > 0) {
            RetValue = 0;
        }
        if (this.m_noPayments == 1 && this.m_noInvoices == 1) {
            if (this.totalInvoiced.intValue() > 0 && totalPay.intValue() > 0) {
                if (this.totalInvoiced.compareTo(totalPay) == 0) {
                    payment.setValueAt((Object)totalPay, payrow, this.i_payment);
                    invoice.setValueAt((Object)this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 1;
                } else if (this.totalInvoiced.compareTo(totalPay) > 0) {
                    payment.setValueAt((Object)totalPay, payrow, this.i_payment);
                    invoice.setValueAt((Object)totalPay, invrow, this.i_applied);
                    RetValue = 2;
                } else {
                    payment.setValueAt((Object)this.totalInvoiced, payrow, this.i_payment);
                    invoice.setValueAt((Object)this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 3;
                }
            }
            if (this.totalInvoiced.intValue() < 0 && totalPay.intValue() < 0) {
                if (this.totalInvoiced.abs().compareTo(totalPay.abs()) == 0) {
                    payment.setValueAt((Object)totalPay, payrow, this.i_payment);
                    invoice.setValueAt((Object)this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 1;
                } else if (this.totalInvoiced.abs().compareTo(totalPay.abs()) > 0) {
                    payment.setValueAt((Object)totalPay, payrow, this.i_payment);
                    invoice.setValueAt((Object)totalPay, invrow, this.i_applied);
                    RetValue = 6;
                } else {
                    payment.setValueAt((Object)this.totalInvoiced, payrow, this.i_payment);
                    invoice.setValueAt((Object)this.totalInvoiced, invrow, this.i_applied);
                    RetValue = 5;
                }
            }
        } else if (this.m_noPayments == 2 && this.m_noInvoices == 0) {
            if (payamt1.intValue() > 0 && payamt2.intValue() < 0 || payamt1.intValue() < 0 && payamt2.intValue() > 0) {
                log.info("payrow:" + payrow + "payrow2:" + payrow2 + ",payamt1:" + payamt1 + " ,payamt2:" + payamt2);
                if (payamt1.abs().compareTo(payamt2.abs()) > 0) {
                    if (payamt2.intValue() < 0) {
                        payment.setValueAt((Object)payamt2.abs(), payrow, this.i_payment);
                    } else {
                        payment.setValueAt((Object)payamt2.negate(), payrow, this.i_payment);
                    }
                    payment.setValueAt((Object)payamt2, payrow2, this.i_payment);
                    RetValue = 11;
                } else if (payamt2.abs().compareTo(payamt1.abs()) > 0) {
                    if (payamt1.intValue() < 0) {
                        payment.setValueAt((Object)payamt1.abs(), payrow2, this.i_payment);
                    } else {
                        payment.setValueAt((Object)payamt1.negate(), payrow2, this.i_payment);
                    }
                    payment.setValueAt((Object)payamt1, payrow, this.i_payment);
                    RetValue = 11;
                } else if (payamt2.abs().compareTo(payamt1.abs()) == 0) {
                    payment.setValueAt((Object)payamt1, payrow, this.i_payment);
                    payment.setValueAt((Object)payamt2, payrow2, this.i_payment);
                    RetValue = 10;
                }
            }
        } else if (this.m_noPayments == 0 && this.m_noInvoices == 2) {
            MInvoice inv1 = new MInvoice(Env.getCtx(), lastInvoice_ID, null);
            MInvoice inv2 = new MInvoice(Env.getCtx(), lastInvoice2_ID, null);
            if (inv1.getC_Currency_ID() == inv2.getC_Currency_ID() && inv1.getC_Currency_ID() != this.m_C_Currency_ID) {
                return 12;
            }
            if (invamt1.intValue() > 0 && invamt2.intValue() < 0 || invamt1.intValue() < 0 && invamt2.intValue() > 0) {
                log.info("invrow:" + invrow + "invrow2:" + invrow2 + ",invamt1:" + invamt1 + " ,invamt2:" + invamt2);
                if (invamt1.abs().compareTo(invamt2.abs()) > 0) {
                    if (invamt2.intValue() < 0) {
                        invoice.setValueAt((Object)invamt2.abs(), invrow, this.i_applied);
                    } else {
                        invoice.setValueAt((Object)invamt2.negate(), invrow, this.i_applied);
                    }
                    invoice.setValueAt((Object)invamt2, invrow2, this.i_applied);
                    RetValue = 8;
                } else if (invamt2.abs().compareTo(invamt1.abs()) > 0) {
                    if (invamt1.intValue() < 0) {
                        invoice.setValueAt((Object)invamt1.abs(), invrow2, this.i_applied);
                    } else {
                        invoice.setValueAt((Object)invamt1.negate(), invrow2, this.i_applied);
                    }
                    invoice.setValueAt((Object)invamt1, invrow, this.i_applied);
                    RetValue = 8;
                } else if (invamt2.abs().compareTo(invamt1.abs()) == 0) {
                    invoice.setValueAt((Object)invamt1, invrow, this.i_applied);
                    invoice.setValueAt((Object)invamt2, invrow2, this.i_applied);
                    RetValue = 7;
                }
            }
        } else if (this.m_noPayments == 0 && this.m_noInvoices == 1) {
            if (autoWriteOff) {
                invoice.setValueAt((Object)invamt1, invrow, this.i_writeOff);
                invoice.setValueAt((Object)Env.ZERO, invrow, this.i_applied);
                RetValue = 9;
            }
        } else if (this.m_noPayments == 1 && this.m_noInvoices == 0 && autoWriteOff) {
            payment.setValueAt((Object)payamt1, payrow, this.i_payment);
            this.indicator = 9;
            RetValue = 9;
        }
        this.m_AD_OrgDoc_ID = lastPayment_ID > 0 ? DB.getSQLValue(null, (String)("select ad_org_id from c_payment where c_payment_id=" + lastPayment_ID)) : DB.getSQLValue(null, (String)("select ad_org_id from c_invoice where c_invoice_id=" + lastInvoice_ID));
        this.multiprocess = false;
        return RetValue;
    }
}

