/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.rmi.AccessException;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.OnlineHelp;
import org.compiere.apps.StatusBar;
import org.compiere.db.CConnection;
import org.compiere.db.CConnectionEditor;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.print.CPrinter;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.ofb.model.OFBForward;

public final class ALogin
extends CDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -3057525535969948097L;
    protected static final String RESOURCE = "org.compiere.apps.ALoginRes";
    private static ResourceBundle res = ResourceBundle.getBundle("org.compiere.apps.ALoginRes");
    private static CLogger log = CLogger.getCLogger(ALogin.class);
    private CPanel mainPanel = new CPanel((LayoutManager)new BorderLayout());
    private CTabbedPane loginTabPane = new CTabbedPane();
    private CPanel connectionPanel = new CPanel();
    private CLabel hostLabel = new CLabel();
    private CConnectionEditor hostField = new CConnectionEditor();
    private CLabel userLabel = new CLabel();
    private CTextField userTextField = new CTextField();
    private CLabel passwordLabel = new CLabel();
    private JPasswordField passwordField = new JPasswordField();
    private CPanel defaultPanel = new CPanel();
    private CLabel clientLabel = new CLabel();
    private CLabel orgLabel = new CLabel();
    private CLabel dateLabel = new CLabel();
    private VDate dateField = new VDate(15);
    private VComboBox orgCombo = new VComboBox();
    private VComboBox clientCombo = new VComboBox();
    private CLabel warehouseLabel = new CLabel();
    private VComboBox warehouseCombo = new VComboBox();
    private CLabel printerLabel = new CLabel();
    private CPrinter printerField = new CPrinter();
    private CLabel roleLabel = new CLabel();
    private VComboBox roleCombo = new VComboBox();
    private CLabel copy0Label = new CLabel();
    private CLabel titleLabel = new CLabel();
    private CLabel versionLabel = new CLabel();
    private CLabel copy1Label = new CLabel();
    private GridBagLayout connectionLayout = new GridBagLayout();
    private GridBagLayout defaultPanelLayout = new GridBagLayout();
    private CLabel languageLabel = new CLabel();
    private VComboBox languageCombo = new VComboBox((Object[])Language.getNames());
    private CLabel compileDate = new CLabel();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private StatusBar statusBar = new StatusBar();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, false, false, false, false, false);
    private CConnection m_cc;
    private String m_user;
    private String m_pwd;
    private boolean m_comboActive = false;
    private boolean m_okPressed = false;
    private boolean m_connectionOK = false;
    private int m_WindowNo;
    private Properties m_ctx = Env.getCtx();
    private Login m_login = null;
    private String txt_NotConnected;
    private String txt_NoDatabase;
    private String txt_UserPwdError;
    private String txt_RoleError;
    private String txt_LoggedIn;

    public ALogin(Frame parent) {
        super(parent, "Login", true);
        log.finer("");
        this.setDefaultCloseOperation(2);
        this.m_WindowNo = Env.createWindowNo(null);
        res = ResourceBundle.getBundle(RESOURCE);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.severe(e.toString());
        }
        this.getRootPane().setDefaultButton((JButton)this.confirmPanel.getOKButton());
        parent.setIconImage(Adempiere.getImage16());
    }

    private void jbInit() throws Exception {
        this.setName("Login");
        this.titleLabel.setFont(new Font("Serif", 2, 10));
        this.titleLabel.setForeground(Color.blue);
        this.titleLabel.setRequestFocusEnabled(false);
        this.titleLabel.setToolTipText(Adempiere.getURL());
        this.titleLabel.setHorizontalTextPosition(0);
        this.titleLabel.setIcon((Icon)Adempiere.getImageIconLogo());
        this.titleLabel.setText(Adempiere.getSubtitle());
        this.titleLabel.setVerticalTextPosition(3);
        this.versionLabel.setRequestFocusEnabled(false);
        this.versionLabel.setHorizontalAlignment(4);
        this.versionLabel.setHorizontalTextPosition(4);
        this.hostLabel.setRequestFocusEnabled(false);
        this.hostLabel.setLabelFor((Component)this.hostField);
        this.hostField.addActionListener((ActionListener)this);
        this.userLabel.setRequestFocusEnabled(false);
        this.userLabel.setLabelFor((Component)this.userTextField);
        this.passwordLabel.setRequestFocusEnabled(false);
        this.passwordLabel.setLabelFor((Component)this.passwordField);
        this.languageLabel.setLabelFor((Component)this.languageCombo);
        this.copy0Label.setFont(new Font("Serif", 2, 10));
        this.copy0Label.setForeground(Color.blue);
        this.copy0Label.setRequestFocusEnabled(false);
        this.copy1Label.setRequestFocusEnabled(false);
        this.roleLabel.setRequestFocusEnabled(false);
        this.roleLabel.setLabelFor((Component)this.roleCombo);
        this.clientLabel.setRequestFocusEnabled(false);
        this.orgLabel.setRequestFocusEnabled(false);
        this.dateLabel.setRequestFocusEnabled(false);
        this.warehouseLabel.setRequestFocusEnabled(false);
        this.printerLabel.setRequestFocusEnabled(false);
        this.compileDate.setHorizontalAlignment(4);
        this.compileDate.setHorizontalTextPosition(4);
        this.compileDate.setText(Adempiere.DATE_VERSION);
        this.compileDate.setToolTipText(Adempiere.getImplementationVendor());
        this.southPanel.setLayout((LayoutManager)this.southLayout);
        this.loginTabPane.addChangeListener((ChangeListener)this);
        this.connectionPanel.setLayout((LayoutManager)this.connectionLayout);
        this.titleLabel.setHorizontalAlignment(0);
        this.versionLabel.setText(Adempiere.MAIN_VERSION);
        this.versionLabel.setToolTipText(Adempiere.getImplementationVersion());
        this.hostLabel.setHorizontalAlignment(4);
        this.hostLabel.setText("Host");
        this.hostLabel.setLabelFor((Component)this.hostField);
        this.connectionPanel.add((Component)this.hostLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.connectionPanel.add((Component)this.hostField, (Object)new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.userLabel.setHorizontalAlignment(4);
        this.userLabel.setText("User");
        this.userLabel.setLabelFor((Component)this.userTextField);
        this.connectionPanel.add((Component)this.userLabel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.userTextField.setText("System");
        this.connectionPanel.add((Component)this.userTextField, (Object)new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.passwordLabel.setHorizontalAlignment(4);
        this.passwordLabel.setText("Password");
        this.passwordLabel.setLabelFor((Component)this.passwordField);
        this.connectionPanel.add((Component)this.passwordLabel, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.passwordField.setText("System");
        this.connectionPanel.add((Component)this.passwordField, (Object)new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.languageLabel.setHorizontalAlignment(4);
        this.languageLabel.setText("Language");
        this.languageLabel.setLabelFor((Component)this.languageCombo);
        this.languageCombo.addActionListener((ActionListener)this);
        this.connectionPanel.add((Component)this.languageLabel, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.connectionPanel.add((Component)this.languageCombo, (Object)new GridBagConstraints(1, 5, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.copy0Label.setText("OFBConsulting Version 20240726.A");
        this.copy0Label.setHorizontalAlignment(4);
        this.connectionPanel.add((Component)this.copy0Label, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.copy1Label.setText("\u00a9 1999-2015 ADempiere\u00ae");
        this.connectionPanel.add((Component)this.copy1Label, (Object)new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 12, 12), 0, 0));
        this.connectionPanel.add((Component)this.compileDate, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 12, 0, new Insets(2, 0, 0, 12), 0, 0));
        this.connectionPanel.add((Component)this.titleLabel, (Object)new GridBagConstraints(0, 0, 2, 2, 0.0, 0.0, 17, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.connectionPanel.add((Component)this.versionLabel, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 13, 0, new Insets(12, 5, 0, 12), 0, 0));
        this.loginTabPane.add((Component)this.connectionPanel, (Object)res.getString("Connection"));
        this.defaultPanel.setLayout((LayoutManager)this.defaultPanelLayout);
        this.roleLabel.setText("Role");
        this.roleLabel.setHorizontalAlignment(4);
        this.roleLabel.setLabelFor((Component)this.roleCombo);
        this.roleCombo.addActionListener((ActionListener)this);
        this.defaultPanel.add((Component)this.roleLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.defaultPanel.add((Component)this.roleCombo, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.clientLabel.setText("Client");
        this.clientLabel.setHorizontalAlignment(4);
        this.clientLabel.setLabelFor((Component)this.clientCombo);
        this.defaultPanel.add((Component)this.clientLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.clientCombo.addActionListener((ActionListener)this);
        this.defaultPanel.add((Component)this.clientCombo, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.orgLabel.setText("Organization");
        this.orgLabel.setHorizontalAlignment(4);
        this.orgLabel.setLabelFor((Component)this.orgCombo);
        this.defaultPanel.add((Component)this.orgLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.orgCombo.addActionListener((ActionListener)this);
        this.defaultPanel.add((Component)this.orgCombo, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.dateLabel.setText("Date");
        this.dateLabel.setHorizontalAlignment(4);
        this.dateLabel.setLabelFor((Component)this.dateField);
        this.defaultPanel.add((Component)this.dateLabel, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.defaultPanel.add((Component)this.dateField, (Object)new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.warehouseLabel.setText("Warehouse");
        this.warehouseLabel.setHorizontalAlignment(4);
        this.warehouseLabel.setLabelFor((Component)this.warehouseCombo);
        this.printerLabel.setText("Printer");
        this.printerLabel.setHorizontalAlignment(4);
        this.printerLabel.setLabelFor((Component)this.printerField);
        this.defaultPanel.add((Component)this.printerLabel, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 12, 5), 0, 0));
        this.defaultPanel.add((Component)this.printerField, (Object)new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 12, 12), 0, 0));
        this.defaultPanel.add((Component)this.warehouseLabel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.defaultPanel.add((Component)this.warehouseCombo, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 12), 0, 0));
        this.loginTabPane.add((Component)this.defaultPanel, (Object)res.getString("Defaults"));
        this.getContentPane().add((Component)this.mainPanel);
        this.mainPanel.add((Component)this.loginTabPane, (Object)"Center");
        this.mainPanel.setName("loginMainPanel");
        this.mainPanel.add((Component)this.southPanel, (Object)"South");
        this.southPanel.add((Component)this.confirmPanel, (Object)"North");
        this.southPanel.add((Component)this.statusBar, (Object)"South");
        this.confirmPanel.addActionListener((ActionListener)this);
        CButton helpBtn = new CButton((Icon)Env.getImageIcon2((String)"Help24"));
        helpBtn.setActionCommand("onlineLoginHelp");
        helpBtn.addActionListener((ActionListener)this);
        helpBtn.setToolTipText(res.getString("Help"));
        this.confirmPanel.addComponent((Component)helpBtn);
        this.statusBar.setStatusDB(null);
    }

    public boolean initLogin() {
        this.m_cc = CConnection.get((String)Adempiere.getCodeBaseHost());
        this.hostField.setValue((Object)this.m_cc);
        if (Ini.isPropertyBool((String)"ValidateConnectionOnStartup")) {
            this.validateConnection();
        }
        this.userTextField.setText(Ini.getProperty((String)"ApplicationUserID"));
        if (Ini.isPropertyBool((String)"StorePassword")) {
            this.passwordField.setText(Ini.getProperty((String)"ApplicationPassword"));
        } else {
            this.passwordField.setText("");
        }
        this.languageCombo.setSelectedItem((Object)Ini.getProperty((String)"Language"));
        if (Ini.isPropertyBool((String)"AutoLogin")) {
            this.connectionOK();
            this.defaultsOK();
            if (this.m_connectionOK) {
                this.m_okPressed = true;
            }
            return this.m_connectionOK;
        }
        return false;
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            this.toFront();
            this.confirmPanel.getOKButton().requestFocusInWindow();
        }
    }

    private void validateAppServer() {
        if (!CConnection.isServerEmbedded()) {
            this.m_cc.testAppsServer();
        }
    }

    private void connectToDatabase() {
        DB.setDBTarget((CConnection)this.m_cc);
        DB.connect();
    }

    private void validateConnection() {
        this.m_connectionOK = false;
        this.validateAppServer();
        DB.closeTarget();
        this.connectToDatabase();
        this.hostField.setDisplay();
    }

    private void appExit() {
        this.m_connectionOK = false;
        this.dispose();
    }

    public boolean isConnected() {
        return this.m_connectionOK;
    }

    public boolean isOKpressed() {
        return this.m_okPressed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            if (this.loginTabPane.getSelectedIndex() == 0) {
                this.connectionOK();
                this.printerField.refresh();
            } else {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_okPressed = true;
                if (!this.defaultsOK()) {
                    this.m_okPressed = false;
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.appExit();
        } else if (e.getSource() == this.hostField) {
            this.validateConnection();
        } else if (e.getSource() == this.languageCombo) {
            this.languageComboChanged();
        } else if (e.getSource() == this.roleCombo) {
            this.roleComboChanged();
        } else if (e.getSource() == this.clientCombo) {
            this.clientComboChanged();
        } else if (e.getSource() == this.orgCombo) {
            this.orgComboChanged();
        } else if ("onlineLoginHelp".equals(e.getActionCommand())) {
            OnlineHelp.openInDefaultBrowser();
        }
    }

    private void connectionOK() {
        log.info("");
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.confirmPanel.getOKButton().setEnabled(false);
        this.m_connectionOK = this.tryConnection();
        if (this.m_connectionOK) {
            Language l = Language.getLoginLanguage();
            Env.verifyLanguage((Properties)this.m_ctx, (Language)l);
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)l.getAD_Language());
            Msg.getMsg((Properties)this.m_ctx, (String)"0");
            MSystem system = MSystem.get((Properties)this.m_ctx);
            if (system.isJustMigrated()) {
                this.statusBar.setStatusLine("Running: After Migration ....", true);
                ADialog.info((int)this.m_WindowNo, (Container)((Object)this), (String)"AfterMigration");
                Thread.yield();
                DB.afterMigration((Properties)this.m_ctx);
            }
            this.printerField.setValue((Object)Ini.getProperty((String)"Printer"));
            this.loginTabPane.setSelectedIndex(1);
        }
        this.confirmPanel.getOKButton().setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.loginTabPane.getSelectedIndex() == 2) {
            return;
        }
        if (!String.valueOf(this.passwordField.getPassword()).equals(this.m_pwd) || !this.userTextField.getText().equals(this.m_user)) {
            this.m_connectionOK = false;
        }
        if (this.m_connectionOK) {
            this.statusBar.setStatusLine(this.txt_LoggedIn);
        } else {
            this.statusBar.setStatusLine(this.txt_NotConnected, true);
            this.loginTabPane.setSelectedIndex(0);
        }
        this.confirmPanel.getOKButton().requestFocus();
    }

    private boolean defaultsOK() {
        log.info("");
        KeyNamePair org = (KeyNamePair)this.orgCombo.getSelectedItem();
        if (org == null) {
            return false;
        }
        Ini.setProperty((String)"Connection", (String)CConnection.get().toStringLong());
        Ini.setProperty((String)"Language", (String)((String)this.languageCombo.getSelectedItem()));
        String error = this.m_login.validateLogin(org);
        if (error != null && error.length() > 0) {
            ADialog.info((int)this.m_WindowNo, (Container)((Object)this), (String)error);
            this.appExit();
            return false;
        }
        this.statusBar.setStatusLine("Loading Preferences");
        String msg = this.m_login.loadPreferences(org, (KeyNamePair)this.warehouseCombo.getSelectedItem(), this.dateField.getTimestamp(), this.printerField.getDisplay());
        if (msg.length() > 0) {
            ADialog.info((int)this.m_WindowNo, (Container)((Object)this), (String)msg);
        }
        this.checkVersion();
        if (this.m_connectionOK) {
            this.dispose();
        }
        return this.m_connectionOK;
    }

    private boolean tryConnection() {
        this.m_user = this.userTextField.getText();
        this.m_pwd = new String(this.passwordField.getPassword());
        if (!DB.isConnected((boolean)false)) {
            this.validateConnection();
        }
        if (!DB.isConnected((boolean)false)) {
            this.statusBar.setStatusLine(this.txt_NoDatabase, true);
            this.hostField.setBackground(AdempierePLAF.getFieldBackground_Error());
            return false;
        }
        Ini.setProperty((String)"AdempiereSys", (boolean)"Reference".equalsIgnoreCase(CConnection.get().getDbUid()));
        Ini.setProperty((String)"LogMigrationScript", (boolean)"Reference".equalsIgnoreCase(CConnection.get().getDbUid()));
        this.m_login = new Login(this.m_ctx);
        KeyNamePair[] roles = null;
        try {
            roles = this.m_login.getRoles(this.m_user, this.m_pwd);
            if (roles == null || roles.length == 0) {
                this.statusBar.setStatusLine(this.txt_UserPwdError, true);
                this.userTextField.setBackground(AdempierePLAF.getFieldBackground_Error());
                this.passwordField.setBackground(AdempierePLAF.getFieldBackground_Error());
                return false;
            }
        }
        catch (Throwable e) {
            if (e.getCause() instanceof AccessException) {
                this.statusBar.setStatusLine(this.txt_UserPwdError, true);
                this.userTextField.setBackground(AdempierePLAF.getFieldBackground_Error());
                this.passwordField.setBackground(AdempierePLAF.getFieldBackground_Error());
                return false;
            }
            log.severe(CLogger.getRootCause((Throwable)e).getLocalizedMessage());
            this.statusBar.setStatusLine(CLogger.getRootCause((Throwable)e).getLocalizedMessage(), true);
            return false;
        }
        this.m_comboActive = true;
        if (this.roleCombo.getItemCount() > 0) {
            this.roleCombo.removeAllItems();
        }
        KeyNamePair iniValue = null;
        String iniDefault = Ini.getProperty((String)"Role");
        int i = 0;
        while (i < roles.length) {
            this.roleCombo.addItem((Object)roles[i]);
            if (roles[i].getName().equals(iniDefault)) {
                iniValue = roles[i];
            }
            ++i;
        }
        if (iniValue != null) {
            this.roleCombo.setSelectedItem(iniValue);
        }
        if (this.roleCombo.getItemCount() == 1 && !MSysConfig.getBooleanValue((String)"ALogin_ShowOneRole", (boolean)true)) {
            this.roleCombo.setSelectedIndex(0);
            this.roleLabel.setVisible(false);
            this.roleCombo.setVisible(false);
        } else {
            this.roleLabel.setVisible(true);
            this.roleCombo.setVisible(true);
        }
        this.userTextField.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.passwordField.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.setTitle(this.hostField.getDisplay());
        this.statusBar.setStatusLine(this.txt_LoggedIn);
        this.m_comboActive = false;
        this.roleComboChanged();
        return true;
    }

    private void roleComboChanged() {
        KeyNamePair role = (KeyNamePair)this.roleCombo.getSelectedItem();
        if (role == null || this.m_comboActive) {
            return;
        }
        log.config(": " + role);
        this.m_comboActive = true;
        KeyNamePair[] clients = this.m_login.getClients(role);
        if (this.clientCombo.getItemCount() > 0) {
            this.clientCombo.removeAllItems();
        }
        if (this.orgCombo.getItemCount() > 0) {
            this.orgCombo.removeAllItems();
        }
        if (clients == null || clients.length == 0) {
            this.statusBar.setStatusLine(this.txt_RoleError, true);
            this.m_comboActive = false;
            return;
        }
        KeyNamePair iniValue = null;
        String iniDefault = Ini.getProperty((String)"Client");
        int i = 0;
        while (i < clients.length) {
            this.clientCombo.addItem((Object)clients[i]);
            if (clients[i].getName().equals(iniDefault)) {
                iniValue = clients[i];
            }
            ++i;
        }
        if (iniValue != null) {
            this.clientCombo.setSelectedItem(iniValue);
        }
        this.m_comboActive = false;
        this.clientComboChanged();
    }

    private void clientComboChanged() {
        KeyNamePair client = (KeyNamePair)this.clientCombo.getSelectedItem();
        if (client == null || this.m_comboActive) {
            return;
        }
        log.config(": " + client);
        this.m_comboActive = true;
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (int)client.getKey());
        KeyNamePair[] rolesKNPairs = this.m_login.getRoles(this.userTextField.getText(), new String(this.passwordField.getPassword()));
        if (rolesKNPairs == null || rolesKNPairs.length == 0) {
            throw new AdempiereException("@UserPwdError@");
        }
        KeyNamePair[] orgs = this.m_login.getOrgs(client);
        if (this.orgCombo.getItemCount() > 0) {
            this.orgCombo.removeAllItems();
        }
        if (orgs == null || orgs.length == 0) {
            this.statusBar.setStatusLine(this.txt_RoleError, true);
            this.m_comboActive = false;
            return;
        }
        KeyNamePair orgValue = null;
        KeyNamePair orgValue2 = null;
        String iniDefault = Ini.getProperty((String)"Organization");
        String defaultOrganizationCC = OFBForward.DefaultOrganizationCC();
        String defaultRoleCC = OFBForward.DefaultRoleCC();
        int i = 0;
        while (i < orgs.length) {
            String org = "";
            KeyNamePair role = (KeyNamePair)this.roleCombo.getSelectedItem();
            this.orgCombo.addItem((Object)orgs[i]);
            String a = orgs[i].getName();
            if (orgs[i].getName().equals(defaultOrganizationCC) && role.getName().compareToIgnoreCase(defaultRoleCC) == 0) {
                orgValue = orgs[i];
                org = orgs[i].getName();
            } else if (orgs[i].getName().equals(iniDefault) && org.compareToIgnoreCase(defaultOrganizationCC) != 0 && role.getName().compareToIgnoreCase(defaultRoleCC) != 0) {
                orgValue = orgs[i];
            }
            orgValue2 = orgs[i];
            ++i;
        }
        if (orgValue2 != null && orgValue != null && orgValue.getKey() == 0) {
            orgValue = orgValue2;
        }
        if (orgValue != null) {
            this.orgCombo.setSelectedItem(orgValue);
        } else {
            orgValue = (KeyNamePair)this.orgCombo.getSelectedItem();
        }
        this.m_comboActive = false;
        this.orgComboChanged();
    }

    private void orgComboChanged() {
        KeyNamePair org = (KeyNamePair)this.orgCombo.getSelectedItem();
        if (org == null || this.m_comboActive) {
            return;
        }
        log.config(": " + org);
        this.m_comboActive = true;
        KeyNamePair[] whs = this.m_login.getWarehouses(org);
        if (this.warehouseCombo.getItemCount() > 0) {
            this.warehouseCombo.removeAllItems();
        }
        if (whs != null) {
            KeyNamePair iniValue = null;
            String iniDefault = Ini.getProperty((String)"Warehouse");
            int i = 0;
            while (i < whs.length) {
                this.warehouseCombo.addItem((Object)whs[i]);
                if (whs[i].getName().equals(iniDefault)) {
                    iniValue = whs[i];
                }
                ++i;
            }
            if (iniValue != null) {
                this.warehouseCombo.setSelectedItem(iniValue);
            }
        }
        this.m_comboActive = false;
    }

    private boolean checkVersion() {
        boolean retValue = false;
        try {
            String version = AEnv.getServerVersion();
            if (Adempiere.DATE_VERSION.equals(version)) {
                log.config("Server = Client - " + version);
                retValue = true;
            } else if (version != null) {
                StringBuffer msg = new StringBuffer(">>\n");
                msg.append(res.getString("VersionConflict")).append("\n").append(res.getString("VersionInfo")).append("\n");
                msg.append(version == null ? "null" : version).append(" <> ").append(Adempiere.DATE_VERSION).append("\n");
                msg.append(res.getString("PleaseUpgrade")).append("\n<<");
                JOptionPane.showMessageDialog(null, msg.toString(), String.valueOf(Adempiere.getName()) + " - " + res.getString("VersionConflict"), 0);
                AEnv.exit((int)1);
            }
        }
        catch (Exception e) {
            log.severe("Contact Server failed - " + e.getClass().toString() + ": " + e.getMessage());
        }
        return retValue;
    }

    private void languageComboChanged() {
        String langName = (String)this.languageCombo.getSelectedItem();
        Language language = Language.getLanguage((String)langName);
        Language.setLoginLanguage((Language)language);
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)language.getAD_Language());
        Locale loc = language.getLocale();
        Locale.setDefault(loc);
        this.setLocale(loc);
        res = ResourceBundle.getBundle(RESOURCE, loc);
        this.setTitle(res.getString("Login"));
        this.hostLabel.setText(res.getString("Host"));
        this.userLabel.setText(res.getString("User"));
        this.userLabel.setToolTipText(res.getString("EnterUser"));
        this.passwordLabel.setText(res.getString("Password"));
        this.passwordLabel.setToolTipText(res.getString("EnterPassword"));
        this.languageLabel.setText(res.getString("Language"));
        this.languageLabel.setToolTipText(res.getString("SelectLanguage"));
        this.roleLabel.setText(res.getString("Role"));
        this.clientLabel.setText(res.getString("Client"));
        this.orgLabel.setText(res.getString("Organization"));
        this.dateLabel.setText(res.getString("Date"));
        this.warehouseLabel.setText(res.getString("Warehouse"));
        this.printerLabel.setText(res.getString("Printer"));
        this.defaultPanel.setToolTipText(res.getString("Defaults"));
        this.connectionPanel.setToolTipText(res.getString("Connection"));
        this.txt_NotConnected = res.getString("NotConnected");
        this.txt_NoDatabase = res.getString("DatabaseNotFound");
        this.txt_UserPwdError = res.getString("UserPwdError");
        this.txt_RoleError = res.getString("RoleNotFound");
        this.txt_LoggedIn = res.getString("Authorized");
        this.loginTabPane.setTitleAt(0, res.getString("Connection"));
        this.loginTabPane.setTitleAt(1, res.getString("Defaults"));
        this.confirmPanel.getOKButton().setToolTipText(res.getString("Ok"));
        this.confirmPanel.getCancelButton().setToolTipText(res.getString("Cancel"));
        this.dateField.setFormat();
        this.dateField.setValue((Object)new Timestamp(System.currentTimeMillis()));
        if (this.m_connectionOK) {
            this.setTitle(this.hostField.getDisplay());
            this.statusBar.setStatusLine(this.txt_LoggedIn);
        } else {
            this.setTitle(res.getString("Login"));
            this.statusBar.setStatusLine(this.txt_NotConnected, true);
        }
    }
}

