/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.OFBProductCost;
import org.compiere.model.ProductCost;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_MatchInv
extends Doc {
    private MInvoiceLine m_invoiceLine = null;
    private MInOutLine m_receiptLine = null;
    private ProductCost m_pc = null;

    public Doc_MatchInv(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMatchInv.class, rs, "MXI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMatchInv matchInv = (MMatchInv)((Object)this.getPO());
        this.setDateDoc(matchInv.getDateTrx());
        this.setQty(matchInv.getQty());
        int C_InvoiceLine_ID = matchInv.getC_InvoiceLine_ID();
        this.m_invoiceLine = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, null);
        int C_BPartner_ID = this.m_invoiceLine.getParent().getC_BPartner_ID();
        this.setC_BPartner_ID(C_BPartner_ID);
        int M_InOutLine_ID = matchInv.getM_InOutLine_ID();
        this.m_receiptLine = new MInOutLine(this.getCtx(), M_InOutLine_ID, null);
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), matchInv.getM_AttributeSetInstance_ID(), null);
        this.m_pc.setQty(this.getQty());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0 || this.m_receiptLine.getMovementQty().signum() == 0) {
            this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
            return facts;
        }
        Fact fact = new Fact((Doc)this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        MDocType DocType = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"MXI")[0];
        if (!DocType.get_ValueAsBoolean("Posted")) {
            return facts;
        }
        BigDecimal invAmt = this.getLineAmt(MInvoice.Table_ID, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), as.getC_AcctSchema_ID());
        BigDecimal inoutAmt = this.getLineAmt(MInOut.Table_ID, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), as.getC_AcctSchema_ID());
        int invQty = this.getQtyAmt(MInvoice.Table_ID, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), as.getC_AcctSchema_ID());
        int inoutQty = this.getQtyAmt(MInOut.Table_ID, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), as.getC_AcctSchema_ID());
        Boolean costoZero = true;
        this.log.config("invAmt:" + invAmt);
        this.log.config("inoutAmt:" + inoutAmt);
        this.log.config("invQty:" + invQty);
        this.log.config("inoutQty:" + inoutQty);
        if (invAmt.signum() == 0 && invQty == 0) {
            this.p_Error = "Invoice not posted yet";
            return null;
        }
        if (inoutAmt.signum() == 0 && inoutQty == 0) {
            this.p_Error = "Mat.Receipt not posted yet";
            return null;
        }
        if (invAmt.signum() == 0 && inoutAmt.signum() == 0 && invQty > 0) {
            return facts;
        }
        FactLine dr = fact.createLine(null, this.getAccount(51, as), as.getC_Currency_ID(), inoutAmt, null);
        if (dr == null && !costoZero.booleanValue()) {
            this.p_Error = "No Product Costs";
            return null;
        }
        dr.setQty(this.getQty());
        MAccount expense = this.m_pc.getAccount(10, as);
        if (this.m_pc.isService()) {
            expense = this.m_pc.getAccount(2, as);
        }
        FactLine cr = null;
        cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, invAmt);
        cr.setQty(this.getQty().negate());
        BigDecimal realAmt = invAmt.subtract(inoutAmt);
        this.log.config("realAmt:" + realAmt);
        if (realAmt.signum() != 0) {
            BigDecimal pricein = inoutAmt.divide(this.m_receiptLine.getQtyEntered(), 2, 4);
            BigDecimal priceinv = invAmt.divide(this.m_invoiceLine.getQtyInvoiced(), 2, 4);
            this.log.info("price in:" + pricein);
            this.log.info("price inv:" + priceinv);
            if (pricein.compareTo(priceinv) != 0) {
                BigDecimal diff = priceinv.subtract(pricein);
                diff = diff.multiply(this.m_receiptLine.getQtyEntered());
                OFBProductCost.createInvoice(as, this.m_invoiceLine.getAD_Org_ID(), this.m_invoiceLine.getM_Product_ID(), this.m_invoiceLine.getM_AttributeSetInstance_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), 0, diff, Env.ZERO, "Ajuste Diferencia de Cambio", this.getTrxName());
                FactLine pv = fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), diff);
                pv.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
                pv.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
                pv.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
                pv.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
                pv.setUser1_ID(this.m_invoiceLine.getUser1_ID());
                pv.setUser2_ID(this.m_invoiceLine.getUser2_ID());
            }
        }
        this.updateProductInfo(as.getC_AcctSchema_ID(), "S".equals(as.getCostingMethod()));
        facts.add(fact);
        if (as.isAccrual() && as.isCreatePOCommitment()) {
            fact = Doc_Order.getCommitmentRelease((MAcctSchema)as, (Doc)this, (BigDecimal)this.getQty(), (int)this.m_invoiceLine.getC_InvoiceLine_ID(), (BigDecimal)Env.ONE);
            if (fact == null) {
                return null;
            }
            facts.add(fact);
        }
        return facts;
    }

    private boolean updateProductInfo(int C_AcctSchema_ID, boolean standardCosting) {
        this.log.fine("M_MatchInv_ID=" + this.get_ID());
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing pc SET (CostStandardCumQty,CostStandardCumAmt, CostAverageCumQty,CostAverageCumAmt) = (SELECT pc.CostStandardCumQty + m.Qty,pc.CostStandardCumAmt + currencyConvert(il.PriceActual,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*m.Qty, pc.CostAverageCumQty + m.Qty,pc.CostAverageCumAmt + currencyConvert(il.PriceActual,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*m.Qty FROM M_MatchInv m INNER JOIN C_InvoiceLine il ON (m.C_InvoiceLine_ID=il.C_InvoiceLine_ID) INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID), C_AcctSchema a WHERE pc.C_AcctSchema_ID=a.C_AcctSchema_ID AND pc.M_Product_ID=m.M_Product_ID AND m.M_MatchInv_ID=").append(this.get_ID()).append(")WHERE pc.C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM M_MatchInv m WHERE pc.M_Product_ID=m.M_Product_ID AND m.M_MatchInv_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.getTrxName());
        this.log.fine("M_Product_Costing - Qty/Amt Updated #=" + no);
        sql = new StringBuffer("UPDATE M_Product_Costing SET CostAverage = CostAverageCumAmt/DECODE(CostAverageCumQty, 0,1, CostAverageCumQty) WHERE C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND M_Product_ID=").append(this.getM_Product_ID());
        no = DB.executeUpdate((String)sql.toString(), (String)this.getTrxName());
        this.log.fine("M_Product_Costing - AvgCost Updated #=" + no);
        if (!standardCosting) {
            sql = new StringBuffer("UPDATE M_Product_Costing SET CurrentCostPrice = CostAverage WHERE C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND M_Product_ID=").append(this.getM_Product_ID());
            no = DB.executeUpdate((String)sql.toString(), (String)this.getTrxName());
            this.log.fine("M_Product_Costing - CurrentCost Updated=" + no);
        }
        return true;
    }

    public BigDecimal getLineAmt(int AD_Table_ID, int Record_ID, int Line_ID, int C_AcctSchema_ID) {
        BigDecimal amt;
        block6: {
            amt = Env.ZERO;
            String sql = "SELECT * FROM Fact_Acct WHERE C_AcctSchema_ID=? AND AD_Table_ID=? AND Record_ID=? AND Line_ID=? AND AmtAcctDr>0";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                    pstmt.setInt(1, C_AcctSchema_ID);
                    pstmt.setInt(2, AD_Table_ID);
                    pstmt.setInt(3, Record_ID);
                    pstmt.setInt(4, Line_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        amt = rs.getBigDecimal("AmtAcctDr");
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return amt;
    }

    public int getQtyAmt(int AD_Table_ID, int Record_ID, int Line_ID, int C_AcctSchema_ID) {
        int qty;
        block6: {
            qty = 0;
            String sql = "SELECT * FROM Fact_Acct WHERE C_AcctSchema_ID=? AND AD_Table_ID=? AND Record_ID=? AND Line_ID=? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                    pstmt.setInt(1, C_AcctSchema_ID);
                    pstmt.setInt(2, AD_Table_ID);
                    pstmt.setInt(3, Record_ID);
                    pstmt.setInt(4, Line_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        qty = 1;
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return qty;
    }
}

