/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA.model;

import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.FA.exceptions.AssetInvoiceWithMixedLines_LRO;
import org.compiere.FA.exceptions.AssetProductStockedException;
import org.compiere.acct.Fact;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_M_InOut;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MAssetDisposed;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.ofb.model.OFBForward;

public class ModelValidator
implements org.compiere.model.ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(ModelValidator.class);
    private int m_AD_Client_ID = -1;

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("C_InvoiceLine", (org.compiere.model.ModelValidator)this);
        engine.addModelChange("M_MatchInv", (org.compiere.model.ModelValidator)this);
        engine.addModelChange("A_Asset_Group", (org.compiere.model.ModelValidator)this);
        engine.addDocValidate("C_Invoice", (org.compiere.model.ModelValidator)this);
        engine.addDocValidate("M_InOut", (org.compiere.model.ModelValidator)this);
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po instanceof MMatchInv && (4 == type || 5 == type && po.is_ValueChanged("Processed"))) {
            MInvoiceLine invoiceLine;
            MMatchInv mi = (MMatchInv)((Object)po);
            if (mi.isProcessed() && (invoiceLine = new MInvoiceLine(mi.getCtx(), mi.getC_InvoiceLine_ID(), mi.get_TrxName())).isA_CreateAsset() && !invoiceLine.isA_Processed()) {
                int loopQty = 1;
                if ("Exp".equals(invoiceLine.getA_CapvsExp())) {
                    invoiceLine.set_ValueOfColumn("IsCollectiveAsset", false);
                }
                if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0) {
                    invoiceLine.set_ValueOfColumn("IsCollectiveAsset", false);
                }
                if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() <= 0 && !invoiceLine.get_ValueAsBoolean("IsCollectiveAsset")) {
                    loopQty = mi.getQty().intValue();
                }
                int i = 0;
                while (i < loopQty) {
                    MAssetAddition.createAsset((MMatchInv)mi);
                    ++i;
                }
            }
        } else if (po instanceof MInvoiceLine) {
            MInvoiceLine il = (MInvoiceLine)((Object)po);
            if (type == 2 || type == 1) {
                this.beforeSave(il, type == 1);
            }
            ModelValidator.modelChange_InvoiceLine(SetGetUtil.wrap((Object)po), type);
        } else if (po.get_TableName().equals("A_Asset_Group")) {
            MAssetGroup ag = (MAssetGroup)po;
            if (type == 1 || type == 2) {
                this.beforeSave(ag, type == 1);
            } else if (type == 4 || type == 5) {
                this.afterSave(ag, type == 4);
            } else if (type == 3) {
                this.beforeDelete(ag);
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        int n;
        int n2;
        Object[] objectArray;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        String result = null;
        String tableName = po.get_TableName();
        if (tableName.equals("C_Invoice")) {
            String error;
            MInvoice mi;
            MInvoice invoice;
            if (timing == 8) {
                invoice = (MInvoice)((Object)po);
                this.validateFixedAssetsInvoice_LRO(invoice);
            }
            if (timing == 9 && (mi = (MInvoice)((Object)po)).isSOTrx()) {
                MInvoiceLine[] mils;
                objectArray = mils = mi.getLines();
                n2 = mils.length;
                n = 0;
                while (n < n2) {
                    MInvoiceLine mil = objectArray[n];
                    if (mil.isA_CreateAsset() && !mil.isA_Processed()) {
                        MAssetDisposed.createAssetDisposed((MInvoiceLine)mil);
                    }
                    ++n;
                }
            }
            if (timing == 10 && (error = this.afterVoid(invoice = (MInvoice)((Object)po))) != null) {
                return error;
            }
            if (timing == 5 && (error = this.beforeReverseCorrect(invoice = (MInvoice)((Object)po))) != null) {
                return error;
            }
        }
        if (tableName.equals("M_InOut")) {
            MInOut inOut;
            if (timing == 9) {
                inOut = (MInOut)((Object)po);
                MInOutLine[] mInOutLineArray = inOut.getLines();
                n = mInOutLineArray.length;
                int mil = 0;
                while (mil < n) {
                    MInOutLine inOutLine = mInOutLineArray[mil];
                    MProduct product = inOutLine.getProduct();
                    if (product != null && inOut.isSOTrx() && product.isCreateAsset() && !product.getM_Product_Category().getA_Asset_Group().isFixedAsset() && inOutLine.getMovementQty().signum() > 0 && !inOut.isReversal()) {
                        log.fine("Asset");
                        int noAssets = inOutLine.getMovementQty().intValue();
                        if (!product.isOneAssetPerUOM()) {
                            noAssets = 1;
                        }
                        int i = 0;
                        while (i < noAssets) {
                            MAsset asset;
                            int deliveryCount = i + 1;
                            if (!product.isOneAssetPerUOM()) {
                                deliveryCount = 0;
                            }
                            if (!(asset = new MAsset(inOut, inOutLine, deliveryCount)).save(inOut.get_TrxName())) {
                                throw new IllegalStateException("Could not create Asset");
                            }
                            ++i;
                        }
                    }
                    ++mil;
                }
            }
            if (timing == 13) {
                inOut = (MInOut)((Object)po);
                I_M_InOut inOutReversal = inOut.getReversal();
                objectArray = inOut.getLines();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    MInvoiceLine inOutLine = objectArray[n];
                    MAsset asset = MAsset.getFromShipment(inOut.getCtx(), inOutLine.getM_InOutLine_ID(), inOut.get_TrxName());
                    if (asset != null) {
                        asset.setIsActive(false);
                        asset.setDescription(String.valueOf(asset.getDescription()) + " (" + inOutReversal.getDocumentNo() + " #" + inOutLine.getLine() + "<-)");
                        asset.saveEx();
                    }
                    ++n;
                }
            }
        }
        return result;
    }

    public static void modelChange_InvoiceLine(SetGetModel m, int changeType) {
        if (-1 == changeType || 1 == changeType || 2 == changeType) {
            boolean isAsset = false;
            int assetGroup_ID = 0;
            isAsset = SetGetUtil.get_AttrValueAsBoolean((SetGetModel)m, (String)"A_CreateAsset");
            int product_id = SetGetUtil.get_AttrValueAsInt((SetGetModel)m, (String)"M_Product_ID");
            if (product_id > 0) {
                MProduct prod = MProduct.get(m.getCtx(), product_id);
                if (prod.isCreateAsset()) {
                    isAsset = prod != null && prod.get_ID() > 0 && prod.isCreateAsset();
                    assetGroup_ID = prod.getA_Asset_Group_ID();
                } else {
                    assetGroup_ID = SetGetUtil.get_AttrValueAsInt((SetGetModel)m, (String)"A_Asset_Group_ID");
                }
            }
            m.set_AttrValue("A_CreateAsset", (Object)isAsset);
            if (isAsset) {
                m.set_AttrValue("A_Asset_Group_ID", (Object)assetGroup_ID);
                m.set_AttrValue("IsFixedAssetInvoice", (Object)isAsset);
                m.set_AttrValue("A_CreateAsset", (Object)"Y");
            } else {
                m.set_AttrValue("A_Asset_Group_ID", null);
                m.set_AttrValue("A_Asset_ID", null);
                m.set_AttrValue("IsFixedAssetInvoice", (Object)false);
            }
            if (isAsset && m instanceof MInvoiceLine) {
                MInvoiceLine line = (MInvoiceLine)m;
                if ("Exp".equals(line.getA_CapvsExp()) && line.getA_Asset_ID() <= 0) {
                    throw new FillMandatoryException(new String[]{"A_Asset_ID"});
                }
                if (line.getLineNetAmt().signum() == 0) {
                    throw new FillMandatoryException(new String[]{"QtyEntered", "PriceEntered"});
                }
                MProduct product = line.getProduct();
                if (product.isStocked() && line.get_ValueAsBoolean("IsFixedAssetInvoice")) {
                    throw new AssetProductStockedException(product);
                }
            }
        }
        if (4 == changeType || 5 == changeType || 6 == changeType) {
            int invoice_id = SetGetUtil.get_AttrValueAsInt((SetGetModel)m, (String)"C_Invoice_ID");
            String sql = "UPDATE C_Invoice i SET IsFixedAssetInvoice=(SELECT COALESCE(MAX(il.IsFixedAssetInvoice),'N') FROM C_InvoiceLine il WHERE il.C_Invoice_ID=i.C_Invoice_ID AND il.IsDescription='N') WHERE C_Invoice_ID=?";
            DB.executeUpdateEx((String)sql, (Object[])new Object[]{invoice_id}, (String)m.get_TrxName());
        }
    }

    private void validateFixedAssetsInvoice_LRO(MInvoice invoice) {
        if (!OFBForward.UseMixedInvoiceAsset() && invoice.get_ValueAsBoolean("IsFixedAssetInvoice")) {
            boolean hasFixedAssetLines = false;
            boolean hasNormalLines = false;
            MInvoiceLine[] mInvoiceLineArray = invoice.getLines();
            int n = mInvoiceLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MProduct product;
                MInvoiceLine line = mInvoiceLineArray[n2];
                if (line.get_ValueAsBoolean("IsFixedAssetInvoice")) {
                    hasFixedAssetLines = true;
                } else if (line.getM_Product_ID() > 0 && (product = MProduct.get(line.getCtx(), line.getM_Product_ID())).isItem()) {
                    hasNormalLines = true;
                }
                if (hasFixedAssetLines && hasNormalLines) {
                    throw new AssetInvoiceWithMixedLines_LRO();
                }
                ++n2;
            }
        }
    }

    private String beforeSave(MAssetGroup ag, boolean newRecord) throws Exception {
        int no;
        if (ag.is_ValueChanged("IsDefault") && (no = DB.getSQLValue((String)ag.get_TrxName(), (String)"SELECT count(*) FROM A_Asset_Group WHERE IsActive='Y' AND IsDefault='Y' AND Ad_Client_ID=? AND Ad_Org_ID=?", (int)ag.getAD_Client_ID(), (int)ag.getAD_Org_ID())) == 1 && !ag.isDefault() && !newRecord) {
            throw new IllegalStateException("One active Default is expected");
        }
        return null;
    }

    private String afterSave(MAssetGroup ag, boolean newRecord) throws Exception {
        if (ag.isDefault()) {
            DB.executeUpdateEx((String)"UPDATE A_Asset_Group SET IsDefault='N' WHERE IsActive='Y' AND Ad_Client_ID=? AND Ad_Org_ID=? AND A_Asset_Group_ID !=?", (Object[])new Object[]{ag.getAD_Client_ID(), ag.getAD_Org_ID(), ag.getA_Asset_Group_ID()}, (String)ag.get_TrxName());
        }
        return null;
    }

    private String beforeDelete(MAssetGroup ag) throws Exception {
        int no = DB.getSQLValue((String)ag.get_TrxName(), (String)"SELECT count(*) FROM A_Asset_Group WHERE IsActive='Y' AND IsDefault='Y' AND Ad_Client_ID=? AND Ad_Org_ID=? AND A_Asset_Group_ID=? ", (Object[])new Object[]{ag.getAD_Client_ID(), ag.getAD_Org_ID(), ag.getA_Asset_Group_ID()});
        if (no == 1) {
            throw new IllegalStateException("One active Default is expected");
        }
        return null;
    }

    private boolean beforeSave(MInvoiceLine invoiceLine, boolean newRecord) {
        if (invoiceLine.isA_CreateAsset()) {
            if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0) {
                if (invoiceLine.getA_Asset_Group_ID() != invoiceLine.getA_Asset().getA_Asset_Group_ID()) {
                    log.saveError("Asset Group Error", Msg.translate((Properties)invoiceLine.getCtx(), (String)"Asset Group on Invoice Line is different from Asset Group on Asset"));
                    return false;
                }
                if (invoiceLine.getM_Product_ID() != invoiceLine.getA_Asset().getM_Product_ID()) {
                    log.saveError("Product Error", Msg.translate((Properties)invoiceLine.getCtx(), (String)"Product on Invoice Line is different from Asset Product"));
                    return false;
                }
            }
            if ("Exp".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() <= 0) {
                log.saveError("Asset Error", Msg.translate((Properties)invoiceLine.getCtx(), (String)"No Asset ID"));
                return false;
            }
            if ("Exp".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0) {
                invoiceLine.setA_Asset_ID(invoiceLine.getA_Asset().getA_Asset_ID());
                invoiceLine.setA_Asset_Group_ID(invoiceLine.getA_Asset().getA_Asset_Group_ID());
                invoiceLine.setA_CapvsExp("Exp");
            }
        }
        return true;
    }

    private String beforeReverseCorrect(MInvoice invoice) {
        if (invoice.get_ValueAsBoolean("IsFixedAssetInvoice")) {
            String sql = "SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ";
            int A_Asset_Addition_ID = DB.getSQLValueEx((String)invoice.get_TrxName(), (String)"SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ", (Object[])new Object[]{invoice.get_ID()});
            MAssetAddition assetAdd = new MAssetAddition(invoice.getCtx(), A_Asset_Addition_ID, invoice.get_TrxName());
            if (assetAdd.getDocStatus().equals("CO") || assetAdd.getDocStatus().equals("CL")) {
                return "Can't Void or Reverse Invoice with Completed Asset Addition";
            }
        }
        return null;
    }

    private String afterVoid(MInvoice invoice) {
        if (invoice.get_ValueAsBoolean("IsFixedAssetInvoice")) {
            String sql = "SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ";
            int A_Asset_Addition_ID = DB.getSQLValueEx((String)invoice.get_TrxName(), (String)"SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ", (Object[])new Object[]{invoice.get_ID()});
            MAssetAddition assetAdd = new MAssetAddition(invoice.getCtx(), A_Asset_Addition_ID, invoice.get_TrxName());
            if ("DR".equals(assetAdd.getDocStatus()) || "IP".equals(assetAdd.getDocStatus()) || "IN".equals(assetAdd.getDocStatus()) || "AP".equals(assetAdd.getDocStatus()) || "NA".equals(assetAdd.getDocStatus())) {
                if (!assetAdd.processIt("VO")) {
                    log.warning("Asset Addition Process Failed: " + assetAdd + " - " + assetAdd.getProcessMsg());
                    throw new IllegalStateException("Asset Addition Process Failed: " + assetAdd + " - " + assetAdd.getProcessMsg());
                }
                assetAdd.saveEx();
            }
        }
        return null;
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        return null;
    }
}

