/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetChange;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Asset_Forecast;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CreateAssetForecast
extends SvrProcess {
    int PGroup_ID = 0;
    String PPosession = "Y";
    int asset_ID = 0;
    int Org_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("A_Asset_Group_ID")) {
                    this.PGroup_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsInPosession")) {
                    this.PPosession = (String)para[i].getParameter();
                } else if (name.equals("A_Asset_ID")) {
                    this.asset_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String sql = "Select A.A_Asset_ID, C.A_Asset_Acct_ID  From A_Asset A  Inner join A_Asset_Acct C on (A.A_Asset_ID=C.A_Asset_ID) where 1=1";
        sql = this.asset_ID > 0 ? String.valueOf(sql) + " and A.A_Asset_ID=?" : String.valueOf(sql) + " and A.A_Asset_Group_ID=?";
        sql = String.valueOf(sql) + " and A.IsInPosession=?";
        if (this.Org_ID > 0) {
            sql = String.valueOf(sql) + " and A.AD_Org_ID=?";
        }
        int count = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            if (this.asset_ID > 0) {
                pstmt.setInt(1, this.asset_ID);
            } else {
                pstmt.setInt(1, this.PGroup_ID);
            }
            pstmt.setString(2, this.PPosession);
            if (this.Org_ID > 0) {
                pstmt.setInt(3, this.Org_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_A_Asset asset = new X_A_Asset(this.getCtx(), rs.getInt(1), this.get_TrxName());
                MDepreciationWorkfile workfile = CreateAssetForecast.getWorkFile(rs.getInt(1));
                MAssetAcct acct = new MAssetAcct(this.getCtx(), rs.getInt(2), this.get_TrxName());
                if (workfile == null || workfile.getA_Period_Posted() == acct.getA_Period_End()) continue;
                this.replanningForecast(asset, workfile.getA_Asset_Cost().subtract(workfile.getA_Accumulated_Depr()), acct, workfile.getA_Period_Posted(), DB.getSQLValueTS((String)this.get_TrxName(), (String)("select max(datedoc) from a_asset_forecast where corrected='Y' and A_Asset_ID=" + rs.getInt(1)), (Object[])new Object[0]));
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return "Activo Replanificados :" + count;
    }

    public static void createForecast(X_A_Asset asset, MAssetChange change, MAssetAcct acct, String trxName) {
        BigDecimal SalvageAmt = acct.getA_Salvage_Value();
        BigDecimal Currentamt = change.getAssetValueAmt();
        if (!acct.get_ValueAsBoolean("IsByYear")) {
            int i = 1;
            while (i < acct.getA_Period_End() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, trxName);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                cal.add(2, i);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt.divide(new BigDecimal(acct.getA_Period_End()), 2, 1);
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++i;
            }
        } else {
            int i = 0;
            while (i < asset.getUseLifeYears()) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, trxName);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                cal.set(2, 11);
                cal.set(5, 1);
                cal.add(1, i);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i + 1);
                acct.save();
                BigDecimal divisor = new BigDecimal("0.0");
                divisor = acct.get_ValueAsBoolean("IsByYear") ? new BigDecimal(asset.getUseLifeYears()) : new BigDecimal(acct.getA_Period_End());
                BigDecimal amtAcct = Currentamt.divide(divisor, 2, 1);
                if (i + 1 == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++i;
            }
        }
    }

    public void replanningForecast(X_A_Asset asset, BigDecimal Amount, MAssetAcct acct, int Period, Timestamp lastdate) {
        BigDecimal SalvageAmt = acct.getA_Salvage_Value();
        BigDecimal Currentamt = Amount;
        Currentamt = Currentamt.divide(new BigDecimal(acct.getA_Period_End() - Period), 2, 1);
        DB.executeUpdate((String)("Update A_Asset_Forecast set amount=" + Currentamt + " Where Processed='N' AND A_Asset_ID=" + asset.getA_Asset_ID()), (String)this.get_TrxName());
        if (asset.isInPosession()) {
            DB.executeUpdate((String)("Delete from A_Asset_Forecast where Processed='N' and Corrected='N' and A_Asset_ID=" + asset.getA_Asset_ID()), (String)this.get_TrxName());
            Period = DB.getSQLValue((String)this.get_TrxName(), (String)("select max(PeriodNo) from a_asset_forecast where corrected='Y' and A_Asset_ID=" + asset.getA_Asset_ID()));
        } else {
            DB.executeUpdate((String)("Delete from A_Asset_Forecast where Processed='N' and A_Asset_ID=" + asset.getA_Asset_ID()), (String)this.get_TrxName());
        }
        int mes = 1;
        if (!acct.get_ValueAsBoolean("IsByYear")) {
            int i = Period + 1;
            while (i < acct.getA_Period_End() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(2, mes);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        } else {
            int i = Period + 1;
            while (i < asset.getUseLifeYears() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(1, mes);
                cal.set(2, 11);
                cal.set(5, 1);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        }
    }

    public static MDepreciationWorkfile getWorkFile(int Asset_ID) {
        MDepreciationWorkfile workfile;
        block6: {
            workfile = null;
            CLogger log = CLogger.getCLogger((String)"MAsset");
            String sql = "SELECT * FROM A_Depreciation_Workfile WHERE A_Asset_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, Asset_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        workfile = new MDepreciationWorkfile(Env.getCtx(), rs, null);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return workfile;
    }
}

