/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_MED_Schedule;
import org.compiere.model.X_MED_ScheduleDay;
import org.compiere.model.X_MED_ScheduleTime;
import org.compiere.model.X_MED_TemplateDay;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ProcessGenerateDays
extends SvrProcess {
    private int m_Record_ID = 0;

    protected void prepare() {
        this.m_Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        X_MED_Schedule horario = new X_MED_Schedule(Env.getCtx(), this.m_Record_ID, this.get_TrxName());
        if (horario.getMED_Template_ID() <= 0) {
            throw new IllegalArgumentException("El horario no posee plantilla");
        }
        if (horario.getState().equals("CO")) {
            throw new IllegalArgumentException("El horario ya se encuentra completo, no puede ser modificado");
        }
        if (horario.get_ValueAsInt("M_Locator_ID") <= 0) {
            throw new IllegalArgumentException("Debe asociar un box de atencion");
        }
        X_MED_TemplateDay[] plantillas = this.getPlantillas(horario.getMED_Template_ID());
        Timestamp dia = horario.getDateFrom();
        int boxatencion = horario.get_ValueAsInt("M_Locator_ID");
        while (dia.compareTo(horario.getDateTo()) <= 0) {
            X_MED_ScheduleTime hora;
            String bpartnername;
            int medinconflict;
            String sqlvalidate;
            int pos = this.getPlantilla(plantillas, dia);
            if (pos < 0) {
                dia = TimeUtil.getNextDay((Timestamp)dia);
                continue;
            }
            X_MED_ScheduleDay newDia = new X_MED_ScheduleDay(Env.getCtx(), 0, this.get_TrxName());
            newDia.setDay(plantillas[pos].getDays());
            newDia.setDateTrx(dia);
            newDia.setCycleA1(plantillas[pos].getCycleA1());
            newDia.setCycleA2(plantillas[pos].getCycleA2());
            newDia.setCycleB1(plantillas[pos].getCycleB1());
            newDia.setCycleB2(plantillas[pos].getCycleB2());
            newDia.setMED_Schedule_ID(horario.getMED_Schedule_ID());
            newDia.setAD_Org_ID(newDia.getAD_Org_ID());
            newDia.save();
            if (newDia.getCycleA1() != null && newDia.getCycleA2() != null) {
                Calendar a1 = Calendar.getInstance();
                a1.setTimeInMillis(newDia.getCycleA1().getTime());
                Calendar a2 = Calendar.getInstance();
                a2.setTimeInMillis(newDia.getCycleA2().getTime());
                Calendar desde1 = Calendar.getInstance();
                desde1.setTimeInMillis(newDia.getDateTrx().getTime());
                desde1.set(11, a1.get(11));
                desde1.set(12, a1.get(12));
                Calendar hasta1 = Calendar.getInstance();
                hasta1.setTimeInMillis(newDia.getDateTrx().getTime());
                hasta1.set(11, a2.get(11));
                hasta1.set(12, a2.get(12));
                while (desde1.compareTo(hasta1) <= 0) {
                    sqlvalidate = "SELECT coalesce(max(c_bpartnermed_id),0) from med_schedule  WHERE c_bpartnermed_id != " + horario.getC_BPartnerMed_ID() + " AND med_schedule_id in (SELECT med_schedule_id from med_scheduleday where med_scheduleday_id in " + " (select med_scheduleday_id from med_scheduletime where timerequested = '" + new Timestamp(desde1.getTimeInMillis()) + "' " + " AND m_locator_id = " + boxatencion + "))";
                    this.log.config(sqlvalidate);
                    medinconflict = DB.getSQLValue((String)this.get_TrxName(), (String)sqlvalidate);
                    if (medinconflict > 0) {
                        bpartnername = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT name from c_bpartner where c_bpartner_id = ? ", (int)medinconflict);
                        throw new AdempiereException("El doctor " + bpartnername + " utiliza el box solicitado en el horario " + new Timestamp(desde1.getTimeInMillis()) + " ");
                    }
                    hora = new X_MED_ScheduleTime(Env.getCtx(), 0, this.get_TrxName());
                    hora.setState("DI");
                    hora.setTimeRequested(new Timestamp(desde1.getTimeInMillis()));
                    hora.setMED_Specialty_ID(horario.getMED_Specialty_ID());
                    hora.setMED_ScheduleDay_ID(newDia.getMED_ScheduleDay_ID());
                    hora.setAD_Org_ID(newDia.getAD_Org_ID());
                    hora.set_CustomColumn("M_Locator_ID", boxatencion);
                    hora.save();
                    desde1.add(12, horario.getminutes().intValue());
                }
            }
            if (newDia.getCycleB1() != null && newDia.getCycleB2() != null) {
                Calendar b1 = Calendar.getInstance();
                b1.setTimeInMillis(newDia.getCycleB1().getTime());
                Calendar b2 = Calendar.getInstance();
                b2.setTimeInMillis(newDia.getCycleB2().getTime());
                Calendar desde2 = Calendar.getInstance();
                desde2.setTimeInMillis(newDia.getDateTrx().getTime());
                desde2.set(11, b1.get(11));
                desde2.set(12, b1.get(12));
                Calendar hasta2 = Calendar.getInstance();
                hasta2.setTimeInMillis(newDia.getDateTrx().getTime());
                hasta2.set(11, b2.get(11));
                hasta2.set(12, b2.get(12));
                while (desde2.compareTo(hasta2) <= 0) {
                    sqlvalidate = "SELECT coalesce(max(c_bpartnermed_id),0) from med_schedule  WHERE c_bpartnermed_id != " + horario.getC_BPartnerMed_ID() + " AND med_schedule_id in (SELECT med_schedule_id from med_scheduleday where med_scheduleday_id in " + " (select med_scheduleday_id from med_scheduletime where timerequested = '" + new Timestamp(desde2.getTimeInMillis()) + "' " + " AND m_locator_id = " + boxatencion + "))";
                    medinconflict = DB.getSQLValue((String)this.get_TrxName(), (String)sqlvalidate);
                    if (medinconflict > 0) {
                        bpartnername = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT name from c_bpartner where c_bpartner_id = ? ", (int)medinconflict);
                        throw new AdempiereException("El doctor " + bpartnername + " utiliza el box solicitado en el horario " + new Timestamp(desde2.getTimeInMillis()) + " ");
                    }
                    hora = new X_MED_ScheduleTime(Env.getCtx(), 0, this.get_TrxName());
                    hora.setState("DI");
                    hora.setTimeRequested(new Timestamp(desde2.getTimeInMillis()));
                    hora.setMED_Specialty_ID(horario.getMED_Specialty_ID());
                    hora.setMED_ScheduleDay_ID(newDia.getMED_ScheduleDay_ID());
                    hora.setAD_Org_ID(newDia.getAD_Org_ID());
                    hora.set_CustomColumn("M_Locator_ID", boxatencion);
                    hora.save();
                    desde2.add(12, horario.getminutes().intValue());
                }
            }
            dia = TimeUtil.getNextDay((Timestamp)dia);
        }
        return "Dias Creados";
    }

    private int getPlantilla(X_MED_TemplateDay[] plantillas, Timestamp dia) {
        int pos = -1;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dia.getTime());
        String numeroDia = "0" + (cal.get(7) - 1);
        int i = 0;
        while (i < plantillas.length) {
            if (numeroDia.equals(plantillas[i].getDays())) {
                pos = i;
            }
            ++i;
        }
        return pos;
    }

    private X_MED_TemplateDay[] getPlantillas(int plantilla_ID) {
        CPreparedStatement pstmt = null;
        ArrayList<X_MED_TemplateDay> lista = new ArrayList<X_MED_TemplateDay>();
        String mysql = "select * from MED_TemplateDay where MED_Template_ID=?";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, plantilla_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MED_TemplateDay dia = new X_MED_TemplateDay(Env.getCtx(), rs, this.get_TrxName());
                lista.add(dia);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return lista.toArray(new X_MED_TemplateDay[lista.size()]);
    }
}

