/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_CC_Evaluation;
import org.compiere.model.X_CC_Hospitalization;
import org.compiere.model.X_CC_ShiftChange;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class ProcessCCShiftChange
extends SvrProcess {
    private int p_AdmDis_ID = 0;
    private String p_Action = "PR";
    private int p_user_id = 0;
    private int p_user2_id = 0;
    private Timestamp p_date;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else if (name.equals("AD_User_ID")) {
                this.p_user_id = para[i].getParameterAsInt();
            } else if (name.equals("AD_User2_ID")) {
                this.p_user2_id = para[i].getParameterAsInt();
            } else if (name.equals("Date1")) {
                this.p_date = para[i].getParameterAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int counter;
        block8: {
            counter = 0;
            if (this.p_user_id > 0 && this.p_user2_id > 0) {
                String sql = "SELECT CC_Hospitalization_ID from CC_Hospitalization WHERE processed='N' and isreadonly1='N'";
                Statement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            X_CC_ShiftChange shift;
                            if (rs.getInt("CC_Hospitalization_ID") <= 0) continue;
                            int hosp_id = rs.getInt("CC_Hospitalization_ID");
                            String sqlevolution = "SELECT coalesce(max(cc_Evaluation_id),0) FROM CC_Evaluation  WHERE cc_hospitalization_id = ?";
                            int eval_id = DB.getSQLValue((String)this.get_TrxName(), (String)sqlevolution, (int)hosp_id);
                            if (eval_id > 0) {
                                X_CC_Evaluation eval = new X_CC_Evaluation(this.getCtx(), eval_id, this.get_TrxName());
                                shift = new X_CC_ShiftChange(this.getCtx(), 0, this.get_TrxName());
                                if (eval.getAD_User_ID() != this.p_user_id) continue;
                                shift.setDate1(this.p_date);
                                shift.setAD_User_ID(this.p_user_id);
                                shift.setAD_User2_ID(this.p_user2_id);
                                shift.setC_BPartner_ID(eval.getC_BPartner_ID());
                                shift.setCC_Hospitalization_ID(hosp_id);
                                shift.setPlanningHorizon(eval.getPlanningHorizon());
                                shift.setDescription1(eval.getDescription());
                                shift.setType("ME");
                                shift.saveEx();
                                ++counter;
                                continue;
                            }
                            X_CC_Hospitalization hosp = new X_CC_Hospitalization(this.getCtx(), hosp_id, this.get_TrxName());
                            shift = new X_CC_ShiftChange(this.getCtx(), 0, this.get_TrxName());
                            if (hosp.getAD_User_ID() != this.p_user_id) continue;
                            shift.setDate1(this.p_date);
                            shift.setAD_User_ID(this.p_user_id);
                            shift.setAD_User2_ID(this.p_user2_id);
                            shift.setC_BPartner_ID(hosp.getC_BPartner_ID());
                            shift.setCC_Hospitalization_ID(hosp_id);
                            shift.setPlanningHorizon(hosp.getLocationComment());
                            shift.setDescription1(hosp.getDescriptionURL());
                            shift.setType("ME");
                            shift.saveEx();
                            ++counter;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                        pstmt.close();
                        rs.close();
                        pstmt = null;
                        rs = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    throw throwable;
                }
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
            }
        }
        return "Se ha generado " + counter + " entrega(s) de turno";
    }
}

