/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPricing;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateSalesOrderFromReq
extends SvrProcess {
    private int p_ID_BPartner;
    private int p_ID_pList;
    private int p_ID_Hosp;
    private Timestamp p_DateFrom;
    private Timestamp p_DateTo;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartner_ID")) {
                this.p_ID_BPartner = para[i].getParameterAsInt();
            } else if (name.equals("M_PriceList_ID")) {
                this.p_ID_pList = para[i].getParameterAsInt();
            } else if (name.equals("CC_Hospitalization_ID")) {
                this.p_ID_Hosp = para[i].getParameterAsInt();
            } else if (name.equals("DateDoc")) {
                this.p_DateFrom = para[i].getParameterAsTimestamp();
                this.p_DateTo = para[i].getParameterToAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MOrder order;
        int cant;
        block22: {
            cant = 0;
            order = null;
            MProductPricing pp1 = null;
            String sql = "SELECT rl.M_Product_ID,rl.qty,M_RequisitionLine_ID,0 as A_Locator_Use_ID,r.c_doctype_id FROM M_Requisition r  INNER JOIN M_RequisitionLine rl ON (r.M_Requisition_ID = rl.M_Requisition_ID ) WHERE r.C_Bpartner_ID = " + this.p_ID_BPartner + " AND CC_Hospitalization_ID = " + this.p_ID_Hosp + " AND rl.m_product_ID NOT IN (select m_product_ID from m_product where Chargeable = 'N')";
            if (this.p_DateFrom != null && this.p_DateTo != null) {
                sql = String.valueOf(sql) + " AND r.datedoc BETWEEN ? AND ?";
            }
            sql = String.valueOf(sql) + " AND r.DocStatus IN ('CO','CL') AND rl.M_RequisitionLine_ID NOT IN " + " (SELECT col.M_RequisitionLine_ID FROM C_OrderLine col" + " INNER JOIN C_Order co ON (col.C_Order_ID = co.C_Order_ID)" + " WHERE M_RequisitionLine_ID IS NOT NULL" + " AND DocStatus IN ('CO'))" + " UNION " + " SELECT M_Product_ID, " + " CASE WHEN (date_part('day', dateend -datestart) > 1) THEN date_part('day', dateend -datestart)" + " WHEN (date_part('day', dateend -datestart) < 1) AND (date_part('second', dateend -datestart) > 1) THEN 1" + " ELSE 0 END as qty,0,A_Locator_Use_ID,0 as c_doctype_id " + " FROM A_Locator_Use lu INNER JOIN M_Locator ml ON (lu.M_Locator_ID = ml.M_Locator_ID)" + " WHERE lu.C_Bpartner_ID = " + this.p_ID_BPartner + " AND CC_Hospitalization_ID = " + this.p_ID_Hosp;
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int ID_Exe;
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    if (this.p_DateFrom != null && this.p_DateTo != null) {
                        pstmt.setTimestamp(1, this.p_DateFrom);
                        pstmt.setTimestamp(2, this.p_DateTo);
                    }
                    rs = pstmt.executeQuery();
                    int ID_Iva = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Tax_ID) FROM C_Tax WHERE UPPER(Name) like '%IVA%'");
                    if (ID_Iva < 0) {
                        ID_Iva = 2000002;
                    }
                    if ((ID_Exe = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Tax_ID) FROM C_Tax WHERE UPPER(Name) like '%EXENTO%'")) < 0) {
                        ID_Exe = 2000003;
                    }
                    while (rs.next()) {
                        if (rs.getInt("M_Product_ID") <= 0 || rs.getBigDecimal("qty").compareTo(Env.ZERO) <= 0) continue;
                        Timestamp today = new Timestamp(System.currentTimeMillis());
                        if (order == null) {
                            order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                            order.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.getCtx()));
                            order.setC_DocType_ID(2000122);
                            order.setC_BPartner_ID(this.p_ID_BPartner);
                            order.setDateOrdered(today);
                            int ID_BPLoc = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location WHERE IsActive = 'Y' AND C_BPartner_ID = " + this.p_ID_BPartner));
                            if (ID_BPLoc > 0) {
                                order.setC_BPartner_Location_ID(ID_BPLoc);
                            }
                            order.setM_PriceList_ID(this.p_ID_pList);
                            order.set_CustomColumn("CC_Hospitalization_ID", this.p_ID_Hosp);
                            order.save(this.get_TrxName());
                        }
                        MOrderLine oLine = new MOrderLine(order);
                        oLine.setM_Product_ID(rs.getInt("M_Product_ID"), true);
                        oLine.setQty(rs.getBigDecimal("qty"));
                        oLine.setPrice();
                        oLine.setC_Tax_ID(ID_Iva);
                        if (rs.getInt("M_RequisitionLine_ID") > 0) {
                            oLine.set_CustomColumn("M_RequisitionLine_ID", rs.getInt("M_RequisitionLine_ID"));
                        } else if (rs.getInt("A_Locator_Use_ID") > 0) {
                            oLine.set_CustomColumn("A_Locator_Use_ID", rs.getInt("A_Locator_Use_ID"));
                        }
                        oLine.setLineNetAmt();
                        pp1 = this.getProductPricing(oLine.getM_Product_ID(), order.getC_BPartner_ID(), oLine.getQtyEntered(), order.isSOTrx(), order.getM_PriceList_ID(), order.getDateOrdered());
                        if (!pp1.isCalculated()) {
                            throw new AdempiereException("PRODUCTO " + oLine.getM_Product().getValue() + "-" + oLine.getM_Product().getName() + ". NO EXISTE EN LISTA DE PRECIOS ");
                        }
                        oLine.save(this.get_TrxName());
                        if (rs.getInt("C_DocType_ID") == 2000174) {
                            oLine.setQty(oLine.getQtyEntered().negate());
                            oLine.saveEx(this.get_TrxName());
                        }
                        ++cant;
                        MProductPricing pp = this.getProductPricing(oLine.getM_Product_ID(), order.getC_BPartner_ID(), oLine.getQtyEntered(), order.isSOTrx(), order.getM_PriceList_ID(), order.getDateOrdered());
                        if (pp.getPriceLimit().compareTo(Env.ZERO) <= 0) continue;
                        MOrderLine oLine2 = new MOrderLine(order);
                        oLine2.setM_Product_ID(rs.getInt("M_Product_ID"), true);
                        oLine2.setQty(rs.getBigDecimal("qty"));
                        oLine2.setPrice();
                        oLine2.setPrice(pp.getPriceLimit());
                        oLine2.setC_Tax_ID(ID_Exe);
                        if (rs.getInt("M_RequisitionLine_ID") > 0) {
                            oLine2.set_CustomColumn("M_RequisitionLine_ID", rs.getInt("M_RequisitionLine_ID"));
                        } else if (rs.getInt("A_Locator_Use_ID") > 0) {
                            oLine2.set_CustomColumn("A_Locator_Use_ID", rs.getInt("A_Locator_Use_ID"));
                        }
                        oLine2.save(this.get_TrxName());
                        oLine2.setLineNetAmt();
                        if (rs.getInt("C_DocType_ID") == 2000174) {
                            oLine.setQty(oLine.getQtyEntered().negate());
                            oLine2.saveEx(this.get_TrxName());
                        }
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        if (order != null) {
            return "Se ha generado nota de venta " + order.getDocumentNo() + " con " + cant + " lineas ";
        }
        return "No se ha podido generar la orden";
    }

    private MProductPricing getProductPricing(int ID_product, int ID_BPartner, BigDecimal qtyOrdered, boolean IssoTrx, int M_PriceList_ID, Timestamp date) {
        MProductPricing m_productPrice = new MProductPricing(ID_product, ID_BPartner, qtyOrdered, IssoTrx);
        m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        m_productPrice.setPriceDate(date);
        m_productPrice.calculatePrice();
        return m_productPrice;
    }
}

