/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class GenerateRequisitionToday
extends SvrProcess {
    private int p_ID_BPartner;
    private Timestamp p_UseDateFrom;
    private Timestamp p_UseDateTo;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartner_ID")) {
                this.p_ID_BPartner = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int cant = 0;
        MRequisition req = null;
        int ID_lastBPartner = 0;
        String sql = "SELECT M_Product_ID, 1 as qty,A_Locator_Use_ID, dateend, datestart,lu.C_Bpartner_ID FROM A_Locator_Use lu INNER JOIN M_Locator ml ON (lu.M_Locator_ID = ml.M_Locator_ID) WHERE lu.C_Bpartner_ID IS NOT NULL  AND dateStart < ? AND (dateEnd > ?  OR dateEnd IS NULL)";
        if (this.p_ID_BPartner > 0) {
            sql = String.valueOf(sql) + " AND lu.C_Bpartner_ID = " + this.p_ID_BPartner;
        }
        sql = String.valueOf(sql) + " ORDER BY C_Bpartner_ID DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        this.p_UseDateFrom = DateUtils.today();
        this.p_UseDateTo = DateUtils.today();
        Timestamp dateTrx = new Timestamp(this.p_UseDateFrom.getTime());
        while (dateTrx.compareTo(this.p_UseDateTo) <= 0) {
            pstmt = null;
            rs = null;
            req = null;
            ID_lastBPartner = 0;
            try {
                int ID_Exe;
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setTimestamp(1, dateTrx);
                pstmt.setTimestamp(2, dateTrx);
                rs = pstmt.executeQuery();
                int ID_Iva = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Tax_ID) FROM C_Tax WHERE UPPER(Name) like '%IVA%'");
                if (ID_Iva < 0) {
                    ID_Iva = 2000002;
                }
                if ((ID_Exe = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Tax_ID) FROM C_Tax WHERE UPPER(Name) like '%EXENTO%'")) < 0) {
                    ID_Exe = 2000003;
                }
                while (rs.next()) {
                    if (rs.getInt("M_Product_ID") > 0 && rs.getBigDecimal("qty").compareTo(Env.ZERO) > 0) {
                        if (ID_lastBPartner != rs.getInt("C_Bpartner_ID")) {
                            req = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                            req.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.getCtx()));
                            req.setC_DocType_ID(2000154);
                            req.set_CustomColumn("C_Bpartner_ID", rs.getInt("C_Bpartner_ID"));
                            req.setDateDoc(dateTrx);
                            req.setDateRequired(dateTrx);
                            req.setM_PriceList_ID(2000005);
                            req.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
                            req.setHelp("Generado automaticamente");
                            req.save(this.get_TrxName());
                            ++cant;
                        }
                        MRequisitionLine rLine = new MRequisitionLine(req);
                        rLine.setM_Product_ID(rs.getInt("M_Product_ID"));
                        rLine.setQty(rs.getBigDecimal("qty"));
                        rLine.setPrice();
                        rLine.set_CustomColumn("A_Locator_Use_ID", (Object)rs.getInt("A_Locator_Use_ID"));
                        rLine.setLineNetAmt();
                        rLine.save(this.get_TrxName());
                        MProductPricing pp = this.getProductPricing(rLine.getM_Product_ID(), req.get_ValueAsInt("C_BPartner_ID"), rLine.getQtyOrdered(), req.isSOTrx(), req.getM_PriceList_ID(), req.getDateDoc());
                        if (pp.getPriceLimit().compareTo(Env.ZERO) > 0) {
                            MRequisitionLine rLine2 = new MRequisitionLine(req);
                            rLine2.setM_Product_ID(rs.getInt("M_Product_ID"));
                            rLine2.setQty(rs.getBigDecimal("qty"));
                            rLine2.setPrice();
                            rLine2.setPriceActual(pp.getPriceLimit());
                            rLine2.set_CustomColumn("A_Locator_Use_ID", (Object)rs.getInt("A_Locator_Use_ID"));
                            rLine2.save(this.get_TrxName());
                            rLine2.setLineNetAmt();
                            ++cant;
                        }
                    }
                    ID_lastBPartner = rs.getInt("C_Bpartner_ID");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            dateTrx = DateUtils.SumarDias(dateTrx, 1);
        }
        return "Se ha generado " + cant + " solicitudes";
    }

    private MProductPricing getProductPricing(int ID_product, int ID_BPartner, BigDecimal qtyOrdered, boolean IssoTrx, int M_PriceList_ID, Timestamp date) {
        MProductPricing m_productPrice = new MProductPricing(ID_product, ID_BPartner, qtyOrdered, IssoTrx);
        m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        m_productPrice.setPriceDate(date);
        m_productPrice.calculatePrice();
        return m_productPrice;
    }
}

