/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModelCCRequestFromInv
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelCCRequestFromInv.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_InventoryLine", (ModelValidator)this);
        engine.addDocValidate("M_Inventory", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        int ID_ReqLine;
        MInventory inv;
        MInventoryLine iLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 3 && po.get_Table_ID() == MInventoryLine.Table_ID) {
            iLine = (MInventoryLine)po;
            inv = new MInventory(po.getCtx(), iLine.getM_Inventory_ID(), po.get_TrxName());
            if (inv.get_ValueAsInt("M_Requisition_ID") > 0 && (ID_ReqLine = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT M_RequisitionLine_ID FROM M_RequisitionLine WHERE M_Requisition_ID=" + inv.get_ValueAsInt("M_Requisition_ID") + " AND M_product_ID=" + iLine.getM_Product_ID()))) > 0) {
                DB.executeUpdate((String)("delete from pp_mrp where M_RequisitionLine_ID=" + ID_ReqLine), (String)po.get_TrxName());
                DB.executeUpdate((String)("delete from M_RequisitionLine where M_RequisitionLine_ID=" + ID_ReqLine), (String)po.get_TrxName());
            }
        }
        if (type == 2 && po.get_Table_ID() == MInventoryLine.Table_ID && po.is_ValueChanged("M_Product_ID")) {
            iLine = (MInventoryLine)po;
            inv = new MInventory(po.getCtx(), iLine.getM_Inventory_ID(), po.get_TrxName());
            if (inv.get_ValueAsInt("M_Requisition_ID") > 0 && (ID_ReqLine = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT M_RequisitionLine_ID FROM M_RequisitionLine WHERE M_Requisition_ID=" + inv.get_ValueAsInt("M_Requisition_ID") + " AND M_product_ID=" + po.get_ValueOldAsInt("M_Product_ID")))) > 0) {
                DB.executeUpdate((String)("UPDATE M_RequisitionLine SET M_product_ID = " + iLine.getM_Product_ID() + " WHERE M_RequisitionLine_ID=" + ID_ReqLine), (String)po.get_TrxName());
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInventory.Table_ID) {
            int ID_ReqLine = 0;
            MInventory inv = (MInventory)po;
            if (inv.get_ValueAsInt("M_Requisition_ID") > 0) {
                MInventoryLine[] lines = inv.getLines(true);
                int i = 0;
                while (i < lines.length) {
                    MInventoryLine line = lines[i];
                    if (line.getM_Product_ID() > 0) {
                        ID_ReqLine = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT M_RequisitionLine_ID FROM M_RequisitionLine WHERE M_Requisition_ID=" + inv.get_ValueAsInt("M_Requisition_ID") + " AND M_product_ID=" + line.getM_Product_ID()));
                        BigDecimal qty = line.getQtyInternalUse();
                        if (ID_ReqLine > 0) {
                            DB.executeUpdate((String)("UPDATE M_RequisitionLine SET qty=" + qty + " WHERE M_RequisitionLine_ID=" + ID_ReqLine), (String)po.get_TrxName());
                        } else {
                            MRequisition req = new MRequisition(po.getCtx(), inv.get_ValueAsInt("M_Requisition_ID"), po.get_TrxName());
                            DB.executeUpdate((String)("UPDATE M_Requisition SET DocStatus='DR', Processed='N'  WHERE M_Requisition_ID=" + inv.get_ValueAsInt("M_Requisition_ID")), (String)po.get_TrxName());
                            req.setDocStatus(DOCSTATUS_Drafted);
                            req.saveEx(po.get_TrxName());
                            MRequisitionLine reqLine = new MRequisitionLine(req);
                            reqLine.setAD_Org_ID(line.getAD_Org_ID());
                            reqLine.setM_Product_ID(line.getM_Product_ID());
                            reqLine.setQty(qty);
                            reqLine.saveEx(po.get_TrxName());
                            DB.executeUpdate((String)("UPDATE M_Requisition SET DocStatus='CO', Processed='Y'  WHERE M_Requisition_ID=" + inv.get_ValueAsInt("M_Requisition_ID")), (String)po.get_TrxName());
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

