/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_CC_AdministrativeDischarge;
import org.compiere.model.X_CC_Hospitalization;
import org.compiere.util.CLogger;

public class ModCCValidDateAdDischarge
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCCValidDateAdDischarge.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("CC_AdministrativeDischarge", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_CC_AdministrativeDischarge.Table_ID) {
            X_CC_AdministrativeDischarge adm = (X_CC_AdministrativeDischarge)po;
            X_CC_Hospitalization hosp = new X_CC_Hospitalization(po.getCtx(), adm.getCC_Hospitalization_ID(), po.get_TrxName());
            if (hosp.getDateInvited() != null && adm.getDate1() != null && adm.getDate1().compareTo(hosp.getDateInvited()) < 0) {
                return "ERROR: Fecha de alta no puede ser menor a fecha de ingreso";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

