/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import java.math.BigDecimal;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_CC_Hospitalization;
import org.compiere.model.X_MED_LabDetail;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModCCUpdateMedLab
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCCUpdateMedLab.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("MED_LabDetail", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_MED_LabDetail.Table_ID) {
            X_MED_LabDetail lab = (X_MED_LabDetail)po;
            int hosp_id = lab.getCC_Hospitalization_ID();
            if (lab.getAmount().compareTo(Env.ZERO) == 0) {
                X_CC_Hospitalization hosp = new X_CC_Hospitalization(po.getCtx(), hosp_id, po.get_TrxName());
                MBPartner bp = new MBPartner(po.getCtx(), hosp.getC_BPartner_ID(), po.get_TrxName());
                int pricelist = bp.getM_PriceList_ID();
                int version = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT coalesce(max(m_pricelist_version_id),0) from m_pricelist_version WHERE isactive='Y' AND m_pricelist_id = " + pricelist));
                BigDecimal amountproduct = Env.ZERO;
                if (version > 0) {
                    int prod = lab.getM_Product_ID();
                    amountproduct = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT coalesce(max(pricelist),0) from m_productprice WHERE m_product_id = ? and m_pricelist_version_id = " + version), (int)prod);
                }
                lab.setAmount(amountproduct.multiply(lab.getQty()));
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

